/* Win3270 widget definitions */

#ifndef _Win3270_h
#define _Win3270_h

#include <X11/Core.h>

/* Resources:

 Name		     Class		RepType		Default Value
 ----		     -----		-------		-------------
 background	     Background		Pixel		XtDefaultBackground
 border		     BorderColor	Pixel		XtDefaultForeground
 borderWidth	     BorderWidth	Dimension	0
 destroyCallback     Callback		Pointer		NULL
 height		     Height		Dimension	0
 mappedWhenManaged   MappedWhenManaged	Boolean		True
 sensitive	     Sensitive		Boolean		True
 width		     Width		Dimension	0
 x		     Position		Position	0
 y		     Position		Position	0
 foreground	     Foreground		Pixel		XtDefaultForeground
 backColor	     BackColor		Pixel		XtDefaultForeground
 foreColor	     ForeColor		Pixel		XtDefaultBackground
 mouseColor	     MouseColor		Pixel		foreground or foreColor
 cursor		     Cursor		Cursor		XC_left_ptr
 speckey	     Boolean		Boolean		False
 keyfile 	     File		String		NULL
 keyProc 	     Callback		Pointer		NULL
 exposeProc 	     Callback		Pointer		NULL
 resizeProc 	     Callback		Pointer		NULL
 actionProc 	     Callback		Pointer		NULL
 destroyProc 	     Callback		Pointer		NULL
*/

/* New resource definitions */
#define XtNbackColor	"backColor"
#define XtNforeColor	"foreColor"
#define XtNmouseColor	"mouseColor"
#define XtNcursor	"cursor"
#define XtNspeckey	"speckey"
#define XtNkeyfile	"keyfile"
#define XtNkeyProc	"keyProc"
#define XtNexposeProc	"exposeProc"
#define XtNresizeProc	"resizeProc"
#define XtNactionProc	"actionProc"
#define XtNdestroyProc	"destroyProc"

#define XtCBackColor	"BackColor"
#define XtCForeColor	"ForeColor"
#define XtCMouseColor	"MouseColor"

/* Class record pointer */
extern WidgetClass win3270WidgetClass;

/* Widget type definitions */
typedef struct _Win3270ClassRec	*Win3270WidgetClass;
typedef struct _Win3270Rec	*Win3270Widget;

/* Other stuff */

typedef enum {
  XtFselectStart, XtFselectAdjust, XtFselectEnd, XtFselectAll,
  XtFinsertSelection, XtFzoom, XtFiconify, XtFsetCursor, XtFspecial1,
  XtFspecial2, XtFspecial3, XtFgaClear, XtFgaRefresh, XtFgaSetCursor,
  XtFimageSave, XtFimageDestroy, XtFaplonoff, XtFmodlock, XtFsystem
  } XtWin3270ActionType;

  
typedef struct {
  XtWin3270ActionType function;
  int x, y;
  String params;
  } XtWin3270Data, *XtWin3270DataPtr;

#endif /* _Win3270_h */
