/* Private data for Win3270 widget */

#ifndef _Win3270P_h
#define _Win3270P_h

#include "Win3270.h"
#include <X11/CoreP.h>

/* New fields for the Win3270 widget record */
typedef struct {
    Pixel foreground;
    Pixel backColor;
    Pixel foreColor;
    Pixel mouseColor;
    Cursor cursor;
    Boolean speckey;
    char *keyfile;
    XtCallbackList keyProc;
    XtCallbackList resizeProc;
    XtCallbackList exposeProc;
    XtCallbackList actionProc;
    XtCallbackList destroyProc;
    XtWin3270Data action_data;
} Win3270Part;

/* Full instance record declaration */
typedef struct _Win3270Rec {
    CorePart	core;
    Win3270Part	win3270;
} Win3270Rec;

/* New fields for the Win3270 widget class record */
typedef struct { int empty; } Win3270ClassPart;

/* Full class record declaration */
typedef struct _Win3270ClassRec {
    CoreClassPart    core_class;
    Win3270ClassPart win3270_class;
} Win3270ClassRec;

/* Class record variable */
extern Win3270ClassRec win3270ClassRec;

#endif /* _Win3270P_h */
