/* X3270 widget definitions */

#ifndef _X3270_h
#define _X3270_h

#include "Win3270.h"

/* Resources:

 Name		     Class		RepType		Default Value
 ----		     -----		-------		-------------
 background	     Background		Pixel		XtDefaultBackground
 border		     BorderColor	Pixel		XtDefaultForeground
 borderWidth	     BorderWidth	Dimension	1
 destroyCallback     Callback		Pointer		NULL
 height		     Height		Dimension	0
 mappedWhenManaged   MappedWhenManaged	Boolean		True
 sensitive	     Sensitive		Boolean		True
 width		     Width		Dimension	0
 x		     Position		Position	0
 y		     Position		Position	0
 foreground	     Foreground		Pixel		XtDefaultForeground
 backColor	     BackColor		Pixel		XtDefaultForeground
 foreColor	     ForeColor		Pixel		XtDefaultBackground
 mouseColor	     MouseColor		Pixel		foreground or foreColor
 cursor		     Cursor		Cursor		XC_left_ptr
 speckey	     Boolean		Boolean		False
 keyfile 	     File		String		NULL
 keyProc 	     Callback		Pointer		NULL
 resizeProc 	     Callback		Pointer		NULL
 cols		     Cols		Dimension	80
 rows		     Rows		Dimension	24
 pnColor	     PNColor		Pixel		Cyan
 piColor	     PIColor		Pixel		White
 unColor	     UNColor		Pixel		Green
 uiColor	     UIColor		Pixel		Red
 extDefault	     ExtDefault		Pixel		Green
 extDefIntense	     ExtDefIntense	Pixel		White
 extBlue	     ExtBlue		Pixel		Cyan
 extRed	   	     ExtRed		Pixel		Red
 extPink	     ExtPink		Pixel		Pink
 extGreen	     ExtGreen		Pixel		Green
 extTurquoise	     ExtTurquoise	Pixel		Turquoise
 extYellow	     ExtYellow		Pixel		Yellow
 extWhite	     ExtWhite		Pixel		White
 cursorColor	     CursorColor	Pixel		foreground or foreColor
 font		     Font		FontStruct	Rom14.500
 boldFont	     BoldFont		FontStruct	Bld14.500
 zoomFont	     ZoomFont		FontStruct	Rom22.500
 boldZoomFont	     BoldZoomFont	FontStruct	Rom22.500
 iconFont	     Font		FontStruct	Rom14.500
 autoRaise	     Boolean		Boolean		False
 warp		     Boolean		Boolean		False
 deIconifyWarp	     Boolean		Boolean		False
 zoom		     Boolean		Boolean		False
 tune		     Tune		String          NULL
 specialCursor       SpecialCursor	Cursor		XC_hand1
*/

/* New resource definitions */
#define XtNcols		"cols"
#define XtNrows		"rows"
#define XtNpnColor	"pnColor"
#define XtNpiColor	"piColor"
#define XtNunColor	"unColor"
#define XtNuiColor	"uiColor"
#define XtNextDefault	"extDefault"
#define XtNextDefIntense "extDefIntense"
#define XtNextBlue	"extBlue"
#define XtNextRed	"extRed"
#define XtNextPink	"extPink"
#define XtNextGreen	"extGreen"
#define XtNextTurquoise	"extTurquoise"
#define XtNextYellow	"extYellow"
#define XtNextWhite	"extWhite"
#define XtNcursorColor	"cursorColor"
#define XtNboldFont	"boldFont"
#define XtNzoomFont	"zoomFont"
#define XtNboldZoomFont	"boldZoomFont"
#define XtNiconFont	"iconFont"
#define XtNautoRaise	"autoRaise"
#define XtNwarp		"warp"
#define XtNdeIconifyWarp "deIconifyWarp"
#define XtNzoom		"zoom"
#define XtNtune		"tune"
#define XtNspecialCursor "specialCursor"

#define XtCCols		"Cols"
#define XtCRows		"Rows"
#define XtCPNColor	"PNColor"
#define XtCPIColor	"PIColor"
#define XtCUNColor	"UNColor"
#define XtCUIColor	"UIColor"
#define XtCExtDefault	"ExtDefault"
#define XtCExtDefIntense "ExtDefIntense"
#define XtCExtBlue	"ExtBlue"
#define XtCExtRed	"ExtRed"
#define XtCExtPink	"ExtPink"
#define XtCExtGreen	"ExtGreen"
#define XtCExtTurquoise	"ExtTurquoise"
#define XtCExtYellow	"ExtYellow"
#define XtCExtWhite	"ExtWhite"
#define XtCCursorColor	"CursorColor"
#define XtCBoldfont	"BoldFont"
#define XtCZoomFont	"ZoomFont"
#define XtCBoldZoomFont	"BoldZoomFont"
#define XtCTune		"Tune"
#define XtCSpecialCursor "SpecialCursor"

/* Class record pointer */
extern WidgetClass x3270WidgetClass;

/* Widget type definitions */
typedef struct _X3270ClassRec	*X3270WidgetClass;
typedef struct _X3270Rec	*X3270Widget;

#endif /* _X3270_h */
