/* Private data for X3270 widget */

#ifndef _X3270P_h
#define _X3270P_h

#include "X3270.h"
#include "Win3270P.h"

/* New fields for the X3270 widget record */
typedef struct {
    Dimension cols;
    Dimension rows;
    Pixel pnColor;
    Pixel piColor;
    Pixel unColor;
    Pixel uiColor;
    Pixel extDefault;
    Pixel extDefIntense;
    Pixel extBlue;
    Pixel extRed;
    Pixel extPink;
    Pixel extGreen;
    Pixel extTurquoise;
    Pixel extYellow;
    Pixel extWhite;
    Pixel cursorColor;
    XFontStruct	*font;
    XFontStruct	*boldFont;
    XFontStruct	*zoomFont;
    XFontStruct	*boldZoomFont;
    XFontStruct	*iconFont;
    Boolean autoRaise;
    Boolean warp;
    Boolean deIconifyWarp;
    Boolean zoom;
    char *tune;
    Cursor specialCursor;
} X3270Part;

/* Full instance record declaration */
typedef struct _X3270Rec {
    CorePart	core;
    Win3270Part	win3270;
    X3270Part	x3270;
} X3270Rec;

/* New fields for the X3270 widget class record */
typedef struct { int empty; } X3270ClassPart;

/* Full class record declaration */
typedef struct _X3270ClassRec {
    CoreClassPart    core_class;
    Win3270ClassPart win3270_class;
    X3270ClassPart   x3270_class;
} X3270ClassRec;

/* Class record variable */
extern X3270ClassRec x3270ClassRec;

#endif /* _X3270P_h */
