/* Network interface */

typedef char Boolean;

static Boolean usepvm;		/* True if PVM gateway should be used */


int net_init(pvm, hostname, extended, port, gateway, secondary, workstation,
	 adapter)
     Boolean pvm;
     char *hostname;
     Boolean extended;
     int port;
     char *gateway, *secondary, *workstation;
     int adapter;
{
  usepvm = pvm;
  if (usepvm)
    return pvm_init(hostname, extended, gateway, secondary, workstation,
		    adapter);
  else
    return tel_init(hostname, port, extended);
}


net_setup(cols, rows, newcols, newrows)
     int cols, rows, *newcols, *newrows;
{
  if (usepvm)
    pvm_setup(cols, rows, newcols, newrows);
  else
    tel_setup(cols, rows, newcols, newrows);
}


int net_check()
{
  if (usepvm) return pvm_check(); else return tel_check();
}


net_put(buff, length)
     unsigned char *buff;
     int length;
{
  if (usepvm) pvm_put(buff, length); else tel_put(buff, length);
}


net_eor()
{
  if (usepvm) pvm_eor(); else tel_eor();
}


net_break()
{
  if (usepvm) pvm_break(); else tel_break();
}


net_close()
{
  if (usepvm) pvm_close(); else tel_close();
}
