/* Send a reply to a Read Partition Query WSF command */


/* Query reply codes (QCODEs) */
#define QC_SUMMARY	0x80	/* Summary */
#define QC_AREA		0x81	/* Usable Area */
#define QC_IMAGE	0x82	/* Image */
#define QC_TEXT		0x83	/* Text Partitions */
#define QC_ALPHA	0x84	/* Alpha Partitions */
#define QC_CHARSETS	0x85	/* Character Sets */
#define QC_COLOR	0x86	/* Color */
#define QC_HIGHLIGHT	0x87	/* Highlight */
#define QC_REPLYMODES	0x88	/* Reply Modes */
#define QC_FIELDVAL	0x8A	/* Field Validation */
#define QC_MSR		0x8B	/* MSR Control */
#define QC_FIELDOUT	0x8C	/* Field Outlining */
#define QC_OEM		0x8F	/* OEM Auxiliary Device */
#define QC_FORMATPR	0x90	/* Format Presentation */
#define QC_DBCS		0x91	/* DBCS-Asia */
#define QC_SAVE		0x92	/* Save/Restore Format */
#define QC_DDM		0x95	/* Distributed Data Management */
#define QC_STORAGE	0x96	/* Storage Pools */
#define QC_DIA		0x97	/* Document Interchange Architecture */
#define QC_CHAIN	0x98	/* Data Chaining */
#define QC_AUXDA	0x99	/* Auxiliary Devices */
#define QC_IPDS		0x9A	/* 3270IPDS */
#define QC_PRODUCT	0x9C	/* Product Defined Data Stream */
#define QC_ANOMALY	0x9D	/* Anomaly */
#define QC_BEGIN	0x9F	/* Begin/End of File */
#define QC_DEVCHAR	0xA0	/* Device Characteristics */
#define QC_RPQ		0xA1	/* RPQ Names */
#define QC_DATASTR	0xA2	/* Data Streams */
#define QC_IMPPART	0xA6	/* Implicit Partitions */
#define QC_PAPER	0xA7	/* Paper Feed Techniques */
#define QC_TRANSP	0xA8	/* Transparency */
#define QC_PRINT	0xA9	/* Settable Printer Characteristics */
#define QC_IOCA		0xAA	/* IOCA Auxiliary Device */
#define QC_COOP		0xAB	/* Cooperative Processing Requestor */
#define QC_SEGMENT	0xB0	/* Segment */
#define QC_PROCEDURE	0xB1	/* Procedure */
#define QC_LINETYPE	0xB2	/* Line Type */
#define QC_PORT		0xB3	/* Port */
#define QC_GRCOLOR	0xB4	/* Graphic Color */
#define QC_EXTDRAW	0xB5	/* Extended Drawing Routine */
#define QC_GRSYMBOL	0xB6	/* Graphic Symbol Sets */
#define QC_NULL		0xFF	/* Null */

/* Inbound structured field IDs */
#define SF_I3270DS	0x80	/* Inbound 3270DS */
#define SF_REPLY	0x81	/* Query Reply */

/* Other definitions */
#define AID_SF		0x88	/* Structured field */

#define DEFCOLS 80
#define DEFROWS 24

#define storew(a, i, val) { a[i] = (val) >> 8; a[(i)+1] = (val) & 0xff; }
typedef char Boolean;
extern unsigned char *graph_colorinfo();


reply_send(altcols, altrows, graphics)
     int altcols, altrows;
     Boolean graphics;
{
  int widthmm, width, heightmm, height, charwidth, charheight;
  Boolean mono;
  static unsigned char rp[] = { AID_SF };

  static unsigned char color[] = 
    {
      0, 22,			/* Length */
      SF_REPLY, QC_COLOR,	/* Header */
      0,			/* Flags */
      8,			/* Number of CAV/COLOR pairs */
      0x00, 0xF4,		/* Green (default color) */
      0xF1, 0xF1,		/* Blue */
      0xF2, 0xF2,		/* Red */
      0xF3, 0xF3,		/* Pink */
      0xF4, 0xF4,		/* Green */
      0xF5, 0xF5,		/* Turquoise */
      0xF6, 0xF6,		/* Yellow */
      0xF7, 0xF7		/* White (neutral color) */
    };

  static unsigned char color_mono[] = 
    {
      0, 22,			/* Length */
      SF_REPLY, QC_COLOR,	/* Header */
      0,			/* Flags */
      8,			/* Number of CAV/COLOR pairs */
      0x00, 0xF8,		/* Black (default color) */
      0xF1, 0x00,		/* Default */
      0xF2, 0x00,		/* Default */
      0xF3, 0x00,		/* Default */
      0xF4, 0x00,		/* Default */
      0xF5, 0x00,		/* Default */
      0xF6, 0x00,		/* Default */
      0xF7, 0x00		/* Default */
    };

  static unsigned char hilight[] = 
    {
      0, 13,			/* Length */
      SF_REPLY, QC_HIGHLIGHT,	/* Header */
      4,			/* Number of attribute-value/action pairs */
      0x00, 0xF0,		/* Default = Normal Hilight */
      0xF1, 0xF1,		/* Blink */
      0xF2, 0xF2,		/* Reverse Video */
      0xF4, 0xF4		/* Underscore */
    };
  /* Note:  We say that blink is supported even though it isn't because
     some programs (e.g. IOS3270) won't try to use reverse video or
     underscore unless they see blink too.  */

  static unsigned char usable[] =
    {
      0, 23,			/* Length */
      SF_REPLY, QC_AREA,	/* Header */
      1, 0,			/* Flags */
      0, 0, 0, 0,		/* Width, Height (filled in) */
      1,			/* Units = Millimeters */
      0, 0, 0, 0, 0, 0, 0, 0,	/* Xr, Yr (filled in) */
      0, 0,			/* AW, AH (filled in) */
      0, 0			/* Buffer size (filled in) */
    };

  static unsigned char charsets[] =
    {
      0, 27,			/* Length */
      SF_REPLY, QC_CHARSETS,	/* Header */
      0x82,			/* Flags = GE supported, CGSCGID present */
      0,			/* More flags */
      0, 0,			/* SDW, SDH (filled in) */
      0, 0, 0, 0,		/* LOAD PS format types not supported */
      7,			/* Descriptor length */
        0,			/* Device specific Character Set ID */
        0,			/* Flags */
        0,			/* Local character set ID */
        2, 0xB9, 0, 37,		/* Coded Graphic Character Set Identifier */
        1,			/* Device specific Character Set ID */
        0,			/* Flags */
        241,			/* Local character set ID */
        3, 0xC3, 1, 0x36	/* Coded Graphic Character Set Identifier */
    };

  static unsigned char imppart[] =
    {
      0, 17,			/* Length */
      SF_REPLY, QC_IMPPART,	/* Header */
      0, 0,			/* Flags */
      11,			/* Length of this self-defining parameter */
      1,			/* Implicit partition sizes */
      0,			/* Flags */
      0, DEFCOLS,		/* Default screen width */
      0, DEFROWS,		/* Default screen height */
      0, 0,			/* Alternate screen width (filled in) */
      0, 0			/* Alternate screen height (filled in) */
    };

  static unsigned char replymodes[] =
    {
      0, 7,			/* Length */
      SF_REPLY, QC_REPLYMODES,	/* Header */
      0,			/* Field mode is supported */
      1,			/* Extended field mode is supported */
      2				/* Character mode is supported */
    };

  static unsigned char segment[] =
    {
      0, 11,			/* Length */
      SF_REPLY, QC_SEGMENT,	/* Header */
      0,			/* Reserved */
      2, 0,			/* Drawing order subset = 2 */
      0, 0,			/* Maximum size of segment storable */
      0xFF, 0xFF		/* Maximum size of segment data */
    };

  static unsigned char procedure[] =
    {
      0, 21,			/* Length */
      SF_REPLY, QC_PROCEDURE,	/* Header */
      0,			/* Flags = Autostart */
      1, 0,			/* Procedure subset level = 1 */
      0, 0,			/* Maximum size of procedure storable */
      0xFF, 0xFF,		/* Maximum size of procedure data */
      6, 0,			/* Maximum size of data storable */
      6, 0,			/* Maximum size of data unit data */
        6,			/* Length of parameter */
        1,			/* Built-in procedure */
        0xFF, 0xFF, 0xFF, 0xF0	/* BP1 for output only device */
    };

  static unsigned char linetype[] =
    {
      0, 24,			/* Length */
      SF_REPLY, QC_LINETYPE,	/* Header */
      0,			/* Reserved */
      9,			/* Number of pairs */
      0, 7,			/* Solid (default) */
      1, 1,			/* Dotted */
      2, 2,			/* Short dashed */
      3, 3,			/* Dash-dot */
      4, 4,			/* Double dotted */
      5, 5,			/* Long dashed */
      6, 6,			/* Dash-double-dot */
      7, 7,			/* Solid */
      8, 8			/* Invisible */
    };

  static unsigned char port1[] =
    {
      0, 27,			/* Length */
      SF_REPLY, QC_PORT,	/* Header */
      0, 3,			/* Port Identity */
      2,			/* Type = Locator */
      0xF0,			/* Flags */
      19,			/* Length of self-defining parameter */
        1,			/* Locator descriptor */
        0, 3,			/* Device ID = Mouse */
        2,			/* Type = Relative */
        0x80, 0, 0x7F, 0xFF,	/* X Range */
        0, 3, 0xE8,		/* X Resolution */
        0x80, 0, 0x7F, 0xFF,	/* Y Range */
        0, 3, 0xE8		/* Y Resolution */
    };

  static unsigned char port2[] =
    {
      0, 15,			/* Length */
      SF_REPLY, QC_PORT,	/* Header */
      0, 4,			/* Port Identity */
      8,			/* Type = Simple button */
      0x60,			/* Flags */
      7,			/* Length of self-defining parameter */
        3,			/* Button descriptor */
        0, 3,			/* Device ID = Mouse */
        0x80,			/* Flags */
        0, 2			/* Number of buttons */
    };

  static unsigned char port3[] =
    {
      0, 15,			/* Length */
      SF_REPLY, QC_PORT,	/* Header */
      0, 7,			/* Port Identity */
      8,			/* Type = Simple button */
      0x60,			/* Flags */
      7,			/* Length of self-defining parameter */
        3,			/* Button descriptor */
        0, 1,			/* Device ID = Keyboard */
        0,			/* Flags */
        0, 28			/* Number of buttons */
    };

  static unsigned char grcolor[] =
    {
      0, 109,			/* Length */
      SF_REPLY, QC_GRCOLOR,	/* Header */
      0,			/* Reserved */
      4,			/* Index of default foreground CAV */
      0,			/* Index of default background CAV */
      255,			/* Number of intensity levels supported */
      0xFF,			/* Color table indentity */
      0, 16,			/* Number of color entries */
      0, 16,			/* Number of intensity definitions following */
      0, 0, 0, 0, 0, 0,		/* Black */
      0, 1, 0, 0, 0, 0,		/* Blue */
      0, 2, 0, 0, 0, 0,		/* Red */
      0, 3, 0, 0, 0, 0,		/* Pink */
      0, 4, 0, 0, 0, 0,		/* Green */
      0, 5, 0, 0, 0, 0,		/* Turquoise */
      0, 6, 0, 0, 0, 0,		/* Yellow */
      0, 7, 0, 0, 0, 0,		/* White */
      0, 8, 0, 0, 0, 0,		/* Brown */
      0, 9, 0, 0, 0, 0,		/* Dark Blue */
      0, 10, 0, 0, 0, 0,	/* Orange */
      0, 11, 0, 0, 0, 0,	/* Purple */
      0, 12, 0, 0, 0, 0,	/* Dark Green */
      0, 13, 0, 0, 0, 0,	/* Dark Turquoise */
      0, 14, 0, 0, 0, 0,	/* Mustard */
      0, 15, 0, 0, 0, 0		/* Gray */
    };

  static unsigned char summary[] =
    {
      0, 16,			/* Length */
      SF_REPLY, QC_SUMMARY,	/* Header */
      QC_SUMMARY, QC_AREA, QC_CHARSETS, QC_COLOR, QC_HIGHLIGHT,
      QC_REPLYMODES, QC_IMPPART, QC_SEGMENT, QC_PROCEDURE,
      QC_LINETYPE, QC_PORT, QC_GRCOLOR
    };

  static unsigned char summary_mono[] =
    {
      0, 15,			/* Length */
      SF_REPLY, QC_SUMMARY,	/* Header */
      QC_SUMMARY, QC_AREA, QC_CHARSETS, QC_COLOR, QC_HIGHLIGHT,
      QC_REPLYMODES, QC_IMPPART, QC_SEGMENT, QC_PROCEDURE,
      QC_LINETYPE, QC_PORT
    };

  static unsigned char summary_nograph[] =
    {
      0, 11,			/* Length */
      SF_REPLY, QC_SUMMARY,	/* Header */
      QC_SUMMARY, QC_AREA, QC_CHARSETS, QC_COLOR, QC_HIGHLIGHT,
      QC_REPLYMODES, QC_IMPPART
    };

  x_parms(&widthmm, &width, &heightmm, &height, &charwidth, &charheight,
	  &mono);

  net_put(rp, sizeof rp);

  if (mono) 
    net_put(color_mono, sizeof color_mono);
  else
    net_put(color, sizeof color);

  net_put(hilight, sizeof hilight);
  
  storew(usable, 6, altcols);
  storew(usable, 8, altrows);
  storew(usable, 11, widthmm);
  storew(usable, 13, width);
  storew(usable, 15, heightmm);
  storew(usable, 17, height);
  usable[19] = charwidth;
  usable[20] = charheight;
  storew(usable, 21, altcols * altrows);
  net_put(usable, sizeof usable);

  charsets[6] = charwidth;
  charsets[7] = charheight;
  net_put(charsets, sizeof charsets);

  storew(imppart, 13, altcols);
  storew(imppart, 15, altrows);
  net_put(imppart, sizeof imppart);

  net_put(replymodes, sizeof replymodes);

  if (graphics)
    {
      net_put(segment, sizeof segment);
      net_put(procedure, sizeof procedure);
      net_put(linetype, sizeof linetype);
      net_put(port1, sizeof port1);
      net_put(port2, sizeof port2);
      net_put(port3, sizeof port3);
      if (mono)
	net_put(summary_mono, sizeof summary_mono);
      else
	{
	  int j, k;
	  unsigned char *colorinfo;
	  colorinfo = graph_colorinfo();
	  for (j = 0; j < 16; j++)
	    for (k = 0; k < 3; k++)
	      grcolor[15 + j * 6 + k] = colorinfo[j * 3 + k];
	  net_put(grcolor, sizeof grcolor);
	  net_put(summary, sizeof summary);
	}
    }
  else
    net_put(summary_nograph, sizeof summary_nograph);

  net_eor();
}
