/* Attribute value definitions */

/* Extended attributes */
#define DEFAULT_CA  0x00
#define COLOR_MASK  0x0F
#define HI_MASK     0x30
#define HI_BLINK    0x10
#define HI_REVERSE  0x20
#define HI_UNDER    0x30
#define GRAPHIC     0x40
#define CHARSET     0x80

/* Internal color values (don't change the order) */
#define IC_UNFORMAT	0
#define IC_DEFINTENSE   1
#define IC_PN		4
#define IC_PI		5
#define IC_UN		6
#define IC_UI		7
#define IC_DEFAULT	8
#define IC_BLUE		9
#define IC_RED		10
#define IC_PINK		11
#define IC_GREEN	12
#define IC_TURQUOISE	13
#define IC_YELLOW	14
#define IC_WHITE	15
#define NUM_IC		16

#define IC_INTENSE      1
#define IC_EXTCOLOR     8
#define EXT_MASK	7

/* Note:  The IC_EXTCOLOR bit is off in character and extended field
   attribute storage.  It is only turned on when attributes are passed
   to x_write.

   With no extended colors being used (four-color mode), the color
   value is assigned based on the internal attribute value (attrib
   variable in the "field" structure).  It will have one of the
   following values:

	    0 - Unformatted
	    4 - FORMATTED				PN
	    5 - FORMATTED + INTENSE			PI
	    6 - FORMATTED + UNPROTECTED			UN
	    7 - FORMATTED + INTENSE + UNPROTECTED	UI

   When extended colors are used, the color is assigned based on the
   foreground color extended field or character attribute.  Values
   coming from the host are 0x00, 0xF1, 0xF2, ..., 0xF7.  The low order
   three bits are saved in the "ca" array.  When sent to x_write, the
   color value is created by turning on the IC_EXTCOLOR bit (unless the
   value was zero).  Here are the possibilities:

	    0 - Sent as 1 if INTENSE bit is on in internal attribute
	        Sent as 8 if INTENSE bit is off in internal attribute
	    1 - Sent as 9
	    2 - Sent as 10
	    3 - Sent as 11
	    4 - Sent as 12
	    5 - Sent as 13
	    6 - Sent as 14
	    7 - Sent as 15
*/
