/* Definitions that are shared by s3270 and s3270loc */

#define nextpos(pos) ((pos) + 1 == scrsize ? 0 : (pos) + 1)
#define prevpos(pos) ((pos) - 1 < 0 ? scrsize - 1 : (pos) - 1)

#define EBCSPACE 0x40		/* An EBCDIC space */

#define True 1
#define False 0

typedef char Boolean;

typedef struct _field
{
  struct _field *next, *prev;	/* Link to next and previous field */
  int pos, len;			/* Position and length */
  char attrib;			/* Attributes */
} field;


/* Values for attribute character in a field (these are tied to
   internal color values) */

#define INTENSE     1
#define UNPROTECTED 2
#define FORMATTED   4
#define INVISIBLE   8
#define NUMERIC     16


/* Notes on attribute storage:

   -- Field attributes that come from the host are stored in the screen
      position corresponding to the start of the field.  The bits in these
      attributes are defined by the ATTR_xxx definitions.  Field attributes
      are sent back to the host by read buffer and read modified commands.
      Even though the information is stored in the screen variable, the
      data always shows on the real display screen as a space.

  -- Extended field attributes are stored in the "ca" buffer in the
     position corresponding to the start of the field.  Start of field
     characters don't have character attributes, so those positions in
     the "ca" buffer are available.  The bits are defined the same as
     for character attributes (see below).

  -- Character attributes are stored in the "ca" buffer.  The attributes
     coming from the host are encoded into a single byte as follows
     (see s3270.h):

	  Bit 7     Alternate character set
	  Bit 6     Graphic escape
	  Bits 5-4  Extended hilighting
	  Bits 3-0  Internal color value

  -- An internal representation of field attributes is stored in the
     attrib item in the field structure.  Definitions for protected,
     invisible, etc. are split out into separate bits rather than being
     encoded as they are in the real field attribute.  Also, the
     representation was designed for easy conversion to an internal
     color value.

  -- Attributes are also passed to the xstuff module.  The bits are
     defined the same as for extended field or character attributes,
     but xstuff doesn't know anything about fields, so the field,
     extended field, and character attributes are combined, if necessary,
     before being passed to xstuff.
*/
