#ifdef __cplusplus
extern "C" {
#endif
#ifndef H_SCCSID
#include <sccs.h>
#endif /* ! H_SCCSID */
H_SCCSID(@(#)NLctype.h	1.12	AIX)	/* Modified: 17:15:29 11/20/90 */
/* @(#)NLctype.h	7.1 - 87/06/16 - 00:15:35 */
/* 
 * (C) Copyright IBM Corp. 1989 
 * All Rights Reserved 
 * Licensed Materials - Property of IBM 
 */


#ifndef	_h_NLCTYPE
#define	_h_NLCTYPE

#ifdef _MBCS

#include <limits.h>

#ifndef	_h_NLCHAR
#include <NLchar.h>
#endif

#ifndef	_h_CTYPE
#include <ctype.h>
#endif

/*  Ctype definitions for use with NLS classification table.
 *  (Note:  NCisshift definition is in NLchar.h.)
 */

#ifndef lint

/************************************************* character types *********/

#define	NCisalpha	iswalpha
#define	NCisupper	iswupper
#define	NCislower	iswlower
#define	NCisdigit	iswdigit
#define	NCisxdigit	iswxdigit
#define	NCisalnum	iswalnum
#define	NCisspace	iswspace
#define	NCispunct	iswpunct
#define	NCisprint	iswprint
#define	NCisgraph	iswgraph
#define	NCiscntrl	iswcntrl
#define	_NCtoupper	towupper	
#define	_NCtolower	towlower


#define	NCisNLchar(c)	(NCisNLc(c) >= 0)
#endif

/*  Macros with no old equivalents.
 */
extern char _NLflattab[];
extern unsigned _NLflattsize;

#ifndef lint
#define	NCflatchr(c)	(((unsigned)(c) < 0x80) ? \
			(c) : ((wctomb(__temp_ch, c) == 1) && \
			(unsigned)((*(__temp_ch)) - 0x80 < _NLflattsize)) ? \
				_NLflattab[(*(__temp_ch)) - 0x80] : '?')
#define	NCtoNLchar(c)	((c) & 0x2ff)
#endif


/*  Information-preserving escape sequence definitions:
 */
#define NLESCMAX	MB_LEN_MAX	/* Maximum length of a sequence */

/*  Map from code point to escape sequence.
 */
extern char _NLesctab[];
extern unsigned _NLesctsize;

/*  Map from escape sequence to code point.
 */
extern struct NLescdata {
	unsigned char key[2];
	NLchar value;
} _NLunesctab[];
extern unsigned _NLunesctsize;

#ifndef lint

/*  Translate single NLchar at nlc to char escape string at c.
 */
#define NCesc(nlc, c)	(((unsigned)*(nlc) < 0x80) ? \
			    ((c)[0] = *(nlc), 1) : \
			    ((c)[0] = '\\', \
			        (c)[1] = '<', \
			    	(((wctomb(__temp_ch,(*(nlc))) != 1) || \
			        (_NLesctsize<= (unsigned)*(__temp_ch)-0x80)) ? \
				    ((c)[2] = '?', \
				    (c)[3] = '?') : \
				    ((c)[2] = _NLesctab[*(__temp_ch)-0x80<<1], \
				    (c)[3]= _NLesctab[(*(__temp_ch)-0x80<<1)+1])), \
			        (((c)[3]) ? ((c)[4] = '>', 5) \
					: ((c)[3] = '>', 4))))

/*  Translate char escape string at c to single NLchar at nlc.
 */
#define NCunesc(c, nlc)	(((c)[0] != '\\' || (c)[1] != '<' || \
				_NLunescval(&(c)[2], \
					((c)[3] == '>') ? 1 : 2, (nlc)) < 0) ? \
				((nlc)[0] = (c)[0], 1) : \
				((c)[3] == '>') ? 4 : \
				((c)[4] == '>') ? 5 : \
				((nlc)[0] = (c)[0], 1))

#endif

#else  /* _MBCS not defined ==> 1.2 header */

#ifndef _CTYPE_
#define _CTYPE_
#define	_U	01
#define	_L	02
#define	_N	04
#define	_S	010
#define	_P	020
#define	_C	040
#define	_B	0100
#define	_X	0200

extern char	_ctype[];

#include <NLchar.h>

#ifndef lint
#define	isalpha(c)	((_ctype+1)[c]&(_U|_L))
#define	isupper(c)	((_ctype+1)[c]&_U)
#define	islower(c)	((_ctype+1)[c]&_L)
#define	isdigit(c)	((_ctype+1)[c]&_N)
#define	isxdigit(c)	((_ctype+1)[c]&_X)
#define	isalnum(c)	((_ctype+1)[c]&(_U|_L|_N))
#define	isspace(c)	((_ctype+1)[c]&_S)
#define	ispunct(c)	((_ctype+1)[c]&_P)
#define	isprint(c)	((_ctype+1)[c]&(_P|_U|_L|_N|_B))
#define	isgraph(c)	((_ctype+1)[c]&(_P|_U|_L|_N))
#define	iscntrl(c)	((_ctype+1)[c]&_C)
#define isascii(c)      (!((c)&~0177))
#define	_toupper(c)	((c)-'a'+'A')
#define	_tolower(c)	((c)-'A'+'a')
#define	toascii(c)	((c)&0177)
#endif


/*  Ctype definitions for use with NLS classification table.
 *  (Note:  NCisshift definition is in NLchar.h.)
 */
#define NLctyp 		_NLctab->ct_ctype

#ifndef lint
#define	NCisalpha(c)	((NLctyp+1)[c] & (_U|_L))
#define	NCisupper(c)	((NLctyp+1)[c] & _U)
#define	NCislower(c)	((NLctyp+1)[c] & _L)
#define	NCisdigit(c)	((NLctyp+1)[c] & _N)
#define	NCisxdigit(c)	((NLctyp+1)[c] & _X)
#define	NCisalnum(c)	((NLctyp+1)[c] & (_U|_L|_N))
#define	NCisspace(c)	((NLctyp+1)[c] & _S)
#define	NCispunct(c)	((NLctyp+1)[c] & _P)
#define	NCisprint(c)	((NLctyp+1)[c] & (_P|_U|_L|_N|_B))
#define	NCisgraph(c)	((NLctyp+1)[c] & (_P|_U|_L|_N))
#define	NCiscntrl(c)	((NLctyp+1)[c] & _C)
#define	NCisNLchar(c)	((unsigned)(c) < NLCHARMAX)
#define	_NCtoupper(c)	((_NLctab->ct_caseconv+1)[c]) /* assume lowercase c */
#define	_NCtolower(c)	((_NLctab->ct_caseconv+1)[c]) /* assume uppercase c */
#endif

/*  Macros with no old equivalents.
 */
extern char _NLflattab[];
extern unsigned _NLflattsize;

#ifndef lint
#define	NCflatchr(c)	(((unsigned)(c) < 0x80) ? \
				(c) : ((unsigned)(c) - 0x80 < _NLflattsize) ? \
				_NLflattab[c - 0x80] : '?')
#define	NCtoNLchar(c)	((c) & 0x2ff)
#endif


/*  Information-preserving escape sequence definitions:
 */
#define NLESCMAX	5	/* Maximum length of a sequence */

/*  Map from code point to escape sequence.
 */
extern char _NLesctab[];
extern unsigned _NLesctsize;

/*  Map from escape sequence to code point.
 */
extern struct NLescdata {
	unsigned char key[2];
	NLchar value;
} _NLunesctab[];
extern unsigned _NLunesctsize;

#ifndef lint

/*  Translate single NLchar at nlc to char escape string at c.
 */
#define NCesc(nlc, c)	(((unsigned)*(nlc) < 0x80) ? \
			    ((c)[0] = *(nlc), 1) : \
			    ((c)[0] = '\\', \
			        (c)[1] = '<', \
			        ((_NLesctsize <= (unsigned)*(nlc)-0x80) ? \
				    ((c)[2] = '?', \
				    (c)[3] = '?') : \
				    ((c)[2] = _NLesctab[*(nlc)-0x80<<1], \
				    (c)[3] = _NLesctab[(*(nlc)-0x80<<1)+1])), \
			        (((c)[3]) ? ((c)[4] = '>', 5) \
					: ((c)[3] = '>', 4))))

/*  Translate char escape string at c to single NLchar at nlc.
 */
#define NCunesc(c, nlc)	(((c)[0] != '\\' || (c)[1] != '<' || \
				_NLunescval(&(c)[2], \
					((c)[3] == '>') ? 1 : 2, (nlc)) < 0) ? \
				((nlc)[0] = (c)[0], 1) : \
				((c)[3] == '>') ? 4 : \
				((c)[4] == '>') ? 5 : \
				((nlc)[0] = (c)[0], 1))

#endif
#endif

#endif  /* _MBCS */

#endif /*_h_NLCTYPE */
#ifdef __cplusplus
}
#endif
