#ifdef __cplusplus
extern "C" {
#endif
/*
 * Copyright (c) 1983 Regents of the University of California.
 * All rights reserved.  The Berkeley software License Agreement
 * specifies the terms and conditions for redistribution.
 *
 *	@(#)nameser.h	5.17 (Berkeley) 11/17/87
 */

#ifndef H_SCCSID
#include <sccs.h>
#endif /* ! H_SCCSID */
H_SCCSID(@(#)nameser.h	1.7.1.1	AIX)	/* Modified 7/23/90 19:03:50 */

/*
 * Define constants based on rfc883
 */
#define PACKETSZ	512		/* maximum packet size */
#define MAXDNAME	256		/* maximum domain name */
#define MAXCDNAME	255		/* maximum compressed domain name */
#define MAXLABEL	63		/* maximum length of domain label */
	/* Number of bytes of fixed size data in query structure */
#define QFIXEDSZ	4
	/* number of bytes of fixed size data in resource record */
#define RRFIXEDSZ	10

/*
 * Internet nameserver port number
 */
#define NAMESERVER_PORT	53

/*
 * Currently defined opcodes
 */
#define QUERY		0x0		/* standard query */
#define IQUERY		0x1		/* inverse query */
#define STATUS		0x2		/* nameserver status query */
/*#define xxx		0x3		/* 0x3 reserved */
	/* non standard */
#define UPDATEA		0x9		/* add resource record */
#define UPDATED		0xa		/* delete a specific resource record */
#define UPDATEDA	0xb		/* delete all nemed resource record */
#define UPDATEM		0xc		/* modify a specific resource record */
#define UPDATEMA	0xd		/* modify all named resource record */

#define ZONEINIT	0xe		/* initial zone transfer */
#define ZONEREF		0xf		/* incremental zone referesh */

/*
 * Currently defined response codes
 */
#define NOERROR		0		/* no error */
#define FORMERR		1		/* format error */
#define SERVFAIL	2		/* server failure */
#define NXDOMAIN	3		/* non existent domain */
#define NOTIMP		4		/* not implemented */
#define REFUSED		5		/* query refused */
	/* non standard */
#define NOCHANGE	0xf		/* update failed to change db */

/*
 * Type values for resources and queries
 */
#define T_A		1		/* host address */
#define T_NS		2		/* authoritative server */
#define T_MD		3		/* mail destination */
#define T_MF		4		/* mail forwarder */
#define T_CNAME		5		/* connonical name */
#define T_SOA		6		/* start of authority zone */
#define T_MB		7		/* mailbox domain name */
#define T_MG		8		/* mail group member */
#define T_MR		9		/* mail rename name */
#define T_NULL		10		/* null resource record */
#define T_WKS		11		/* well known service */
#define T_PTR		12		/* domain name pointer */
#define T_HINFO		13		/* host information */
#define T_MINFO		14		/* mailbox information */
#define T_MX		15		/* mail routing information */
	/* non standard */
#define T_UINFO		100		/* user (finger) information */
#define T_UID		101		/* user ID */
#define T_GID		102		/* group ID */
#define T_UNSPEC	103		/* Unspecified format (binary data) */
	/* Query type values which do not appear in resource records */
#define T_AXFR		252		/* transfer zone of authority */
#define T_MAILB		253		/* transfer mailbox records */
#define T_MAILA		254		/* transfer mail agent records */
#define T_ANY		255		/* wildcard match */

/*
 * Values for class field
 */

#define C_IN		1		/* the arpa internet */
#define C_CHAOS		3		/* for chaos net at MIT */
	/* Query class values which do not appear in resource records */
#define C_ANY		255		/* wildcard match */

/*
 * Status return codes for T_UNSPEC conversion routines
 */
#define CONV_SUCCESS 0
#define CONV_OVERFLOW -1
#define CONV_BADFMT -2
#define CONV_BADCKSUM -3
#define CONV_BADBUFLEN -4

/*
 * Structure for query header, the order of the fields is machine and
 * compiler dependent, in our case, the bits within a byte are assignd 
 * least significant first, while the order of transmition is most 
 * significant first.  This requires a somewhat confusing rearrangement.
 */

/*
 * The header structure was changed to one unsigned bitfield as opposed
 * to one unsigned short, and 2 unsigned char bitfields due to problems
 * with the PS/2 compiler. This format should work anywhere. 
 */

typedef struct {
#if defined (sun) || defined (sel) || defined (pyr) || defined (is68k) \
|| defined (tahoe) || defined (BIT_ZERO_ON_LEFT)
	/* Bit zero on left:  Gould and similar architectures */
	unsigned	id:16;		/* query identification number */
			/* fields in third byte */
	unsigned	qr:1;		/* response flag */
	unsigned	opcode:4;	/* purpose of message */
	unsigned	aa:1;		/* authoritive answer */
	unsigned	tc:1;		/* truncated message */
	unsigned	rd:1;		/* recursion desired */
			/* fields in fourth byte */
	unsigned	ra:1;		/* recursion available */
	unsigned	pr:1;		/* primary server required (non standard) */
	unsigned	unused:2;	/* unused bits */
	unsigned	rcode:4;	/* response code */
#else
#if defined (vax) || defined(ns32000) || defined (BIT_ZERO_ON_RIGHT)
	/* Bit zero on right:  VAX */
	unsigned	id:16;		/* query identification number */
			/* fields in third byte */
	unsigned	rd:1;		/* recursion desired */
	unsigned	tc:1;		/* truncated message */
	unsigned	aa:1;		/* authoritive answer */
	unsigned	opcode:4;	/* purpose of message */
	unsigned	qr:1;		/* response flag */
			/* fields in fourth byte */
	unsigned	rcode:4;	/* response code */
	unsigned	unused:2;	/* unused bits */
	unsigned	pr:1;		/* primary server required (non standard) */
	unsigned	ra:1;		/* recursion available */
#else
#if defined (u370) || defined (__UNDEF__) || defined (i386) || defined (__UNDEF__)
	u_short		id;		/* query identification number */
	/* use masks instead of bit fields */
	u_char	qh1flds;	/* 1st byte of header info */
#define	QH1_QR		0x80	/* response flag */
#define	QH1_OPCODE	0x78	/* query type code */
#define QH1_AA		0x04	/* authoritative answer */
#define	QH1_TC		0x02	/* truncated message */
#define	QH1_RD		0x01	/* recursion desired */
	/* macros to convert opcodes to and from header format */
#define OPCODE_2_HDR(hfld, ov)	hfld = (((hfld) & ~QH1_OPCODE) | (((ov) & 0x0f) << 3))
#define HDR_2_OPCODE(hv)	(((hv) >> 3) & 0x0f)

	u_char	qh2flds;	/* 2nd byte of header info */
#define QH2_RA		0x80	/* recursion available */
#define QH2_PR		0x40	/* primary server required (non standard) */
#define QH2_RCODE	0x0f	/* response code */
	/* macros to convert rcodes to and from header format */
#define RCODE_2_HDR(hfld, rv)	hfld = (((hfld) & ~QH2_RCODE) | ((rv) & 0x0f))
#define HDR_2_RCODE(hv)		((hv) & 0x0f)

#else
	/* you must determine what the correct bit order is for your compiler */
	UNDEFINED_BIT_ORDER;
#endif
#endif
#endif
			/* remaining bytes */
	u_short	qdcount;	/* number of question entries */
	u_short	ancount;	/* number of answer entries */
	u_short	nscount;	/* number of authority entries */
	u_short	arcount;	/* number of resource entries */
} HEADER;

/*
 * Defines for handling compressed domain names
 */
#define INDIR_MASK	0xc0

/*
 * Structure for passing resource records around.
 */
struct rrec {
	short	r_zone;			/* zone number */
	short	r_class;		/* class number */
	short	r_type;			/* type number */
	u_long	r_ttl;			/* time to live */
	int	r_size;			/* size of data area */
	char	*r_data;		/* pointer to data */
};

extern	u_short	_getshort();
extern	u_long	_getlong();

/*
 * Inline versions of get/put short/long.
 * Pointer is advanced; we assume that both arguments
 * are lvalues and will already be in registers.
 * cp MUST be u_char *.
 */
#define GETSHORT(s, cp) { \
	(s) = *(cp)++ << 8; \
	(s) |= *(cp)++; \
}

#define GETLONG(l, cp) { \
	(l) = *(cp)++ << 8; \
	(l) |= *(cp)++; (l) <<= 8; \
	(l) |= *(cp)++; (l) <<= 8; \
	(l) |= *(cp)++; \
}


#define PUTSHORT(s, cp) { \
	*(cp)++ = (s) >> 8; \
	*(cp)++ = (s); \
}

/*
 * Warning: PUTLONG destroys its first argument.
 */
#define PUTLONG(l, cp) { \
	(cp)[3] = l; \
	(cp)[2] = (l >>= 8); \
	(cp)[1] = (l >>= 8); \
	(cp)[0] = l >> 8; \
	(cp) += sizeof(u_long); \
}
#ifdef __cplusplus
}
#endif
