#ifdef __cplusplus
extern "C" {
#endif
#ifndef H_SCCSID
#include <sccs.h>
#endif /* ! H_SCCSID */
H_SCCSID(@(#)backup.h	1.20.1.2	LCC)	/* Modified: 15:13:38 4/13/91 */
/* @(#)backup.h	7.2 - 87/07/28 - 10:18:09 */
/* 
* (C) Copyright IBM Corp. 1989, 1989
 * All Rights Reserved 
 * Licensed Materials - Property of IBM 
 */

#include <sys/dir.h>

/*
 *      bitmap parameters.
 *      note: 8K * 8 == 64K, largest possible inumber
 */
#define MLEN             8              /* number of bits per map word   */
#define MSIZ            (8*1024)        /* number of words in map        */
#define BIGMSIZ         (32*1024)       /* number of words in map for    */
					/* more than 65536               */
#define HUGEMSIZ	(BIGMSIZ*8)	/* Mucho bigger			 */
/*
 * Because of the end-around copying done in readtape, buffers
 * returned by readtape must be no greater than RDTMAX bytes
 */
#define RDTMAX BSIZE	/* maximum tape read length */

/*
 * macros for accessing bitmaps
 *      MWORD( map, bitno )     returns word containing specified bit
 *      MBIT(i)                 returns mask for specified bit within map word
 *      BIS                     turns on specified bit in map
 *      BIC                     turns off specified bit in map
 *      BIT                     tests specified bit in map
 */
#define	MWORD(m,i) (m[(unsigned)(i-1)/MLEN])
#define	MBIT(i)	(1<<((unsigned)(i-1)%MLEN))
#define	BIS(i,w)	(MWORD(w,i) |=  MBIT(i))
#define	BIC(i,w)	(MWORD(w,i) &= ~MBIT(i))
#define	BIT(i,w)	(MWORD(w,i) & MBIT(i))

/*
 * format of inode dump
 *      FS_VOLUME
 *      FS_CLRI         (if incremental)
 *              list of inodes unallocated at time of dump
 *
 *      FS_BITS         (just before the first FS_INODE header on each vol.)
 *              list of files on this and succeeding volumes
 *
 *      FS_FINDEX
 *              index of files on this volume.  the last file or two
 *              may not be indexed, for space reasons.  the link field
 *              gives the address of the next FS_INDEX on this volume.
 *
 *      FS_INODE        (before each file)
 *      file data
 *      FS_END or FS_VOLEND
 *
 * format of name dump:
 *      FS_VOLUME
 *      FS_NAME         (before each file)
 *      file data
 *      FS_END
 *
 * format of minidisk dump:
 *      FS_VOLUME
 *      <FS total blocks>       (1 "word" record only on 1rst volume)
 *      file system image
 *      FS_END
 */

#define MAGIC           (int)60011   /* magic number for headers      */
#define PACKED_MAGIC    (int)60012   /* magic # for Huffman packed format */
#define CHECKSUM        (int)84446   /* checksum for all headers      */

/*
 * the file /etc/budates contains a record for the last dump of each file
 *     system at each level.  This file is used to determine how far back
 *     new dumps should extend.  The record format is ...
 */
struct	idates
{
	char	id_name[MAXDIRLEN];
	char	id_incno;
	time_t	id_budate;
};

/*
 * header types.  the hdrlen[] array (dump and restor) assumes that
 * the numbers begin at 0, and that they are in this order.
 * the VOINODE and VONAME records are not produced by backup, but were
 * produced by older versions, and restore knows how to interpret
 * them.
 */
#define FS_VOLUME        0
#define FS_DFINDEX       1
#define FS_CLRI          2
#define FS_BITS          3
#define FS_OINODE        4
#define FS_ONAME         5
#define FS_VOLEND        6
#define FS_END           7
#define FS_DINODE        8
#define FS_DNAME         9
#define FS_DS           10
#define FS_INODE        11
#define FS_NAME         12
#define	FS_FINDEX	13
#define FS_BIGCLRI      14
#define FS_BIGBITS      15
#define FS_HUGECLRI     16
#define FS_HUGEBITS     17

/* other constants */
#define FXLEN          80       /* length of file index */

/* commands to findex */
#define TBEG    0               /* start indexing */
#define TEND    1               /* end of this track */
#define TINS    2               /* install new inode in index */

/*
 * the addressing unit is 8-byte "words", also known as dwords
 */
#define BPW     8
#define LOGBPW  3
typedef struct {char x[BPW];} dword;

/* bytes to "words" and back; must fit into char */
/* must be even -- so always room for VOLEND record (8 bytes long) */
#define btow(x)   ( ((x) + BPW - 1) >> LOGBPW)
#define wtob(x)   ( (x) << LOGBPW )

long    XXlong();
short   XXshort();
#define rlong(a)    ((a) = XXlong((a),0))
#define wlong(a)    ((a) = XXlong((a),0))
#define rshort(a)   ((a) = XXshort((a),0))
#define wshort(a)   ((a) = XXshort((a),0))

#define SIZHDR    btow(sizeof(struct hdr))
#define DUMNAME   4     /* dummy name length for FS_NAME */
#define SIZSTR   16     /* size of strings in the volume record */
#define NAMESZ	100	/* internal name string sizes */

#define min(a,b)  ( ((a) < (b))? (a): (b) )
#define max(a,b)  ( ((a) > (b))? (a): (b) )

#define BYNAME  100             /* must be illegal v.incno */
#define BYINODE 101             /*    "       "       "    */
#define BYMD    102             /*    "       "       "    */

#define DONTCOUNT   -1          /* for counting # files we want */

/*
 * the headers follow.  note that there are no places that might
 * tempt a compiler to insert gaps for alignment.  for example,
 * making the FS_FINDEX arrays into an array of (inode, address)
 * structs might later cause trouble.  also, there is code in
 * both dump and restor that reorders the bytes in these headers;
 * this code MUST know about any change in the structures.
 */

struct hdr {                    /* common part of every header */
	unsigned char   len;    /* hdr length in dwords */
	unsigned char   type;   /* FS_* */
	ushort  magic;          /* magic number (MAGIC above) */
	ushort  checksum;
};

union fs_rec {

	/* common fields */
	struct hdr h;

	/* FS_VOLUME -- begins each volume */
	struct {
		struct  hdr h;
		ushort  volnum;         /* volume number */
		time_t  date;           /* current date */
		time_t  budate;          /* starting date */
		daddr_t numwds;         /* number of wds this volume */
		char    disk[SIZSTR];   /* name of disk */
		char    fsname[SIZSTR]; /* name of file system */
		char    user[SIZSTR];   /* name of user */
		short   incno;          /* dump level (or BYNAME) */
	} v;

	/* FS_DFINDEX -- indexes files on this volume */
	struct {
		struct  hdr h;
		ushort  dummy;          /* get the alignment right */
		ushort   ino[FXLEN];     /* inumbers */
		daddr_t addr[FXLEN];    /* addresses */
		daddr_t link;           /* next volume record */
	} dx;

	/* FS_FINDEX -- indexes files on this volume */
	struct {
		struct  hdr h;
		ushort  dummy;          /* get the alignment right */
		ino_t   ino[FXLEN];     /* inumbers */
		daddr_t addr[FXLEN];    /* addresses */
		daddr_t link;           /* next volume record */
	} x;

	/* FS_BITS or FS_CLRI or FS_*BITS or FS_*CLRI */
	struct {
		struct hdr h;
		ushort  nwds;           /* number of words of bits */
	} b;

	/* FS_OINODE */
	struct {
		struct hdr h;
		ushort  ino;            /* inumber */
		ushort  mode;           /* info from inode */
		ushort  nlink;
		ushort  uid;
		ushort  gid;
		off_t   size;
		time_t  atime;
		time_t  mtime;
		time_t  ctime;
		ushort   dev;            /* device file is on */
		ushort   rdev;           /* maj/min devno */
		off_t   dsize;          /* dump size if packed */
	} voi;

	/* FS_DINODE */
	struct {
		struct hdr h;
		ushort  ino;            /* inumber */
		ushort  mode;           /* info from inode */
		ushort  nlink;
		ushort  uid;
		ushort  gid;
		off_t   size;
		time_t  atime;
		time_t  mtime;
		time_t  ctime;
		ushort  devmaj;         /* device file is on */
		ushort  devmin;
		ushort  rdevmaj;        /* maj/min devno */
		ushort  rdevmin;
		off_t   dsize;          /* dump size if packed */
		long    pad;
	} oi;

	/* FS_INODE */
	struct {
		struct hdr h;
		ushort  nlink;
		ulong  ino;            /* inumber */
		ulong  mode;           /* info from inode */
		long  uid;
		long  gid;
		off_t   size;
		time_t  atime;
		time_t  mtime;
		time_t  ctime;
		ushort  devmaj;         /* device file is on */
		ushort  devmin;
		ushort  rdevmaj;        /* maj/min devno */
		ushort  rdevmin;
		off_t   dsize;          /* dump size if packed */
		ulong	gen;		/* inode generation number */
		ulong	cmtcnt;		/* commit count;  (TCF) */
		ulong	fstore;		/* replicated file storage attribute TCF */
		ulong	version;	/* file version number */
		ushort	rdevsite;	/* device site, for device inodes only */
#ifdef	SMALLBLOCKS
		char	sbflag;
		char	pada;
#else	/* SMALLBLOCKS */
		ushort	pada;
#endif	/* SMALLBLOCKS */
	} i;

	/* FS_ONAME */
	/* must be exactly like FS_OINODE except name at end */
	struct {
		struct hdr h;
		ushort  ino;
		ushort  mode;
		ushort  nlink;
		ushort  uid;
		ushort  gid;
		off_t   size;
		time_t  atime;
		time_t  mtime;
		time_t  ctime;
		ushort   dev;
		ushort   rdev;
		off_t   dsize;
		char    name[DUMNAME];  /* file name given by user */
	} von;

	/* FS_DNAME */
	/* must be exactly like FS_DINODE except name at end */
	struct {
		struct hdr h;
		ushort  ino;
		ushort  mode;
		ushort  nlink;
		ushort  uid;
		ushort  gid;
		off_t   size;
		time_t  atime;
		time_t  mtime;
		time_t  ctime;
		ushort  devmaj;         /* device file is on */
		ushort  devmin;
		ushort  rdevmaj;        /* maj/min devno */
		ushort  rdevmin;
		off_t   dsize;
		long    pad;
		char    name[DUMNAME];  /* file name given by user */
	} on;

	/* FS_NAME */
	/* must be exactly like FS_INODE except name at end */
	struct {
		struct hdr h;
		ushort  nlink;
		ulong  ino;            /* inumber */
		ulong  mode;           /* info from inode */
		long  uid;
		long  gid;
		off_t   size;
		time_t  atime;
		time_t  mtime;
		time_t  ctime;
		ushort  devmaj;         /* device file is on */
		ushort  devmin;
		ushort  rdevmaj;        /* maj/min devno */
		ushort  rdevmin;
		off_t   dsize;          /* dump size if packed */
		ulong	gen;		/* inode generation number */
		ulong	cmtcnt;		/* commit count;  (TCF) */
		ulong	fstore;		/* replicated file storage attribute TCF */
		ulong	version;	/* file version number */
		ushort	rdevsite;	/* device site, for device inodes only */
#ifdef	SMALLBLOCKS
		char	sbflag;
		char	pada;
#else	/* SMALLBLOCKS */
		ushort	pada;
#endif	/* SMALLBLOCKS */
		char    name[DUMNAME];  /* file name given by user */
	} n;

	/* FS_END or FS_VOLEND */
	struct {
		struct hdr h;
	} e;

	/* FS_DS */
	struct {
		struct hdr h;
		char	nid[8];
		char	qdir[2];	/* makes it 2 dwords */
	} ds;

};

/* output device info */

#define DEF_LEV		'9'	/* default dump level	*/
#define A_WHILE		150	/* period between informative comments	*/
#define NTRACKS		1	/* default number of tracks per tape unit */

#define ROOT_FILSYS     "/dev/root"
#define DEF_FILSYS      ROOT_FILSYS
#define DEF_MEDIUM	"/dev/rfd0"
#define DEF_DTYP	DD_DISK
#define DEF_CLUSTER	100	/* default tape cluster in 512-byte units */
#define DEF_TLEN        4500    /* default tape length in feet */
#define DEF_TDEN        700     /* default tape density in bytes/inch */
#define IRG             1       /* tape inter-record gap in inches */



#ifdef __cplusplus
}
#endif
