#ifdef __cplusplus
extern "C" {
#endif
#ifndef H_SCCSID
#include <sccs.h>
#endif /* ! H_SCCSID */
H_SCCSID(@(#)cfg04.h	1.12	AIX)	/* Modified: 14:44:03 10/7/91 */

/* @(#)cfg04.h	7.2 - 87/06/21 - 15:05:57 */
/* @(#)cfg04.h	7.2 87/06/21 15:05:57 */

/*  (c) Copyright IBM Corp. 1985, 1989  */
/*  Licensed Material - Program Property of IBM */

#ifndef _h_STDIO
#include <stdio.h>
#endif /* ! _h_STDIO  */

/*      Return codes for common routines */
#define CFG_SUCC  0            /* successful termination */
#define CFG_EOF   4004         /* end of file encountered */
#define CFG_EXBF -4013         /* input exceeds buffer size */
#define CFG_SZNF -4015         /* stanza not found */
#define CFG_SZBF -4016         /* stanza size exceeds buffer size */
#define CFG_UNIO -4017         /* unrecoverable I/O error */

#define CFG_SPCE -4028         /* malloc failed -- out of space */
#define CFG_FRMT -4029         /* attribute file format corrupted */
#define CFG_EOPN -4030         /* error opening file */
#define CFG_ECLS -4032         /* error closing file */
#define CFG_NSCSI -4040        /* attempt to add duplicate SCSI device   */
#define CFG_COMA -4444         /* comma separated list found */

/* declarations for standard lengths */

#define MAXVAL   512    /* maximum size for keyword value */
#define MAXKWD   75     /* maximum keyword length */
#define MAXDDISZ 4096   /* maximum size for DDI stanza */
#define MAXATRSZ 4096   /* maximum size for attribute file stanza */
#define MAXDIR   260    /* maximum directory path length */

/*
 *  Structure for character level access to attribute files
 */

typedef struct {

    FILE *sfile;       /* file pointer returned from fopen */
    char *defbuf;      /* pointer to buffer containing default stanza */
    short *defmap;     /* pointer to array of line indexes in default */
    char spath[MAXDIR];/* Actual filename for re-opens */
    char sympath[MAXDIR]; /*Symbolic name user sees, may be the same as */
			/*the above for files which are not symbolic links*/

} CFG__SFT;


CFG__SFT *cfgcopsf();  /* open routine returns structure pointer */


/*      Macro for rewinding attribute file (handles default info)     */
#define cfgcrwnd(sfptr) { \
	if (sfptr->defbuf != NULL) *sfptr->defbuf = '\0'; \
	rewind(sfptr->sfile); \
	}


#ifdef __cplusplus
}
#endif
