#ifdef __cplusplus
extern "C" {
#endif
#include <sccs.h>
H_SCCSID(@(#)cfgpest.h	1.7	LCC)	/* Modified: 22:53:31 9/16/89 */
/* 
 * (C) Copyright IBM Corp. 1989 
 * All Rights Reserved 
 * Licensed Materials - Property of IBM 
 */

#ifdef BUG

#define TRACE 0

#ifndef BOGUS
#define BUGLEV ((getenv("DBUGL") == NULL) ? 0 : atoi(getenv("DBUGL")))
#define DEBUG_INIT()
#else /* BOGUS */
#define DEBUG_INIT()	if (getenv("DBUGL") == NULL) \
				BUGLEV = 0; \
			else \
				BUGLEV = atoi(getenv("DBUGL"))
extern int BUGLEV;
#endif /* BOGUS */

	      /* Values of "DBUGL" */
#define BUGNFO 1        /* information: e.g., file open/close */
#define BUGACT 3        /* statement of program action */
#define BUGNTF 5        /* interfaces: names, data, return codes */
#define BUGNTA 6        /* interfaces for subordinate routines */
#define BUGNTX 7        /* detailed interface data */
#define BUGGID 9        /* gory internal detail */

#define bugpr(prspec) \
    {fprintf(stderr,"[%s #%d]  ", __FILE__, __LINE__); \
     fprintf prspec;}
#define buglpr(bl,prspec) {if (bl <= BUGLEV) \
    {fprintf(stderr,"[%s #%d]  ", __FILE__, __LINE__); \
     fprintf prspec;}}

#define bugl(bl,comnt) buglc(bl, 0, comnt)

#define bugc(expr,comnt) {if (!(expr)) \
    {fprintf(stderr,"[%s #%d]  %s\n", \
    __FILE__, __LINE__,comnt);}}
#define buglc(bl,expr,comnt) {if ((!(expr)) && (bl <= BUGLEV)) \
    {fprintf(stderr,"[%s #%d]  %s\n", \
    __FILE__, __LINE__,comnt);}}

#define bugx(expr,funct) {if (!(expr)) \
    {fprintf(stderr,"[%s #%d]\n", \
    __FILE__, __LINE__);funct;}}
#define buglx(bl,expr,funct) {if ((!(expr)) && (bl <= BUGLEV)) \
    {fprintf(stderr,"[%s #%d]\n", \
    __FILE__, __LINE__);funct;}}

#define bugcx(expr,comnt,funct) {if (!(expr)) \
    {fprintf(stderr,"[%s #%d]  %s\n", \
    __FILE__, __LINE__,comnt);funct;}}
#define buglcx(bl,expr,comnt,funct) {if ((!(expr)) && (bl <= BUGLEV)) \
    {fprintf(stderr,"[%s #%d]  %s\n", \
    __FILE__, __LINE__,comnt);funct;}}

#define bugvt(variable,type)  \
    {fprintf(stderr,"[%s #%d]  variable = %type\n", \
    __FILE__, __LINE__,variable);}
#define buglvt(bl,variable,type)  {if (bl <= BUGLEV) \
    {fprintf(stderr,"[%s #%d]  variable = %type\n", \
    __FILE__, __LINE__,variable);}}

#define bugrt(comnt,variable,type)  \
    {fprintf(stderr,"[%s #%d]  %s...variable = %type\n", \
    __FILE__, __LINE__,comnt,variable);}
#define buglrt(bl,comnt,variable,type)  {if (bl <= BUGLEV) \
    {fprintf(stderr,"[%s #%d]  %s...variable = %type\n", \
    __FILE__, __LINE__,comnt,variable);}}

#define bugdm(comnt,dumpaddr,dumpl) \
    {fprintf(stderr,"[%s #%d]  %s\n", \
    __FILE__, __LINE__,comnt);cmxdump(dumpaddr,dumpl);}
#define bugldm(bl,comnt,dumpaddr,dumpl) {if (bl <= BUGLEV) \
    {fprintf(stderr,"[%s #%d]  %s\n", \
    __FILE__, __LINE__,comnt);cmxdump(dumpaddr,dumpl);}}

/* Don't use bugstop if stdin is not from the terminal */
#define bugstop()  \
    {fprintf(stderr,"[%s #%d]  PRESS ENTER TO CONTINUE", \
    __FILE__, __LINE__);while (getchar() != '\n');}
/* Don't use bugstop if stdin is not from the terminal */
#define buglstop(bl) {if (bl <= BUGLEV) \
    {fprintf(stderr,"[%s #%d]  PRESS ENTER TO CONTINUE", \
    __FILE__, __LINE__);while (getchar() != '\n');}}
/* Don't use bugstop if stdin is not from the terminal */

#else

#define bugpr(prspec) ;
#define buglpr(bl,prspec) ;
#define bugl(bl, comnt) ;
#define bugc(expr,comnt) ;
#define buglc(bl,expr,comnt) ;
#define bugx(expr,funct) ;
#define buglx(bl,expr,funct) ;
#define bugvt(variable,type) ;
#define buglvt(bl,variable,type) ;
#define bugrt(comnt,variable,type) ;
#define buglrt(bl,comnt,variable,type) ;
#define bugcx(expr,comnt,funct) ;
#define buglcx(bl,expr,comnt,funct) ;
#define bugdm(comnt,dumpaddr,dumpl) ;
#define bugldm(bl,comnt,dumpaddr,dumpl) ;
#define bugstop() ;
#define buglstop(bl) ;

#endif

#define BUGPR bugpr
#define BUGLPR buglpr
#define BUGL bugl
#define BUGC bugc
#define BUGLC buglc
#define BUGX bugx
#define BUGLX buglx
#define BUGVT bugvt
#define BUGLVT buglvt
#define BUGRT bugrt
#define BUGLRT buglrt
#define BUGCX bugcx
#define BUGLCX buglcx
#define BUGDM bugdm
#define BUGLDM bugldm
#define BUGSTOP bugstop
#define BUGLSTOP buglstop
#ifdef __cplusplus
}
#endif
