#ifdef __cplusplus
extern "C" {
#endif
/* 
 *	LICENSED MATERIALS - PROPERTY OF IBM
 * 	(c) Copyright IBM Corp. 1989, 1990 
 *	(c) Copyright Locus Computing Corporation 1989, 1990
 * 	All Rights Reserved 
 */

#ifndef _POSIX_SOURCE
#ifndef H_SCCSID
#include <sccs.h>
#endif /* ! H_SCCSID */
H_SCCSID(@(#)ctype.h	1.28	AIX)	/* Modified 6/26/91 21:45:52 */
#endif


#ifndef _h_CTYPE
#define _h_CTYPE

#define	_U	01		/* upper case */
#define	_L	02		/* lower case */
#define	_N	04		/* numeric    */
#define	_S	010		/* space */
#define	_P	020		/* punctuation */
#define	_C	040		/* control */
#define	_B	0100		/* blank */
#define	_X	0200		/* hex digit */
#define	_J	0400  		/* Japanese locale symbol mask */
#define	_k	01000 		/* Japanese Katakana */
#define	_H	02000 		/* Japanese Hiragana */
#define	_K	04000 		/* Japanese Kanji */

#ifdef	_MBCS 	/**************************  _MBCS  ************************/

/************** These make sense only in the MBCS environment **************/
/***** When _POSIX_SOURCE is defined mbcs.h and NLchar.h are removed **********/
/** for posix compliance, and ctab.h is added which is a portion of NLchar.h **/

#ifdef _POSIX_SOURCE
#ifndef	_h_NLCHAR
#include <ctab.h>
#endif
#else /* ! _POSIX_SOURCE */
#ifndef	_h_MBCS
#include <mbcs.h>
#endif
#ifndef	_h_NLCHAR
#include <NLchar.h>
#endif
#endif

#define _CTYPE		_MB_ctab->ct_ctype

#define	iswalpha(c)	(_CTYPE[__wcindx(c)+1]&(_U|_L))
#define	iswupper(c)	(_CTYPE[__wcindx(c)+1]&_U)
#define	iswlower(c)	(_CTYPE[__wcindx(c)+1]&_L)
#define	iswdigit(c)	(_CTYPE[__wcindx(c)+1]&_N)
#define	iswxdigit(c)	(_CTYPE[__wcindx(c)+1]&_X)
#define	iswalnum(c)	(_CTYPE[__wcindx(c)+1]&(_U|_L|_N))
#define	iswspace(c)	(_CTYPE[__wcindx(c)+1]&_S)
#define	iswpunct(c)	(_CTYPE[__wcindx(c)+1]&_P)
#define	iswprint(c)	(_CTYPE[__wcindx(c)+1]&(_P|_U|_L|_N|_B|_J))
#define	iswgraph(c)	(_CTYPE[__wcindx(c)+1]&(_P|_U|_L|_N))
#define	iswcntrl(c)	(_CTYPE[__wcindx(c)+1]&_C)

#define	iswascii(c)	(_CTYPE[__wcindx(c)+1]&(_P|_U|_L|_N|_B|_C))
#define	towupper(c)	( _MB_ctab->ct_caseconv[__wcindx(c)+1])
#define	towlower(c)	( _MB_ctab->ct_caseconv[__wcindx(c)+1])
#define	towascii(c)	((c)&0177)

#define isascii(c)      (!((c)&~0177))
#define	_toupper(c)	((c)-'a'+'A')
#define	_tolower(c)	((c)-'A'+'a')
#define	toascii(c)	((c)&0177)

extern	int	__c_temp;

#define	isalpha(c)  (isascii(__c_temp=c) && _CTYPE[__c_temp+1]&(_U|_L))
#define	isupper(c)  (isascii(__c_temp=c) && _CTYPE[__c_temp+1]&_U)
#define	islower(c)  (isascii(__c_temp=c) && _CTYPE[__c_temp+1]&_L)
#define	isdigit(c)  (isascii(__c_temp=c) && _CTYPE[__c_temp+1]&_N)
#define	isxdigit(c) (isascii(__c_temp=c) && _CTYPE[__c_temp+1]&_X)
#define	isalnum(c)  (isascii(__c_temp=c) && _CTYPE[__c_temp+1]&(_U|_L|_N))
#define	isspace(c)  (isascii(__c_temp=c) && _CTYPE[__c_temp+1]&_S)
#define	ispunct(c)  (isascii(__c_temp=c) && _CTYPE[__c_temp+1]&_P)
#define	isprint(c)  (isascii(__c_temp=c) && _CTYPE[__c_temp+1]&(_P|_U|_L|_N|_B))
#define	isgraph(c)  (isascii(__c_temp=c) && _CTYPE[__c_temp+1]&(_P|_U|_L|_N))
#define	iscntrl(c)  (isascii(__c_temp=c) && _CTYPE[__c_temp+1]&_C)


#define isjsjis(c)	(_CTYPE[__wcindx(c)+1]&_J)
#define isjhira(c)	(_CTYPE[__wcindx(c)+1]==(_J|_H))
#define isjkata(c)	(_CTYPE[__wcindx(c)+1]==(_J|_k))
#define isjkanji(c)	(_CTYPE[__wcindx(c)+1]==(_J|_K))
/*#define isj1bytekana(c)	 (_CTYPE[_wcindx(c)] == (_J|_k) &&
			   c & 0xffff >= 0x2f20 &&
			   c & 0xffff <= 0x2f7e)*/ 
#define isjalpha(c)	 (_CTYPE[__wcindx(c)+1]&(_J|_U|_L)==(_J|_U|_L))
#define isjupper(c)	 (_CTYPE[__wcindx(c)+1]&(_J|_U)==(_J|_U))
#define isjlower(c)	 (_CTYPE[__wcindx(c)+1]&(_J|_L)==(_J|_L))
#define isjpunct(c)	 (_CTYPE[__wcindx(c)+1]&(_J|_P)==(_J|_P))
#define isjdigit(c)	 (_CTYPE[__wcindx(c)+1]&(_J|_N)==(_J|_N))
#define isjxdigit(c)	 (_CTYPE[__wcindx(c)+1]&(_J|_X)==(_J|_X))
#define isjprint(c)	 (_CTYPE[__wcindx(c)+1]&(_J|_P|_U|_L|_N|_B)==(_J|_P|_U|_L|_N|_B))
#define isjgraph(c)	 ((_CTYPE[__wcindx(c)+1]&(_J|_P|_U|_L|_N))==(_J|_P|_U|_L|_N))

#define	tojupper(c)	( _MB_ctab->ct_caseconv[__wcindx(c)+1])
#define	tojlower(c)	( _MB_ctab->ct_caseconv[__wcindx(c)+1])
#define	tojhira(c)	( _MB_ctab->ct_caseconv[__wcindx(c)+1])
#define	tojkata(c)	( _MB_ctab->ct_caseconv[__wcindx(c)+1])

#else 		/************************** ! _MBCS  **********************/

#ifndef  CC4	/************************** ! CC4 & ! _MBCS ***************/

extern char	_ctype[];

#ifndef lint

#define	isalpha(c)	((_ctype+1)[c]&(_U|_L))
#define	isupper(c)	((_ctype+1)[c]&_U)
#define	islower(c)	((_ctype+1)[c]&_L)
#define	isdigit(c)	((_ctype+1)[c]&_N)
#define	isxdigit(c)	((_ctype+1)[c]&_X)
#define	isalnum(c)	((_ctype+1)[c]&(_U|_L|_N))
#define	isspace(c)	((_ctype+1)[c]&_S)
#define	ispunct(c)	((_ctype+1)[c]&_P)
#define	isprint(c)	((_ctype+1)[c]&(_P|_U|_L|_N|_B))
#define	isgraph(c)	((_ctype+1)[c]&(_P|_U|_L|_N))
#define	iscntrl(c)	((_ctype+1)[c]&_C)
#define isascii(c)      (!((c)&~0177))     /* ascii if 8th bit is zero */
#define	_toupper(c)	((c)-'a'+'A')
#define	_tolower(c)	((c)-'A'+'a')
#define	toascii(c)	((c)&0177)

#ifdef	_BSD
#define toupper(c)	_toupper(c)
#define tolower(c)	_tolower(c)
#endif	/* _BSD */
#endif	/* ! lint */

#else 		/************************** CC4 & ! _MBCS ******************/

extern	char	_ctype_[];

#define	isalpha(c)	((_ctype_+1)[c]&(_U|_L))
#define	isupper(c)	((_ctype_+1)[c]&_U)
#define	islower(c)	((_ctype_+1)[c]&_L)
#define	isdigit(c)	((_ctype_+1)[c]&_N)
#define	isxdigit(c)	((_ctype_+1)[c]&(_N|_X))
#define	isspace(c)	((_ctype_+1)[c]&_S)
#define ispunct(c)	((_ctype_+1)[c]&_P)
#define isalnum(c)	((_ctype_+1)[c]&(_U|_L|_N))
#define isprint(c)	((_ctype_+1)[c]&(_P|_U|_L|_N))
#define iscntrl(c)	((_ctype_+1)[c]&_C)
#define isascii(c)	((unsigned)(c)<=0177)
#define toupper(c)	((c)-'a'+'A')
#define tolower(c)	((c)-'A'+'a')
#define toascii(c)	((c)&0177)

#endif 		/************************** ! CC4      *********************/
#endif		/************************** ! _MBCS    *********************/

#endif		/************************** ! _h_CTYPE *********************/
}
