#ifdef __cplusplus
extern "C" {
#endif
#ifndef H_SCCSID
#include <sccs.h>
#endif /* ! H_SCCSID */
H_SCCSID(@(#)cur01.h	1.8.1.4	AIX)	/* Modified 11/9/90 14:25:15 */
/* @(#)cur01.h	7.2-87/10/16-16:56:55 */
/**PROLOGUE****************************************************************/
/*									  */
/* FUNCTION NAME =      cur       (/usr/lib/libcur.a)                     */
/* COMPONENT NAME =     cur01.h                                           */
/*									  */
/* DESCRIPTIVE NAME =	Ecurses include file				  */
/* FUNCTIONAL DESCRIPTION =	This file contains the defines and	  */
/*	declarations needed by most application programs.  It is normally */
/*      included by cur00.h for other Ecurses routines.                   */
/* INVOCATION = n/a							  */
/*									  */
/*									  */
/* RETURNS =	n/a							  */
/*									  */
/* EXTERNAL REFERENCES = n/a						  */
/*									  */
/* DATA STRUCTURES =	WINDOW (struct _win_st), SGTTY			  */
/*									  */
/*------------------------------------------------------------------------*/
/* CHANGE HISTORY:							  */
/*   DATE   |INITS| CHANGE & REASON (BRIEF)				  */
/* _________|_____|______________________________________________________ */
/* 10/16/84 | trm | created this include file from former curses.h file   */
/*          |     | other information from that file is now in cur00.h    */
/* 10/17/84 | trm | added extern for ESCSTR for keypad ESC support        */
/* 01/02/85 | trm | moved definition for BX and BY to cur01.h             */
/* 03-28-85 | trm | corrected the syntax of mvchgat                       */
/* 04-10-85 | trm | modify interface to savetty/resetty                   */
/* 05-19-86 | jcd | NLS: define NLSCHAR; change data array type to NLSCHAR*/
/* 02-20-87 | jcd | ATTR: char->ATTR in window struct                     */
/* 10/09/87 | dje | added wrefresh to mvwgetch and mvwgetstr              */
/* 05/31/90 | hen | added mbcs	  					  */
/* 10/22/90 | drl | made drawbox a function. APAR A13637/PTM P29693	  */
/*********************************************************************END**/

#ifndef H_SCCSID
#include <sccs.h>
#endif
H_SCCSID(@(#)cur01.h	1.5	AIX);	/* Modified 6/25/88 15:08:32 */
/* /* SCCSid = @(#)cur01.h	7.2-87/10/16-16:56:55 */
/* 
 * (C) Copyright IBM Corp. 1989 
 * All Rights Reserved 
 * Licensed Materials - Property of IBM 
 */

#include	<stdio.h>
#ifdef _MBCS
#include 	<stdlib.h>     /* mbcs */
#include	<stddef.h>     /* mbcs */
#include	<mbcs.h>       /* mbcs */
#include	<ctype.h>      /* mbcs */
#endif /* _MBCS */
#if (IS1|IS2|V7)
#include       <sgtty.h>
#else
#include       <termio.h>
#endif

#ifdef _MBCS
char _arp[4];     /* used in macro isdwidth and mbbytes */
mbchar_t __t;    /* used in mbtoarr_conv  */

#define		pd_char		0x7f00ffff        /* mbcs */
#define		part_char	(NLSCHAR) '@'     /* mbcs */

#define mbtoarr_conv(p,c) (__t = (c), ((__t) & 0xff000000) || ((__t) <<=8), \
((__t) & 0xff000000) || ((__t) <<=8), ((__t) & 0xff000000) || ((__t) <<=8), \
p[3]=(__t) & 0x000000ff, p[2]=((__t) & 0x0000ff00)>>8, p[1]=((__t) & 0x00ff0000)>>16,\
p[0]=((__t) & 0xff000000)>>24)              /* mbcs */

#define		bad_char	0x7f00ff00        /* mbcs */
#define		is_datachar(c)	(((c) & 0xffff0000) != 0x7f000000)  /* mbcs */
#define		is_padchar(c)	((c) == pd_char)    /* mbcs */

#define		is_dwidth(c) 	(mbtoarr_conv(_arp,c), \
(!is_padchar(c) && (mbdwidth(_arp)==2)))               /* mbcs */

#define		mb_bytes(c)	(mbtoarr_conv(_arp,c), \
_mblen(_arp, MB_CUR_MAX))                             /* mbcs */
#endif /* _MBCS */

# ifndef	CHAR
#define	CHAR	unsigned char	/* Defined to support diff default in CC */
# endif		/* CHAR */

#define bool	CHAR
#define reg	register

# ifndef	TRUE
#define TRUE	(1)
#define FALSE	(0)
# endif

#define ERR	(0)
#define OK	(1)

/* see cur05.h  */
#ifdef _MBCS
#define  NLSCHAR        mbchar_t
#else /* ~_MBCS */
#define  NLSCHAR        unsigned short
#endif /* ~_MBCS */

#define  NLSBLANK       (NLSCHAR) ' '
#define  NLSNL          (NLSCHAR) '\n'

#define  ATTR           unsigned short

#define WINDOW	struct _win_st

struct _win_st {
	short	_cury, _curx;	/* current (y,x) window coordinates */
	short	_maxy, _maxx;	/* number of rows and columns */
	short	_begy, _begx;	/* starting (y,x) coordinates on glass */
	short	_winy, _winx;	/* for a view:	starting (y,x) in original */
	short	_flags; 	/* for various #define state flags */
	short   _tmarg;		/* top of scrolling region */
	short	*_firstch;	/* optimization arrays:  first and last   */
	short	*_lastch;	/* position changed on a row by row basis */
	bool	_clear; 	/* clear flag */
	bool	_leave; 	/* cursor leave ok flag */
	bool	_scroll;	/* window scroll ok flag */
	ATTR    _csbp;          /* current standout(attribute) bit pattern*/
	short   _bmarg;		/* bottom of scrolling region */
	NLSCHAR **_y;           /* window character array */
	ATTR    **_a;           /* window attribute array */
	struct _win_st *_view;	/* for a view:	pointer to original window */
	};

  /* The following #defines are the flags defined within the _flags	*/
  /* field in the WINDOW structure above				*/

#define _SUBWIN 	01
#define _ENDLINE	02
#define _FULLWIN	04
#define _SCROLLWIN	010
#define _FLUSH		020
#define _ISVIEW 	040
#define _HASVIEW	0100
#define _STANDOUT	0200
#define _NOCHANGE	-1


extern int      LINES, COLS ;

extern WINDOW	*stdscr, *curscr;

  /* The following external definitions are used by the box drawing     */
  /* functions to specify the normal characters to be used in the boxes */

extern  CHAR    *BX, *BY;

  /* The following integers are used to specify the display attribute	*/
  /* mask to the colorout function.					*/

extern	int	NORMAL, STANDOUT, REVERSE, BOLD, UNDERSCORE, DIM, INVISIBLE,
		PROTECTED, BLINK, F_WHITE, F_RED, F_BLUE, F_GREEN, F_BROWN,
		F_MAGENTA, F_CYAN, F_BLACK, B_BLACK, B_RED, B_BLUE, B_GREEN,
		B_BROWN, B_MAGENTA, B_CYAN, B_WHITE, FONT0, FONT1, FONT2,
		FONT3, FONT4, FONT5, FONT6, FONT7;

extern  CHAR    ESCSTR[] ;

/*
 * Define FVOID to stop lint from generating "null effect" comments.
 */
#ifdef lint
int	__void__;
#define FVOID(x) (__void__ = (int) (x))
#else
#define FVOID(x) (x)
#endif

/*
 * psuedo functions for standard screen
 */
#define chgat(num, mod) FVOID(wchgat(stdscr, num, mod))
#define addch(ch)	FVOID(waddch(stdscr, ch))
#define getch() 	FVOID(wgetch(stdscr))
#define addstr(str)	FVOID(waddstr(stdscr, str))
#define getstr(str)	FVOID(wgetstr(stdscr, str))
#define move(y, x)	FVOID(wmove(stdscr, y, x))
#define clear() 	FVOID(wclear(stdscr))
#define erase() 	FVOID(werase(stdscr))
#define clrtobot()	FVOID(wclrtobot(stdscr))
#define clrtoeol()	FVOID(wclrtoeol(stdscr))
#define insertln()	FVOID(winsertln(stdscr))
#define deleteln()	FVOID(wdeleteln(stdscr))
#define refresh()	FVOID(wrefresh(stdscr))
#define inch()		FVOID(winch(stdscr))
#define insch(c)	FVOID(winsch(stdscr, c))
#define delch() 	FVOID(wdelch(stdscr))
#define standout()	FVOID(xstandout(stdscr, 1 ))
#define standend()	FVOID(xstandend(stdscr))
#define colorout(a)	FVOID(xstandout(stdscr, a))
#define colorend()	FVOID(xstandend(stdscr))
#define setscrreg(t,b)		FVOID(wsetscrreg(stdscr, t, b))
#define wsetscrreg(win,t,b)	FVOID((win->_tmarg=(t),win->_bmarg=(b)))
#define overwrite(a,b)	FVOID(overput(a, b, TRUE))
#define overlay(a, b)	FVOID(overput(a, b, FALSE))

#define wcolorout(w,a)	FVOID(xstandout(w, a))
#define wstandout(win)	FVOID(xstandout(win, 1 ))
#define wstandend(win)	FVOID(xstandend(win))
#define wcolorend(win)	FVOID(xstandend(win))


/*
 * mv functions
 */
#define mvwchgat(win,y,x,n,m)	FVOID(wmove(win,y,x)==ERR?ERR:wchgat(win,n,m))
#define mvwaddch(win,y,x,ch)	FVOID(wmove(win,y,x)==ERR?ERR:waddch(win,ch))
#define mvwgetch(win,y,x)	FVOID(wmove(win,y,x)==ERR?ERR:(wrefresh(win),wgetch(win)))
#define mvwaddstr(win,y,x,str)	FVOID(wmove(win,y,x)==ERR?ERR:waddstr(win,str))
#define mvwgetstr(win,y,x,s)	FVOID(wmove(win,y,x)==ERR?ERR:(wrefresh(win),wgetstr(win,s)))
#define mvwinch(win,y,x)	FVOID(wmove(win,y,x)==ERR?ERR:winch(win))
#define mvwdelch(win,y,x)	FVOID(wmove(win,y,x)==ERR?ERR:wdelch(win))
#define mvwinsch(win,y,x,c)	FVOID(wmove(win,y,x)==ERR?ERR:winsch(win,c))
#define mvchgat(y,x,n,m)        mvwchgat(stdscr,y,x,n,m)
#define mvaddch(y,x,ch) 	mvwaddch(stdscr,y,x,ch)
#define mvgetch(y,x)		mvwgetch(stdscr,y,x)
#define mvaddstr(y,x,str)	mvwaddstr(stdscr,y,x,str)
#define mvgetstr(y,x,str)	mvwgetstr(stdscr,y,x,str)
#define mvinch(y,x)		mvwinch(stdscr,y,x)
#define mvdelch(y,x)            mvwdelch(stdscr,y,x)
#define mvinsch(y,x,c)		mvwinsch(stdscr,y,x,c)

/*
 * psuedo functions
 */

#define box(w,b,c)	       superbox(w,0,0,w->_maxy,w->_maxx,b,c,c,c,c,c)
#define fullbox(w,b,c,d,e,f,g) superbox(w,0,0,w->_maxy,w->_maxx,b,c,d,e,f,g)
#define cbox(w)                drawbox(w,0,0,w->_maxy,w->_maxx)

#define flash() bell(2)
#define beep()	bell(1)

#define werase(win)	 (win->_curx = win->_cury = 0, wclrtobot(win))
#define wclear(win)	 (win->_curx = win->_cury = 0, wclrtobot(win), win->_clear = TRUE)
#define clearok(win,bf)  (win->_clear = bf)
#define leaveok(win,bf)  (win->_leave = bf)
#define scrollok(win,bf) (win->_scroll = bf)
#define flushok(win,bf)  (bf ? (win->_flags |= _FLUSH):(win->_flags &= ~_FLUSH))
#define getyx(win,y,x)	 y = win->_cury, x = win->_curx
#define winch(win)	 (win->_y[win->_cury][win->_curx])

#if (IS1|IS2|V7)
#define raw()	 (_tty.sg_flags|=RAW, _pfast=_rawmode=TRUE, stty(_tty_ch,&_tty))
#define noraw()  (_tty.sg_flags&=~RAW,_rawmode=FALSE,_pfast=!(_tty.sg_flags&CRMOD),stty(_tty_ch,&_tty))
#define crmode() (_tty.sg_flags |= CBREAK, _rawmode = TRUE, stty(_tty_ch,&_tty))
#define nocrmode() (_tty.sg_flags &= ~CBREAK,_rawmode=FALSE,stty(_tty_ch,&_tty))
#define echo()	 (_tty.sg_flags |= ECHO, _echoit = TRUE, stty(_tty_ch, &_tty))
#define noecho() (_tty.sg_flags &= ~ECHO, _echoit = FALSE, stty(_tty_ch, &_tty))
#define nl()	 (_tty.sg_flags |= CRMOD,_pfast = _rawmode,stty(_tty_ch, &_tty))
#define nonl()	 (_tty.sg_flags &= ~CRMOD, _pfast = TRUE, stty(_tty_ch, &_tty))
#define savetty() (gtty(_tty_ch, &_tty), _res_flg = _tty.sg_flags)
#define resetty() (_tty.sg_flags = _res_flg, stty(_tty_ch, &_tty))
#else
#define Stty(chan, data)	ioctl(chan, TCSETAW, data)
#define Gtty(chan, data)	ioctl(chan, TCGETA, data)
extern raw(), noraw(), crmode(), nocrmode();
extern nl(), nonl(), echo(), noecho();
extern savetty() ;
extern resetty() ;
#endif

WINDOW	*newview(), *initscr(), *newwin(), *subwin();
CHAR	*longname(), *getcap();
#ifdef _MBCS
NLSCHAR wgetch();
NLSCHAR MBecflin();
NLSCHAR keych();
NLSCHAR _keych();
#endif /* _MBCS */
#ifdef __cplusplus
}
#endif
