#ifdef __cplusplus
extern "C" {
#endif
#ifndef H_SCCSID
#include <sccs.h>
#endif

#ifndef	_h_DATAREP
#define _h_DATAREP

H_SCCSID(@(#)datarep.h	1.4	AIX)	/* Modified: 19:04:13 9/22/89 */
/* 
* Copyright (C)  1989, Locus Computing Corporation
 * All Rights Reserved
 */ 
/* 
 * (C) Copyright IBM Corp. 1989 
 * All Rights Reserved 
 * Licensed Materials - Property of IBM 
 */

/*
 * Defines and macros for use in identifying the data representation
 * used by a particular machine.  The data-representation identifier
 * format used is the one specified by Apollo Computer for their
 * NCS (Network Computing System).
 */

typedef unsigned char	datarep_t [4];	/* The data representation "word" */

/*
 * The information in the data representation field is:
 *
 * |--- byte 0 ---|  |--- byte 1 ---|  |--- byte 2 ---|  |--- byte 3 ---|
 * X X X X  Y Y Y Y  Z Z Z Z  Z Z Z Z  U U U U  U U U U  U U U U  U U U U
 *
 * where each letter represents a bit, and bits are laid out with most-
 * significant bit of each byte on the left, most-significant four-bit
 * nibble on the left.
 *
 * XXXX		Four-bit field encoding the integer representation used,
 *		one of the following values:
 *
 *	0000		"big-endian" (370, 680x0)
 *	0001		"little-endian" (80x86, Vax)
 *
 * YYYY		Four-bit field encoding the character set used, one of
 *		the following values:
 *
 *	0000		ASCII
 *	0001		EBCDIC
 *
 * ZZZZZZZZ	Eight-bit field encoding the floating-point format used,
 *		one of the following values:
 *
 *	00000000	IEEE 754
 *	00000001	DEC Vax
 *	00000010	Cray
 *	00000011	IBM-370
 *
 * The 'U' bits are currently unused and are reserved for future use.
 */

/*
 * Macros to extract the subinformation from the data representation
 * field.
 */

#define	DR_INTEGER(x)	(((x)[0] & 0xf0) >> 4)
#define		DR_I_BIGEND	0x0
#define		DR_I_LITTLEND	0x1
#define	DR_CHARSET(x)	((x)[0] & 0x0f)
#define		DR_C_ASCII	0x0
#define		DR_C_EBCDIC	0x1
#define	DR_FLOATING(x)	((x)[1])
#define		DR_F_IEEE	0x0
#define		DR_F_VAX	0x1
#define		DR_F_CRAY	0x2
#define		DR_F_IBM370	0x3

/*
 * Define the "native" datarep field for each machine type.
 * Note that AIX/370 uses ASCII even though the 370 hardware uses
 * EBCDIC.
 * The DR_LOCAL_FORMAT defines a longword that when stored/read as
 * a character array has the correct values for the local machine
 * type.  It should be used only through the DR_MAKE_LOCAL macro.
 */

#ifdef	i386
#define	DR_LOCAL_FORMAT		0x00000010L
#define	DR_LOCAL_INTEGER	DR_I_LITTLEND
#define	DR_LOCAL_CHARSET	DR_C_ASCII
#define	DR_LOCAL_FLOATING	DR_F_IEEE
#endif
#ifdef	u370
#define	DR_LOCAL_FORMAT		0x00030000L
#define	DR_LOCAL_INTEGER	DR_I_BIGEND
#define	DR_LOCAL_CHARSET	DR_C_ASCII
#define	DR_LOCAL_FLOATING	DR_F_IBM370
#endif

/*
 *  Macro to store the local datarep value into a field
 *  of type datarep_t.
 */

#define	DR_MAKE_LOCAL(x)	(*(long *) (x) = DR_LOCAL_FORMAT)

/*
 * NOTICE:
 * The next macros convert a datarep_t into a "howflip" value that
 * can be used with the macros and routines in <sys/flip.h>.
 */

/*
 * Macro to convert a datarep field (representing how data is stored
 * e.g. in a file) into a howflip value that can be used to convert
 * data in that file to/from the local machines byte order.
 */

#define	DR_TO_HOWFLIP(x)	(DR_INTEGER(x) == DR_LOCAL_INTEGER ? 0 : 3)

#endif
#ifdef __cplusplus
}
#endif
