#ifdef __cplusplus
extern "C" {
#endif
#ifndef H_SCCSID
#include <sccs.h>
#endif /* ~H_SCCSID */
H_SCCSID(@(#)dgn.h	1.9	AIX)	/* Modified 9/16/89 23:57:01 */
/* H_SCCSID(@(#) dgn.h 1.3     LM 09:35:45 9/15/86 C 16:00:07 5/8/88)   

/*      @(#)dgn.h	5.1 u370  source        */

/*
 *	Diagnostic Commands
 */
#define D_DRMV	0	/* start diagnostics  */
#define D_DRST	1	/* diagnostics complete */
#define D_READ	2	/* diagnostic DMA read */
#define D_WRITE	3	/* diagnostic DMA write */
#define D_MAINT	4	/* diagnostic command */
#define D_STAT	5	/* return state of unit */
#define D_RMV	6	/* put unit in OOS state from ACT state */
#define D_RST	7	/* put unit in ACT state from OOS state */
#define D_FORMAT 8      /* format a disk */
#define D_VERIFY 9      /* verify a disk */
#define D_LOCAL	10	/* local driver diag commands */
#define D_RESRV 11	/* reserve dual-ported drive */
#define D_UNRSRV 12	/* unreserve dual-ported drive */
#define D_DVCNTS 15	/* get DFC and MHD counts */
#define D_SASTAT 16	/* return sa statistics for dfcs and mhds */
#define D_DOVERP 17	/* temporary version id test */

/*
 *	Unit states
 */
#define S_OOS	0	/* out of service */
#define S_ACT	1	/* in service */
#define S_IDL	2	/* being restored to the ACT state */
#define S_DGN	3	/* undergoing diagnostics */
#define S_ERR	4	/* error during restore */

/*
 *	Diagnostic Message
 */
struct	dgnmsg	{
	short	unit;
	short	type;
	short	cmd;
	short 	rtncode;
	int	chstatus;
	int	data1;
	int	data2;
	int	data3;
	int	data4;
	char	*pumpfil;
	char	*addr;
	int	bcnt;
	int	blk;
};

/*
 *	Maintenance types for IOP
 */
#define IOP_DMA		0x8000
#define IOP_PIO		0x4000
#define IOP_NORSP	0x2000
#define IOP_SYSGN	0x1000

/*
 *	Maintenance commands for DFC and IOP
 */
#define M_SS		0	/* sense status */
#define M_RDW		1	/* read word */
#define M_WTW		2	/* write word */
#define M_SDCMD		3	/* send command */
#define M_ENINT		4	/* enable interrupts */
#define M_DISINT	5	/* disable interrupts */
#define	M_DSTAT		6	/* return status from dma */
#define M_INIT		7	/* initialize hardware */
#define M_SYSGEN	8	/* sysgen for DFC */
#define M_NORESP	9	/* no response */
#define M_DMAJB		10	/* DMA job to follow */
#define M_SAFCMD	11	/* SAF command for DFC */
#define M_DGNDMA	12	/* diagnostic DMA */
#define M_RDMAC		13	/* read DMAC RAM */
#define M_WDMAC	14	/* write DMAC RAM */
#define M_SETUP0	15	/* write setup word 0 */
#define M_SETUP1	16	/* write setup word 1 */
#define M_DMAEND	17	/* DMA end */
#define M_WDATPAR	18	/* write data and parity */
#define M_WCAWT		19	/* write WCA */
#define M_NUMTRKS	20	/* get number of tracks per MHD */
#define M_GETVERS	21	/* get version (coarse generic #) of DFC */
#define M_SETVERS	22	/* set version of DFC interface in driver */

/*
 *	Message return codes
 */
#define R_DRVERR	5	/* driver inconsistency detected */
#define R_NODEV		6	/* unit out of range or unequipped */
#define R_DEVBUSY	7	/* device in wrong state */
#define R_ILLCNTXT	8	/* illegal command context */
#define R_NOMEM		9	/* not enough memory or kernel segments */
#define R_PIOERR	10	/* programmed i/o error */
#define R_NOPUMP	11	/* can't find or read pump file */
#define R_INTR		12	/* driver sleep interrupted by signal */
#define R_ILLCMD	13	/* bad command or type in message */
#define R_FAULT		14	/* copyin/copyout fault during read/write */
#define R_CMDERR	15	/* device command failed or timed out */
#define R_NOOP		16	/* device already in ?? state */
#define R_NOTSUP	17	/* request not supported by this DFC version */
#define R_NOTSG		18	/* DFC not sysgened */

/*
	special command states for formatting 675Mb Disks
*/
#define DF_FCTRY 1
#define DF_UPDAT 2

/* /* <@(#)dgn.h	1.3> */
/* 
 * (C) Copyright IBM Corp. 1989 
 * All Rights Reserved 
 * Licensed Materials - Property of IBM 
 */
#ifdef __cplusplus
}
#endif
