#ifdef __cplusplus
extern "C" {
#endif
/*
 *		IX/370
 *		5667-126
 *	LICENSED MATERIALS - PROPERTY OF IBM
 *	(c) Copyright 1985, 1986, 1989 IBM Corp.
 *	(c) Copyright 1983, 1984, 1985, 1986,  1989 Locus Computing Corporation
 *	All Rights Reserved
 */

#ifndef _POSIX_SOURCE
#ifndef H_SCCSID
#include <sccs.h>
#endif /* ~H_SCCSID */
H_SCCSID(@(#)dir.h	16.10       LCC)    /* Modified: 21:31:19 10/25/90 */
#endif /* NOT _POSIX_SOURCE */

#ifndef _H_DIR
#define _H_DIR

#include <sys/types.h>

#include <limits.h>


/* The official way to look at directories is through the POSIX dirent
 * structure.  The directory access routine readdir() returns a pointer
 * to this type of structure.
 */

/* NAME_MAX is the maximum length of a directory entry.
 * PATH_MAX is the maximum length of an entire path name.
 * These constants are defined in <limits.h>, and neither length includes
 * the terminating null character in the string.
 * Note that the constant MAXPATHLEN in <sys/param.h> does include the
 * terminating null character.
 */ 

#ifndef _POSIX_SOURCE

#define MAXNAMLEN NAME_MAX
#define MAXDIRLEN NAME_MAX

#endif /* NOT _POSIX_SOURCE */


struct	dirent {
	ino_t     d_ino;		/* inode number of file to which
					   this entry points */
	u_short_t d_reclen;		/* offset to next dir entry or
					   offset past end of file */
	u_short_t d_namlen;		/* length of the name field */
	char      d_name[NAME_MAX + 1];	/* Null-terminated file name */
	/* typically shorter */
};


#ifndef _POSIX_SOURCE

/*
 * The NDIRSIZ macro gives the minimum record length which will hold
 * the directory entry.  This requires the amount of space in struct direct
 * without the d_name field, plus enough space for the name with a terminating
 * null byte (dp->d_namlen+1), rounded up to a 16 byte boundary.
 */
#define NDIRSIZ(dp) \
    (((sizeof(struct dirent) - (NAME_MAX+1)) + ((dp)->d_namlen+1 + 15)) &~ 15)


#ifdef _BSD
/* BSD applications expect readdir() to return a pointer to struct direct
 * and to use the macro DIRSIZ to determine the size of an entry */

#define direct dirent
#undef  DIRSIZ
#define DIRSIZ(dp) NDIRSIZ(dp)

#else /* ! BSD */
/* Kernel and other apps expect sys V struct direct for compatibility */

#undef   DIRSIZ
#define  DIRSIZ  14
struct	direct
{
	s_ino_t	d_ino;
	char	d_name[DIRSIZ];
};

/* directory cache requires long inodes - P19447 */
struct	dc_direct
{
	ino_t	d_ino;
	char	d_name[DIRSIZ];
};

#endif /* ! BSD */

/*
 * useful macros.
 */
/* NEXTDIRENT points at the entry following the current one.
 * NOTE: this macro should not be trusted without checking that d_reclen
 *	 is valid (i.e. non NULL, within reason ...)
 */
#define	NEXTDIRENT(dirp) (struct dirent *)((caddr_t)(dirp)+(dirp)->d_reclen)

/* NEEDROOM gives the record length needed for a name of the given length */
/* The length passed should be the string length of the name, not including */
/* the trailing null; for instance obtained from dirp->d_namlen. */
#define NEEDROOM(length) \
	roundup((int)(((struct dirent *)0)->d_name) + (length) + 1, 16)

/* SPACEUSED gives the amount of space actually used in a dir entry */
#define SPACEUSED(dirp) NEEDROOM((dirp)->d_namlen)

/* EMPTYSPACE gives the amount of empty space in a dir entry */
#define EMPTYSPACE(dirp) ((dirp)->d_reclen - SPACEUSED(dirp))

/* Old definitions -- kept around for 'temporary' compatibility */
#define ldirect		dirent
#define ld_ino		d_ino
#define ld_reclen	d_reclen
#define ld_namlen	d_namlen
#define ld_name		d_name

/*
 * Maximum length of a single symbolic link
 */
#define MAXSYMLKLEN 256

#endif /* NOT _POSIX_SOURCE */

#ifndef	NULL
#define NULL	0
#endif /* ~NULL */

#ifndef _POSIX_SOURCE
#define DIRBLKSIZ _DIRBLKSIZ
#define DIRBLKMSK (DIRBLKSIZ - 1)
#endif /* NOT _POSIX_SOURCE */

#define	_DIRBLKSIZ	1024

#ifndef  _KERNEL

/*
 * Directory access routine declarations; originally in xdir.h
 */

/*
 * Definitions for library routines operating on directories.
 */

typedef struct _dirdesc {
	int	dd_fd;
	long	dd_loc;
	long	dd_size;
	bool_t	dd_typef;
	struct  dirent dd_dir;
	char	dd_buf[_DIRBLKSIZ];
	int	dd_entno ;
	int	dd_bbase ;
} DIR;

extern	DIR *opendir(const char*);
extern	struct dirent *readdir(DIR*);
extern	int closedir(const DIR*);
extern	void rewinddir(DIR*);	/* Gil Beyda@IBM: removed macro & added func */

#ifndef _POSIX_SOURCE
extern	void seekdir(DIR*,long);
extern	long telldir(const DIR*);
/* Old definition -- kept around for 'temporary' compatibility */
#define dd_ldir		dd_dir
#endif  /* NOT _POSIX_SOURCE */

#endif	/* NOT _KERNEL */

#endif  /* NOT _H_DIR */
#ifdef __cplusplus
}
#endif
