#ifdef __cplusplus 
extern "C" {
#endif
/*
 *		IX/370
 *		5667-126
 *	LICENSED MATERIALS - PROPERTY OF IBM
*	(c) Copyright 1985, 1986, 1989 IBM Corp.
*	(c) Copyright 1983, 1984, 1985, 1986,  1989 Locus Computing Corporation
 *	All Rights Reserved
 */

#ifndef H_SCCSID
#include <sccs.h>
#endif /* ~H_SCCSID */
H_SCCSID(@(#)dustat.h	16.4	LCC)	/* Modified: 18:10:01 9/22/89 */

#ifndef _h_DUSTAT
#define _h_DUSTAT

#ifndef _h_TYPES
#ifdef KERNEL
#include <types.h>
#else /* ~KERNEL */
#include <sys/types.h>
#endif /* ~KERNEL */
#endif /* ~_h_TYPES */

#ifndef _h_PARAM
#ifdef KERNEL
#include <param.h>
#else /* ~KERNEL */
#include <sys/param.h>
#endif /* ~KERNEL */
#endif /* ~_h_PARAM */

#define MAXPACKNO	32

/*  The arrangement of these fields is important for network flipping.
 *  DON'T change them without changing svrpacklst. */
struct dpacklst {
	fstore_t	dpk_fstore;

	unsigned short	dpk_flags;
	siteno_t 	dpk_site;
	pckno_t		dpk_pack;	
	short		dpk_dummy;	/* dummy used for padding/ future 
					   expansion. */
};

/* This is essentially a subset of the filsys struct. */
/* The attempt was to make the trailing field names the same. */
/* See also nmdustat.h. */
struct dustat {
	fstore_t	du_fstore;
	commitcnt_t	du_hwm;
	commitcnt_t	du_lwm;
	daddr_t		du_fsize;	/* size in blocks of entire volume. */
	union du_mix {
		daddr_t	dum_tfree;	/* number of free blocks. */
		dev_t	dum_majmin; 	/* major / minor */
	} DU_mix;
	ino_t		du_tinode;	/* # of free inodes. */
	ino_t		du_isize;	/* addr of first data block. */
	short		du_bsize;	/* size of BSIZE. */
	pckno_t		du_pckno;	
	siteno_t	du_site;
	unsigned short	du_flags;	/* from s_flags */

	char		du_inopb;	/* inodes per block. */
	char		du_version;
	char		du_packcnt;	/* number of valid entries in 
					   dust_dpacklst */
	char		du_dummy[5];	/* padding/expansion */
	char 		du_fsmnt[32];
	char		du_fpack[8];
	struct dpacklst du_dpacklst[MAXPACKNO]; 
};

#define du_majmin DU_mix.dum_majmin /* Major/minor returned when -1 spec. in dustat */
#define du_tfree DU_mix.dum_tfree /* Free blocks */

#endif /* ! _h_DUSTAT */
#ifdef __cplusplus 
}
#endif
