#ifdef __cplusplus
extern "C" {
#endif
#ifndef H_SCCSID
#include <sccs.h>
#endif /* ~H_SCCSID */
H_SCCSID(@(#)fstab.h	1.9	AIX)	/* Modified 9/17/89 00:28:38 */
/* H_SCCSID(@(#)fstab.h	1.3	LCC)	/* Modified: 10:31:22 10/30/86 */
/* 
 * (C) Copyright IBM Corp. 1989 
 * All Rights Reserved 
 * Licensed Materials - Property of IBM 
 */

/*
 * File system table, see fstab (5)
 *
 * Used by dump, mount, umount, swapon, fsck, df, ...
 *
 * The fs_spec field is the block special name.
 * Programs that want to use the character special name must
 * create that name by prepending a 'r' after the right most slash.
 */

#ifdef	FSFLAG
#define	FSTAB		"/etc/fstab"
#else
#define	FSTAB		"/etc/filesystems"
#define FSDEV		"dev"
#define FSVOL		"vol"
#define FSMODE		"mode"
#define FSSITE		"site"
#define FSFREQ		"freq"
#endif
#define	FSNMLG		32
#define	FSSTNLG		16

#define	FSTABFMT	"%32s:%32s:%2s:%d:%d\n"
#define	FSTABARG(p)	(p)->fs_spec, (p)->fs_file, \
			(p)->fs_type, &(p)->fs_freq, &(p)->fs_passno
#define FSTABNARGS	6

#define	FSTAB_RW	"rw"	/* read write device */
#define	FSTAB_RO	"ro"	/* read only device */
#define	FSTAB_SW	"sw"	/* swap device */
#define FSTAB_NM	"nm"	/* File system not normally mounted */
#define	FSTAB_XX	"xx"	/* ignore totally */

struct	fstab{
	char	fs_spec[FSNMLG];	/* block special device name */
	char	fs_file[FSNMLG];	/* file system path prefix */
	char	fs_type[3];		/* rw,ro,sw or xx */
	char	fs_stname[FSSTNLG];	/* site name of site w/ fs. */
	int	fs_freq;		/* dump frequency, in days */
	int	fs_passno;		/* pass number on parallel dump */
};

struct	fstab *getfsent();
struct	fstab *getfsspec(const char*);
struct	fstab *getfsfile(const char*);
int	setfsent();
int	endfsent();
#ifdef __cplusplus
}
#endif
