#ifdef __cplusplus
extern "C" {
#endif
#ifndef H_SCCSID
#include <sccs.h>
#endif /* ! H_SCCSID */
H_SCCSID(@(#)ieeetrap.h	1.12	AIX)	/* Modified 9/17/89 00:35:04 */
/* @(#)ieeetrap.h	7.2 - 87/12/15 - 09:10:33 */
/* 
 * (C) Copyright IBM Corp. 1989 
 * All Rights Reserved 
 * Licensed Materials - Property of IBM 
 */
#ifdef RTPC
#ifndef _h_IEEETRAP
#define _h_IEEETRAP

#include <sys/fpfp.h>

/*
 * Number of double precision floating point registers at release 1.0
 * and 1.1 time.
 */

#define NDPFPREGS 8	

typedef union {
	struct {
		unsigned long hp;
		unsigned long lp;
	} u;
	double d;
	float freg[2];
} fpreg;		/* double, floats, longs */

typedef struct {
	unsigned int operation:8;
	unsigned int rsvd0:2;
	unsigned int src:6;
	unsigned int dest_loc:1;
	unsigned int dest_inv:1;
	unsigned int dest:6;
	unsigned int except_flags:5;
	unsigned int except_type:3;
} fptrapinfo;

typedef struct {
	fptrapinfo fptrapinfo;
	fpreg designated_result;
} fptrap;

typedef struct {
	fpreg fpreg[NDPFPREGS];
	FP_STATUS statusreg;
	fptrap fptrap;
	fpreg fpregup[24];       /* upper 24 fp regs for release 2.1 onward */
	unsigned int *dest_addr; /* address of destination if dest_loc = 1  */
	unsigned int dmalength;  /* saved value of dma length register      */
} fpvmach;

#endif  _h_IEEETRAP
#endif RTPC
#ifdef __cplusplus
}
#endif
