#ifdef __cplusplus
extern "C" {
#endif
/* /*      @(#)ldfcn.h	5.3 u370  source        */
/* 
 * (C) Copyright IBM Corp. 1989 
 * All Rights Reserved 
 * Licensed Materials - Property of IBM 
 */
/*
#ifndef H_SCCSID
#include <sccs.h>
#endif
H_SCCSID(@(#)ldfcn.h	1.5	AIX)	/* Modified 9/17/89 00:38:14 */
/*  * static char ID_ldfcnh[] = "@(#) ldfcn.h: 1.3 5/1/83";
 */

/*
 *	The following two declarations appear in the IH versions of
 *	"stdio.h" but do not appear in the normal 1.2 versions.
 */
#ifdef __cplusplus
#include <filehdr.h>
#include <stdio.h>
#else

long ftell();
char *fgets();
#endif
		
#ifndef LDFILE
struct	ldfile {
	int	_fnum_;		/* so each instance of an LDFILE is unique */
	FILE	*ioptr;		/* system I/O pointer value */
	long	offset;		/* absolute offset to the start of the file */
	FILHDR	header;		/* the file header of the opened file */
	unsigned short	type;		/* indicator of the type of the file */
};
		
		
/*
	provide a structure "type" definition, and the associated
	"attributes"
*/
		
#define	LDFILE		struct ldfile
#define IOPTR(x)	x->ioptr
#define OFFSET(x)	x->offset
#define TYPE(x)		x->type
#define	HEADER(x)	x->header
#define LDFSZ		sizeof(LDFILE)
		
/*
	define various values of TYPE(ldptr)
*/
		
#define LDTYPE	B16MAGIC    /* defined in terms of the filehdr.h include file */
#define TVTYPE	TVMAGIC		/* ditto */
#if u3b5
#define USH_ARTYPE	ARTYPE
#else
#define USH_ARTYPE	(unsigned short) ARTYPE
#endif
#if defined(PORTAR) || defined(PORT5AR)
#define ARTYPE 	0177545
#else
#define ARTYPE	ARMAG
#endif
		
/*
	define symbolic positioning information for FSEEK (and fseek)
*/
		
#define BEGINNING	0
#define CURRENT		1
#define END		2
		
/*
	define a structure "type" for an archive header
*/
		
#if defined(PORTAR) || defined(PORT5AR)
typedef struct
{
	char ar_name[16];
	long ar_date;
	int ar_uid;
	int ar_gid;
	long ar_mode;
	long ar_size;
} archdr;
		
#define	ARCHDR	archdr
#else
#define	ARCHDR	struct ar_hdr	/* ARCHIVE is defined in ts.h */
#endif
#define ARCHSZ	sizeof(ARCHDR)
		
		
/*
	define some useful symbolic constants
*/
		
#define SYMTBL	0	/* section nnumber and/or section name of the Symbol Table */
		
#define	SUCCESS	 1
#define	CLOSED	 1
#define	FAILURE	 0
#define	NOCLOSE	 0
#define	BADINDEX	-1L
		
#define	OKFSEEK	0
		
/*
	define macros to permit the direct use of LDFILE pointers with the
	standard I/O library procedures
*/
		
LDFILE *ldopen(const char*, LDFILE*);
LDFILE *ldaopen(const char*, LDFILE);
		
#define GETC(ldptr)	getc(IOPTR(ldptr))
#define GETW(ldptr)	getw(IOPTR(ldptr))
#define FEOF(ldptr)	feof(IOPTR(ldptr))
#define FERROR(ldptr)	ferror(IOPTR(ldptr))
#define FGETC(ldptr)	fgetc(IOPTR(ldptr))
#define FGETS(s,n,ldptr)	fgets(s,n,IOPTR(ldptr))
#define FILENO(ldptr)	fileno(IOPTR(ldptr))
#define FREAD(p,s,n,ldptr)	fread(p,s,n,IOPTR(ldptr))
#define FSEEK(ldptr,o,p)	fseek(IOPTR(ldptr),(p==BEGINNING)?(OFFSET(ldptr)+o):o,p)
#define FTELL(ldptr)	ftell(IOPTR(ldptr))
#define FWRITE(p,s,n,ldptr)       fwrite(p,s,n,IOPTR(ldptr))
#define REWIND(ldptr)	rewind(IOPTR(ldptr))
#define SETBUF(ldptr,b)	setbuf(IOPTR(ldptr),b)
#define UNGETC(c,ldptr)		ungetc(c,IOPTR(ldptr))
#define STROFFSET(ldptr)	(HEADER(ldptr).f_symptr + HEADER(ldptr).f_nsyms * 18) /* 18 == SYMESZ */
#endif
#ifdef __cplusplus
#include <syms.h>
        LDFILE *ldaopen(const char*, LDFILE*);
        long ldtbindex(LDFILE*);
        long sgetl(const char*);
        void sputl(long, char*);
        char* ldgetname(LDFILE*, const SYMENT*);
        LDFILE *ldopen(const char*, LDFILE*);
#if defined(__STDC__)
#include <linenum.h>
#include <scnhdr.h>
        int ldahread(LDFILE*, ARCHDR*);
        int ldclose(LDFILE*);
        int ldaclose(LDFILE*);
        int ldfhread(LDFILE*, FILHDR*);
        int ldlitem(LDFILE*, unsigned int, LINENO*);
        int ldlread(LDFILE*, long, unsigned int, LINENO*);
        int ldlseek(LDFILE*,unsigned int);
        int ldrseek(LDFILE*, unsigned int);
        int ldshread(LDFILE*, unsigned int, SCNHDR*);
        int ldsseek(LDFILE*, unsigned int);
        int ldlinit(LDFILE*, long);
        int ldnlseek(LDFILE*, const char*);
        int ldohseek(LDFILE*);
        int ldnrseek(LDFILE*, const char*);
        int ldnrseek(LDFILE*, const char*);
        int ldnshread(LDFILE*, const char*, SCNHDR*);
        int ldnsseek(LDFILE*, const char*);
        int ldtbread(LDFILE*, long, SYMENT*);
        int ldtbseek(LDFILE*);
#endif
}
#endif
