#ifdef __cplusplus
extern "C" {
#endif
#ifndef _POSIX_SOURCE
#ifndef H_SCCSID
#include <sccs.h>
#endif /* ! H_SCCSID */
H_SCCSID(@(#)limits.h	1.10.1.3      AIX)    /* Modified 21:02:10 4/8/92 */

#endif /* NOT _POSIX_SOURCE */
/* 
 * Copyright (C)  1989, Locus Computing Corporation
 * All Rights Reserved
 */ 
/* 
 * (C) Copyright IBM Corp. 1989 
 * All Rights Reserved 
 * Licensed Materials - Property of IBM 
 */
/* limits.h - sizes of integral types */

#ifndef _H_LIMITS
#define _H_LIMITS

#define CHAR_BIT	8
#define CHAR_MIN	0
#define CHAR_MAX	(+255)
#define UCHAR_MAX 	(+255)
#define SCHAR_MAX	(+127)
#define SCHAR_MIN	(-(SCHAR_MAX + 1))
#define INT_MAX		(+2147483647)
#define INT_MIN		(-(INT_MAX + 1))
#define UINT_MAX	(+4294967295)
#define LONG_MAX	(+2147483647)
#define LONG_MIN	(-(LONG_MAX + 1))
#define ULONG_MAX	(+4294967295)
#define SHRT_MAX	(+32767)
#define SHRT_MIN 	(-(SHRT_MAX + 1))
#define USHRT_MAX	(+65535)
#define MB_LEN_MAX	4	/* This is the max bytes in a multibyte  */
				/* character for ANY character code set. */
				/* as per ANSI C 			 */

/* POSIX limit values  */

/* pathconf() specific constants...	*/

#define LINK_MAX	32767	/* Max value of file's link count	*/
#define MAX_INPUT	255	/* Max no of bytes in term input queue	*/
#define MAX_CANON	255	/* Max no of bytes in canonical input	*/
#define NAME_MAX	255	/* Max no of bytes in file name		*/
#define PATH_MAX	1023	/* Max no of bytes in pathname		*/
#define PIPE_BUF	40960	/* Max no of bytes written to pipe	*/

/* sysconf() specific constants...  */

#define NGROUPS_MAX	32	/* Max no of group ID's per process	*/
#define OPEN_MAX	200	/* Max no of open files per process	*/
#define ARG_MAX		16384	/* Max length of args for exec		*/

#define _POSIX_ARG_MAX		4096
#define _POSIX_CHILD_MAX	6
#define _POSIX_LINK_MAX		8
#define _POSIX_MAX_CANON	255
#define _POSIX_MAX_INPUT	255
#define _POSIX_NAME_MAX		14
#define _POSIX_NGROUPS_MAX	0
#define _POSIX_OPEN_MAX		16
#define _POSIX_PATH_MAX		255
#define _POSIX_PIPE_BUF		512

#ifndef _POSIX_SOURCE
/* defines for message catalog usage */
#define NL_ARGMAX       9               /* max number of printf args */
#define NL_MSGMAX       65535           /* max number of messages per set */
#define NL_SETMAX       65535           /* max number of set per catalog */
#define NL_TEXTMAX      4096            /* max message length in bytes */
#endif /* NOT _POSIX_SOURCE */

#define       EVTCLASS_MIN    (0)             /* minimum event class value */
#define       EVTCLASS_MAX    (63)            /* maximum event class value */

/* default event class for signals - configurable in /etc/master */
#define       EVTCLASS_SIG    (sysconf(_SC_EVTCLASS_SIG))


#define       AIO_PRIO_DFL    (7)             /* default asynch I/O priority level */
#define       AIO_PRIO_MAX    (15)            /* maximum asynch I/O priority level */
#define       AIO_PRIO_MIN    (0)             /* minimum asynch I/O priority level */

/* minimax number of liocb structures indirectly referencable */
#define       AIO_LISTIO_MAX_SIZE     (128)

#endif	/* ! _H_LIMITS */
#ifdef __cplusplus
}
#endif
