#ifdef __cplusplus
extern "C" {
#endif
#ifndef _POSIX_SOURCE
#ifndef H_SCCSID
#  include <sccs.h>
#endif /* ~H_SCCSID */
H_SCCSID(@(#)math.h	1.23	AIX)	/* Modified 11/19/90 17:00:55 */
#endif /* NOT _POSIX_SOURCE */

/* 
 * (C) Copyright IBM Corp. 1989 
 * All Rights Reserved 
 * Licensed Materials - Property of IBM 
 */

#ifndef _H_MATH
#define _H_MATH


#define	EDOM	33	/* Math arg out of domain of func	*/ 
#define	ERANGE	34	/* Math result not representable	*/

/* The following constants are defined to be equal to MAXDOUBLE found
 * in <values.h>.  The MAXDOUBLE symbol is avoided to avoid introducing
 * a symbol not defined by POSIX.
 */

#ifdef _I386
#ifndef HUGE_VAL
#ifdef	__HIGHC__
#define HUGE_VAL	(1.0/0.0)
#else
#define HUGE_VAL	1e+309
#endif
#endif /* HUGE_VAL */
#endif /* _I386 */

#ifdef _U370
#ifndef HUGE_VAL
#define HUGE_VAL	7.237005577332262113e75
#endif /* HUGE_VAL */
#endif /* _U370 */

extern double frexp(double,int*), ldexp(double,int), 
	modf(double,double*), scalb(double,int);
extern double exp(double), expm1(double), log(double), 
	log10(double), log1p(double), logb(double);
extern double pow(double), sqrt(double), cbrt(double); 
/* (MRL) cabs is not needed use class complex instead.  
	Removed - cabs(struct {double x;double y;}z); */
extern double floor(double), ceil(double), rint(double), 
	fmod(double,double), fabs(double);
extern double sin(double), cos(double), tan(double);
extern double asin(double), acos(double), atan(double), atan2(double,double);
extern double sinh(double), cosh(double), tanh(double);
extern double asinh(double), acosh(double), atanh(double);


#ifndef	_POSIX_SOURCE

     extern int errno, signgam;

     extern double atof(const char*);
     extern double j0(double), j1(double), jn(int,double), 
	y0(double), y1(double), yn(int,double );
     extern double erf(double), erfc(double);
     extern double gamma(double), lgamma(double);
     extern double hypot(double);
     extern int matherr(struct exception*);
     extern double copysign(double,double);

#include <values.h>

#      define M_PI_2     1.570796326794896619231322E0  
#      define M_E        2.718281828459045235360287E0 
#      define M_LOG2E    1.4426950408889633870E0 
#      define M_LOG10E   4.342944819032518276511289E-1 
#      define M_LN10     2.3025850929940456840179915E0  
#      define M_2PI      6.283185307179586476925287E0  
#      define M_PI_4     7.853981633974483096156608E-1 
#      define M_1_PI     3.183098861837906715377675E-1 
#      define M_2_PI     6.3661977236758134308E-1 
#      define M_2_SQRTPI 1.1283791670955125739E0  
#      define M_SQRT1_2  7.0710678118654752440E-1 

/* Note: HUGE should be INF. Change this as soon as the compilers can   */
/*       understand INF as input.                                       */

#      define HUGE       MAXDOUBLE
#ifndef HUGE_VAL
#      define HUGE_VAL   HUGE
#endif /* HUGE_VAL */

#    define _ABS(x)	((x) < 0 ? -(x) : (x))

#    define _REDUCE(TYPE, X, XN, C1, C2)	{ \
	double x1 = (double)(TYPE)X, x2 = X - x1; \
	X = x1 - (XN) * (C1); X += x2; X -= (XN) * (C2); }

#    define _POLY1(x, c)	((c)[0] * (x) + (c)[1])
#    define _POLY2(x, c)	(_POLY1((x), (c)) * (x) + (c)[2])
#    define _POLY3(x, c)	(_POLY2((x), (c)) * (x) + (c)[3])
#    define _POLY4(x, c)	(_POLY3((x), (c)) * (x) + (c)[4])
#    define _POLY5(x, c)	(_POLY4((x), (c)) * (x) + (c)[5])
#    define _POLY6(x, c)	(_POLY5((x), (c)) * (x) + (c)[6])
#    define _POLY7(x, c)	(_POLY6((x), (c)) * (x) + (c)[7])
#    define _POLY8(x, c)	(_POLY7((x), (c)) * (x) + (c)[8])
#    define _POLY9(x, c)	(_POLY8((x), (c)) * (x) + (c)[9])

     struct exception {
	int type;
	char *name;
	double arg1;
	double arg2;
	double retval;
     };

#    define 	DOMAIN		01
#    define		SING		02
#    define		OVERFLOW	03
#    define		UNDERFLOW	04
#    define		TLOSS		05
#    define		PLOSS		06
 
#    if defined(_I386)
       /* This is the nearest number to the cube root of MAXDOUBLE that   */
       /*      doesn't cause the cube of it to overflow.                  */
#ifndef CUBRTHUGE
#      define CUBRTHUGE      5.6438030941223618e102
#endif /* CUBRTHUGE */
#ifndef INV_CUBRTHUGE
#      define INV_CUBRTHUGE  1.7718548704178434e-103
#endif /* INV_CUBRTHUGE */
#    endif /* _I386 */

#endif /* NOT _POSIX_SOURCE */

#endif /* !_H_MATH */
#ifdef __cplusplus
}
#endif
