#ifdef __cplusplus
extern "C" {
#endif
#ifndef H_SCCSID
#include <sccs.h>
#endif /* ~H_SCCSID */
H_SCCSID(@(#)mntent.h	1.13	AIX)	/* Modified 9/17/89 00:48:17 */
/*	@(#)mntent.h 1.1 86/09/24 SMI	*/
/* 
 * (C) Copyright IBM Corp. 1989 
 * All Rights Reserved 
 * Licensed Materials - Property of IBM 
 */

/*
 * File system table, see mntent (5)
 *
 * Used by mount, umount, swapon, fsck, df, ...
 *
 * Quota files are always named "quotas", so if type is "rq",
 * then use concatenation of mnt_dir and "quotas" to locate
 * quota file.
 */

#ifndef _h_TYPES
#include <sys/types.h>
#endif  _h_TYPES

#define	MOUNTED		"/etc/mtab"

#define	MNTMAXSTR	128

#define	MNTTYPE_UFS	"ufs"	/* user file system */
#define	MNTTYPE_NFS	"nfs"	/* network file system */
#define	MNTTYPE_SWAP	"swap"	/* swap file system */
#define	MNTTYPE_IGNORE	"ignore"/* No type specified, ignore this entry */

#define	MNTOPT_RO	"ro"	/* read only */
#define	MNTOPT_RW	"rw"	/* read/write */
#define	MNTOPT_QUOTA	"quota"	/* quotas */
#define	MNTOPT_NOQUOTA	"noquota"	/* no quotas */
#define	MNTOPT_SOFT	"soft"	/* soft mount */
#define	MNTOPT_HARD	"hard"	/* hard mount */
#define	MNTOPT_NOSUID	"nosuid"/* no set uid allowed */
#define	MNTOPT_NOAUTO	"noauto"	/* hide entry from mount -a */
#define	MNTOPT_INTR	"intr"	/* allow interrupts on hard mount */

struct	mntent{
	char	*mnt_fsname;		/* name of mounted file system */
	char	*mnt_dir;		/* file system path prefix */
	char	*mnt_type;		/* MNTTYPE_* */
	char	*mnt_opts;		/* MNTOPT* */
	int	mnt_freq;		/* dump frequency, in days */
	int	mnt_checkno;		/* pass number on parallel fsck */
	char	mnt_flags;		/* filsys flags			*/
	gfs_t	mnt_gfs;		/* GFS number			*/
	pckno_t	mnt_pack;		/* Pack number			*/
	long	mnt_time;		/* System V time field		*/
};

struct	mntent *getmntent(FILE*);
char	*hasmntopt(struct mntent*, char*);
FILE	*setmntent(char*, char*);
int	endmntent(FILE*);
#ifdef __cplusplus
int	mntprtent(...); 		/* (MRL) prototype is unknown */
}
#else
int	mntprtent();
#endif
