#ifdef __cplusplus
extern "C" {
#endif
#ifndef H_SCCSID
#include <sccs.h>
#endif /* ! H_SCCSID */
H_SCCSID(@(#)msgx1.h	1.2	LCC)	/* Modified: 16:43:14 1/20/88 */

/* @(#)msgx1.h	4.1 - 86/06/27 - 08:11:34 */
/* @(#)msgx1.h	4.1 86/06/27 08:11:34 */
/* 
 * (C) Copyright IBM Corp. 1989 
 * All Rights Reserved 
 * Licensed Materials - Property of IBM 
 */

/***  msgx1.h  ***/

#ifndef MsG01
#define MsG01   MsG01

/***********************************************************************
*  Definitions                                                         *
***********************************************************************/

#include "msg08.h"

#define  MSGBUFLM 2000     /* initial allocation for msg/insert buffer*/
#define  MSGBUFLH 2000     /* initial allocation for help buffer      */
#define  MSGINDSZ 8        /* indent size (if msg/help ID displayed)  */
#define  MSGFILES 2        /* max. # of files open at once (>= 2)     */

/***********************************************************************
*  Structure Passed Among Message Support Run-Time Functions           *
*       (Note: functions that initialize or update the variables       *
*        are indicated in brackets.)                                   *
***********************************************************************/

struct msginfo {

     unsigned msgflags;    /* flags                   [API functions] */
#define MSGFFRCC 0x0001    /*   remove control characters from text.  */
#define MSGFFREA 0x0002    /*   realloc the buffer, if necessary.     */
#define MSGFFIND 0x0004    /*   indent next character.      [msgchar] */
#define MSGFFSNL 0x0008    /*   suppress appending of new-line char   */
			   /*   to msg/help.                          */
#define MSGFFSID 0x0010    /*   suppress msg/help ID in text.         */
#define MSGFFALO 0x0020    /*   malloc/realloc failed.      [msgchar] */
#define MSGFFSUB 0x0040    /*   substitute msg to be output.[msgtext] */
#define MSGFFIHT 0x0080    /*   include help title (if any).[msgrtrv] */

     char     *msgbufp;    /* ptr to working buffer.                  */
			   /*               [msgqued,msgrtrv,msgchar] */
     int      msgblen;     /* length of working buffer.               */
			   /*                 [API functions,msgchar] */
     int      msglen;      /* length of text currently in working     */
			   /* buffer.         [API functions,msgchar] */
     int      msgtextl;    /* length of constructed text (even if it  */
			   /* won't fit in the buffer).     [msgchar] */
     msg__table *msgtabp;  /* ptr to resident message table (null if  */
			   /* none).[msgimed,msgqued,msgrtrv,msgtext] */
     char     msgcomp[6];  /* component ID from requestor.            */
			   /*                         [API functions] */
     int      msgtype;     /* 0 = msg, 1 = insert, 2 = help.          */
                           /*                         [API functions] */
     int      msgindx;     /* msg/insert/help index from requestor.   */
                           /*                         [API functions] */
     int      msgctry;     /* override country #.  If not zero, this  */
                           /* country # is used instead of the one in */
                           /* the user or system pool.  Country # in- */
			   /* dicates the formats in which date,      */
                           /* time, decimal, & currency are displayed.*/
                           /* If overridden, msgtext will reflect this*/
                           /* in the msgdatef field (below).          */
			   /* (not implemented yet)   [API functions] */
     char     msglang[2];  /* override national language ID.  If not  */
			   /* a null string, this ID is used instead  */
			   /* the one in the user or system pool.     */
			   /* (not implemented yet)   [API functions] */

     char     msgdatef;    /* date format to be used:                 */
                           /*   'A' - dd/mm                           */
                           /*   'B' - mm/dd                           */
                           /*   'C' - mm-dd                 [msgtext] */
     int      msgindt;     /* # characters msg/help is indented.      */
			   /*                               [msgtext] */
     char     msgid[8];    /* msg/help ID:  "ccc-nnn "      [msgtext] */
     char     *msgpathp[3];/* array of ptrs to path prefixes[msgtext] */

     char     *msgfilep;   /* addr of file data             [msgfile] */

     char     *msgtextp;   /* addr of requested text        [msgftch] */
     int      msgtilen;    /* help title length.            [msgftch] */
     int      msghelp;     /* help index# for message.      [msgftch] */
     int      msgsindx;    /* index# for @I0 field in substitute      */
			   /* message.                      [msgftch] */
     char     msgscomp[6]; /* comp. ID for @C0 field in substitute    */
			   /* message.                      [msgftch] */
     char     msgdcomp[3]; /* displayed component ID.       [msgftch] */
     char     msgdmsg[3];  /* displayed message ID.         [msgftch] */
     };

#endif
#ifdef __cplusplus
}
#endif
