#ifdef __cplusplus
extern "C" {
#endif
#ifndef H_SCCSID
#include <sccs.h>
#endif /* ! H_SCCSID */
H_SCCSID(@(#)nan.h	1.15	AIX)	/* Modified 9/17/89 01:01:16 */
/* @(#)nan.h	7.1 - 87/06/16 - 00:12:06 */
/* 
 * (C) Copyright IBM Corp. 1989 
 * All Rights Reserved 
 * Licensed Materials - Property of IBM 
 */
/* Handling of Not_a_Number's (only in IEEE floating-point standard) */

/*
 *UPDATES:
 *  P----: 7/14/86 jfb
 *      Modified heavily by jfb on 7/14/86
 *
 *      This include file is sort of strange and with the inclusion
 *      of the Berkeley libraries it may not now be called by anyone.
 *
 *  P2843: 9/24/88 r h bloom	-- PS/2 AIX
 *	Of all attributes and forms of UNIX, the physical ordering
 *	of the elements of a structure are the least portable among
 *	varying CPUs and varying CC implementations.
 *	 These Macros inspect the words of a double (floating) by pairing
 *	it in a union with a structure consisting of two unsigned integers.
 *	Under CC on AIX for PS/2 (1E38C), the first element of the structure
 *	will find the LOW-order word of the double.  The 2nd element: HIGH.
 */

#ifdef i386
typedef union {double d; struct { unsigned dfractl, dfracth;} s; } DNANX;
#else
typedef union {double d; struct { unsigned dfracth, dfractl;} s; } DNANX;
#endif	/* i386 */
#ifdef __cplusplus
/* (MRL) To pick up declaration of kill() */
#include <sysent.h>
#endif

#define KILLFPE()	(void) kill(getpid(), 8)

#define HIX(val) \
	(((DNANX *)&(val))->s.dfracth)

#define LOX(val) \
	(((DNANX *)&(val))->s.dfractl)

#define TNANX(X) \
	((( HIX(X) & 0x7ff00000) == 0x7ff00000 && \
	((( HIX(X) & 0x000fffff) != 0) | LOX(X) != 0)) \
	&& !(HIX(X) & 0x00080000))

#define KILLNaN(X) if (TNANX(X)) KILLFPE()
#ifdef __cplusplus
}
#endif
