#ifdef __cplusplus
extern "C" {
#endif
#ifndef H_SCCSID
#include <sccs.h>
#endif /* ! H_SCCSID */
H_SCCSID(@(#)netdb.h	1.13.1.1	AIX)	/* Modified 7/30/90 18:16:34 */
/*	@(#)netdb.h	5.7 (Berkeley) 5/12/86
 */
/* 
 * (C) Copyright IBM Corp. 1989 
 * All Rights Reserved 
 * Licensed Materials - Property of IBM 
 */

/*
 * Structures returned by network
 * data base library.  All addresses
 * are supplied in host order, and
 * returned in network order (suitable
 * for use in system calls).
 */
struct	hostent {
	char	*h_name;	/* official name of host */
	char	**h_aliases;	/* alias list */
	int	h_addrtype;	/* host address type */
	int	h_length;	/* length of address */
	char	**h_addr_list;	/* list of addresses from name server */
#define	h_addr	h_addr_list[0]	/* address, for backward compatiblity */
};

/*
 * Assumption here is that a network number
 * fits in 32 bits -- probably a poor one.
 */
struct	netent {
	char		*n_name;	/* official name of net */
	char		**n_aliases;	/* alias list */
	int		n_addrtype;	/* net address type */
	unsigned long	n_net;		/* network # */
};

struct	servent {
	char	*s_name;	/* official service name */
	char	**s_aliases;	/* alias list */
	int	s_port;		/* port # */
	char	*s_proto;	/* protocol to use */
};

struct	protoent {
	char	*p_name;	/* official protocol name */
	char	**p_aliases;	/* alias list */
	int	p_proto;	/* protocol # */
};

struct rpcent {
        char    *r_name;        /* name of server for this rpc program */
        char    **r_aliases;    /* alias list */
        int     r_number;       /* rpc program number */
};

struct hostent	*gethostbyname(cont char*), 
	*gethostbyaddr(const char*, int, int), 
	*gethostent(void);
struct netent	*getnetbyname(const char*), 
	*getnetbyaddr(long, int), /* (MRL) I think - or it is int,int */
	*getnetent(void);
struct servent	*getservbyname(const char*, const char*), 
	*getservbyport(int, const char*), 
	*getservent(void);
struct protoent	*getprotobyname(const char*), 
	*getprotobynumber(int), 
	*getprotoent(void);
struct rpcent   *getrpcbyname(const char*), 
	*getrpcbynumber(int), 
	*getrpcent(void);

/*
 * Error return codes from gethostbyname() and gethostbyaddr()
 */

extern  int h_errno;	

#define	HOST_NOT_FOUND	1 /* Authoritive Answer Host not found */
#define	TRY_AGAIN	2 /* Non-Authoritive Host not found, or SERVERFAIL */
#define	NO_RECOVERY	3 /* Non recoverable errors, FORMERR, REFUSED, NOTIMP */
#define NO_DATA		4 /* Define used in new 4.8.1 resolver code */
#define NO_ADDRESS	NO_DATA /* Valid host, no address, look for MX record */
#ifdef __cplusplus
}
#endif
