#ifdef __cplusplus
extern "C" {
#endif
#ifndef H_SCCSID
#include <sccs.h>
#endif /* ~H_SCCSID */
H_SCCSID(@(#)resource.h	16.7	LCC)	/* Modified: 18:47:00 9/22/89 */

#ifndef	_h_RESOURCE
#define	_h_RESOURCE

#ifndef _h_TIME
#ifdef KERNEL
#include <time.h>
#else /* ~KERNEL */
#include <sys/time.h>
#endif /* ~KERNEL */
#endif /* _h_TIME */

/*
 * Resource utilization information.
 */

/*
 * Copyright (c) 1982, 1986 Regents of the University of California.
 * All rights reserved.  The Berkeley software License Agreement
 * specifies the terms and conditions for redistribution.
 *
 *	@(#)resource.h	7.1 (Berkeley) 6/4/86
 */
/* 
* Copyright (C)  1989, Locus Computing Corporation
 * All Rights Reserved
 */ 
/* 
 * (C) Copyright IBM Corp. 1989 
 * All Rights Reserved 
 * Licensed Materials - Property of IBM 
 */

/*
 * Process priority specifications to get/setpriority.
 */

#ifdef	_BSD
#define	PRIO_MIN	-20
#define	PRIO_MAX	20
#else	/* ~_BSD */
#define	PRIO_MIN	0
#define	PRIO_MAX	40
#endif	/* ~_BSD */

#define	PRIO_PROCESS	0
#define	PRIO_PGRP	1
#define	PRIO_USER	2

#define	RUSAGE_SELF	0
#define	RUSAGE_CHILDREN	-1

struct	rusage {
	struct timeval ru_utime;	/* user time used */
	struct timeval ru_stime;	/* system time used */
	long	ru_maxrss;
/*
 * To "add" two rusage structures, make appropriate adjustments for the
 * fields above, and then just add all of the counters between ru_first
 * and ru_last, inclusive.  All of these counters must be longs.
 */
#define	ru_first	ru_ixrss
	long	ru_ixrss;		/* integral shared memory size */
	long	ru_idrss;		/* integral unshared data " */
	long	ru_isrss;		/* integral unshared stack " */
	long	ru_minflt;		/* page reclaims */
	long	ru_majflt;		/* page faults */
	long	ru_nswap;		/* swaps */
	long	ru_inblock;		/* block input operations */
	long	ru_oublock;		/* block output operations */
	long	ru_msgsnd;		/* messages sent */
	long	ru_msgrcv;		/* messages received */
	long	ru_nsignals;		/* signals received */
	long	ru_nvcsw;		/* voluntary context switches */
	long	ru_nivcsw;		/* involuntary " */
#define	ru_last		ru_nivcsw
};

/*
 * Resource limits
 */
#define	RLIMIT_CPU	0		/* cpu time in milliseconds */
#define	RLIMIT_FSIZE	1		/* maximum file size */
#define	RLIMIT_DATA	2		/* data size */
#define	RLIMIT_STACK	3		/* stack size */
#define	RLIMIT_CORE	4		/* core file size */
#define	RLIMIT_RSS	5		/* resident set size */

#define	RLIM_NLIMITS	6		/* number of resource limits */

#define	RLIM_INFINITY	0x7fffffff

struct rlimit {
	long	rlim_cur;		/* current (soft) limit */
	long	rlim_max;		/* maximum value for rlim_cur */
};

#endif	/* ! _h_RESOURCE */
#ifdef __cplusplus
}
#endif
