#ifdef __cplusplus
extern "C" {
#endif
#ifndef H_SCCSID
#include <sccs.h>
#endif /* ~H_SCCSID */
H_SCCSID(@(#)sst.h	1.8	AIX)	/* Modified 9/17/89 01:32:35 */
/*      @(#)sst.h	5.2 u370  source        */
/* 
 * (C) Copyright IBM Corp. 1989 
 * All Rights Reserved 
 * Licensed Materials - Property of IBM 
 */

/*
 * Data returned by UNIX/370 system statistics special file.
 */

typedef	int	DEC;	/* DEC really means 4-byte packed decimal (aargh!) */

/* system configuration and parameters */
struct pxs {
	struct {		/* page header */
		short	svc;		/* object of ex instruction */
		char	unused01;
		char	flag;		/* 0 ok, 4 bad passwd, 8 page ovfl */
		int	unused02;
		char	name[8];	/* password to ceass */
		int	unused03;
	}	head;
	short	nap;		/* number of processors available (cstnap) */
	short	nam;		/* number of 2301's/2305's (asanam) */
	short	ndr;		/* number of 2301's (asandr) */
	short	fsc;		/* initial drum pages available (asafsc) */
	short	nak;		/* number of aux disks in system (asanak) */
	short	sze;		/* core blocks in system (cehsze) */
	short	icba;		/* core blocks not assigned to rc (cbhicba) */
	short	unused04[19];
	double	tod;		/* ipl time of day (systod) */
	double	unused05;
	/* system parameters */
	short	pmt;		/* tsi's permitted on disp. list (syspmt) */
	short	low;		/* low core threshold (low) (syslow) */
	short	hi;		/* low core threshold (high) (syshi) */
	short	buf;		/* buffer size on drum (sysbuf) */
	short	unused06;
	short	mwt;		/* scan shared pages threshold (sys wt) */
	short	mxd;		/* upper shared page drum threshold (sysmxd) */
	short	mnd;		/* lower shared page drum threshold (sysmnd) */
	short	mxs;		/* max number of shared pages (sysmxs) */
	short	mns;		/* min number of shared pages (sysmns) */
	short	blk;		/* max pages blocked to drum (sysblk) */
	short	blk2;		/* max pgs blocked to drum & disk (sysblk2) */
	short	pl1;		/* prejudice level 1 */
	short	pl2;		/* prejudice level 2 */
	short	pl3;		/* prejudice level 3 */
	short	pl4;		/* prejudice level 4 */
	short	btlmt;		/* limit of big task pages (sysbtlmt) */
	short	btsiz;		/* size of big task (sysbtsiz) */
	short	migr1;		/* time for complete migr. in min (sysmigr1) */
	short	migr2;		/* time for abend in min (sysmigr2) */
	short	unused07;
	short	stn;		/* number of ste levels returned */
	char	st[32][123];	/* schedule table entries */
};

/* global system statistics */
struct stv {
	struct {		/* header */
		short	svc;		/* svc */
		char	unused11;
		char	flag;		/* 0 ok, 4 bad passwd, 8 page ovfl */
		char	ful;		/* page overflow flag for ftn */
		char	unused12[3];
		char	name[8];	/* password to ceass */
		int	unused13;
	}	head;
	/* times */
	int	unused14;
	double	ccv;		/* current clock value */
	double	wtm1;		/* wait time cpu 1 (psawtm) */
	double	wtm2;		/* wait time cpu 2 (psawtm) */
	double	res;		/* response time. computed in vm */
	double	vmb;		/* vm time (sysvmb) micro-seconds */
	double	nvmb;		/* non-priv vm time (sysnvmb) micro-secs */
	double	zet;		/* time sst zeroed (sstzet) */
	/* schedule table counters */
	int	npg;		/* number of program counts returned */
	int	nct;		/* number of level counts returned */
	struct {		/* program counts */
		int	kz1;		/* ceakz ceakt call task in delay */
		int	kz2;		/* ceakz ceakt call task not in dly */
		int	kz3;		/* ceakz ceakt call free lock */
		int	nb;		/* ceanb */
		int	ki;		/* ceaki */
		int	r2;		/* cear2 */
		int	r3;		/* cear3 */
	}	prog;
	int	lvl[256];	/* level counts */
	struct {
		int	stc;		/* calls to steal */
		int	stn;		/* none stolen */
		int	stt;		/* forced tsends */
		int	stl;		/* partial steals */
		int	pgs;		/* total pages stolen */
	}	steal;
	struct {
		DEC	plt;		/* tsend disk read limit sstplt */
		DEC	qlt;		/* tsend quant limit sstqlt */
		DEC	lct;		/* tsend lo-core sstlct */
		DEC	twt;		/* tsend twait ssttwt */
		DEC	tst;		/* tsend svc ssttst */
		DEC	alt;		/* tsend all sstalt */
		DEC	awt;		/* tsend await sstawt */
		DEC	xcr;		/* tsend page limit sst xcr */
		DEC	wait;		/* tsend twait sstwait */
	}	tsend;
	struct {
		int	kie;		/* times ceaki entered */
		int	kid;		/* times ceaki put task on disp list */
		int	kinw;		/* times ceaki entered w/ sysnwk off */
	}	sched;
	int	unused15;
	struct {
		int	scn;		/* write shared pages scan calls */
		int	prg;		/* write shared pages purge calls */
	}	shrd;
	struct {
		int	pms;		/* private migration starts */
		int	sms;		/* shared migration starts */
		int	mms;		/* mtt private migration starts */
		int	mmr;		/* mtt private migration requests */
	}	migr;
	int	unused16[4];
	struct {
		int	proct;		/* time spent in queue proc. */
		int	procc;		/* no. of times queue proc. entered */
	}	proc[81];
	int	unused17;
	/* drum and disk i/o */
	int	lh2;		/* sst drum area length (sstlh2) */
	int	lh3;		/* sst disk area length (sstlh3) */
	char	unused18[168];
	struct {
		DEC	ddrs;		/* shared reads (sstdrrs, sstdsrs) */
		DEC	ddrp;		/* private reads (sstdrrp, sstdsrp) */
		DEC	ddws;		/* shared writes (sstdrws, sstdsws) */
		DEC	ddwp;		/* private writes (sstdrwp, sstdswp) */
	}	dd[126];
};

/* memory and local task statistics */
struct tsx {
	struct {		/* page header */
		short	svc;		/* object of ex instruction */
		char	unused21;
		char	flag;		/* 0 ok, 4 bad passwd, 8 page ovfl */
		char	ful;		/* page ovflw flag for ftn */
		char	unused22[3];
		char	name[8];	/* password to ceass */
		int	unused23;
	}	head;
	struct {		/* system statistics */
		short	tsi;		/* number of tsi's returned */
		short	tct;		/* no. of tsi's in system (systct) */
		/* real memory */
		short	avc;		/* available core blocks (cbhavc) */
		short	ecb;		/* estimated core blocks (sysecb) */
		short	sca;		/* supervisor owned core blocks */
		short	usr;		/* user owned core blocks */
		short	prt;		/* partitioned core blocks */
		short	rsv;		/* reserved core blocks */
		short	ptp;		/* page table pages */
		short	shp;		/* shared pages in core cnt (sysshp) */
		short	cor;		/* core pressure (syscor) */
		short	btcnt;		/* big task pages assgd (sysbtcnt) */
		/* virtual memory */
		short	unused24;
		short	psc;		/* public segment count (syspsc) */
		int	pwp;		/* page writes pending cnt (syspwp) */
		int	prp;		/* page reads pending ct (sum tsicp) */
		int	nx;		/* xtsi pages (sum tsinx) */
		int	srp;		/* steal wrts pend ct (sum tsiswpct) */
		int	mip;		/* migrated pages (sstmip) */
		DEC	mis;		/* migrated shared pages (sstmis) */
		DEC	dcp;		/* deleted core pages (sstdcp) */
		DEC	ccp;		/* created core pages (sstccp) */
		DEC	scp;		/* reclaimed shared pages (sstscp) */
		DEC	pcp;		/* reclaimed private pages (sstpcp) */
		DEC	xcp;		/* relocation exceptions (sstxcp) */
		short	fsv;		/* drum fair share (sysfsv) */
		short	tma;		/* no. of drum pages avail. (asatma) */
		int	tka;		/* no. of aux pages avail. (asatka) */
		int	elg;		/* tasks eligible (syselg) */
		int	ina;		/* tasks active (sysina) */
		int	unused25[5];
	}	sys;
	/* tasks */
	struct {		/* task entry */
		int	drmr;		/* drum reads */
		int	dskr;		/* disk reads */
		int	rec;		/* reclaimed pages count */
		int	tmslc;		/* tsend count */
		int	svcc;		/* svc count */
		int	rel;		/* relocation count */
		double	atime;		/* vm time */
		short	aux;		/* pages on paging packs */
		char	unused26;
		char	fl1;		/* flag byte */
#define			MGM	0x02		/* migration */
#define			CNM	0x04		/* conversational */
#define			DSM	0x08		/* dispatchable */
#define			ELM	0x10		/* eligible */
#define			EBM	0x20		/* execute bound */
#define			SRM	0x40		/* steal writes pending */
#define			SCM	0x80		/* ahead of schedule */
		short	drpag;		/* number of drum pages */
		short	tskid;		/* taskid */
		char	usrid[8];	/* userid */
		char	ring[16];	/* ste ring */
	}	stat[62];
};
#ifdef __cplusplus
}
#endif
