#ifdef __cplusplus
extern "C" {
#endif
#ifndef H_SCCSID
#include <sccs.h>
#endif /* ! H_SCCSID */
H_SCCSID(@(#)stand.h	1.12	AIX)	/* Modified 11/13/89 12:28:04 */
/* @(#)stand.h	7.1 - 87/06/16 - 00:13:06 */
/* 
 * (C) Copyright IBM Corp. 1989 
 * All Rights Reserved 
 * Licensed Materials - Property of IBM 
 */

/*
 * Header file for standalone package
 */

#undef FsTYPE
#ifdef RTPC
#define	FsTYPE	4
#endif
#ifdef vax
#define	FsTYPE	2
#endif
/* default case is 1.  The 386 and 370 fall into this catagory */
#ifndef FsTYPE
#define	FsTYPE	1
/* default case is 1.  The 386 and 370 fall into this catagory */
#endif
#include <errno.h>
#include <sys/param.h>
#include <sys/types.h>
#include <sys/inode.h>
/*
 * Undefine some names that inode.h defined.
 * (Conflict when declaring struct iob.)
 */
#undef i_atime
#undef i_mtime
#undef i_ctime

/*
 * I/O block flags
 */

#define F_READ	01
#define F_WRITE	02
#define F_ALLOC	04
#define F_FILE	010

/*
 * Request codes -- must be
 * the same as an F_XXX above
 */

#define	READ	1
#define	WRITE	2

/*
 * Buffer sizes
 */

#ifdef RTPC
#define BLKSIZ BSIZE
#endif
#if FsTYPE == 2
#define BLKSIZ	1024
#else
#define BLKSIZ	512
#endif
#define NAMSIZ	60

/*
 * devsw table --
 * initialized in conf.c
 */

struct devsw {
	int	(*dv_strategy)();
	int	(*dv_open)();
	int	(*dv_close)();
};
extern struct devsw _devsw[];

/*
 * dtab table -- entries
 * are created by MKNOD
 */

#ifdef RTPC
#define NDEV	20
#else
#define NDEV	16
#endif

struct dtab {
	char		*dt_name;
	struct devsw	*dt_devp;
	int		dt_unit;
	daddr_t		dt_boff;
#ifdef RTPC
	int             dt_opens;          /* # times opened */
#endif
};
extern struct dtab _dtab[];

/*
 * mtab table -- entries
 * are created by mount
 */

#ifdef RTPC
#define NMOUNT	20
#else
#define NMOUNT	8
#endif

struct mtab {
	char		*mt_name;
	struct dtab	*mt_dp;
};
extern struct mtab _mtab[];

/*
 * I/O block: includes an inode,
 * cells for the use of seek, etc,
 * and a buffer.
 */

#define NFILES	6

struct iob {
	char		i_flgs;
	struct inode	i_ino;
	time_t		i_atime;
#ifdef RTPC
#undef i_mtime
#endif
	time_t		i_mtime;
	time_t		i_ctime;
	struct dtab	*i_dp;
	off_t		i_offset;
	daddr_t		i_bn;		/* disk block number (physical) */
	char		*i_ma;
	int		i_cc;		/* character count */
	char		i_buf[BLKSIZ];
};
extern struct iob _iobuf[];


/*
 * Set to the error type of the routine that
 * last returned an error -- may be read by perror.
 */

extern int errno;
#define	RAW	040
#define	LCASE	04
#define	XTABS	02
#define	ECHO	010
#define	CRMOD	020
#define B300	7
#define B1200   11
#define B9600   15
struct sgttyb {
	char	sg_ispeed;		/* input speed */
	char	sg_ospeed;		/* output speed */
	char	sg_erase;		/* erase character */
	char	sg_kill;		/* kill character */
	int	sg_flags;		/* mode flags */
};
#ifdef RTPC
#define FSBB 0200 /* standalone fs */
#define FSB(io) ((io->i_dp->dt_unit&FSBB) ? io->i_bn + FSBOFF : io->i_bn)
#define FSM(u) (u&~FSBB)
#define FSBOFF 60 /* offset for boot file system */
#define VD1000BOFF 16
#define VD1000MINOR 10
#define ROOTIODN 16384
#endif RTPC
#ifdef __cplusplus
}
#endif
