#ifndef _H_STRING
/* MRL Added H_STRING guard */
#define _H_STRING
#ifdef __cplusplus
extern "C" {
#endif
#ifndef _POSIX_SOURCE
#ifndef H_SCCSID
#include <sccs.h>
#endif /* ! H_SCCSID */
H_SCCSID(@(#)string.h	1.26	AIX)	/* Modified 10/12/90 19:54:27 */
#endif /* NOT _POSIX_SOURCE */

/* 
 * (C) Copyright IBM Corp. 1989 
 * All Rights Reserved 
 * Licensed Materials - Property of IBM 
 */

/*  POSIX needed definition of size_t */
// (MRL) typedef long	size_t;
typedef unsigned long size_t;

extern char
	*strcpy(char*, const char*),
	*strncpy(char*, const char*, int),
	*strcat(char*, const char*),
	*strncat(char*, const char*, int),
	*strchr(const char*, int),
	*strrchr(const char*, int),
	*strstr(const char *, const char *);
extern int
	strcmp(const char*, const char*),
	strncmp(const char*, const char*, int);
extern int
	strcspn(const char*, const char*),
	strlen(const char*),
	strspn(const char*, const char*);
#ifndef _VSX
	extern void
		*memchr(const void*, int, size_t),
		*memcpy(void*, const void*, size_t),
		*memccpy(void *, const void *, int, size_t),
		*memset(void*, int, size_t);
#else /* _VSX */
	extern void
		*memchr(const void*, int, size_t),
		*memcpy(void*, const void*, size_t),
		*memccpy(void *, const void *, int, size_t),
		*memset(void*, int, size_t);
#endif /* _VSX */
extern int memcmp(const void*, const void*, size_t);

#ifdef _BSD
extern char 
	*index(const char*, char), 
	*rindex(const char*, char);
#endif /* _BSD */

extern char
	*strpbrk(const char*, const char*),
	*strtok(char*, const char*);
extern long
	strtol(const char*, char**, int);

#ifndef _POSIX_SOURCE
#include <NLchar.h>
extern char
	*NLstrcpy(),
	*NLstrncpy(),
	*NLstrcat(),
	*NLstrncat(),
	*NLstrchr(),
	*NLstrrchr(),
	*NLstrpbrk(),
	*NLstrtok();
extern NLchar
	*NCstrcpy(),
	*NCstrncpy(),
	*NCstrcat(),
	*NCstrncat(),
	*NCstrchr(),
	*NCstrrchr(),
	*NCstrpbrk(),
	*NCstrtok();
#endif /* NOT _POSIX_SOURCE */

#ifndef NULL
#define NULL 0
#endif
#ifdef __cplusplus
}
#endif
#endif
