#ifdef __cplusplus
extern "C" {
#endif
/*
 *		IX/370
 *		5667-126
 *	LICENSED MATERIALS - PROPERTY OF IBM
*	(c) Copyright 1985, 1986, 1989 IBM Corp.
*	(c) Copyright 1983, 1984, 1985, 1986,  1989 Locus Computing Corporation
 *	All Rights Reserved
 */

#ifndef H_SCCSID
#include <sccs.h>
#endif /* ~H_SCCSID */
H_SCCSID(@(#)dirstat.h	16.4	LCC)	/* Modified: 18:07:47 9/22/89 */

#ifndef _h_DIRSTAT
#define _h_DIRSTAT

#ifndef _h_STAT
#ifdef  KERNEL
#include <stat.h>
#else  /* ~KERNEL */
#include <sys/stat.h>
#endif /* ~KERNEL */
#endif  /* ! _h_STAT */

/*
 * This structure is transmitted through netmsg's;  it doesn't use
 * the PADOPEN, PADCLOSE macros because it is user-visible.  If it
 * changes, dirstat_flp() must be updated.
 */
struct  dirstat
{
/* Lengths come first, so that we can extend the structure later without
 * recompiling user programs.  See the access macros below.  */
	short	dir_nam_len;	/* Length of name. */
	short	dir_rec_len;	/* length of record. */
	struct  stat  dir_stat;

/* If we could not stat this inode for any reason, dir_ss will be -1
 * and we use st_css to hold the errno.  Only st_ino, 
 * dir_name_len, and dir_rec_len fields are valid in this case, all others 
 * are undefined.
 */
#define st_errno		st_css
};

/* dirstat -- stat multiple entries in a directory
 * int retcode = dirstat(fd, loc, length);
 *     int fd; 			/* file descriptor for open dir
 *     struct dirstat *loc;	/* buffer to be filled in
 *     int length;		/* size of buffer
 */

extern int dirstat(int, struct dirstat*, int);

/* 
 * Actual number of bytes needed for this particular entry.   The name
 * field is padded up to a 4-byte boundary, as in the 4.3 directory 
 * structure. 
 */
#define DIRST_SIZ(dirp) \
    (((dirp)->dir_rec_len + (dirp)->dir_nam_len + 3) & ~3)

/*
 * This is the ONLY proper way to advance through a list of dirstat
 * structures.  The structure may have more fields added (to the end)
 * at some future date, at which point the dir_rec_len field will be
 * returned with a new value.  This will allow old programs to continue
 * working without needing to be recompiled.
 */
#define DIRST_ADV(dirp) \
	((struct dirstat *)((char *)(dirp) + DIRST_SIZ(dirp)))
/* Fix the name, and change not to do the assignment */

#ifdef KERNEL
/* Avoid a needless pointer reference. */
#define DIRST_NAME(dirp) ((char *)((char *)dirp + sizeof(struct dirstat)))
#else
#define DIRST_NAME(dirp) ((char *)((char *)dirp + dirp->dir_rec_len))
#endif /* ! KERNEL */

/* Room needed for dirstat struct with name of length 'len' */
#ifdef KERNEL
#define DIRST_ROOM(len)  ((sizeof(struct dirstat) + (len) + 3) & ~3)
#endif /* KERNEL */
#endif  /* ! _h_DIRSTAT */
#ifdef __cplusplus
}
#endif
