#ifdef __cplusplus
extern "C" {
#endif
/*
 *		IX/370
 *		5667-126
 *	LICENSED MATERIALS - PROPERTY OF IBM
 *	(c) Copyright 1985, 1986, 1989 IBM Corp.
 *	(c) Copyright 1983, 1984, 1985, 1986,  1989 Locus Computing Corporation
 *	All Rights Reserved
 */

#ifndef _POSIX_SOURCE
#ifndef H_SCCSID
#include <sccs.h>
#endif /* ~H_SCCSID */
H_SCCSID(@(#)fcntl.h	16.11       LCC)    /* Modified: 19:43:31 1/11/90 */
#endif /* NOT _POSIX_SOURCE */

#ifndef	_H_FCNTL
#define	_H_FCNTL

#include <sys/types.h>

/* WARNING: if you change FD_CLOEXEC be sure to change EXCLOSE in <sys/user.h>
 */
#define FD_CLOEXEC 01 	


/* Open Flags.  These may only be passed to open(2) */
#define	O_RDONLY        0
#define	O_WRONLY        1
#define	O_RDWR	        2
#define O_ACCMODE (O_RDONLY|O_WRONLY|O_RDWR)

#ifndef _POSIX_SOURCE
#define	O_DEFERC       040	/* do deferred commits of changes */
#endif /* NOT _POSIX_SOURCE */

#define O_NOCTTY      0200	/* do not establish a controlling terminal */
#define	O_CREAT	      0400	/* open with file create (uses third open arg)*/
#define	O_TRUNC	     01000	/* open with truncation */
#define	O_EXCL	     02000	/* exclusive open */


/* Flag values accessible to open(2) and fcntl(2) */
#define	O_NONBLOCK	(_O_NDELAY|_O_EDELAY)	/* POSIX Non-blocking I/O */
#define	_O_NDELAY 	04	/* Non-blocking I/O, System V Flavor */
#define	O_APPEND       010	/* append (writes guaranteed at the end) */
#define _O_EDELAY     0100	/* with O_NDELAY, indicates BSD-flavor NDELAY */

#ifndef _POSIX_SOURCE
#ifdef _BSD		/* For Berkeley apps, emulate BSD behavior */
#define	O_NDELAY	O_NONBLOCK
#else
#define	O_NDELAY	_O_NDELAY
#endif /* _BSD */

#define O__NDELAY _O_NDELAY
#define O_EDELAY _O_EDELAY

#define	O_ASYNC	       020	/* signal pgrp when data ready */
#define	O_OPENDIR    04000	/* no longer used */
#define O_SYNC	   0200000	/* synchronous write */
#define O_REPLSYNC 0400000	/* syncronous replicated write */
#endif /* NOT _POSIX_SOURCE */


/* fcntl(2) requests */
#define	F_DUPFD	0	/* Duplicate fildes */
#define	F_GETFD	1	/* Get fildes flags */
#define	F_SETFD	2	/* Set fildes flags */
#define	F_GETFL	3	/* Get file flags */
#define	F_SETFL	4	/* Set file flags */
#define F_GETLK 5	/* Get first blocking lock */
#define F_SETLK 6	/* Non-blocking lock */
#define F_SETLKW 7	/* Blocking lock */


#ifndef _POSIX_SOURCE

#define F_OPENLOCK 8	/* Dos - file sharing options */
#define F_GETOWN 9	/* Get pgrp */
#define F_SETOWN 10 	/* Set pgrp for SIGIO */

/* F_SETFL/GETFL flags */

#if defined(_BSD) && !defined(_KERNEL)
#define FNDELAY		(O_NDELAY|_O_EDELAY) /* for BSD */
#else
#define FNDELAY		O_NDELAY /* enable non-blocking system calls	*/
#endif  /* defined(_BSD) && !defined(_KERNEL) */

#define	FAPPEND		O_APPEND /* enable write at end-of-file mode	*/
#define FASYNC		O_ASYNC	 /* send signal when I/O completes	*/
#define FDEFERC		O_DEFERC /* enable deferred commit		*/
#define FCOMMIT		O_DEFERC /* enable deferred commit		*/
#define FEDELAY		_O_EDELAY /* return EAGAIN when block condition	*/
#define FSYNC		O_SYNC	 /* synchronous write 			*/
#define FREPLSYNC	O_REPLSYNC /* synchronous replicated write	*/
#define	FCREAT		O_CREAT	/* open, creating if necessary		*/
#define	FTRUNC		O_TRUNC	/* open, truncating the file		*/
#define	FEXCL		O_EXCL	/* open for exclusive use		*/

#endif /* NOT _POSIX_SOURCE */


/* File locking modes used with F_GETLK, F_SETLK, F_SETLKW */
#define F_RDLCK 1
#define F_WRLCK 2
#define F_UNLCK 3

#ifndef _POSIX_SOURCE

#define F_DOSENFORCE   8
#define F_DOSRDLCK     (F_RDLCK|F_DOSENFORCE)	/* Not currently used */

/* used by PCI servers for DOS-locking emulation */
/* F_DOSWRLCK - should be specified as the lock type for DOS-locking */
#define F_DOSWRLCK     (F_WRLCK|F_DOSENFORCE)

/* the following definitions are used in the fcntl F_OPENLOCK option */
#define EXCLUDE_COMPAT  0 
#define EXCLUDE_READ	1
#define EXCLUDE_WRITE	2 
#define EXCLUDE_BOTH	3 
#define EXCLUDE_NONE	4 

#endif /* NOT _POSIX_SOURCE */


/* The following structure is used for fcntl().  It is not to be
 * confused with the BSD flock() routine. */

struct	flock {
		short      l_type;
		short      l_whence;
		off_t	   l_start;
		off_t      l_len;
		u_long_t   l_sysid;
		pid_t      l_pid;
};


#ifndef _KERNEL
#ifdef __cplusplus
extern int open(const char*, int, mode_t mode=0666), 
	creat(const char*, mode_t), 
	fcntl(int, int, int);
#else 
extern int open(), creat(), fcntl();
#endif
#endif /* NOT _KERNEL */

#endif /* NOT _H_FCNTL */
#ifdef __cplusplus
}
#endif
