#ifdef __cplusplus
extern "C" {
#endif
/*
 *		IX/370
 *		5667-126
 *	LICENSED MATERIALS - PROPERTY OF IBM
*	(c) Copyright 1985, 1986, 1989 IBM Corp.
*	(c) Copyright 1983, 1984, 1985, 1986,  1989 Locus Computing Corporation
 *	All Rights Reserved
 */

#ifndef H_SCCSID
#include <sccs.h>
#endif /* ~H_SCCSID */
H_SCCSID(@(#)file.h	16.7	AIX)	/* Modified: 18:11:43 9/22/89 */

#ifndef	_h_FILE
#define	_h_FILE

/* Certain constands (file access, and seek offsets) were moved to unistd.h
 * where AIX programs expect to find them. We included that header file here
 * for BSD programs which expect to find these contstants in file.h
 */
#ifndef _h_UNISTD
#include <unistd.h>
#endif

/* Certain constants (FNDELAY, etc) were moved from file.h to fcntl.h
 * because that is where BSD programs expect to find them.  We include
 * that header file here for those SYS V programs which expect to find
 * these constants in file.h
 */
#include <sys/fcntl.h>

/*
 * One file structure is allocated
 * for each open/creat/pipe call.
 * Main use is to hold the read/write
 * pointer associated with each open
 * file.
 */

/* LOCUS changes:
 * 1. set FNLR as 04, which FPIPE used to be.  Set FPIPE to 010 and
 *    moved FMPX, FMPY and FMP up appropritely (could be reused now).
 * 2. dynamic table allocation and free list of available blocks.
 */

struct	file
{
	long	f_flag;
	short	f_count;		/* reference count */
	short	f_tcbdes;		/* TCB descriptor */
	short	f_type;			/* descriptor type */
	siteno_t f_tmgrsite;		/* token manager site */
	char	f_wnttok;		/* token semaphore */
	char	f_tlckcnt;		/* token lock semaphore */
	union {
		struct inode *F_inode;	/* pointer to inode structure */
		caddr_t	F_data;		/* pointer to socket */
	} f_ISP;
#define f_inode	f_ISP.F_inode
#define f_data	f_ISP.F_data
	union {
		off_t	F_offset;	/* read/write char pointer */
		short F_msgcount;	/* references from msg queue */
#define f_msgcount	f_UN.F_msgcount
		struct  file *F_next;	/* pointer for free list */
#define f_next  f_UN.F_next
	} f_UN;
#define f_offset	f_UN.F_offset
};

#ifdef	KERNEL

/* these two definitions are not used */
#define	DTYPE_INODE	1	/* file */
#define	DTYPE_SOCKET	2	/* communications endpoint */

extern  struct	file *file;	/* the file table itself */

#define fileNFILE	v.ve_file	/* use the value in struct var */
#define nfile		v.v_file	/* use the value in struct var */
extern  struct  file * file_flist;	/* head of free list */
extern	struct	file *getf(int file_t**);
extern	struct	file *falloc(struct vnide*, int, file_t**, int*);

#ifdef __cplusplus
/* (MRL)  Who knows - so make it ... */
extern  struct file *file_destoptr(...);
#else
extern  struct file *file_destoptr();
#endif

#endif  /* KERNEL */

/* flags */
#define	FOPEN		(-1)
#define	FREAD		0x01
#define	FWRITE		0x02
#define	FDEVHANDLE	0x80	/* flag passed to mpx device open routine */
#define FOWRITE		0x80	/* when closing, close for MOD */
#define	FMASK		0x300ff	/* only flags less the FMASK are protected
				 * by the token mechanism so far */
#define	FAUTOCONF	0x100	/* flag passed to auto conf open routines */

/***********************************************************
*	Defining FSHLOCK enables the kernel implementation of flock	
*	and overloads FDEFERA. Please excercise caution. Currently
*	affected modules are (lockf, tokens, sysent). Flock is now
*	available in libbsd.
*
*       #define	FSHLOCK	0x40	/ shared lock present    /
*       #define	FEXLOCK	0x100	/ exclusive lock present /
***********************************************************/

#define FSPCL		0x200  	/* this file block used in a non-standard way */
#define FSOCKET	FSPCL
#define FOPRCD		0x400	/* passed to open1 for remote RCD opens */
#define FPRESENT	0x0800	/* token has been acquired */

#define FMARK		0x0800	/* used by unp_gc and unp_mark */
#define FDEFER		0x1000	/* used by unp_gc and unp_mark */

#define FTLOCKED	0x1000	/* token is locked */
#define FTOKWNT		0x2000	/* token is wanted elsewhere */
#define FNETOPEN	0x4000	/* passed to open1/openp on netfork */
#define FDOSOPEN	0x8000	/* file opened using dos-semantics */

/* bits which cant be set with fcntl setfl - should be expanded */
#define	FCNTLCAN	(FNDELAY|FEDELAY|FAPPEND|FASYNC|FSYNC|FREPLSYNC)


/*
 * Flock call.
 */
#define	LOCK_SH		1	/* shared lock */
#define	LOCK_EX		2	/* exclusive lock */
#define	LOCK_NB		4	/* don't block when locking */
#define	LOCK_UN		8	/* unlock */

/*
 * Lseek call.
 */
#define	L_SET		SEEK_SET	/* absolute offset */
#define	L_INCR		SEEK_CUR	/* relative to current offset */
#define	L_XTND		SEEK_END	/* relative to end of file */

#endif /* ~_h_FILE */
#ifdef __cplusplus
}
#endif
