#ifdef __cplusplus
extern "C" {
#endif
/*
 *		IX/370
 *		5667-126
 *	LICENSED MATERIALS - PROPERTY OF IBM
 *	(c) Copyright 1985, 1986, 1989 IBM Corp.
 *	(c) Copyright 1983, 1984, 1985, 1986,  1989 Locus Computing Corporation
 *	All Rights Reserved
 */

#ifndef _POSIX_SOURCE
#ifndef H_SCCSID
#include	<sccs.h>
#endif /* !H_SCCSID */
H_SCCSID(@(#)ioctl.h	1.2    IBM AIX)    /* Modified: 20:01:56 7/15/92 */
#endif /* ! _POSIX_SOURCE */

#ifndef	_H_IOCTL
#define	_H_IOCTL

#ifndef _POSIX_SOURCE

#include <sys/ioctlcmd.h>
#include <sys/types.h>
#include <sgtty.h>

/*
**	Structures definitions for ioctl args
*/

/*	tty control character stuff	*/
struct tchars {
	char	t_intrc;	/* interrupt */
	char	t_quitc;	/* quit */
	char	t_startc;	/* start output */
	char	t_stopc;	/* stop output */
	char	t_eofc;		/* end-of-file */
	char	t_brkc;		/* input delimiter (like nl) */
};
struct ltchars {
	char	t_suspc;	/* stop process signal */
	char	t_dsuspc;	/* delayed stop process signal */
	char	t_rprntc;	/* reprint line */
	char	t_flushc;	/* flush output (toggles) */
	char	t_werasc;	/* word erase */
	char	t_lnextc;	/* literal next character */
};
struct ttypagestat {
	int	tps_length;	/* screen length (vertical) */
	int	tps_lpos;	/* current vertical position */
	char	tps_statc;	/* show system status info */
	char	tps_pagec;	/* show next screenful */
	char	tps_pgoffc;	/* ignore paging till next input */
	char	tps_flag;	/* page the screen even in cbreak */
};

#ifdef _MBCS
/*
 * define a codeset structure template
 */
struct tcset {
	u_short		tdc_len;   /* length of table to be read/written */
	charlen_t 	tdc_codeset[CODESIZE];
};
#endif /* _MBCS */

/*
	Default control characters:
	Some of these defaults are duplicated in termio.h, namely,
	CUNDEF, CINTR, CQUIT, CEOF, CSTART, and CSTOP.  If you change any of
	these (I really doubt that anyone will want to...), make sure
	that termio.h gets exact duplicates, otherwise cpp will complain
	about multiple definitions whenever we compile the kernel.
*/
#define	CTRL(c)	('c'&037)
#define CUNDEF	0377
#define	CINTR	0177	/* DEL */
#define	CQUIT	026	/* cntl v */
#define	CEOF	04	/* cntl d */
#define	CSTART	021	/* cntl q */
#define	CSTOP	023	/* cntl s */
#define	CEOT	CEOF
#define	CBRK	CUNDEF
#define	CSUSP	CTRL(z)
#define	CDSUSP	CTRL(y)
#define	CRPRNT	CTRL(r)
#define	CFLUSH	CTRL(o)
#define	CWERASE	CTRL(w)
#define	CLNEXT	CUNDEF
#define	CSTAT	CTRL(t)
#define	CPAGE	(' ')
#define	CPGOFF	CTRL(m)

/*	disk partition stuff	*/
struct	dkpart {
	long	dk_numblks;	/* number of sectors in partition */
	long	dk_cyloff;	/* cylinder where partition starts */
};

/*	disk partition table ioctl commands	*/
#define	DKGETPART	_IOR(d, 0, struct dkpart) /* get disk partition entry */
#define	DKSETPART	_IOW(d, 1, struct dkpart) /* set disk partition entry */

#endif /* ! _POSIX_SOURCE */

/*
**	Ioctl commands:
*/
/* Window/terminal size structure.
 * This information is stored by the kernel
 * in order to provide a consistent interface,
 * but is not used by the kernel.
 *
 * Type are "unsigned short" so that types.h not required.
 */

#ifdef _POSIX_SOURCE
struct _Winsize 
#else
struct winsize 
#endif
{
	unsigned short	ws_row;			/* rows, in characters */
	unsigned short	ws_col;			/* columns, in characters */
	unsigned short	ws_xpixel;		/* horizontal size, pixels */
	unsigned short	ws_ypixel;		/* vertical size, pixels */
};

#ifndef _POSIX_SOURCE
/*
 * Pun for SUN.
 */
struct ttysize {
	unsigned short	ts_lines;
	unsigned short	ts_cols;
	unsigned short	ts_xxx;
	unsigned short	ts_yyy;
};
#define TIOCGSIZE	TIOCGWINSZ
#define TIOCSSIZE	TIOCSWINSZ

#ifndef NO_AUSTIN_HOOKS
/* ******************************* AUSTIN HOOK ************************ */
struct hfscreen	{
	unsigned short screen[25][80];
	};
struct hfcurpos {
	unsigned short row;
	unsigned short column;
	};

/* subcodes for HFSKEP ioctl	*/
#define KEPOPEN		0x01
#define KEPCLOSE	0x02
#define KEPIOCTL	0x03
#define KEPREAD		0x04
#define KEPWRITE	0x05
#define KEPRDSLP	0x06
/* ******************************************************************** */
#endif

/*	file control ioctl commands	*/
#define FIOCLEX		_ION(f, 1)		/* set exclusive use on fd */
#define FIONCLEX	_ION(f, 2)		/* remove exclusive use */
#define FIOGETOWN	_IOR(f, 123, int)	/* 4.2: get owner */
#define FIOSETOWN	_IOW(f, 124, int)	/* 4.2: set owner */
#define FIOASYNC	_IOW(f, 125, int)	/* 4.2: set/clr async i/o */
#define FIONBIO		_IOW(f, 126, int)	/* 4.2: set/clr non-blk i/o */
#define FIONREAD	_IOR(f, 127, long)	/* get # bytes to read */

/*	tty ioctl commands	*/
#define TIOCGETD	_IOR(t, 0, int)		/* get line discipline */
#define TIOCSETD	_IOW(t, 1, int)		/* set line discipline */
#define TIOCHPCL	_ION(t, 2)		/* hang up on last close */
#define TIOCMODG	_IOR(t, 3, int)		/* get modem control state */
#define TIOCMODS	_IOW(t, 4, int)		/* set modem control state */
#define		TIOCM_LE	0001		/* line enable */
#define		TIOCM_DTR	0002		/* data terminal ready */
#define		TIOCM_RTS	0004		/* request to send */
#define		TIOCM_ST	0010		/* secondary transmit */
#define		TIOCM_SR	0020		/* secondary receive */
#define		TIOCM_CTS	0040		/* clear to send */
#define		TIOCM_CAR	0100		/* carrier detect */
#define		TIOCM_RNG	0200		/* ring */
#define		TIOCM_DSR	0400		/* data set ready */
#define		TIOCM_RI	TIOCM_RNG	/* ring (alternate) */
#define		TIOCM_CD	TIOCM_CAR	/* carrier detect (alternate) */
#define TIOCGETP	_IOR(t, 8, struct sgttyb) /* get params -- gtty */
#define TIOCSETP	_IOW(t, 9, struct sgttyb) /* set params -- stty */
#define TIOCSETN	_IOW(t, 10, struct sgttyb) /* set, but no flushtty */
#define TIOCOSM   	_IOR(t, 11, int)	/* osm logging allowed */
#define TIOCNOSM  	_IOR(t, 12, int)	/* osm logging disallowed */
#define TIOCEXCL	_ION(t, 13)		/* set exclusive use of tty */
#define TIOCNXCL	_ION(t, 14)		/* reset exclusive use of tty */
#define TIOCFLUSH	_IOW(t, 16, int)	/* flush buffers */
#define TIOCSETC	_IOW(t, 17, struct tchars) /* set special chars */
#define TIOCGETC	_IOR(t, 18, struct tchars) /* get special chars */

#ifdef _MBCS
#define	TIOCSCLTBL	0x00007417		/* _IOW(t, 23)
						    set codeset info. */
#define	TIOCGCLTBL	0x00007418		/* _IOR(t, 24
						    get codeset info. */
#endif /* _MBCS */

#if defined(_BSD) && !defined(KERNEL)
#define		CRTBS		0x00010000	/* do backspacing for crt */
#define		PRTERA		0x00020000	/* \ ... / erase */
#define		CRTERA		0x00040000	/* " \b " to wipe out char */
#define		TILDE		0x00080000	/* hazeltine tilde kludge */
#define		MDMBUF		0x00100000	/* start/stop output on carrier intr */
#define		LITOUT		0x00200000	/* literal output */
#define		TOSTOP		0x00400000	/* SIGSTOP on background output */
#define		FLUSHO		0x00800000	/* flush output to terminal */
#define		NOHANG		0x01000000	/* no SIGHUP on carrier drop */
#define		L001000		0x02000000
#define		CRTKIL		0x04000000	/* kill line with " \b " */
#define		PASS8		0x08000000
#define		CTLECH		0x10000000	/* echo control chars as ^X */
#define		PENDIN		0x20000000	/* tp->t_rawq needs reread */
#define		DECCTQ		0x40000000	/* only ^Q starts after ^S */
#define		NOFLSH		0x80000000	/* no output flush on signal */
#endif /* _BSD && !KERNEL */

#define TIOCLBIS	_IOW(t, 127, int)	/* bis local mode bits */
#define TIOCLBIC	_IOW(t, 126, int)	/* bic local mode bits */
#define TIOCLSET	_IOW(t, 125, int)	/* set entire local mode word */
#define TIOCLGET	_IOR(t, 124, int)	/* get local modes */
#define TIOCSBRK	_ION(t, 123)		/* set break bit */
#define TIOCCBRK	_ION(t, 122)		/* clear break bit */
#define TIOCSDTR	_ION(t, 121)		/* set data terminal ready */
#define TIOCCDTR	_ION(t, 120)		/* clear data terminal ready */
#define TIOCGPGRP	_IOR(t, 119, long)	/* get pgrp of tty */
#define TIOCSPGRP	_IOW(t, 118, long)	/* set pgrp of tty */
#define TIOCSLTC	_IOW(t, 117, struct ltchars) /* set bsd special chars */
#define TIOCGLTC	_IOR(t, 116, struct ltchars) /* get bsd special chars */
#define TIOCOUTQ	_IOR(t, 115, int)	/* output queue size */
#define TIOCSTI		_IOW(t, 114, char)	/* simulate terminal input */
#define TIOCNOTTY	_ION(t, 113)		/* void tty association */
#define TIOCPKT		_IOW(t, 112, int)	/* 4.2: pty: set/clr pkt mode */
#define		TIOCPKT_DATA		0x00	/* data packet */
#define		TIOCPKT_FLUSHREAD	0x01	/* flush packet */
#define		TIOCPKT_FLUSHWRITE	0x02	/* flush packet */
#define		TIOCPKT_STOP		0x04	/* stop output */
#define		TIOCPKT_START		0x08	/* start output */
#define		TIOCPKT_NOSTOP		0x10	/* no more ^S, ^Q */
#define		TIOCPKT_DOSTOP		0x20	/* now do ^S ^Q */
#define TIOCSTOP	_ION(t, 111)		/* 4.2: stop output, like ^S */
#define TIOCSTART	_ION(t, 110)		/* 4.2: start output, like ^Q */
#define TIOCMSET	_IOW(t, 109, int)	/* set all modem bits */
#define TIOCMBIS	_IOW(t, 108, int)	/* bis modem bits */
#define TIOCMBIC	_IOW(t, 107, int)	/* bic modem bits */
#define TIOCMGET	_IOR(t, 106, int)	/* get all modem bits */
#define TIOCREMOTE	_IOW(t, 105, int)	/* 4.2: remote input editing */

#ifdef _POSIX_SOURCE
#define TIOCGWINSZ      _IOR(t, 104, struct _Winsize)    /* get window size */
#define TIOCSWINSZ      _IOW(t, 103, struct _Winsize)    /* set window size */
#else
#define TIOCGWINSZ      _IOR(t, 104, struct winsize)    /* get window size */
#define TIOCSWINSZ      _IOW(t, 103, struct winsize)    /* set window size */
#endif

#define TIOCUCNTL	_IOW(t, 102, int)	/* pty set/clr usr cntrl mode */
#define		UIOCCMD(n)	_IO(u, n)		/* usr cntl op "n" */

#define TIOCRESET	_ION(t, 101)		/* LCC: reset tty structure */
#define TIOCSCONS	_ION(t, 104)		/* 4.2: Select console line */
#define TIOCGPAGE	_IOR(t, 64, struct ttypagestat)	/* get page/stat info */
#define TIOCSPAGE	_IOW(t, 65, struct ttypagestat)	/* set page/stat info */

#define BBNTTNO		(('b'<<8)|1)		/* rfg:bbn tty empty? */

#define	OTTYDISC	0		/* old, v7 std tty driver */
#define	NETLDISC	1		/* line discip for berk net */
#define	NTTYDISC	2		/* new tty discipline */

/* SPECIAL BSD/SYSV MERGE IOCTL COMMANDS */
/* the following two values are reserved and noted as such in termio.h */
#define TCSETPSX   (TIOC|36)
#define TCGETPSX   (TIOC|37)

/*
 *	Additional tty mode flags for 4.[12] bsd
 */
#define	LCRTBS	0000001		/* correct backspacing for crt */
#define	LPRTERA 0000002		/* printing terminal \ ... / erase */
#define	LCRTERA	0000004		/* do "\b \b" to wipe out character */
#define	LTILDE	0000010		/* IIASA - hazeltine tilde kludge */
#define	LMDMBUF	0000020		/* IIASA - start/stop output on carrier intr */
#define	LLITOUT	0000040		/* IIASA - suppress any output translations */
#define	LTOSTOP	0000100		/* send stop for any background tty output */
#define	LFLUSHO	0000200		/* flush output sent to terminal */
#define	LNOHANG 0000400		/* IIASA - don't send hangup on carrier drop */
#define	LETXACK 0001000		/* IIASA - diablo style buffer hacking */
#define	LCRTKIL	0002000		/* erase whole line on kill with "\b \b" */
#define	LPASS8  0004000		/* allow all 8 bits to pass through on input */ 
#define	LCTLECH	0010000		/* echo control characters as ^X */
#define	LPENDIN	0020000		/* tp->t_rawq is waiting to be reread */
#define	LDECCTQ 0040000		/* only ^Q starts after ^S */
#define	LNOFLSH 0100000		/* disable flush after signal */

#define		uclaltchars	ttypagestat
#define		ut_length	tps_length
#define		ut_lpos		tps_lpos
#define		ut_statc	tps_statc
#define		ut_pagec	tps_pagec
#define		ut_npagec	tps_pgoffc
#define		ut_pgcbrk	tps_flag
#define		TIOGUCLA	TIOCGPAGE
#define		TIOSUCLA	TIOCSPAGE

/*
 *	Additional flags for terminal paging
 */
#define PGCBRK		0001	/* enable page-stop even in cbreak mode */
#define PGBELL		0002	/* ring bell on full page stop */
#define ERASBELL 	0004	/* ring bell on attempted erase-past-prompt */
/*	State bits don't really belong here, but shucks ....	*/
#define PAGESTOP	0010	/* state bit: tty is stopped on a full page */
#define PG0LPOS		0020	/* state bit: last page-start set t_lpos = 0 */
#define PG_ENB		0040	/* paging enabled (if length is also > 0) */

/*
 * General device I/O controls
 */
#define DIOCONLINE	_ION(D, 0)		/* turn device on-line */
#define DIOCOFFLINE	_ION(D, 1)		/* turn device off-line */
#define DIOCRESET	_ION(D, 2)		/* reset the device */
#ifdef b370
/*
 * 370 device I/O controls
 */
#define DEVADDR		_ION(D, 100)		/* virtual address of this device */
#endif /* b370 */

/*
 * osm device I/O controls
 */
#define OSMIOC_WRITE_ON	_ION(O, 0)		/* include console writes */
#define OSMIOC_WRITE_OFF _ION(O, 1)		/* exclude console writes */
#define OSMIOC_ECHO_ON	_ION(O, 2)		/* include input echoes */
#define OSMIOC_ECHO_OFF _ION(O, 3)		/* exclude input echoes */

/* socket i/o controls */
#define SIOCSHIWAT	_IOW(s,  0, int)		/* set high watermark */
#define SIOCGHIWAT	_IOR(s,  1, int)		/* get high watermark */
#define SIOCSLOWAT	_IOW(s,  2, int)		/* set low watermark */
#define SIOCGLOWAT	_IOR(s,  3, int)		/* get low watermark */
#define SIOCATMARK	_IOR(s,  7, int)		/* at oob mark? */
#define SIOCSPGRP	_IOW(s,  8, int)		/* set process group */
#define SIOCGPGRP	_IOR(s,  9, int)		/* get process group */

#define SIOCADDRT	_IOW(r, 10, struct rtentry)	/* add route */
#define SIOCDELRT	_IOW(r, 11, struct rtentry)	/* delete route */

#define SIOCSIFADDR	_IOW(i, 12, struct ifreq)	/* set ifnet address */
#define SIOCGIFADDR	_IOWR(i,13, struct ifreq)	/* get ifnet address */
#define SIOCSIFDSTADDR	_IOW(i, 14, struct ifreq)	/* set p-p address */
#define SIOCGIFDSTADDR	_IOWR(i,15, struct ifreq)	/* get p-p address */
#define SIOCSIFFLAGS	_IOW(i, 16, struct ifreq)	/* set ifnet flags */
#define SIOCGIFFLAGS	_IOWR(i,17, struct ifreq)	/* get ifnet flags */
#define SIOCGIFBRDADDR	_IOWR(i,18, struct ifreq)	/* get broadcast addr */
#define SIOCSIFBRDADDR	_IOW(i,19, struct ifreq)	/* set broadcast addr */
#define SIOCGIFCONF	_IOWR(i,20, struct ifconf)	/* get ifnet list */
#define SIOCGIFNETMASK	_IOWR(i,21, struct ifreq)	/* get net addr mask */
#define SIOCSIFNETMASK	_IOW(i,22, struct ifreq)	/* set net addr mask */
#define SIOCGIFMETRIC	_IOWR(i,23, struct ifreq)	/* get IF metric */
#define SIOCSIFMETRIC	_IOW(i,24, struct ifreq)	/* set IF metric */
#define SIOCGIFMTU	_IOWR(i,25, struct ifreq)	/* get IF mtu */
#define SIOCSIFMTU	_IOW(i,26, struct ifreq)	/* set IF mtu */
#define SIOCGIFREMMTU	_IOWR(i,27, struct ifreq)	/* get IF remmtu */
#define SIOCSIFREMMTU	_IOW(i,28, struct ifreq)	/* set IF remmtu */

#define SIOCSARP	_IOW(i, 30, struct arpreq)	/* set arp entry */
#define SIOCGARP	_IOWR(i,31, struct arpreq)	/* get arp entry */
#define SIOCDARP	_IOW(i, 32, struct arpreq)	/* delete arp entry */
#define SIOCSIFIUCV	_IOW(i, 33, struct ifreq)	/* set iucv state */
#define SIOCGIFIUCV	_IOWR(i,34, struct ifreq)	/* get iucv state */
#define	SIOCSARP_802_5	_IOW(i, 93, struct ie5_arpreq)	/* set arp entry */
#define	SIOCGARP_802_5	_IOWR(i,94, struct ie5_arpreq)	/* get arp entry */
#define	SIOCDARP_802_5	_IOW(i, 95, struct ie5_arpreq)	/* delete arp entry */
#define	IOCTYPE		0xff00
#define IOCINFO 	0xff01
#define IOCCONFIG	0xff02
#define IOCSTATS	0xff03

#ifdef b370
#define HDIORST		_ION(F,75)	/* reset driver (re-read vtoc) */
#define HDIOPAR		_ION(F,76)	/* get drive information (fba_dev) */
#endif

#ifdef	i386
/* Floppy/Micro diskette control */
#define FDIO	('F' << 8)
#define FDFMTON		(FDIO|1)	/* formatting on */
#define FDFMTOFF	(FDIO|2)	/* formatting off */
#define FDVERIFY	(FDIO|3)	/* enable last byte read back verify */
#define FDNOVERIFY	(FDIO|4)	/* disable last byte read back verify */

/* Hard disk control */
#define HDIO	('H' << 8)
#define HDIORST	(HDIO|1)	/* hard disk reset */
#define HDIOPAR	(HDIO|2)	/* hard disk parameters */
#define HDIOSTAT     (HDIO|9)	/* hard disk partition open status */
#define HDSETERRSCAN (HDIO|10)	/* set "scanning for errors" mode */
#define HDCLRERRSCAN (HDIO|11)	/* clear "scanning for errors" mode */
#define HDNUMDISKS _IOR(H,12,int) /* get the max number of disks supported */

#include <sys/i386/crtioctl.h>	/* CRT related ioctls in their own module */

#endif	/* i386 */
#endif /* !_POSIX_SOURCE */

#ifdef i386
/* ioctl commmands for posdev driver */
#define PIOCMACHINFO _IOR(p,0,struct mach_info)	
#endif /* i386 */
	int ioctl(int, int, ...);
#endif /* ~_H_IOCTL */
#ifdef __cplusplus
}
#endif
