#ifdef __cplusplus
extern "C" {
/* (MRL) USL had prototypes for 'msgget, semget, shmget, and ftok.  I have not 
	included them */

#endif
/*
 *		IX/370
 *		5667-126
 *	LICENSED MATERIALS - PROPERTY OF IBM
*	(c) Copyright 1985, 1986, 1989 IBM Corp.
*	(c) Copyright 1983, 1984, 1985, 1986,  1989 Locus Computing Corporation
 *	All Rights Reserved
 */

#ifndef H_SCCSID
#include <sccs.h>
#endif /* ~H_SCCSID */
H_SCCSID(@(#)ipc.h	16.6	AIX)	/* Modified: 18:19:35 9/22/89 */

#ifndef _h_IPC
#define _h_IPC

#ifndef _h_TYPES
#ifdef  KERNEL
#include <types.h>
#else  /* ~KERNEL */
#include <sys/types.h>
#endif /* ~KERNEL */
#endif  /* _h_TYPES */

/* Common IPC Access Structure */
struct ipc_perm {
	ushort	uid;	/* owner's user id */
	ushort	gid;	/* owner's group id */
	ushort	cuid;	/* creator's user id */
	ushort	cgid;	/* creator's group id */
	ushort	mode;	/* access modes */
	ushort	seq;	/* slot usage sequence number */
	key_t	key;	/* key */
};

/* Common ipc_perm mode definitions. */
#define	IPC_ALLOC	0100000		/* entry currently allocated */
#define IPC_TYPEDEP	0007000		/* for msg,sem,shm dependent defs */
#define IPC_PERMS	0000777		/* permission mode bits */

/* Common IPC operation flag definitions. */
#define	IPC_CREAT	0001000		/* create entry if key doesn't exist */
#define	IPC_EXCL	0002000		/* fail if key exists */
#define	IPC_NOWAIT	0004000		/* error if request must wait */

/* Keys. */
#define	IPC_PRIVATE	(key_t)0	/* private key */

/* Control Commands. */
#define	IPC_RMID	0	/* remove identifier */
#define	IPC_SET		1	/* set options */
#define	IPC_STAT	2	/* get options */

#endif /* ~_IPC_ */
#ifdef __cplusplus
}
#endif
