#ifdef __cplusplus
extern "C" {
#endif
/*
 *		IX/370
 *		5667-126
 *	LICENSED MATERIALS - PROPERTY OF IBM
*	(c) Copyright 1985, 1986, 1989 IBM Corp.
*	(c) Copyright 1983, 1984, 1985, 1986, 1989 Locus Computing Corporation
 *	All Rights Reserved
 */

#ifndef H_SCCSID
#include <sccs.h>
#endif /* ~H_SCCSID */
H_SCCSID(@(#)sem.h	16.3	LCC)	/* Modified: 19:03:51 9/16/89 */

#ifndef _h_SEM
#define _h_SEM

/*
	IPC Semaphore Facility.
*/

#ifndef _h_IPC
#ifdef  KERNEL
#include <ipc.h>
#else  /* ~KERNEL */
#include <sys/ipc.h>
#endif /* ~KERNEL */
#endif /* ~_h_IPC */

/*
	Implementation Constants.
*/

#define	PSEMN	(PZERO + 3)	/* sleep priority waiting for greater value */
#define	PSEMZ	(PZERO + 2)	/* sleep priority waiting for zero */

/*
	Permission Definitions.
*/

#define	SEM_A	0200	/* alter permission */
#define	SEM_R	0400	/* read permission */

/*
	Semaphore Operation Flags.
*/

#define	SEM_UNDO	010000	/* set up adjust on exit entry */
#define SEM_ORDER	020000  /* perfore operations non-atomically */
#define SEM_ERR		040000  /* set if error encountered on semop */

/*
	Semctl Command Definitions.
*/

#define	GETNCNT	3	/* get semncnt */
#define	GETPID	4	/* get sempid */
#define	GETVAL	5	/* get semval */
#define	GETALL	6	/* get all semval's */
#define	GETZCNT	7	/* get semzcnt */
#define	SETVAL	8	/* set semval */
#define	SETALL	9	/* set all semval's */

/*
	Structure Definitions.
*/

/*
	There is one semaphore structure for each semaphore in the system.
*/

struct sem {
	pid_t	sempid;		/* pid of last operation */
	ushort	semval;		/* semaphore text map address */
	ushort	semncnt;	/* # awaiting semval > cval */
	ushort	semzcnt;	/* # awaiting semval = 0 */
};


/*
	There is one semaphore id data structure for each set of semaphores
		in the system.
*/
struct semid_ds {
	struct ipc_perm	sem_perm;	/* operation permission struct */
	struct sem 	*sem_base;	/* ptr to first semaphore in set */
	ushort		sem_nsems;	/* # of semaphores in set */
	time_t		sem_otime;	/* last semop time */
	time_t		sem_ctime;	/* last change time */
};

#define SEMAVAIL	(-1)	/* sempid for unallocated semaphores */

/*
	There is one undo structure per process in the system.
*/

struct sem_undo {
	struct sem_undo	*un_np;	/* ptr to next active undo structure */
	short		un_cnt;	/* # of active entries */
	struct undo {
		short	un_aoe;	/* adjust on exit values */
		short	un_num;	/* semaphore # */
		han_t	un_id;	/* semid */
	}	un_ent[1];	/* undo entries (one minimum) */
};

/*
	semaphore information structure
*/
struct	seminfo	{
	int	semmap,		/* # of entries in semaphore map */
		semmni,		/* # of semaphore identifiers */
		semmns,		/* # of semaphores in system */
		semmnu,		/* # of undo structures in system */
		semmsl,		/* max # of semaphores per id */
		semopm,		/* max # of operations per semop call */
		semume,		/* max # of undo entries per process */
		semusz,		/* size in bytes of undo structure */
		semvmx,		/* semaphore maximum value */
		semaem;		/* adjust on exit max value */
};

/*
	User semaphore template for semop system calls.
*/

struct sembuf {
	ushort	sem_num;	/* semaphore # */
	short	sem_op;		/* semaphore operation */
	short	sem_flg;	/* operation flags */
};
#ifdef __cplusplus
        int semget(key_t, int, int);
        int semctl(int, int, int, union semun);
        int semop(int, struct sembuf *, int);
#endif

#endif /* ~_h_SEM */
#ifdef __cplusplus
}
#endif
