#ifdef __cplusplus
extern "C" {
#endif
#ifndef _POSIX_SOURCE
#ifndef H_SCCSID
#include <sccs.h>
#endif /* ! H_SCCSID */
H_SCCSID(@(#)signal.h	16.21	AIX)	/* Modified 6/26/91 21:47:02 */
#endif /* NOT _POSIX_SOURCE */
/*
* 5713-AEQ COPYRIGHT IBM CORP 1989
* LICENSED MATERIAL - PROGRAM PROPERTY OF IBM
*/


#ifndef _H_SIGNAL  /* else we've already been included */
#define _H_SIGNAL

#include <sys/scontext.h>

/**********************************************************************
  SIGNAL NUMBERS
**********************************************************************/

#ifndef _POSIX_SOURCE
#define NSIG _NSIG
#endif /* ! _POSIX_SOURCE */

#define SIGHUP	1	/* hangup */
#define SIGINT	2	/* interrupt (probably user typed intr key) */
#define SIGQUIT	3	/* quit */
#define SIGILL	4	/* illegal instruction */
#define SIGTRAP	5	/* trace trap */

#ifndef _POSIX_SOURCE
#define SIGIOT	6	/* IOT instruction */
#endif	/* NOT _POSIX_SOURCE */

#define SIGABRT	6	/* used by abort, replacing old IOT in the future */
#define SIGEMT	7	/* EMT instruction */
#define SIGFPE	8	/* floating point exception */
#define SIGKILL	9	/* kill (may not be caught, blocked, or ignored) */
#define SIGBUS	10	/* bus error */
#define SIGSEGV	11	/* segmentation violation (bad access to data) */
#define SIGSYS	12	/* bad argument to system call */
#define SIGPIPE	13	/* write on a pipe with no one to read it */
#define SIGALRM	14	/* alarm clock */
#define SIGTERM	15	/* software termination signal */
/* signal 16 is also used by BSD in the vtrace system call */
#define SIGURG	16	/* urgent condition on IO channel */
#define SIGSTOP	17	/* stop (may not be caught, blocked, or ignored) */
#define SIGTSTP	18	/* interactive stop signal from TTY */
#define SIGCONT	19	/* continue if stopped (may not be ignored) */
#define SIGCHLD	20	/* A child has stopped or exited */

#ifndef _POSIX_SOURCE
#define SIGCLD	20	/* death of a child, Sys V style */
#endif	/* NOT _POSIX_SOURCE */

#define SIGTTIN	21	/* Read of control TTY attempted from background */
#define SIGTTOU	22	/* Write to control TTY attempted from background */
#define SIGIO	23	/* input/output possible or complete */

#ifndef _POSIX_SOURCE
#define SIGPOLL	SIGIO	/* selectable event pending (like SIGIO) */
#endif	/* NOT _POSIX_SOURCE */

#define SIGXCPU	24	/* exceeded CPU time limit */
#define SIGXFSZ	25	/* exceeded file size limit */

/* signal 26 reserved */

#define SIGMSG	27	/* HFT input data pending */
#define SIGWINCH 28	/* window size change */
#define SIGPWR	29	/* power failure imminent (save your data) */
#define SIGUSR1	30	/* user defined signal 1 */
#define SIGUSR2	31	/* user defined signal 2 */
#define SIGPROF	32	/* profiling time alarm */
#define SIGDANGER 33	/* system crash imminent */
#define SIGVTALRM 34	/* virtual time alarm */
#define SIGMIGRATE 35	/* migrate process to another CPU */
#define SIGPRE	36	/* programming error */

/* signals 37-59 reserved */

#define SIGGRANT 60	/* HFT monitor mode granted */
#define SIGRETRACT 61	/* HFT monitor mode retracted */
#define SIGSOUND 62	/* HFT sound sequence has completed */

/* signal 63 reserved */

#ifndef _POSIX_SOURCE
#define SIGAIO SIGIO	/* compatibility */
#define SIGIOINT SIGIO
#define SIGPTY SIGIO
#endif	/* NOT _POSIX_SOURCE */

/**********************************************************************
  COMPATIBILITY ASSISTANCE
**********************************************************************/


#if defined(_BSD) || defined(__RT) || defined(_KERNEL)
#define __SIGVOID int
#else /* new AIX */
#define __SIGVOID void
#endif	/* _BSD or __RT or _KERNEL */


/**********************************************************************
  SIGACTION STUFF
**********************************************************************/

#ifndef _POSIX_SOURCE
#define	SIGSETSZ	_SIGSETSZ
#endif

struct sigaction {		/* signal handlers are specified thus */
	__SIGVOID (*sa_handler)();
	int sa_flags;
	sigset_t sa_mask;
};


#ifndef _POSIX_SOURCE
				/*=== flag bits for sa_flags ===*/
#define SA_ONSTACK	0x1	/* handle signal on alternate stack */
#define SA_OLDSTYLE	0x2	/* reset handler, don't block while handling */
#define SA_RESTART	0x4	/* restart slow syscalls interrupted by sig */

#endif /* NOT _POSIX_SOURCE */


#define SA_NOCLDSTOP	0x8	/* receive SIGCLD only upon a child's death */
				/*=== sigprocmask() operation codes ===*/
#ifndef _POSIX_SOURCE
#define SA_SIGSETSTYLE 	0x80	/* for the SVR3 compatibility */
#endif /* NOT _POSIX_SOURCE */

#define SIG_BLOCK	0	/* add given signals to list of those blocked */
#define SIG_UNBLOCK	1	/* remove given signals from blocked list */
#define SIG_SETMASK	2	/* block (prevent delivery of) given signals */

#define SIG_ERR ((__SIGVOID(*)())-1)    /* error from signal() */
#define SIG_DFL ((__SIGVOID (*)())0)	/* default action */
#define SIG_IGN ((__SIGVOID (*)())1)	/* ignore signal */

#ifndef _POSIX_SOURCE
#define BADSIG  SIG_ERR
#endif /* NOT _POSIX_SOURCE */

#ifndef _KERNEL   /* ::::::::::::::::::::::::::::::::::::::::::::::::::: */
extern int sigaction(int, struct sigaction*, struct sigaction*), 
	sigprocmask(int, const sigset_t*, sigset*), 
	sigsuspend(sigset_t*);
extern int sigemptyset(sigset_t*), 
	sigaddset(sigset_t*, int), 
	sigdelset(sigset_t*, int), 
	sigfillset(sigset_t*);
extern int sigismember(sigset_t*, int), 
	sigpending(sigset_t*), 
	kill(int, int);


#ifndef _POSIX_SOURCE
extern int sigstack(struct sigstack*, struct sigstack*), 
	sigreturn(); /* applications shouldn't use sigreturn() */

#define siginitset sigemptyset	/* grunt */

#define SV_INTERRUPT 0x800   /* used by bsd compatibility routines */
#define SV_ONSTACK SA_ONSTACK

#define SIG_STK  SA_ONSTACK
#define SIG_STD  SA_OLDSTYLE	/* RT compatible */
#define sv_onstack sv_flags	/* ditto */


struct sigvec {
	__SIGVOID (*sv_handler)();  /* handler routine */
	int sv_mask;          /* mask while in handler */
	int sv_flags;         /* control flags #defined above */
};


extern int sigvec(int, struct sigvec*);        /* BSD/RT compatible sigvec() */
extern int sigblock(int);      /* BSD/RT compatible sigblock() */
extern int sigsetmask(int);    /* BSD/RT compatible sigsetmask() */
extern int sigpause(int);      /* BSD/RT compatible sigpause() */

extern void (*sigset(int, void(*)()))();/* SVR3 compatible sigset() */
extern int sighold(int);     /* SVR3 compatible sighold() */
extern int sigrelse(int);    /* SVR3 compatible sigrelse() */
extern int sigignore(int);   /* SVR3 compatible sigignore() */
extern void SIG_HOLD(); /* special placeholding library routine used
                           when blocking a signal in SVR3 compatible way */

extern __SIGVOID (*signal(int,void(*)()))();   /* BSD or SVR3 compatability interface */

extern int siginterrupt(int, int);  /* BSD43 compatible siginterrupt() */


#define sigmask(m)  (1L << ((m)-1))  /* signal number --> mask for sigblock */

#endif /* NOT _POSIX_SOURCE */

#endif /* NOT _KERNEL ::::::::::::::::::::::::::::::::::::::::::::::::::::: */

/**********************************************************************
  SIGNAL STACK AND HANDLER CONTEXT INFO
**********************************************************************/

/* Structure used in sigstack call.
 */
#ifndef _POSIX_SOURCE
struct	sigstack {
	char	*ss_sp;			/* signal stack pointer */
	int	ss_onstack;		/* current status */
};
#endif /* NOT _POSIX_SOURCE */


#ifndef _POSIX_SOURCE
/*
 * This  #define is for programs using the small signal interface
 * they only know about the element sc_mask, and only know about
 * the first 32 signals
 */
#define sc_mask	sc_smask.sigs[0]



typedef	struct ksigmask {	/* used in u struct */
	 unsigned long sigs[SIGSETSZ];
} ksigmask_t;


#ifdef  _KERNEL

#define	SIGNUMMASK	0377		/* to extract pure signal number */
#define SIGSPERLONG	32		/* number of signals represented */
					/* in a non-extended signal mask */

#undef sigmask
#define sigmask(m)  (1L << ((m)-1))     /* signal number --> mask */


/* u struct doesn't store 'setsize' field of sigset_t, just the mask words;
 * so we use this macro to make copying masks in and out of a sigset_t
 * easier.  ksigmask_t is used in the kernel only.
 *
 * (The various xxxSIGINMASK macros cleverly work with both sigset_t's
 * and ksigmask_t's, thanks to a not-entirely-accidental similarity of
 * field names.)
 */
#define MASKPART(x) (*((ksigmask_t*)((x).sigs)))



/***************************** Compatibility stuff soon to disappear... **/

#define xsigmask_t ksigmask_t
#define lowsigs sigs[0]
#define highsigs sigs[1]


struct sigvec {
	__SIGVOID (*sv_handler)();	/* handler routine */
	long sv_mask;		/* mask while in handler */
	int sv_flags;		/* control flags #defined above */
};


typedef struct xsigvec {	/* compatability, will disappear soon */
	__SIGVOID (*xsv_handler)();
	ksigmask_t xsv_mask;
	int xsv_flags;
} xsigvec_t;


extern int signew2old();
extern int masknew2old();
extern int maskold2new();

/**********************************************************************/

#endif /* _KERNEL */


/*
 * Macros for testing if a signal is set in an extended signal mask,
 * setting a signal in an extended signal mask, and clearing a signal
 * from an extended signal mask.  32 signals fit into a single long.
 *
 * These macros should NOT be used in new application code.  Applications
 * should use the siginitset(), sigaddset(), sigdelset(), sigfillset(),
 * and sigismember() functions.
 *
 * These SIGIN macros could be faster, but have been recoded this way to
 * pass through the metaware compiler without engendering silly and annoying
 * diagnostics about negative shift values in code which is never executed
 * and which could be elided at compile time in most cases (constant signal
 * numbers).
 *
 * Later... on the 386 the compiler was generating very prolix, slow
 * code for these macros, so assembly language kernel library support has
 * been added.  Perhaps we'll do this for other machines too.
 */

#if defined(_I386)  /* || others? */

#define SIGISINMASK(mask,sig)  _siginmask(&MASKPART(mask),(sig))
#define SETSIGINMASK(mask,sig)  _addinmask(&MASKPART(mask),(sig))
#define CLEARSIGINMASK(mask,sig)  _delinmask(&MASKPART(mask),(sig))

#else /* no library support */

#define SIGISINMASK(mask, sig) \
		((mask).sigs[(sig) > 32 ? 1 : 0] & \
			sigmask((sig) > 32 ? ((sig) - 32) : (sig)))

#define SETSIGINMASK(mask, sig) { \
	(mask).sigs[(sig) > 32 ? 1 : 0] |= \
		sigmask((sig) > 32 ? (sig)-32 : (sig)); \
}

#define CLEARSIGINMASK(mask, sig) { \
	(mask).sigs[(sig) > 32 ? 1 : 0] &= \
		~sigmask((sig) > 32 ? (sig)-32 : (sig)); \
}

#endif /* _I386 */


#define INITSIGMASK(mask) { \
	(mask).sigs[0] = 0L; \
	(mask).sigs[1] = 0L; \
}

#define ALLSIGMASK(mask) { \
	(mask).sigs[0]= 0xffffffffL; \
	(mask).sigs[1]= 0xffffffffL; \
}

#define COPYSIGMASK(mask1, mask2) { \
	(mask1).sigs[0] = (mask2).sigs[0]; \
	(mask1).sigs[1] = (mask2).sigs[1]; \
}

#define ANDSIGMASK(mask1, mask2) { \
	(mask1).sigs[0] &= (mask2).sigs[0]; \
	(mask1).sigs[1] &= (mask2).sigs[1]; \
}

#define AND3SIGMASK(mask0, mask1, mask2) { \
	(mask0).sigs[0] = (mask1).sigs[0]  & (mask2).sigs[0]; \
	(mask0).sigs[1] = (mask1).sigs[1] & (mask2).sigs[1]; \
}

#define ORSIGMASK(mask1, mask2) { \
	(mask1).sigs[0] |= (mask2).sigs[0]; \
	(mask1).sigs[1] |= (mask2).sigs[1]; \
}

#define OR3SIGMASK(mask0, mask1, mask2) { \
	(mask0).sigs[0] = (mask1).sigs[0]  | (mask2).sigs[0]; \
	(mask0).sigs[1] = (mask1).sigs[1] | (mask2).sigs[1]; \
}

#define ANDNOTSIGMASK(mask1, mask2) { \
	(mask1).sigs[0] &= ~((mask2).sigs[0]); \
	(mask1).sigs[1] &= ~((mask2).sigs[1]); \
}

#endif /* NOT _POSIX_SOURCE */

#endif /* NOT _H_SIGNAL */
#ifdef __cplusplus
}
#endif
