#ifdef __cplusplus
extern "C" {
#endif
/*
 *		AIX/370
 *		5713-AFL
 *	LICENSED MATERIALS - PROPERTY OF IBM
*	(c) Copyright 1985, 1986, 1989 IBM Corp.
*	(c) Copyright 1983, 1984, 1985, 1986,  1989 Locus Computing Corporation
 *	All Rights Reserved
 */


#ifndef _POSIX_SOURCE
#ifndef H_SCCSID
#include <sccs.h>
#endif /* ~H_SCCSID */
H_SCCSID(@(#)types.h	16.15	AIX)	/* Modified: 10/17/90 14:08:10 */
/*H_SCCSIDgen1(@(#)types.afp.h	11.20	AIX)	Modified 11/2/88 19:59:34 */
#endif /* NOT _POSIX_SOURCE */

#ifndef  _H_TYPES
#define  _H_TYPES

#ifndef _POSIX_SOURCE
#include <DOPTIONS.h>
#endif	/* !_POSIX_SOURCE */

/*
 * types.h: Basic system types and major/minor device
 * constructing/busting macros.
 */

typedef	unsigned short	u_short_t;
typedef	unsigned int	u_int_t;
typedef	unsigned long	u_long_t;

#ifndef _POSIX_SOURCE

/* Abbreviations for basic 'C' types with otherwise long names */
typedef	unsigned char	u_char;
typedef	unsigned short	u_short;
typedef	unsigned int	u_int;
typedef	unsigned long	u_long;
typedef int	(*funcp_t)();

/* System 5 compatability constants */
typedef	unsigned short	ushort;
typedef unsigned int	uint;
typedef	unsigned long	ulong;
#endif /* NOT _POSIX_SOURCE */

typedef	long		key_t;		/* SysV IPC keys */
typedef long		han_t;		/* SysV IPC handles */
typedef	unsigned long	vaddr_t;	/* User mode virtual address */
typedef	long		paddr_t;	/* Physical (real) as opposed to */
					/* virtual memory address.	 */

#ifndef _POSIX_SOURCE

/* This really should be "long", not "int".  But doing so would create tons
of extraneous lint output. */
typedef	struct { int r[1]; } *	physadr;

#endif /* ! _POSIX_SOURCE */

/*
 * The largest alignment requirement of all AIX machines.  If
 * sizeof(align_t) != 4 (on some future machines), lots of
 * reorganization may be necessary.
 */
typedef	long	align_t;	/* Type for strictest standard type alignment */

/* Miscellaneous kernel types */
typedef	long	  daddr_t;	/* Disk address */
typedef	char *	  caddr_t;	/* Kernel virtual address (char *) */
// (MRL) typedef	long	  size_t;	/* Number of mem allocation units (clicks) */
typedef	unsigned long	  size_t;	/* Number of mem allocation units (clicks) */
typedef	size_t	  click_t;	/* Number of mem allocation units (clicks) */
typedef	daddr_t	  swblk_t;	/* Swap block */
typedef	long	  time_t;	/* Time in seconds (since Jan. 1, 1970) */
typedef	time_t    clock_t;	/* Time in clock ticks */
typedef	u_long_t  dev_t;	/* Device numbers (major and minor together) */
typedef	long	  off_t;	/* File offset (e.g. for lseek()) */
typedef	long	  pid_t;	/* Process ID */
typedef u_int_t	  bcount_t;	/* Byte count: for buffer I/O (see bio.c) */
typedef	u_long_t  jrtime_t;	/* Microsecond time for journaling */
typedef	long	  igflag_t;	/* Namei/iget flags (flags.h) */
typedef	long	  rmap_t;	/* Counts for resource maps (map.h) */
typedef u_int_t	  spl_t;	/* What spl returns */
typedef long	  gfs_t;	/* Global File System number */
typedef short	  pckno_t;	/* Filesystem pack number */
typedef	short	  cnt_t;	/* Random count type */

/* Inode related types */
typedef	long 	  ino_t;	/* Inode number */
typedef	u_short_t s_ino_t;	/* Short (old) inode number (for conversion) */
typedef long	  ino_uniqid_t;	/* Inode unique identifier */
typedef	short	  islot_t;	/* Kernel Inode table index */
typedef	long	  iflag_t;	/* In-core inode flags */
typedef	short	  dflag_t;	/* Disk inode flags */
typedef	u_long_t  uid_t;	/* User ID */
typedef	u_short_t suid_t;	/* User ID */
typedef	u_long_t  gid_t;	/* Group ID */
typedef	u_short_t sgid_t;	/* Group ID */
typedef	u_long_t  mode_t;	/* File mode (permission) type */
typedef	u_short_t smode_t;	/* File mode (permission) type */
typedef	short	  nlink_t;	/* Number of links to an inode */
typedef long	  commitcnt_t;	/* Commit count */
typedef long	  fstore_t;	/* Fstore */

/* TCF related types */
typedef char	netno_t;	/* AIX TCF network number (netsw index) */
typedef short	siteno_t;	/* AIX TCF cluster site number */
typedef	short	netmap_t;	/* Mask identifying networks available */
typedef	long	sitemap_t;	/* Bit mask for cluster sites */


/* Sitepath support */
typedef u_short_t sitepath_t;	/* Sitepath element */

#ifndef _POSIX_SOURCE

#define SPATH_CPU	0x8000
#define SPATH_MASK	(SPATH_CPU - 1)

#ifdef	b370
typedef	short	ioaddr_t;	/* 370 IO address type */
#ifdef	SVPAGING
typedef u_short_t pgadr_t;
#endif	SVPAGING
#endif	/* b370 */

#if !defined(TRUE) || !defined(FALSE)
/* Define them both if either undefined to guarantee they're consistent */
#define  FALSE	(0)
#define  TRUE	(1)
#endif /* !(TRUE && FALSE) */

#ifdef _MBCS
#define	CODESIZE	256	/* size of character length table */
typedef char 	charlen_t;	/* defined to hold the codeset information to
				   interpret process code multibyte chars */
#ifdef KERNEL
/*
 * Like mblen(), this will return the number of bytes of the first character
 * in the string pointed to by chptr. See <mbcs.h> for more info.
 * Currently, _kmblen() only uses the first byte to index into the chlen_tbl
 * of the character table header, so it cannot detect bogus mbchars where the
 * first byte is a valid part of some character, but the second byte is invalid.
 * Notice that _kmblen has an array (codeset) passed in. This is to accomodate
 * both namei and dir routines, which use codeset info. from user structure and
 * tty routines which use codeset from tty structure.
 */
#define _kmblen(chptr, cset)\
	                (*((unsigned char *)(chptr)) == '\0' ? 0 : \
	                (unsigned)((cset)[*((unsigned char *)(chptr))]) )

/*
 * A macro for copying the codeset information between the user struct
 * (u.u_codeset) and a netmsg.  This should be in a header somewhere!
 */
struct __codeset__	/* Should be thus in user.h! */
{
	charlen_t codeset[CODESIZE];
};
#define	CODESET_COPY(from, to) \
	(*((struct __codeset__ *)(to)) = *((struct __codeset__ *)(from)))

/*
 * macros for initializing codeset information to default values
 */
#ifdef i386
#define CODESET_INIT(dest)\
	memsetlongs((dest), 0x01010101, (CODESIZE>>1)/sizeof(long))
#endif /* i386 */

#ifdef b370
#define CODESET_INIT(dest)\
	bfill((dest), CODESIZE>>1, 0x01)
#endif /* b370 */

#endif /* KERNEL */
#endif /* _MBCS */

/* the NULL value/pointer */
#ifndef NULL
#define NULL		0
#endif

/* major part of a device */
#define	major(x)	((int)(((x)>>16)&0xffff))

/* minor part of a device */
#define	minor(x)	((int)((x)&0xffff))

/* make a device number */
#define	makedev(x,y)	((dev_t)(((long)(x)<<16) | (y)))

/* Load average support */
#ifdef NOFLOATINGPOINT
typedef struct Float { long Flt_val[1]; } float_t;
typedef struct Double { long Dbl_val[2]; } double_t;
typedef u_long_t loadav_t;
#else
typedef	double	double_t;
typedef	float	float_t;
typedef double	loadav_t;
#endif /* NOFLOATINGPOINT */

/*
 * NULLSITE and NOSITE are each illegal site numbers, except that NULLSITE
 * refers to the local site in some network process operations.  NULLSITE
 * is used in most contexts.  NOSITE is used to terminate the site-path list.
 */
#define	NULLSITE	((siteno_t) 0)
#define	NOSITE		((sitepath_t) 127)

#endif /* ! _POSIX_SOURCE */


/* values to be used with getsites(2) */
typedef char	sitestat_t;
#ifndef _POSIX_SOURCE
#define	GS_UP		0x1
#endif /* ! _POSIX_SOURCE */

typedef	int	bool_t;		/* Boolean type: holds TRUE or FALSE */

/* values to be used with getxperm(2) */
typedef char	sitexperm_t;
#ifndef _POSIX_SOURCE
#define	GS_NOPERMISSION	0
#define	GS_PERMISSION	1

/* values to be used with setxuid(2E) */
#define GS_XUID	1
#define GS_XGID	2

#ifdef  u370
#	define  LABEL_SIZE	16	/* Only 14 in use with MW 2.0 CS */
#endif  /* u370 */
#ifdef	i386
#	define  LABEL_SIZE	6
#endif

union  label
{
	int	lb_label[LABEL_SIZE];
#ifdef  REPRESENTATION

#ifdef	u370
	{
		int	lb_r2;
		int	lb_r3;
		int	lb_r4;
		int	lb_r5;
		int	lb_r6;
		int	lb_r7;
		int	lb_r8;
		int	lb_r9;
		int	lb_r10;
		int	lb_r11;
		int	lb_r12;
		int	lb_r13;
		int	lb_r14;
		int	lb_r15;
		int	lb_unused1;
		int	lb_unused2;
	} lb_label_fields;
#endif /* u370 */

#ifdef i386
	{
		int	lb_sp;		/* saved stack pointer	     */
		int	lb_ip;		/* return address	     */
		int	lb_bp;		/* saved bp (frame pointer)  */
		int	lb_si;		/* saved si register	     */
		int	lb_di;		/* saved di register	     */
		int	lb_bx;		/* saved bx register	     */
	} lb_label_fields;
#endif	/* i386 */
#endif /* REPRESENTATION */
};

typedef	union label 	label_t;	/* Save/resume save structure */

#ifndef	FD_SETSIZE
#define	FD_SETSIZE	200
#endif
#ifndef	NBBY
#define	NBBY		8		/* number of bits in a byte */
#endif

typedef long	fd_mask;
#define NFDBITS	(sizeof(fd_mask) * NBBY)	/* bits per mask */
#ifndef howmany
#define	howmany(x, y)	(((x)+((y)-1))/(y))
#endif

typedef	struct fd_set {
	fd_mask	fds_bits[howmany(FD_SETSIZE, NFDBITS)];
} fd_set;

#define	FD_SET(n, p)	((p)->fds_bits[(n)/NFDBITS] |= (1 << ((n) % NFDBITS)))
#define	FD_CLR(n, p)	((p)->fds_bits[(n)/NFDBITS] &= ~(1 << ((n) % NFDBITS)))
#define	FD_ISSET(n, p)	((p)->fds_bits[(n)/NFDBITS] & (1 << ((n) % NFDBITS)))
#define FD_ZERO(p)	bzero((char *)(p), sizeof(*(p)))

#define  roundup(x,y)	((((x)+((y)-1))/(y))*(y))

/*
 * Use these when you really want to shorten a long to int,
 * or int to short
 */
#define	INTCAST(val)	((int)(val))
#define	SHORTCAST(val)	((short)(val))
#define RDEVTODEV(dev)	((dev_t)(dev))	/* actually a noop now */

#ifdef	lint
#define ALIGNCAST(caddr)	aligncast((caddr_t)(caddr))
extern align_t *aligncast();
#else  /* ~lint */
#define ALIGNCAST(caddr)	((align_t *)(caddr))
#endif  /* ~lint */

#if defined(lint) && defined(KERNEL)
/* Have lint detect declarations of the form "register i;" */
#define	register
#endif /* (lint && KERNEL) */


/*
 * A use of the following macro should appear following each
 * declaration of an overlay to the variable portion of the netmsg.
 */
#define CHECKNMVARSIZE(tag, nmvtype) \
	struct tag { char xxnmxx[NMVARSIZE+1-sizeof(struct nmvtype)]; }

#if defined(KERNEL) && !defined(__UNDEF__)
/* Define away near/far keywords if not a 286 */
#define	far	/* */
#define	near	/* */
#endif /* (KERNEL && ~) */

#endif /* ! _POSIX_SOURCE */

#endif  /* ~_H_TYPES */
#ifdef __cplusplus
}
#endif
