#ifdef __cplusplus
extern "C" {
#endif
/*
 *		IX/370
 *		5667-126
 *	LICENSED MATERIALS - PROPERTY OF IBM
 *	(c) Copyright 1985, 1986, 1989 IBM Corp.
 *	(c) Copyright 1983, 1984, 1985, 1986, 1989 Locus Computing Corporation
 *	All Rights Reserved
 */

#ifndef H_SCCSID
#include <sccs.h>
#endif /* ~H_SCCSID */
H_SCCSID(@(#)termio.h	16.12       LCC)    /* Modified: 19:14:23 1/11/90 */

#ifndef	_h_TERMIO
#define	_h_TERMIO

#ifdef i386
#include <sys/ioctl.h>
#endif /* i386 */
#ifdef NLS
#include <sys/ttmap.h> /* for struct tty_map: ioctl arg for TCGMAP/TCSMAP */
#endif

/* USG	termio.h	1.1 */

/*
   WARNING:  There is code in iocpack()/ioctl.c which depends upon
   the value of NCC being 8.  Search for NCC in ioctl.c to find it.
   (randy s.)
*/
#define	NCC	8

#if defined(KERNEL) || !defined(_POSIX_SOURCE)

#ifndef _h_TERMIOS /* include <termios.h> first if you need both */

/* control characters */
#define	VINTR	0
#define	VQUIT	1
#define	VERASE	2
#define	VKILL	3
#define	VEOF	4
#define	VEOL	5
#define	VEOL2	6
#define	VMIN	4
#define	VTIME	5
#define	VSWTCH	7

#endif /* ! _h_TERMIOS */

#endif /* NOT _POSIX_SOURCE */


/*
	Default control characters:
	Some of these defaults are duplicated in ioctl.h, namely,
	CUNDEF, CINTR, CQUIT, and CEOF.  If you change any of
	these (I really doubt that anyone will want to...), make sure
	that ioctl.h gets exact duplicates, otherwise cpp will complain
	about multiple definitions whenever we compile the kernel.
*/

#define	CNUL	0
#define	CDEL	0377

#define CUNDEF	0377
#define CEOL2	0
#define CMIN	1
#define CTIME	0

/* default control chars */

#define CERASE	010	/* cntl h */
#define CKILL	025	/* cntl u */
#define	CINTR	0177	/* DEL */
#define CQUIT	026	/* cntl v */
#define	CSTART	021	/* cntl q */
#define	CSTOP	023	/* cntl s */
#define	CEOF	04	/* cntl d */
#define	CEOL	CUNDEF
#define	CESC	'\\'

#ifdef RTPC_NO_NLS
#define	CQUIT	034	/* FS, cntl | */
#endif /* RTPC_NO_NLS */

#define	CSWTCH	032	/* cntl z */
#define	CNSWTCH	0


/* input modes */
#define	IGNBRK	0000001
#define	BRKINT	0000002
#define	IGNPAR	0000004
#define	PARMRK	0000010
#define	INPCK	0000020
#define	ISTRIP	0000040
#define	INLCR	0000100
#define	IGNCR	0000200
#define	ICRNL	0000400
#define	IUCLC	0001000
#define	IXON	0002000
#define	IXANY	0004000
#define	IXOFF	0010000
#define	ASCEDIT	0020000

/* output modes */
#define	OPOST	0000001
#define	OLCUC	0000002
#define	ONLCR	0000004
#define	OCRNL	0000010
#define	ONOCR	0000020
#define	ONLRET	0000040
#define	OFILL	0000100
#define	OFDEL	0000200
#define	NLDLY	0000400
#define	NL0	0
#define	NL1	0000400
#define	CRDLY	0003000
#define	CR0	0
#define	CR1	0001000
#define	CR2	0002000
#define	CR3	0003000
#define	TABDLY	0014000
#define	TAB0	0
#define	TAB1	0004000
#define	TAB2	0010000
#define	TAB3	0014000
#define	BSDLY	0020000
#define	BS0	0
#define	BS1	0020000
#define	VTDLY	0040000
#define	VT0	0
#define	VT1	0040000
#define	FFDLY	0100000
#define	FF0	0
#define	FF1	0100000


/* control modes */
#define	CBAUD	0000017
#define	B0	0
#define	B50	0000001
#define	B75	0000002
#define	B110	0000003
#define	B134	0000004
#define	B150	0000005
#define	B200	0000006
#define	B300	0000007
#define	B600	0000010
#define	B1200	0000011
#define	B1800	0000012
#define	B2400	0000013
#define	B4800	0000014
#define	B9600	0000015
#define	B19200	0000016
#define	EXTA	0000016
#define	EXTB	0000017
#define	CSIZE	0000060
#define	CS5	0
#define	CS6	0000020
#define	CS7	0000040
#define	CS8	0000060
#define	CSTOPB	0000100
#define	CREAD	0000200
#define	PARENB	0000400
#define	PARODD	0001000
#define	HUPCL	0002000
#define	CLOCAL	0004000
#define	LOBLK	0010000

/* line discipline 0 modes */
#define	ISIG	0000001
#define	ICANON	0000002
#define	XCASE	0000004
#define	ECHO	0000010
#define	ECHOE	0000020
#define	ECHOK	0000040
#define	ECHONL	0000100
#define	NOFLSH	0000200
#define XSCAN	0000400

#ifndef NO_AUSTIN_HOOKS
/* ************************** AUSTIN HOOK ************************** */
#define LTCKEP	0001000	/* AUSTIN HOOK */
/* ***************************************************************** */
#endif

#define SSPEED  13      /* default speed: 13 => 9600 baud */

/*
 * Ioctl control packet
 */
struct termio {
	unsigned short	c_iflag;	/* input modes */
	unsigned short	c_oflag;	/* output modes */
	unsigned short	c_cflag;	/* control modes */
	unsigned short	c_lflag;	/* line discipline modes */
	char	c_line;			/* line discipline */
	unsigned char	c_cc[NCC];	/* control chars */
};

/*
 * TTY(console) logging flags, chai
 */
#define TLOG_ON		01000000	/* terminal logging enabled */
#define TLOG_QID	0400000		/* valid msg id in tl_msgqid */
/*
 * TTY(console) logging, chai
 */
struct tlog {
	int     tl_flags;
	int	tl_msgqid;
};

/*
 *  Structure, defines for setting page length
 */
#define PAGE_SETL    04     /* Set Page Length (Ioctl TCSLEN) */
#define PAGE_MSK     03     /* Paging Ioctl Command Mask (TCSLEN) */
#define PAGE_ON      01     /* Enable Paging (TCSLEN), Paging Enabled (TCGLEN) */
#define PAGE_OFF     02     /* Disable Paging (TCSLEN) */
#ifndef PAGE_ENB
#define PAGE_ENB     PAGE_ON	/* For compatibility with older version */
#endif

struct  tty_page {
	char          tp_flags;
	unsigned char tp_slen;
};

#define	IOCTYPE		0xff00
#define	TIOC	('T'<<8)
#define	TCGETA	(TIOC|1)
#define	TCSETA	(TIOC|2)
#define	TCSETAW	(TIOC|3)
#define	TCSETAF	(TIOC|4)
#define	TCSBRK	(TIOC|5)
#define	TCXONC	(TIOC|6)
#define	TCFLSH	(TIOC|7)
#define TCGLEN  (TIOC|8)
#define TCSLEN  (TIOC|9)
#define TCLOG   (TIOC|10)
#define TCSVEC  (TIOC|12)
#define TCGVEC  (TIOC|13)

#ifdef NLS
#define TCSMAP  (TIOC|14)
#define TCGMAP  (TIOC|15)
#endif

#define TIONREAD (TIOC|16)

#define	TCDSET	(TIOC|32)
#define TCKEP   (TIOC|33)

#define	LDIOC	('D'<<8)
#define	LDOPEN	(LDIOC|0)
#define	LDCLOSE	(LDIOC|1)
#define	LDCHG	(LDIOC|2)
#define	LDGETT	(LDIOC|8)
#define	LDSETT	(LDIOC|9)
#define LDGETDT (LDIOC|10)
#define LDSETDT (LDIOC|11)

#if	defined(u370) /* Start of IX/370 code */
#define U370	('U'<<8)
#define U370TABS	(U370|1)
#define CNIOEMLON   (TIOC|34)
#define CNIOEMLOFF   (TIOC|35)
#endif  /* (u370)	 End of IX/370 code */

/* RESERVED: (TIOC | 36) and (TIOC | 37) */


/*
 * Terminal types
 */
#define	TERM_NONE	0	/* tty */
#define	TERM_TEC	1	/* TEC Scope */
#define	TERM_V61	2	/* DEC VT61 */
#define	TERM_V10	3	/* DEC VT100 */
#define	TERM_TEX	4	/* Tektronix 4023 */
#define	TERM_D40	5	/* TTY Mod 40/1 */
#define	TERM_H45	6	/* Hewlitt-Packard 45 */
#define	TERM_D42	7	/* TTY Mod 40/2B */

/*
 * Terminal flags
 */
#define TM_NONE		0000	/* use default flags */
#define TM_SNL		0001	/* special newline flag */
#define TM_ANL		0002	/* auto newline on column 80 */
#define TM_LCF		0004	/* last col of last row special */
#define TM_CECHO	0010	/* echo terminal cursor control */
#define TM_CINVIS	0020	/* do not send esc seq to user */
#define TM_SET		0200	/* must be on to set/res flags */

/*
 * structure of ioctl arg for LDGETT and LDSETT
 */
struct	termcb	{
	char	st_flgs;	/* term flags */
	char	st_termt;	/* term type */
	char	st_crow;	/* gtty only - current row */
	char	st_ccol;	/* gtty only - current col */
	char	st_vrow;	/* variable row */
	char	st_lrow;	/* last row */
};

/*
 * ioctl arg for TCGETDT/TCSETDT
 */
#define DTBSIZE 128             /* shdb <= TTXOHI */
struct dostmplt {
	char    *dt_tbuf;
	int     dt_tlen;
};

#endif /* ~_h_TERMIO */
#ifdef __cplusplus
}
#endif
