#ifdef __cplusplus
extern "C" {
#endif
#ifndef _POSIX_SOURCE
#ifndef H_SCCSID
#include <sccs.h>
#endif /* ! H_SCCSID */
H_SCCSID(@(#)unistd.h	1.35.1.1	AIX)	/* Modified 6/26/91 21:46:41 */
#endif /* NOT _POSIX_SOURCE */
/* 
* Copyright (C)  1989, Locus Computing Corporation
 * All Rights Reserved
 */ 
/* 
 * (C) Copyright IBM Corp. 1989 
 * All Rights Reserved 
 * Licensed Materials - Property of IBM 
 */
/*
 * 1984 /usr/group Standard
 */

#ifndef _H_UNISTD
#define _H_UNISTD

#include <sys/types.h>
#include <posixcf.h>

/* Symbolic constants for the "access" function: */
#define R_OK 4		/* Test for "Read" Permission */
#define W_OK 2		/* Test for "Write" Permission */
#define X_OK 1		/* Test for "Execute" (Search) Permission */
#define F_OK 0		/* Test for existence of file */

#ifndef _POSIX_SOURCE

/* Symbolic constants for the "lockf" function: */
#define F_ULOCK 0	/* Unlock a previously locked region */
#define F_LOCK  1	/* Lock a region for exclusive use */
#define F_TLOCK 2	/* Test and lock a region for exclusive use */
#define F_TEST  3	/* Test a region for a previous lock */

/* The largest file offset, implied in lockf() call when size = 0 */
#define FCHR_MAX	((off_t)0x7fffffff)

#endif /* ! _POSIX_SOURCE */


/* Symbolic constants for the "lseek" function: */
#define SEEK_SET 0	/* Set file pointer to "offset" */
#define SEEK_CUR 1	/* Set file pointer to current plus "offset" */
#define SEEK_END 2	/* Set file pointer to EOF plus "offset" */


#ifndef _POSIX_SOURCE

/* Path names of the passwd file and group file: */
#define GF_PATH "/etc/group"	/* Path name of the "group" file */
#define PF_PATH "/etc/passwd"	/* Path name of the "passwd" file */
#define IN_PATH "/usr/include"	/* Path name for <...> files */

#define	LOCAL_MAX	30	/* Longest <LOCAL> name, including null */
#define DSPL_BSIZE	1024	/* Bytes in disk block for user interface. */

#endif /* ! _POSIX_SOURCE */

/* Structure for "utime" function: */
struct	utimbuf {
	time_t	actime; 	/* Date and time of last access */
	time_t	modtime;	/* Date and time of last modification */
};

/* other POSIX defines */
#define _POSIX_JOB_CONTROL	1
#define _POSIX_SAVED_IDS	1
#define _POSIX_VERSION		198808L
#define _POSIX_CHOWN_RESTRICTED	1
#define _POSIX_NO_TRUNC		1
#define _POSIX_VDISABLE		-1
#define STDIN_FILENO		0
#define STDOUT_FILENO		1
#define STDERR_FILENO		2

#if !defined(_KERNEL) && defined(_POSIX_SOURCE)
/* POSIX forward declarations */
extern	long	fpathconf(int, int);
extern	long	pathconf(const char*, int);
extern	long	sysconf(int);
extern	unsigned int	alarm(unsigned);
extern	unsigned int	sleep(unsigned);
extern	char	*ctermid(char*);
extern	char	*cuserid(char*);
extern	char	*getcwd(char *, int);
extern	char	*getenv(const char*);
extern	char	*getlogin(void);
extern	char	*ttyname(int);
extern	pid_t	fork(void);
extern	pid_t	getpgrp(int);
extern	pid_t	getpid(void);
extern	pid_t	getppid(void);
extern	pid_t	setsid(void);                   
extern	pid_t	tcgetpgrp(int);                   
extern	gid_t	getegid(void);
extern	gid_t	getgid(void);
extern	uid_t	geteuid(void);
extern	uid_t	getuid(void);
extern	off_t	lseek(int, off_t, int);
extern	void	_exit(int);
#endif /* ! _KERNEL  && _POSIX_SOURCE */

/* AIX defines NULL in <stdio.h> (and in several other locations).  POSIX draft
 * 13 (in section 2.8) specifies that "The symbol NULL shall be declared in
 * <unistd.h>, with the same value as required by the C standard, in addition
 * to the several locations already required by the C Standard".  One could
 * introduce <null.h> to contain the definition of NULL, and then #include
 * <null.h> in each of the several locations, but instead we will just add
 * another #define of NULL and hope that the various definitions are kept
 * identical.
 */

/* WARNING: if you change the definition of NULL, you should change it in
 * several locations (see the above comment for more information).
 */
#ifndef NULL
#define NULL	0
#endif

#endif /* _H_UNISTD */
#ifdef __cplusplus
}
#endif
