#ifdef __cplusplus
extern "C" {
#endif
#ifndef H_SCCSID
#include <sccs.h>
#endif /* ~H_SCCSID */
H_SCCSID(@(#)vrycns.h	1.19	AIX)	/* Modified 7/2/90 23:03:37 */
/* H_SCCSID(@(#)vrycns.h	1.11	LCC)	/* Modified: 10:11:04 9/15/86 */
/* 
 * (C) Copyright IBM Corp. 1989 
 * All Rights Reserved 
 * Licensed Materials - Property of IBM 
 */

/************************************************************************
 *    vrycns: check, if command entered at console			*
 *	 	input: s: silent version				*
 *		output: none						*
 *		returncode: 0 :command entered at console		*
 *			    1: otherwise				*
 *									*
 *	Systemcalls:		strcmp					*
 *				ttyname					*
 *				fprintf					*
 *									*
 *	Description:							*
 * 	Vrycns is called by the operator commands to see, if the	*
 *	command was entered at operator's console.			*
 *	Via ttyname the tty-id of this userid is checked.		*
 ***********************************************************************/

#include <pwd.h>
#include <sys/types.h>
#include <string.h>
#include <stdio.h>
#include <ix370.h>
#define ON 1
#define OFF 0
#define CONSOLE1 "syscon"
#define CONSOLE2 "console"

char *ttyname(int);
char *tp;
int ERROR = OFF;

vrycns (char *silent)
{
	/* check if command is entered at console */
	
	/* stdin == console? */
	if ((tp = ttyname(0)) && 
	    (ttysite(0) == site((pid_t)0)) &&
	    (tp = strrchr(tp,'/')+1) &&
	    (Eq(tp,CONSOLE1) || Eq(tp,CONSOLE2))) {

		ERROR = OFF;
	}

	/* stdout == console? */
	else if ((tp = ttyname(1)) && 
	    (ttysite(1) == site((pid_t)0)) &&
	    (tp = strrchr(tp,'/')+1) &&
	    (Eq(tp,CONSOLE1) || Eq(tp,CONSOLE2))) {

		ERROR = OFF;
	}

	/* stderr == console? */
	else if ((tp = ttyname(2)) && 
	    (ttysite(2) == site((pid_t)0)) &&
	    (tp = strrchr(tp,'/')+1) &&
	    (Eq(tp,CONSOLE1) || Eq(tp,CONSOLE2))) {

		ERROR = OFF;
	}

	else {
		if ( !Eq(silent,"s") ) {
			fprintf (stderr,"%s\n",_M"Sorry, use operator console");
		}
		ERROR = ON;
	}
	return(ERROR);
}
#ifdef __cplusplus
}
#endif
