@echo off
REM Licensed Materials - Property of IBM
REM 5648-F10 (C) Copyright International Business Machines Corp. 2010, 2012
REM All Rights Reserved
REM US Government Users Restricted Rights- Use, duplication or disclosure
REM restricted by GSA ADP Schedule Contract with IBM Corp.

title Preparing to start InitTool

rem Prevent multiple instances.
tasklist | find /I "InitTool.exe" && exit

rem Prevent Windows 2003.
ver | find /I "5.2" && set isWin2003="yes"
if defined isWin2003 (
    echo Windows 2003 is unsupported, please launch InitTool from Windows XP or Windows 7 ...
    pause
    exit
)

rem Go to BAT real executing path
cd /D %~d0%~p0

rem If the executing path is not in the root of a drive, call copyApp directly.
if not %~p0 == \ goto copyApp

rem check usb drive file system is FAT32 or not.
set FileSysType=""
chkdsk | find /I "FAT32" && set FileSysType="FAT32"

if not %FileSysType% == "FAT32" (
    echo The flash drive file system is not FAT32, InitTool can't start on it...
    echo If you are sure this drive is FAT32, try running InitTool as administrator...
    pause
    exit
)

:copyApp
echo Copying application to local disk...

set targetDir=%tmp%\initTool

setlocal enabledelayedexpansion

if exist %targetDir% (
    FOR /F "tokens=2 delims=: " %%i in (.\InitTool\launchpad\content\build.txt) do set usbVer=!usbVer!%%i
    FOR /F "tokens=2 delims=: " %%i in (%targetDir%\launchpad\content\build.txt) do set existingVer=!existingVer!%%i
) else goto clearTgtDir

if %usbVer% == %existingVer% if exist %targetDir%\flashdrivepath.txt goto startAPP

:clearTgtDir
if exist %targetDir%  (
    rd /S /Q %targetDir%
)

if not exist %targetDir% mkdir %targetDir%

xcopy /E /Q InitTool\* %targetDir%

:startAPP
rem Write Flash drive path into temporary folder.
echo %cd% > %targetDir%\flashdrivepath.txt

cd /D %targetDir%

echo Start InitTool from local disk...
if exist InitTool.ex1 (
    rename InitTool.ex1 InitTool.exe
)
start InitTool.exe
