/*
	Copyright (c) 2004-2011, The Dojo Foundation All Rights Reserved.
	Available via Academic Free License >= 2.1 OR the modified BSD license.
	see: http://dojotoolkit.org/license for details
*/

/*
	This is an optimized version of Dojo, built for deployment and not for
	development. To get sources and documentation, please visit:

		http://dojotoolkit.org
*/

//>>built
require({
	cache: {
		"dijit/form/nls/validate": function () {
			define("dijit/form/nls/validate", {
				root: ({
					invalidMessage: "The value entered is not valid.",
					missingMessage: "This value is required.",
					rangeMessage: "This value is out of range."
				}),
				"zh": true,
				"zh-tw": true,
				"tr": true,
				"th": true,
				"sv": true,
				"sl": true,
				"sk": true,
				"ru": true,
				"ro": true,
				"pt": true,
				"pt-pt": true,
				"pl": true,
				"nl": true,
				"nb": true,
				"ko": true,
				"kk": true,
				"ja": true,
				"it": true,
				"hu": true,
				"hr": true,
				"he": true,
				"fr": true,
				"fi": true,
				"es": true,
				"el": true,
				"de": true,
				"da": true,
				"cs": true,
				"ca": true,
				"az": true,
				"ar": true
			});
		},
		"dijit/form/TextBox": function () {
			require({
				cache: {
					"url:dijit/form/templates/TextBox.html": "<div class=\"dijit dijitReset dijitInline dijitLeft\" id=\"widget_${id}\" role=\"presentation\"\r\n\t><div class=\"dijitReset dijitInputField dijitInputContainer\"\r\n\t\t><input class=\"dijitReset dijitInputInner\" data-dojo-attach-point='textbox,focusNode' autocomplete=\"off\"\r\n\t\t\t${!nameAttrSetting} type='${type}'\r\n\t/></div\r\n></div>\r\n"
				}
			});
			define("dijit/form/TextBox", ["dojo/_base/declare", "dojo/dom-construct", "dojo/dom-style", "dojo/_base/kernel", "dojo/_base/lang", "dojo/_base/sniff", "dojo/_base/window", "./_FormValueWidget", "./_TextBoxMixin", "dojo/text!./templates/TextBox.html", ".."], function (_1, _2, _3, _4, _5, _6, _7, _8, _9, _a, _b) {
				var _c = _1([_8, _9], {
					templateString: _a,
					_singleNodeTemplate: "<input class=\"dijit dijitReset dijitLeft dijitInputField\" data-dojo-attach-point=\"textbox,focusNode\" autocomplete=\"off\" type=\"${type}\" ${!nameAttrSetting} />",
					_buttonInputDisabled: _6("ie") ? "disabled" : "",
					baseClass: "dijitTextBox",
					postMixInProperties: function () {
						var _d = this.type.toLowerCase();
						if (this.templateString && this.templateString.toLowerCase() == "input" || ((_d == "hidden" || _d == "file") && this.templateString == this.constructor.prototype.templateString)) {
							this.templateString = this._singleNodeTemplate;
						}
						this.inherited(arguments);
					},
					_onInput: function (e) {
						this.inherited(arguments);
						if (this.intermediateChanges) {
							var _e = this;
							setTimeout(function () {
								_e._handleOnChange(_e.get("value"), false);
							}, 0);
						}
					},
					_setPlaceHolderAttr: function (v) {
						this._set("placeHolder", v);
						if (!this._phspan) {
							this._attachPoints.push("_phspan");
							this._phspan = _2.create("span", {
								className: "dijitPlaceHolder dijitInputField"
							}, this.textbox, "after");
						}
						this._phspan.innerHTML = "";
						this._phspan.appendChild(document.createTextNode(v));
						this._updatePlaceHolder();
					},
					_updatePlaceHolder: function () {
						if (this._phspan) {
							this._phspan.style.display = (this.placeHolder && !this.focused && !this.textbox.value) ? "" : "none";
						}
					},
					_setValueAttr: function (_f, _10, _11) {
						this.inherited(arguments);
						this._updatePlaceHolder();
					},
					getDisplayedValue: function () {
						_4.deprecated(this.declaredClass + "::getDisplayedValue() is deprecated. Use set('displayedValue') instead.", "", "2.0");
						return this.get("displayedValue");
					},
					setDisplayedValue: function (_12) {
						_4.deprecated(this.declaredClass + "::setDisplayedValue() is deprecated. Use set('displayedValue', ...) instead.", "", "2.0");
						this.set("displayedValue", _12);
					},
					_onBlur: function (e) {
						if (this.disabled) {
							return;
						}
						this.inherited(arguments);
						this._updatePlaceHolder();
					},
					_onFocus: function (by) {
						if (this.disabled || this.readOnly) {
							return;
						}
						this.inherited(arguments);
						this._updatePlaceHolder();
					}
				});
				if (_6("ie")) {
					_c = _1(_c, {
						declaredClass: "dijit.form.TextBox",
						_isTextSelected: function () {
							var _13 = _7.doc.selection.createRange();
							var _14 = _13.parentElement();
							return _14 == this.textbox && _13.text.length == 0;
						},
						postCreate: function () {
							this.inherited(arguments);
							setTimeout(_5.hitch(this, function () {
								try {
									var s = _3.getComputedStyle(this.domNode);
									if (s) {
										var ff = s.fontFamily;
										if (ff) {
											var _15 = this.domNode.getElementsByTagName("INPUT");
											if (_15) {
												for (var i = 0; i < _15.length; i++) {
													_15[i].style.fontFamily = ff;
												}
											}
										}
									}
								} catch (e) {}
							}), 0);
						}
					});
					_b._setSelectionRange = _9._setSelectionRange = function (_16, _17, _18) {
						if (_16.createTextRange) {
							var r = _16.createTextRange();
							r.collapse(true);
							r.moveStart("character", -99999);
							r.moveStart("character", _17);
							r.moveEnd("character", _18 - _17);
							r.select();
						}
					};
				} else {
					if (_6("mozilla")) {
						_c = _1(_c, {
							declaredClass: "dijit.form.TextBox",
							_onBlur: function (e) {
								this.inherited(arguments);
								if (this.selectOnClick) {
									this.textbox.selectionStart = this.textbox.selectionEnd = undefined;
								}
							}
						});
					} else {
						_c.prototype.declaredClass = "dijit.form.TextBox";
					}
				}
				_5.setObject("dijit.form.TextBox", _c);
				return _c;
			});
		},
		"oob/summary/CountDownTimerMixin": function () {
			define(["dojo/_base/declare", "dojo/_base/lang"], function (_19, _1a) {
				return _19("oob.summary.CountDownTimer", null, {
					countdownTimer: {
						inter: null,
						date: new Date(),
						time: 0,
						setTime: function (_1b) {
							this.date.setTime(_1b);
							this.time = _1b;
						},
						getDisplayText: function () {
							return this.date.getMinutes() + ":" + dojo.string.pad(this.date.getSeconds(), 2);
						},
						startCount: function (_1c, _1d) {
							this.inter = setInterval(_1a.hitch(this, function () {
								if (this.time < 0) {
									_1d();
									return;
								}
								_1c(this.getDisplayText());
								this.setTime(this.time - 1000);
							}), 1000);
						},
						stopCount: function () {
							clearInterval(this.inter);
							this.inter = null;
						}
					}
				});
			});
		},
		"dijit/_TemplatedMixin": function () {
			define("dijit/_TemplatedMixin", ["dojo/_base/lang", "dojo/touch", "./_WidgetBase", "dojo/string", "dojo/cache", "dojo/_base/array", "dojo/_base/declare", "dojo/dom-construct", "dojo/_base/sniff", "dojo/_base/unload", "dojo/_base/window"], function (_1e, _1f, _20, _21, _22, _23, _24, _25, has, _26, win) {
				var _27 = _24("dijit._TemplatedMixin", null, {
					templateString: null,
					templatePath: null,
					_skipNodeCache: false,
					_earlyTemplatedStartup: false,
					constructor: function () {
						this._attachPoints = [];
						this._attachEvents = [];
					},
					_stringRepl: function (_28) {
						var _29 = this.declaredClass,
							_2a = this;
						return _21.substitute(_28, this, function (_2b, key) {
							if (key.charAt(0) == "!") {
								_2b = _1e.getObject(key.substr(1), false, _2a);
							}
							if (typeof _2b == "undefined") {
								throw new Error(_29 + " template:" + key);
							}
							if (_2b == null) {
								return "";
							}
							return key.charAt(0) == "!" ? _2b : _2b.toString().replace(/"/g, "&quot;");
						}, this);
					},
					buildRendering: function () {
						if (!this.templateString) {
							this.templateString = _22(this.templatePath, {
								sanitize: true
							});
						}
						var _2c = _27.getCachedTemplate(this.templateString, this._skipNodeCache);
						var _2d;
						if (_1e.isString(_2c)) {
							_2d = _25.toDom(this._stringRepl(_2c));
							if (_2d.nodeType != 1) {
								throw new Error("Invalid template: " + _2c);
							}
						} else {
							_2d = _2c.cloneNode(true);
						}
						this.domNode = _2d;
						this.inherited(arguments);
						this._attachTemplateNodes(_2d, function (n, p) {
							return n.getAttribute(p);
						});
						this._beforeFillContent();
						this._fillContent(this.srcNodeRef);
					},
					_beforeFillContent: function () {},
					_fillContent: function (_2e) {
						var _2f = this.containerNode;
						if (_2e && _2f) {
							while (_2e.hasChildNodes()) {
								_2f.appendChild(_2e.firstChild);
							}
						}
					},
					_attachTemplateNodes: function (_30, _31) {
						var _32 = _1e.isArray(_30) ? _30 : (_30.all || _30.getElementsByTagName("*"));
						var x = _1e.isArray(_30) ? 0 : -1;
						for (; x < _32.length; x++) {
							var _33 = (x == -1) ? _30 : _32[x];
							if (this.widgetsInTemplate && (_31(_33, "dojoType") || _31(_33, "data-dojo-type"))) {
								continue;
							}
							var _34 = _31(_33, "dojoAttachPoint") || _31(_33, "data-dojo-attach-point");
							if (_34) {
								var _35, _36 = _34.split(/\s*,\s*/);
								while ((_35 = _36.shift())) {
									if (_1e.isArray(this[_35])) {
										this[_35].push(_33);
									} else {
										this[_35] = _33;
									}
									this._attachPoints.push(_35);
								}
							}
							var _37 = _31(_33, "dojoAttachEvent") || _31(_33, "data-dojo-attach-event");
							if (_37) {
								var _38, _39 = _37.split(/\s*,\s*/);
								var _3a = _1e.trim;
								while ((_38 = _39.shift())) {
									if (_38) {
										var _3b = null;
										if (_38.indexOf(":") != -1) {
											var _3c = _38.split(":");
											_38 = _3a(_3c[0]);
											_3b = _3a(_3c[1]);
										} else {
											_38 = _3a(_38);
										}
										if (!_3b) {
											_3b = _38;
										}
										this._attachEvents.push(this.connect(_33, _1f[_38] || _38, _3b));
									}
								}
							}
						}
					},
					destroyRendering: function () {
						_23.forEach(this._attachPoints, function (_3d) {
							delete this[_3d];
						}, this);
						this._attachPoints = [];
						_23.forEach(this._attachEvents, this.disconnect, this);
						this._attachEvents = [];
						this.inherited(arguments);
					}
				});
				_27._templateCache = {};
				_27.getCachedTemplate = function (_3e, _3f) {
					var _40 = _27._templateCache;
					var key = _3e;
					var _41 = _40[key];
					if (_41) {
						try {
							if (!_41.ownerDocument || _41.ownerDocument == win.doc) {
								return _41;
							}
						} catch (e) {}
						_25.destroy(_41);
					}
					_3e = _21.trim(_3e);
					if (_3f || _3e.match(/\$\{([^\}]+)\}/g)) {
						return (_40[key] = _3e);
					} else {
						var _42 = _25.toDom(_3e);
						if (_42.nodeType != 1) {
							throw new Error("Invalid template: " + _3e);
						}
						return (_40[key] = _42);
					}
				};
				if (has("ie")) {
					_26.addOnWindowUnload(function () {
						var _43 = _27._templateCache;
						for (var key in _43) {
							var _44 = _43[key];
							if (typeof _44 == "object") {
								_25.destroy(_44);
							}
							delete _43[key];
						}
					});
				}
				_1e.extend(_20, {
					dojoAttachEvent: "",
					dojoAttachPoint: ""
				});
				return _27;
			});
		},
		"dijit/_CssStateMixin": function () {
			define("dijit/_CssStateMixin", ["dojo/touch", "dojo/_base/array", "dojo/_base/declare", "dojo/dom-class", "dojo/_base/lang", "dojo/_base/window"], function (_45, _46, _47, _48, _49, win) {
				return _47("dijit._CssStateMixin", [], {
					cssStateNodes: {},
					hovering: false,
					active: false,
					_applyAttributes: function () {
						this.inherited(arguments);
						_46.forEach(["onmouseenter", "onmouseleave", _45.press], function (e) {
							this.connect(this.domNode, e, "_cssMouseEvent");
						}, this);
						_46.forEach(["disabled", "readOnly", "checked", "selected", "focused", "state", "hovering", "active"], function (_4a) {
							this.watch(_4a, _49.hitch(this, "_setStateClass"));
						}, this);
						for (var ap in this.cssStateNodes) {
							this._trackMouseState(this[ap], this.cssStateNodes[ap]);
						}
						this._setStateClass();
					},
					_cssMouseEvent: function (_4b) {
						if (!this.disabled) {
							switch (_4b.type) {
								case "mouseenter":
								case "mouseover":
									this._set("hovering", true);
									this._set("active", this._mouseDown);
									break;
								case "mouseleave":
								case "mouseout":
									this._set("hovering", false);
									this._set("active", false);
									break;
								case "mousedown":
								case "touchpress":
									this._set("active", true);
									this._mouseDown = true;
									var _4c = this.connect(win.body(), _45.release, function () {
										this._mouseDown = false;
										this._set("active", false);
										this.disconnect(_4c);
									});
									break;
							}
						}
					},
					_setStateClass: function () {
						var _4d = this.baseClass.split(" ");

						function _4e(_4f) {
							_4d = _4d.concat(_46.map(_4d, function (c) {
								return c + _4f;
							}), "dijit" + _4f);
						};
						if (!this.isLeftToRight()) {
							_4e("Rtl");
						}
						var _50 = this.checked == "mixed" ? "Mixed" : (this.checked ? "Checked" : "");
						if (this.checked) {
							_4e(_50);
						}
						if (this.state) {
							_4e(this.state);
						}
						if (this.selected) {
							_4e("Selected");
						}
						if (this.disabled) {
							_4e("Disabled");
						} else {
							if (this.readOnly) {
								_4e("ReadOnly");
							} else {
								if (this.active) {
									_4e("Active");
								} else {
									if (this.hovering) {
										_4e("Hover");
									}
								}
							}
						}
						if (this.focused) {
							_4e("Focused");
						}
						var tn = this.stateNode || this.domNode,
							_51 = {};
						_46.forEach(tn.className.split(" "), function (c) {
							_51[c] = true;
						});
						if ("_stateClasses" in this) {
							_46.forEach(this._stateClasses, function (c) {
								delete _51[c];
							});
						}
						_46.forEach(_4d, function (c) {
							_51[c] = true;
						});
						var _52 = [];
						for (var c in _51) {
							_52.push(c);
						}
						tn.className = _52.join(" ");
						this._stateClasses = _4d;
					},
					_trackMouseState: function (_53, _54) {
						var _55 = false,
							_56 = false,
							_57 = false;
						var _58 = this,
							cn = _49.hitch(this, "connect", _53);

						function _59() {
							var _5a = ("disabled" in _58 && _58.disabled) || ("readonly" in _58 && _58.readonly);
							_48.toggle(_53, _54 + "Hover", _55 && !_56 && !_5a);
							_48.toggle(_53, _54 + "Active", _56 && !_5a);
							_48.toggle(_53, _54 + "Focused", _57 && !_5a);
						};
						cn("onmouseenter", function () {
							_55 = true;
							_59();
						});
						cn("onmouseleave", function () {
							_55 = false;
							_56 = false;
							_59();
						});
						cn(_45.press, function () {
							_56 = true;
							_59();
						});
						cn(_45.release, function () {
							_56 = false;
							_59();
						});
						cn("onfocus", function () {
							_57 = true;
							_59();
						});
						cn("onblur", function () {
							_57 = false;
							_59();
						});
						this.watch("disabled", _59);
						this.watch("readOnly", _59);
					}
				});
			});
		},
		"dijit/DialogUnderlay": function () {
			define("dijit/DialogUnderlay", ["dojo/_base/declare", "dojo/dom-attr", "dojo/_base/window", "dojo/window", "./_Widget", "./_TemplatedMixin", "./BackgroundIframe"], function (_5b, _5c, win, _5d, _5e, _5f, _60) {
				return _5b("dijit.DialogUnderlay", [_5e, _5f], {
					templateString: "<div class='dijitDialogUnderlayWrapper'><div class='dijitDialogUnderlay' data-dojo-attach-point='node'></div></div>",
					dialogId: "",
					"class": "",
					_setDialogIdAttr: function (id) {
						_5c.set(this.node, "id", id + "_underlay");
						this._set("dialogId", id);
					},
					_setClassAttr: function (_61) {
						this.node.className = "dijitDialogUnderlay " + _61;
						this._set("class", _61);
					},
					postCreate: function () {
						win.body().appendChild(this.domNode);
					},
					layout: function () {
						var is = this.node.style,
							os = this.domNode.style;
						os.display = "none";
						var _62 = _5d.getBox();
						os.top = _62.t + "px";
						os.left = _62.l + "px";
						is.width = _62.w + "px";
						is.height = _62.h + "px";
						os.display = "block";
					},
					show: function () {
						this.domNode.style.display = "block";
						this.layout();
						this.bgIframe = new _60(this.domNode);
					},
					hide: function () {
						this.bgIframe.destroy();
						delete this.bgIframe;
						this.domNode.style.display = "none";
					}
				});
			});
		},
		"dijit/place": function () {
			define("dijit/place", ["dojo/_base/array", "dojo/dom-geometry", "dojo/dom-style", "dojo/_base/kernel", "dojo/_base/window", "dojo/window", "."], function (_63, _64, _65, _66, win, _67, _68) {
				function _69(_6a, _6b, _6c, _6d) {
					var _6e = _67.getBox();
					if (!_6a.parentNode || String(_6a.parentNode.tagName).toLowerCase() != "body") {
						win.body().appendChild(_6a);
					}
					var _6f = null;
					_63.some(_6b, function (_70) {
						var _71 = _70.corner;
						var pos = _70.pos;
						var _72 = 0;
						var _73 = {
							w: {
								"L": _6e.l + _6e.w - pos.x,
								"R": pos.x - _6e.l,
								"M": _6e.w
							} [_71.charAt(1)],
							h: {
								"T": _6e.t + _6e.h - pos.y,
								"B": pos.y - _6e.t,
								"M": _6e.h
							} [_71.charAt(0)]
						};
						if (_6c) {
							var res = _6c(_6a, _70.aroundCorner, _71, _73, _6d);
							_72 = typeof res == "undefined" ? 0 : res;
						}
						var _74 = _6a.style;
						var _75 = _74.display;
						var _76 = _74.visibility;
						if (_74.display == "none") {
							_74.visibility = "hidden";
							_74.display = "";
						}
						var mb = _64.getMarginBox(_6a);
						_74.display = _75;
						_74.visibility = _76;
						var _77 = {
								"L": pos.x,
								"R": pos.x - mb.w,
								"M": Math.max(_6e.l, Math.min(_6e.l + _6e.w, pos.x + (mb.w >> 1)) - mb.w)
							} [_71.charAt(1)],
							_78 = {
								"T": pos.y,
								"B": pos.y - mb.h,
								"M": Math.max(_6e.t, Math.min(_6e.t + _6e.h, pos.y + (mb.h >> 1)) - mb.h)
							} [_71.charAt(0)],
							_79 = Math.max(_6e.l, _77),
							_7a = Math.max(_6e.t, _78),
							_7b = Math.min(_6e.l + _6e.w, _77 + mb.w),
							_7c = Math.min(_6e.t + _6e.h, _78 + mb.h),
							_7d = _7b - _79,
							_7e = _7c - _7a;
						_72 += (mb.w - _7d) + (mb.h - _7e);
						if (_6f == null || _72 < _6f.overflow) {
							_6f = {
								corner: _71,
								aroundCorner: _70.aroundCorner,
								x: _79,
								y: _7a,
								w: _7d,
								h: _7e,
								overflow: _72,
								spaceAvailable: _73
							};
						}
						return !_72;
					});
					if (_6f.overflow && _6c) {
						_6c(_6a, _6f.aroundCorner, _6f.corner, _6f.spaceAvailable, _6d);
					}
					var l = _64.isBodyLtr(),
						s = _6a.style;
					s.top = _6f.y + "px";
					s[l ? "left" : "right"] = (l ? _6f.x : _6e.w - _6f.x - _6f.w) + "px";
					s[l ? "right" : "left"] = "auto";
					return _6f;
				};
				return (_68.place = {
					at: function (_7f, pos, _80, _81) {
						var _82 = _63.map(_80, function (_83) {
							var c = {
								corner: _83,
								pos: {
									x: pos.x,
									y: pos.y
								}
							};
							if (_81) {
								c.pos.x += _83.charAt(1) == "L" ? _81.x : -_81.x;
								c.pos.y += _83.charAt(0) == "T" ? _81.y : -_81.y;
							}
							return c;
						});
						return _69(_7f, _82);
					},
					around: function (_84, _85, _86, _87, _88) {
						var _89 = (typeof _85 == "string" || "offsetWidth" in _85) ? _64.position(_85, true) : _85;
						if (_85.parentNode) {
							var _8a = _85.parentNode;
							while (_8a && _8a.nodeType == 1 && _8a.nodeName != "BODY") {
								var _8b = _64.position(_8a, true);
								var _8c = _65.getComputedStyle(_8a).overflow;
								if (_8c == "hidden" || _8c == "auto" || _8c == "scroll") {
									var _8d = Math.min(_89.y + _89.h, _8b.y + _8b.h);
									var _8e = Math.min(_89.x + _89.w, _8b.x + _8b.w);
									_89.x = Math.max(_89.x, _8b.x);
									_89.y = Math.max(_89.y, _8b.y);
									_89.h = _8d - _89.y;
									_89.w = _8e - _89.x;
								}
								_8a = _8a.parentNode;
							}
						}
						var x = _89.x,
							y = _89.y,
							_8f = "w" in _89 ? _89.w : (_89.w = _89.width),
							_90 = "h" in _89 ? _89.h : (_66.deprecated("place.around: dijit.place.__Rectangle: { x:" + x + ", y:" + y + ", height:" + _89.height + ", width:" + _8f + " } has been deprecated.  Please use { x:" + x + ", y:" + y + ", h:" + _89.height + ", w:" + _8f + " }", "", "2.0"), _89.h = _89.height);
						var _91 = [];

						function _92(_93, _94) {
							_91.push({
								aroundCorner: _93,
								corner: _94,
								pos: {
									x: {
										"L": x,
										"R": x + _8f,
										"M": x + (_8f >> 1)
									} [_93.charAt(1)],
									y: {
										"T": y,
										"B": y + _90,
										"M": y + (_90 >> 1)
									} [_93.charAt(0)]
								}
							});
						};
						_63.forEach(_86, function (pos) {
							var ltr = _87;
							switch (pos) {
								case "above-centered":
									_92("TM", "BM");
									break;
								case "below-centered":
									_92("BM", "TM");
									break;
								case "after-centered":
									ltr = !ltr;
								case "before-centered":
									_92(ltr ? "ML" : "MR", ltr ? "MR" : "ML");
									break;
								case "after":
									ltr = !ltr;
								case "before":
									_92(ltr ? "TL" : "TR", ltr ? "TR" : "TL");
									_92(ltr ? "BL" : "BR", ltr ? "BR" : "BL");
									break;
								case "below-alt":
									ltr = !ltr;
								case "below":
									_92(ltr ? "BL" : "BR", ltr ? "TL" : "TR");
									_92(ltr ? "BR" : "BL", ltr ? "TR" : "TL");
									break;
								case "above-alt":
									ltr = !ltr;
								case "above":
									_92(ltr ? "TL" : "TR", ltr ? "BL" : "BR");
									_92(ltr ? "TR" : "TL", ltr ? "BR" : "BL");
									break;
								default:
									_92(pos.aroundCorner, pos.corner);
							}
						});
						var _95 = _69(_84, _91, _88, {
							w: _8f,
							h: _90
						});
						_95.aroundNodePos = _89;
						return _95;
					}
				});
			});
		},
		"dijit/_HasDropDown": function () {
			define("dijit/_HasDropDown", ["dojo/_base/declare", "dojo/_base/Deferred", "dojo/_base/event", "dojo/dom", "dojo/dom-attr", "dojo/dom-class", "dojo/dom-geometry", "dojo/dom-style", "dojo/has", "dojo/keys", "dojo/_base/lang", "dojo/touch", "dojo/_base/window", "dojo/window", "./registry", "./focus", "./popup", "./_FocusMixin"], function (_96, _97, _98, dom, _99, _9a, _9b, _9c, has, _9d, _9e, _9f, win, _a0, _a1, _a2, _a3, _a4) {
				return _96("dijit._HasDropDown", _a4, {
					_buttonNode: null,
					_arrowWrapperNode: null,
					_popupStateNode: null,
					_aroundNode: null,
					dropDown: null,
					autoWidth: true,
					forceWidth: false,
					maxHeight: 0,
					dropDownPosition: ["below", "above"],
					_stopClickEvents: true,
					_onDropDownMouseDown: function (e) {
						if (this.disabled || this.readOnly) {
							return;
						}
						e.preventDefault();
						this._docHandler = this.connect(win.doc, _9f.release, "_onDropDownMouseUp");
						this.toggleDropDown();
					},
					_onDropDownMouseUp: function (e) {
						if (e && this._docHandler) {
							this.disconnect(this._docHandler);
						}
						var _a5 = this.dropDown,
							_a6 = false;
						if (e && this._opened) {
							var c = _9b.position(this._buttonNode, true);
							if (!(e.pageX >= c.x && e.pageX <= c.x + c.w) || !(e.pageY >= c.y && e.pageY <= c.y + c.h)) {
								var t = e.target;
								while (t && !_a6) {
									if (_9a.contains(t, "dijitPopup")) {
										_a6 = true;
									} else {
										t = t.parentNode;
									}
								}
								if (_a6) {
									t = e.target;
									if (_a5.onItemClick) {
										var _a7;
										while (t && !(_a7 = _a1.byNode(t))) {
											t = t.parentNode;
										}
										if (_a7 && _a7.onClick && _a7.getParent) {
											_a7.getParent().onItemClick(_a7, e);
										}
									}
									return;
								}
							}
						}
						if (this._opened) {
							if (_a5.focus && _a5.autoFocus !== false) {
								window.setTimeout(_9e.hitch(_a5, "focus"), 1);
							}
						} else {
							setTimeout(_9e.hitch(this, "focus"), 0);
						}
						if (has("ios")) {
							this._justGotMouseUp = true;
							setTimeout(_9e.hitch(this, function () {
								this._justGotMouseUp = false;
							}), 0);
						}
					},
					_onDropDownClick: function (e) {
						if (has("ios") && !this._justGotMouseUp) {
							this._onDropDownMouseDown(e);
							this._onDropDownMouseUp(e);
						}
						if (this._stopClickEvents) {
							_98.stop(e);
						}
					},
					buildRendering: function () {
						this.inherited(arguments);
						this._buttonNode = this._buttonNode || this.focusNode || this.domNode;
						this._popupStateNode = this._popupStateNode || this.focusNode || this._buttonNode;
						var _a8 = {
							"after": this.isLeftToRight() ? "Right" : "Left",
							"before": this.isLeftToRight() ? "Left" : "Right",
							"above": "Up",
							"below": "Down",
							"left": "Left",
							"right": "Right"
						} [this.dropDownPosition[0]] || this.dropDownPosition[0] || "Down";
						_9a.add(this._arrowWrapperNode || this._buttonNode, "dijit" + _a8 + "ArrowButton");
					},
					postCreate: function () {
						this.inherited(arguments);
						this.connect(this._buttonNode, _9f.press, "_onDropDownMouseDown");
						this.connect(this._buttonNode, "onclick", "_onDropDownClick");
						this.connect(this.focusNode, "onkeypress", "_onKey");
						this.connect(this.focusNode, "onkeyup", "_onKeyUp");
					},
					destroy: function () {
						if (this.dropDown) {
							if (!this.dropDown._destroyed) {
								this.dropDown.destroyRecursive();
							}
							delete this.dropDown;
						}
						this.inherited(arguments);
					},
					_onKey: function (e) {
						if (this.disabled || this.readOnly) {
							return;
						}
						var d = this.dropDown,
							_a9 = e.target;
						if (d && this._opened && d.handleKey) {
							if (d.handleKey(e) === false) {
								_98.stop(e);
								return;
							}
						}
						if (d && this._opened && e.charOrCode == _9d.ESCAPE) {
							this.closeDropDown();
							_98.stop(e);
						} else {
							if (!this._opened && (e.charOrCode == _9d.DOWN_ARROW || ((e.charOrCode == _9d.ENTER || e.charOrCode == " ") && ((_a9.tagName || "").toLowerCase() !== "input" || (_a9.type && _a9.type.toLowerCase() !== "text"))))) {
								this._toggleOnKeyUp = true;
								_98.stop(e);
							}
						}
					},
					_onKeyUp: function () {
						if (this._toggleOnKeyUp) {
							delete this._toggleOnKeyUp;
							this.toggleDropDown();
							var d = this.dropDown;
							if (d && d.focus) {
								setTimeout(_9e.hitch(d, "focus"), 1);
							}
						}
					},
					_onBlur: function () {
						var _aa = _a2.curNode && this.dropDown && dom.isDescendant(_a2.curNode, this.dropDown.domNode);
						this.closeDropDown(_aa);
						this.inherited(arguments);
					},
					isLoaded: function () {
						return true;
					},
					loadDropDown: function (_ab) {
						_ab();
					},
					loadAndOpenDropDown: function () {
						var d = new _97(),
							_ac = _9e.hitch(this, function () {
								this.openDropDown();
								d.resolve(this.dropDown);
							});
						if (!this.isLoaded()) {
							this.loadDropDown(_ac);
						} else {
							_ac();
						}
						return d;
					},
					toggleDropDown: function () {
						if (this.disabled || this.readOnly) {
							return;
						}
						if (!this._opened) {
							this.loadAndOpenDropDown();
						} else {
							this.closeDropDown();
						}
					},
					openDropDown: function () {
						var _ad = this.dropDown,
							_ae = _ad.domNode,
							_af = this._aroundNode || this.domNode,
							_b0 = this;
						if (!this._preparedNode) {
							this._preparedNode = true;
							if (_ae.style.width) {
								this._explicitDDWidth = true;
							}
							if (_ae.style.height) {
								this._explicitDDHeight = true;
							}
						}
						if (this.maxHeight || this.forceWidth || this.autoWidth) {
							var _b1 = {
								display: "",
								visibility: "hidden"
							};
							if (!this._explicitDDWidth) {
								_b1.width = "";
							}
							if (!this._explicitDDHeight) {
								_b1.height = "";
							}
							_9c.set(_ae, _b1);
							var _b2 = this.maxHeight;
							if (_b2 == -1) {
								var _b3 = _a0.getBox(),
									_b4 = _9b.position(_af, false);
								_b2 = Math.floor(Math.max(_b4.y, _b3.h - (_b4.y + _b4.h)));
							}
							_a3.moveOffScreen(_ad);
							if (_ad.startup && !_ad._started) {
								_ad.startup();
							}
							var mb = _9b.getMarginSize(_ae);
							var _b5 = (_b2 && mb.h > _b2);
							_9c.set(_ae, {
								overflowX: "hidden",
								overflowY: _b5 ? "auto" : "hidden"
							});
							if (_b5) {
								mb.h = _b2;
								if ("w" in mb) {
									mb.w += 16;
								}
							} else {
								delete mb.h;
							}
							if (this.forceWidth) {
								mb.w = _af.offsetWidth;
							} else {
								if (this.autoWidth) {
									mb.w = Math.max(mb.w, _af.offsetWidth);
								} else {
									delete mb.w;
								}
							}
							if (_9e.isFunction(_ad.resize)) {
								_ad.resize(mb);
							} else {
								_9b.setMarginBox(_ae, mb);
							}
						}
						var _b6 = _a3.open({
							parent: this,
							popup: _ad,
							around: _af,
							orient: this.dropDownPosition,
							onExecute: function () {
								_b0.closeDropDown(true);
							},
							onCancel: function () {
								_b0.closeDropDown(true);
							},
							onClose: function () {
								_99.set(_b0._popupStateNode, "popupActive", false);
								_9a.remove(_b0._popupStateNode, "dijitHasDropDownOpen");
								_b0._opened = false;
							}
						});
						_99.set(this._popupStateNode, "popupActive", "true");
						_9a.add(_b0._popupStateNode, "dijitHasDropDownOpen");
						this._opened = true;
						return _b6;
					},
					closeDropDown: function (_b7) {
						if (this._opened) {
							if (_b7) {
								this.focus();
							}
							_a3.close(this.dropDown);
							this._opened = false;
						}
					}
				});
			});
		},
		"url:oob/tasks/templates/Tasks.html": "<div>\r\n    <form id=\"taskform\" dojoType=\"dijit.form.Form\" dojoAttachPoint=\"taskForm\">\r\n        <div id=\"tasks\" class=\"tasksdiv\">\r\n            <div dojoAttachPoint=\"createPrompt\" class=\"promptArea\">\r\n                <div>${nls.newsystemprompt}</div>\r\n                <div class=\"alignCenter optionsDiv\">\r\n                    <span class=\"spirit\">\r\n                        <input type=\"radio\" dojoType=\"dijit.form.RadioButton\" name=\"firstSelection\" id=\"firstSelectionYes\" dojoAttachEvent=\"onChange:firstOptionSelected\" value=\"Yes\"/>\r\n                        <label for=\"firstSelectionYes\" class=\"radioLabel\">${nls.yes}</label>\r\n                    </span>\r\n                    <span class=\"spirit\">\r\n                        <input type=\"radio\" dojoType=\"dijit.form.RadioButton\" name=\"firstSelection\" id=\"firstSelectionNo\" dojoAttachEvent=\"onChange:firstOptionSelected\" value=\"No\"/>\r\n                        <label for=\"firstSelectionNo\" class=\"radioLabel\">${nls.no}</label>\r\n                    </span>\r\n                </div>\r\n            </div>\r\n\r\n            <div dojoAttachPoint=\"extendPrompt\" class=\"hidden promptArea\">\r\n                <div>${nls.extendsystemprompt}</div>\r\n                <div class=\"alignCenter optionsDiv\">\r\n                    <span class=\"spirit\">\r\n                        <input type=\"radio\" dojoType=\"dijit.form.RadioButton\" name=\"secondSelection\" id=\"secondSelectionYes\" dojoAttachEvent=\"onChange:secondOptionSelected\" value=\"Yes\"/>\r\n                        <label for=\"secondSelectionYes\" class=\"radioLabel\">${nls.yes}</label>\r\n                    </span>\r\n                    <span class=\"spirit\">\r\n                        <input type=\"radio\" dojoType=\"dijit.form.RadioButton\" name=\"secondSelection\" id=\"secondSelectionNo\" dojoAttachEvent=\"onChange:secondOptionSelected\" value=\"No\"/>\r\n                        <label for=\"secondSelectionNo\" class=\"radioLabel\">${nls.no}</label>\r\n                    </span>\r\n                </div>\r\n            </div>\r\n\r\n            <!--div dojoAttachPoint=\"selectImageArea\" class=\"hidden\">\r\n                <div class=\"selectImg\" dojoAttachPoint=\"selectImage\">\r\n                    <div class=\"new\"><a></a><div class=\"desc\">${nls.confignewsystem}</div></div>\r\n                    <div class=\"extend\"><a></a><div class=\"desc\">${nls.extendsystem}</div></div>\r\n                </div>\r\n            </div-->\r\n\r\n            <div class=\"radioItem\" dojoAttachPoint=\"simpleCreateSysArea\">\r\n                 <input type=\"radio\" dojoType=\"dijit.form.RadioButton\" name=\"task\" id=\"task1\" dojoAttachPoint=\"task1\" dojoAttachEvent=\"onChange:onOptionClicked\" value=\"createCluster\"/>\r\n                 <label for=\"task1\" class=\"radioLabel\">${nls.createsystem}</label>\r\n            </div>\r\n\r\n            <div dojoAttachPoint=\"sysCantAccessArea\" class=\"hidden sysCantAccessArea\">\r\n                <div class=\"noSysAccessText\">${nls.unableaccesssystem}</div>\r\n\r\n                <div class=\"radioItem\">  \r\n                    <input type=\"radio\" dojoType=\"dijit.form.RadioButton\" name=\"task\" id=\"task2\" dojoAttachPoint=\"task2\" dojoAttachEvent=\"onChange:onOptionClicked\" value=\"resetPwd\"/>\r\n                    <label for=\"task2\" class=\"radioLabel\">${nls.resetpassword}</label>\r\n                </div>\r\n\r\n  <div style=\"margin-top:3px;\"><label style=\"margin:0 5px 0 32px;\">New password:</label><input type=\"text\" name=\"resetpwdval\" dojoAttachPoint=\"resetpwdval\" dojoType=\"dijit.form.ValidationTextBox\" dojoAttachEvent=\"onChange:onOptionClicked\" regExp=\"^[\\x00-\\x7F]{6,64}$\" required=true intermediateChanges=true trim=true></input></div><div class=\"radioItem\">\r\n                    <input type=\"radio\" dojoType=\"dijit.form.RadioButton\" name=\"task\" id=\"task3\" dojoAttachPoint=\"task3\" dojoAttachEvent=\"onChange:onOptionClicked\" value=\"setServiceIp\"/>\r\n                    <label for=\"task3\" class=\"radioLabel\">${nls.setserviceip}</label>\r\n                </div>\r\n            </div>\r\n        </div>\r\n    </form>\r\n</div>",
		"dijit/focus": function () {
			define("dijit/focus", ["dojo/aspect", "dojo/_base/declare", "dojo/dom", "dojo/dom-attr", "dojo/dom-construct", "dojo/Evented", "dojo/_base/lang", "dojo/on", "dojo/ready", "dojo/_base/sniff", "dojo/Stateful", "dojo/_base/unload", "dojo/_base/window", "dojo/window", "./a11y", "./registry", "."], function (_b8, _b9, dom, _ba, _bb, _bc, _bd, on, _be, has, _bf, _c0, win, _c1, _c2, _c3, _c4) {
				var _c5 = _b9([_bf, _bc], {
					curNode: null,
					activeStack: [],
					constructor: function () {
						var _c6 = _bd.hitch(this, function (_c7) {
							if (dom.isDescendant(this.curNode, _c7)) {
								this.set("curNode", null);
							}
							if (dom.isDescendant(this.prevNode, _c7)) {
								this.set("prevNode", null);
							}
						});
						_b8.before(_bb, "empty", _c6);
						_b8.before(_bb, "destroy", _c6);
					},
					registerIframe: function (_c8) {
						return this.registerWin(_c8.contentWindow, _c8);
					},
					registerWin: function (_c9, _ca) {
						var _cb = this;
						var _cc = function (evt) {
							_cb._justMouseDowned = true;
							setTimeout(function () {
								_cb._justMouseDowned = false;
							}, 0);
							if (has("ie") && evt && evt.srcElement && evt.srcElement.parentNode == null) {
								return;
							}
							_cb._onTouchNode(_ca || evt.target || evt.srcElement, "mouse");
						};
						var doc = has("ie") ? _c9.document.documentElement : _c9.document;
						if (doc) {
							if (has("ie")) {
								_c9.document.body.attachEvent("onmousedown", _cc);
								var _cd = function (evt) {
									var tag = evt.srcElement.tagName.toLowerCase();
									if (tag == "#document" || tag == "body") {
										return;
									}
									if (_c2.isTabNavigable(evt.srcElement)) {
										_cb._onFocusNode(_ca || evt.srcElement);
									} else {
										_cb._onTouchNode(_ca || evt.srcElement);
									}
								};
								doc.attachEvent("onactivate", _cd);
								var _ce = function (evt) {
									_cb._onBlurNode(_ca || evt.srcElement);
								};
								doc.attachEvent("ondeactivate", _ce);
								return {
									remove: function () {
										_c9.document.detachEvent("onmousedown", _cc);
										doc.detachEvent("onactivate", _cd);
										doc.detachEvent("ondeactivate", _ce);
										doc = null;
									}
								};
							} else {
								doc.body.addEventListener("mousedown", _cc, true);
								doc.body.addEventListener("touchstart", _cc, true);
								var _cf = function (evt) {
									_cb._onFocusNode(_ca || evt.target);
								};
								doc.addEventListener("focus", _cf, true);
								var _d0 = function (evt) {
									_cb._onBlurNode(_ca || evt.target);
								};
								doc.addEventListener("blur", _d0, true);
								return {
									remove: function () {
										doc.body.removeEventListener("mousedown", _cc, true);
										doc.body.removeEventListener("touchstart", _cc, true);
										doc.removeEventListener("focus", _cf, true);
										doc.removeEventListener("blur", _d0, true);
										doc = null;
									}
								};
							}
						}
					},
					_onBlurNode: function () {
						this.set("prevNode", this.curNode);
						this.set("curNode", null);
						if (this._justMouseDowned) {
							return;
						}
						if (this._clearActiveWidgetsTimer) {
							clearTimeout(this._clearActiveWidgetsTimer);
						}
						this._clearActiveWidgetsTimer = setTimeout(_bd.hitch(this, function () {
							delete this._clearActiveWidgetsTimer;
							this._setStack([]);
							this.prevNode = null;
						}), 100);
					},
					_onTouchNode: function (_d1, by) {
						if (this._clearActiveWidgetsTimer) {
							clearTimeout(this._clearActiveWidgetsTimer);
							delete this._clearActiveWidgetsTimer;
						}
						var _d2 = [];
						try {
							while (_d1) {
								var _d3 = _ba.get(_d1, "dijitPopupParent");
								if (_d3) {
									_d1 = _c3.byId(_d3).domNode;
								} else {
									if (_d1.tagName && _d1.tagName.toLowerCase() == "body") {
										if (_d1 === win.body()) {
											break;
										}
										_d1 = _c1.get(_d1.ownerDocument).frameElement;
									} else {
										var id = _d1.getAttribute && _d1.getAttribute("widgetId"),
											_d4 = id && _c3.byId(id);
										if (_d4 && !(by == "mouse" && _d4.get("disabled"))) {
											_d2.unshift(id);
										}
										_d1 = _d1.parentNode;
									}
								}
							}
						} catch (e) {}
						this._setStack(_d2, by);
					},
					_onFocusNode: function (_d5) {
						if (!_d5) {
							return;
						}
						if (_d5.nodeType == 9) {
							return;
						}
						this._onTouchNode(_d5);
						if (_d5 == this.curNode) {
							return;
						}
						this.set("curNode", _d5);
					},
					_setStack: function (_d6, by) {
						var _d7 = this.activeStack;
						this.set("activeStack", _d6);
						for (var _d8 = 0; _d8 < Math.min(_d7.length, _d6.length); _d8++) {
							if (_d7[_d8] != _d6[_d8]) {
								break;
							}
						}
						var _d9;
						for (var i = _d7.length - 1; i >= _d8; i--) {
							_d9 = _c3.byId(_d7[i]);
							if (_d9) {
								_d9._hasBeenBlurred = true;
								_d9.set("focused", false);
								if (_d9._focusManager == this) {
									_d9._onBlur(by);
								}
								this.emit("widget-blur", _d9, by);
							}
						}
						for (i = _d8; i < _d6.length; i++) {
							_d9 = _c3.byId(_d6[i]);
							if (_d9) {
								_d9.set("focused", true);
								if (_d9._focusManager == this) {
									_d9._onFocus(by);
								}
								this.emit("widget-focus", _d9, by);
							}
						}
					},
					focus: function (_da) {
						if (_da) {
							try {
								_da.focus();
							} catch (e) {}
						}
					}
				});
				var _db = new _c5();
				_be(function () {
					var _dc = _db.registerWin(win.doc.parentWindow || win.doc.defaultView);
					if (has("ie")) {
						_c0.addOnWindowUnload(function () {
							_dc.remove();
							_dc = null;
						});
					}
				});
				_c4.focus = function (_dd) {
					_db.focus(_dd);
				};
				for (var _de in _db) {
					if (!/^_/.test(_de)) {
						_c4.focus[_de] = typeof _db[_de] == "function" ? _bd.hitch(_db, _de) : _db[_de];
					}
				}
				_db.watch(function (_df, _e0, _e1) {
					_c4.focus[_df] = _e1;
				});
				return _db;
			});
		},
		"dojo/i18n": function () {
			define(["./_base/kernel", "require", "./has", "./_base/array", "./_base/config", "./_base/lang", "./_base/xhr"], function (_e2, _e3, has, _e4, _e5, _e6, xhr) {
				var _e7 = _e2.i18n = {},
					_e8 = /(^.*(^|\/)nls)(\/|$)([^\/]*)\/?([^\/]*)/,
					_e9 = function (_ea, _eb, _ec, _ed) {
						for (var _ee = [_ec + _ed], _ef = _eb.split("-"), _f0 = "", i = 0; i < _ef.length; i++) {
							_f0 += (_f0 ? "-" : "") + _ef[i];
							if (!_ea || _ea[_f0]) {
								_ee.push(_ec + _f0 + "/" + _ed);
							}
						}
						return _ee;
					},
					_f1 = {},
					_f2 = _e2.getL10nName = function (_f3, _f4, _f5) {
						_f5 = _f5 ? _f5.toLowerCase() : _e2.locale;
						_f3 = "dojo/i18n!" + _f3.replace(/\./g, "/");
						_f4 = _f4.replace(/\./g, "/");
						return (/root/i.test(_f5)) ? (_f3 + "/nls/" + _f4) : (_f3 + "/nls/" + _f5 + "/" + _f4);
					},
					_f6 = function (_f7, _f8, _f9, _fa, _fb, _fc) {
						_f7([_f8], function (_fd) {
							var _fe = _f1[_f8 + "/"] = _e6.clone(_fd.root),
								_ff = _e9(!_fd._v1x && _fd, _fb, _f9, _fa);
							_f7(_ff, function () {
								for (var i = 1; i < _ff.length; i++) {
									_f1[_ff[i]] = _fe = _e6.mixin(_e6.clone(_fe), arguments[i]);
								}
								var _100 = _f8 + "/" + _fb;
								_f1[_100] = _fe;
								_fc && _fc(_e6.delegate(_fe));
							});
						});
					},
					_101 = function (id, _102) {
						var _103 = _e8.exec(id),
							_104 = _103[1];
						return /^\./.test(_104) ? _102(_104) + "/" + id.substring(_104.length) : id;
					},
					_105 = function () {},
					load = function (id, _106, load) {
						var _107 = _e8.exec(id),
							_108 = _107[1] + "/",
							_109 = _107[5] || _107[4],
							_10a = _108 + _109,
							_10b = (_107[5] && _107[4]),
							_10c = _10b || _e2.locale,
							_10d = _10a + "/" + _10c;
						if (_10b) {
							_105(_10d);
							if (_f1[_10d]) {
								load(_f1[_10d]);
							} else {
								_f6(_106, _10a, _108, _109, _10c, load);
							}
							return;
						}
						var _10e = _e5.extraLocale || [];
						_10e = _e6.isArray(_10e) ? _10e : [_10e];
						_10e.push(_10c);
						var _10f = _10e.length,
							_110;
						_e4.forEach(_10e, function (_111) {
							_f6(_106, _10a, _108, _109, _111, function (_112) {
								if (_111 == _10c) {
									_110 = _112;
								}
								if (!--_10f) {
									load(_110);
								}
							});
						});
					};
				if (has("dojo-unit-tests")) {
					var _113 = _e7.unitTests = [];
				}
				true || has.add("dojo-v1x-i18n-Api", 1);
				if (1) {
					var _114 = {},
						_115 = new Function("bundle, __evalError", "var __amdResult, define = function(x){__amdResult= x;};" + "return [(function(){" + "try{eval(arguments[0]);}catch(e){}" + "if(__amdResult)return 0;" + "try{return eval('('+arguments[0]+')');}" + "catch(e){__evalError.e = e; return __evalError;}" + "})(arguments[0]) , __amdResult];"),
						_116 = function (url, _117, _118) {
							if (_117 === _114) {
								console.error("failed to evaluate i18n bundle; url=" + url, _114.e);
								return {};
							}
							return _117 ? (/nls\/[^\/]+\/[^\/]+$/.test(url) ? _117 : {
								root: _117,
								_v1x: 1
							}) : _118;
						},
						_119 = function (deps, _11a) {
							var _11b = [];
							_e4.forEach(deps, function (mid) {
								var url = _e3.toUrl(mid + ".js");
								if (_f1[url]) {
									_11b.push(_f1[url]);
								} else {
									try {
										var _11c = _e3(mid);
										if (_11c) {
											_11b.push(_11c);
											return;
										}
									} catch (e) {}
									xhr.get({
										url: url,
										sync: true,
										load: function (text) {
											var _11d = _115(text, _114);
											_11b.push(_f1[url] = _116(url, _11d[0], _11d[1]));
										},
										error: function () {
											_11b.push(_f1[url] = {});
										}
									});
								}
							});
							_11a.apply(null, _11b);
						},
						_11e = _e7.normalizeLocale = function (_11f) {
							var _120 = _11f ? _11f.toLowerCase() : _e2.locale;
							if (_120 == "root") {
								_120 = "ROOT";
							}
							return _120;
						},
						_121 = function (_122, func) {
							var _123 = _122.split("-");
							while (_123.length) {
								if (func(_123.join("-"))) {
									return true;
								}
								_123.pop();
							}
							return func("ROOT");
						};
					_105 = function (_124) {
						for (var _125 = _124.split("/"), _126 = _e2.global[_125[0]], i = 1; _126 && i < _125.length; _126 = _126[_125[i++]]) {}
						if (_126) {
							_f1[_124] = _126;
						}
					};
					_e7.getLocalization = function (_127, _128, _129) {
						var _12a, _12b = _f2(_127, _128, _129).substring(10);
						load(_12b, (1 && !_e3.isXdUrl(_e3.toUrl(_12b + ".js")) ? _119 : _e3), function (_12c) {
							_12a = _12c;
						});
						return _12a;
					};
					_e7._preloadLocalizations = function (_12d, _12e) {
						if (_12d.indexOf("oob/nls") != -1) {
							return;
						}

						function _12f(_130) {
							_130 = _11e(_130);
							_121(_130, function (loc) {
								for (var i = 0; i < _12e.length; i++) {
									if (_12e[i] == loc) {
										_e3([_12d.replace(/\./g, "/") + "_" + loc]);
										return true;
									}
								}
								return false;
							});
						};
						_12f();
						var _131 = _e2.config.extraLocale || [];
						for (var i = 0; i < _131.length; i++) {
							_12f(_131[i]);
						}
					};
					if (has("dojo-unit-tests")) {
						_113.push(function (doh) {
							doh.register("tests.i18n.unit", function (t) {
								var _132;
								_132 = _115("{prop:1}", _114);
								t.is({
									prop: 1
								}, _132[0]);
								t.is(undefined, _132[1]);
								_132 = _115("({prop:1})", _114);
								t.is({
									prop: 1
								}, _132[0]);
								t.is(undefined, _132[1]);
								_132 = _115("{'prop-x':1}", _114);
								t.is({
									"prop-x": 1
								}, _132[0]);
								t.is(undefined, _132[1]);
								_132 = _115("({'prop-x':1})", _114);
								t.is({
									"prop-x": 1
								}, _132[0]);
								t.is(undefined, _132[1]);
								_132 = _115("define({'prop-x':1})", _114);
								t.is(0, _132[0]);
								t.is({
									"prop-x": 1
								}, _132[1]);
								_132 = _115("define({'prop-x':1});", _114);
								t.is(0, _132[0]);
								t.is({
									"prop-x": 1
								}, _132[1]);
								_132 = _115("this is total nonsense and should throw an error", _114);
								t.is(_114, _132[0]);
								t.is(undefined, _132[1]);
								t.is({}, _116("some/url", _132[0], _132[1]));
							});
						});
					}
				}
				return _e6.mixin(_e7, {
					dynamic: true,
					normalize: _101,
					load: load,
					cache: function (mid, _133) {
						_f1[mid] = _133;
					}
				});
			});
		},
		"url:oob/clusterip/templates/IPconfig.html": "<div>\r\n    <div class=\"radioDiv\">\r\n        <div class=\"radioItem\">\r\n            <input type=\"radio\" name=\"iptype\" id=\"type4\" value=\"ipv4\" dojoAttachPoint=\"radio4\" dojoType=\"dijit.form.RadioButton\" dojoAttachEvent=\"onClick:ipV4Selected\"></input>\r\n            <label for=\"type4\" class=\"radioLabel\">${nls.ipv4}</label>\r\n        </div>\r\n        <div class=\"radioItem\">\r\n            <input type=\"radio\" name=\"iptype\" id=\"type6\" value=\"ipv6\" dojoAttachPoint=\"radio6\" dojoType=\"dijit.form.RadioButton\" dojoAttachEvent=\"onClick:ipV6Selected\"></input>\r\n            <label for=\"type6\" class=\"radioLabel\">${nls.ipv6}</label>\r\n        </div>\r\n    </div>\r\n    <div dojoAttachPoint=\"ipv4div\" class=\"ipDiv\">\r\n        <form dojoType=\"dijit.form.Form\" dojoAttachPoint=\"ipv4Form\">\r\n            <table>\r\n                <tr><td>${nls.address}</td><td><input type=\"text\" name=\"address4\" dojoAttachPoint=\"address_4\" dojoType=\"dijit.form.ValidationTextBox\"></input></td></tr>\r\n                <tr><td>${nls.mask}</td>   <td><input type=\"text\" name=\"mask4\" dojoAttachPoint=\"mask_4\" dojoType=\"dijit.form.ValidationTextBox\"></input></td></tr>\r\n                <tr><td>${nls.gateway}</td><td><input type=\"text\" name=\"gateway4\" dojoAttachPoint=\"gateway_4\" dojoType=\"dijit.form.ValidationTextBox\"></input></td></tr>\r\n            </table>\r\n        </form>\r\n        <div dojoAttachPoint=\"difSubnet\" class=\"difSubnet hidden\">${nls.notsamenetwork}</div>\r\n    </div>\r\n    <div dojoAttachPoint=\"ipv6div\" class=\"ipDiv\">\r\n        <form dojoType=\"dijit.form.Form\" dojoAttachPoint=\"ipv6Form\">\r\n            <table>\r\n                <tr><td>${nls.address}</td><td><input type=\"text\" name=\"address6\" dojoAttachPoint=\"address_6\" dojoType=\"dijit.form.ValidationTextBox\"></input></td></tr>\r\n                <tr><td>${nls.prefix}</td> <td><input type=\"text\" name=\"mask6\" dojoAttachPoint=\"mask_6\" dojoType=\"dijit.form.ValidationTextBox\"></input></td></tr>\r\n                <tr><td>${nls.gateway}</td><td><input type=\"text\" name=\"gateway6\" dojoAttachPoint=\"gateway_6\" dojoType=\"dijit.form.ValidationTextBox\"></input></td></tr>\r\n            </table>\r\n        </form>\r\n    </div>\r\n</div>",
		"dijit/hccss": function () {
			define("dijit/hccss", ["require", "dojo/_base/config", "dojo/dom-class", "dojo/dom-construct", "dojo/dom-style", "dojo/ready", "dojo/_base/sniff", "dojo/_base/window"], function (_134, _135, _136, _137, _138, _139, has, win) {
				if (has("ie") || has("mozilla")) {
					_139(90, function () {
						var div = _137.create("div", {
							id: "a11yTestNode",
							style: {
								cssText: "border: 1px solid;" + "border-color:red green;" + "position: absolute;" + "height: 5px;" + "top: -999px;" + "background-image: url(\"" + (_135.blankGif || _134.toUrl("dojo/resources/blank.gif")) + "\");"
							}
						}, win.body());
						var cs = _138.getComputedStyle(div);
						if (cs) {
							var _13a = cs.backgroundImage;
							var _13b = (cs.borderTopColor == cs.borderRightColor) || (_13a != null && (_13a == "none" || _13a == "url(invalid-url:)"));
							if (_13b) {
								_136.add(win.body(), "dijit_a11y");
							}
							if (has("ie")) {
								div.outerHTML = "";
							} else {
								win.body().removeChild(div);
							}
						}
					});
				}
			});
		},
		"dijit/form/_ComboBoxMenuMixin": function () {
			define("dijit/form/_ComboBoxMenuMixin", ["dojo/_base/array", "dojo/_base/declare", "dojo/dom-attr", "dojo/i18n", "dojo/_base/window", "dojo/i18n!./nls/ComboBox"], function (_13c, _13d, _13e, i18n, win) {
				return _13d("dijit.form._ComboBoxMenuMixin", null, {
					_messages: null,
					postMixInProperties: function () {
						this.inherited(arguments);
						this._messages = i18n.getLocalization("dijit.form", "ComboBox", this.lang);
					},
					buildRendering: function () {
						this.inherited(arguments);
						this.previousButton.innerHTML = this._messages["previousMessage"];
						this.nextButton.innerHTML = this._messages["nextMessage"];
					},
					_setValueAttr: function (_13f) {
						this.value = _13f;
						this.onChange(_13f);
					},
					onClick: function (node) {
						if (node == this.previousButton) {
							this._setSelectedAttr(null);
							this.onPage(-1);
						} else {
							if (node == this.nextButton) {
								this._setSelectedAttr(null);
								this.onPage(1);
							} else {
								this.onChange(node);
							}
						}
					},
					onChange: function () {},
					onPage: function () {},
					onClose: function () {
						this._setSelectedAttr(null);
					},
					_createOption: function (item, _140) {
						var _141 = this._createMenuItem();
						var _142 = _140(item);
						if (_142.html) {
							_141.innerHTML = _142.label;
						} else {
							_141.appendChild(win.doc.createTextNode(_142.label));
						}
						if (_141.innerHTML == "") {
							_141.innerHTML = "&#160;";
						}
						this.applyTextDir(_141, (_141.innerText || _141.textContent || ""));
						_141.item = item;
						return _141;
					},
					createOptions: function (_143, _144, _145) {
						this.previousButton.style.display = (_144.start == 0) ? "none" : "";
						_13e.set(this.previousButton, "id", this.id + "_prev");
						_13c.forEach(_143, function (item, i) {
							var _146 = this._createOption(item, _145);
							_13e.set(_146, "id", this.id + i);
							this.nextButton.parentNode.insertBefore(_146, this.nextButton);
						}, this);
						var _147 = false;
						if (_143.total && !_143.total.then && _143.total != -1) {
							if ((_144.start + _144.count) < _143.total) {
								_147 = true;
							} else {
								if ((_144.start + _144.count) > _143.total && _144.count == _143.length) {
									_147 = true;
								}
							}
						} else {
							if (_144.count == _143.length) {
								_147 = true;
							}
						}
						this.nextButton.style.display = _147 ? "" : "none";
						_13e.set(this.nextButton, "id", this.id + "_next");
						return this.containerNode.childNodes;
					},
					clearResultList: function () {
						var _148 = this.containerNode;
						while (_148.childNodes.length > 2) {
							_148.removeChild(_148.childNodes[_148.childNodes.length - 2]);
						}
						this._setSelectedAttr(null);
					},
					highlightFirstOption: function () {
						this.selectFirstNode();
					},
					highlightLastOption: function () {
						this.selectLastNode();
					},
					selectFirstNode: function () {
						this.inherited(arguments);
						if (this.getHighlightedOption() == this.previousButton) {
							this.selectNextNode();
						}
					},
					selectLastNode: function () {
						this.inherited(arguments);
						if (this.getHighlightedOption() == this.nextButton) {
							this.selectPreviousNode();
						}
					},
					getHighlightedOption: function () {
						return this._getSelectedAttr();
					}
				});
			});
		},
		"dojo/parser": function () {
			define(["./_base/kernel", "./_base/lang", "./_base/array", "./_base/html", "./_base/window", "./_base/url", "./_base/json", "./aspect", "./date/stamp", "./query", "./on", "./ready"], function (dojo, _149, _14a, _14b, _14c, _14d, _14e, _14f, _150, _151, don) {
				new Date("X");
				var _152 = {
					"dom-attributes-explicit": document.createElement("div").attributes.length < 40
				};

				function has(_153) {
					return _152[_153];
				};
				dojo.parser = new function () {
					var _154 = {};

					function _155(_156) {
						var map = {};
						for (var name in _156) {
							if (name.charAt(0) == "_") {
								continue;
							}
							map[name.toLowerCase()] = name;
						}
						return map;
					};
					_14f.after(_149, "extend", function () {
						_154 = {};
					}, true);
					var _157 = {};
					this._functionFromScript = function (_158, _159) {
						var _15a = "";
						var _15b = "";
						var _15c = (_158.getAttribute(_159 + "args") || _158.getAttribute("args"));
						if (_15c) {
							_14a.forEach(_15c.split(/\s*,\s*/), function (part, idx) {
								_15a += "var " + part + " = arguments[" + idx + "]; ";
							});
						}
						var _15d = _158.getAttribute("with");
						if (_15d && _15d.length) {
							_14a.forEach(_15d.split(/\s*,\s*/), function (part) {
								_15a += "with(" + part + "){";
								_15b += "}";
							});
						}
						return new Function(_15a + _158.innerHTML + _15b);
					};
					this.instantiate = function (_15e, _15f, args) {
						var _160 = [],
							_15f = _15f || {};
						args = args || {};
						var _161 = (args.scope || dojo._scopeName) + "Type",
							_162 = "data-" + (args.scope || dojo._scopeName) + "-",
							_163 = _162 + "type",
							_164 = _162 + "props",
							_165 = _162 + "attach-point",
							_166 = _162 + "attach-event",
							_167 = _162 + "id";
						var _168 = {};
						_14a.forEach([_164, _163, _161, _167, "jsId", _165, _166, "dojoAttachPoint", "dojoAttachEvent", "class", "style"], function (name) {
							_168[name.toLowerCase()] = name.replace(args.scope, "dojo");
						});
						_14a.forEach(_15e, function (obj) {
							if (!obj) {
								return;
							}
							var node = obj.node || obj,
								type = _161 in _15f ? _15f[_161] : obj.node ? obj.type : (node.getAttribute(_163) || node.getAttribute(_161)),
								ctor = _157[type] || (_157[type] = _149.getObject(type)),
								_169 = ctor && ctor.prototype;
							if (!ctor) {
								throw new Error("Could not load class '" + type);
							}
							var _16a = {};
							if (args.defaults) {
								_149.mixin(_16a, args.defaults);
							}
							if (obj.inherited) {
								_149.mixin(_16a, obj.inherited);
							}
							var _16b;
							if (has("dom-attributes-explicit")) {
								_16b = node.attributes;
							} else {
								var _16c = /^input$|^img$/i.test(node.nodeName) ? node : node.cloneNode(false),
									_16d = _16c.outerHTML.replace(/=[^\s"']+|="[^"]*"|='[^']*'/g, "").replace(/^\s*<[a-zA-Z0-9]*/, "").replace(/>.*$/, "");
								_16b = _14a.map(_16d.split(/\s+/), function (name) {
									var _16e = name.toLowerCase();
									return {
										name: name,
										value: (node.nodeName == "LI" && name == "value") || _16e == "enctype" ? node.getAttribute(_16e) : node.getAttributeNode(_16e).value,
										specified: true
									};
								});
							}
							var i = 0,
								item;
							while (item = _16b[i++]) {
								if (!item || !item.specified) {
									continue;
								}
								var name = item.name,
									_16f = name.toLowerCase(),
									_170 = item.value;
								if (_16f in _168) {
									switch (_168[_16f]) {
										case "data-dojo-props":
											var _171 = _170;
											break;
										case "data-dojo-id":
										case "jsId":
											var _172 = _170;
											break;
										case "data-dojo-attach-point":
										case "dojoAttachPoint":
											_16a.dojoAttachPoint = _170;
											break;
										case "data-dojo-attach-event":
										case "dojoAttachEvent":
											_16a.dojoAttachEvent = _170;
											break;
										case "class":
											_16a["class"] = node.className;
											break;
										case "style":
											_16a["style"] = node.style && node.style.cssText;
											break;
									}
								} else {
									if (!(name in _169)) {
										var map = (_154[type] || (_154[type] = _155(_169)));
										name = map[_16f] || name;
									}
									if (name in _169) {
										switch (typeof _169[name]) {
											case "string":
												_16a[name] = _170;
												break;
											case "number":
												_16a[name] = _170.length ? Number(_170) : NaN;
												break;
											case "boolean":
												_16a[name] = _170.toLowerCase() != "false";
												break;
											case "function":
												if (_170 === "" || _170.search(/[^\w\.]+/i) != -1) {
													_16a[name] = new Function(_170);
												} else {
													_16a[name] = _149.getObject(_170, false) || new Function(_170);
												}
												break;
											default:
												var pVal = _169[name];
												_16a[name] = (pVal && "length" in pVal) ? (_170 ? _170.split(/\s*,\s*/) : []) : (pVal instanceof Date) ? (_170 == "" ? new Date("") : _170 == "now" ? new Date() : _150.fromISOString(_170)) : (pVal instanceof dojo._Url) ? (dojo.baseUrl + _170) : _14e.fromJson(_170);
										}
									} else {
										_16a[name] = _170;
									}
								}
							}
							if (_171) {
								try {
									_171 = _14e.fromJson.call(args.propsThis, "{" + _171 + "}");
									_149.mixin(_16a, _171);
								} catch (e) {
									throw new Error(e.toString() + " in data-dojo-props='" + _171 + "'");
								}
							}
							_149.mixin(_16a, _15f);
							var _173 = obj.node ? obj.scripts : (ctor && (ctor._noScript || _169._noScript) ? [] : _151("> script[type^='dojo/']", node));
							var _174 = [],
								_175 = [],
								_176 = [],
								on = [];
							if (_173) {
								for (i = 0; i < _173.length; i++) {
									var _177 = _173[i];
									node.removeChild(_177);
									var _178 = (_177.getAttribute(_162 + "event") || _177.getAttribute("event")),
										prop = _177.getAttribute(_162 + "prop"),
										type = _177.getAttribute("type"),
										nf = this._functionFromScript(_177, _162);
									if (_178) {
										if (type == "dojo/connect") {
											_174.push({
												event: _178,
												func: nf
											});
										} else {
											if (type == "dojo/on") {
												on.push({
													event: _178,
													func: nf
												});
											} else {
												_16a[_178] = nf;
											}
										}
									} else {
										if (type == "dojo/watch") {
											_176.push({
												prop: prop,
												func: nf
											});
										} else {
											_175.push(nf);
										}
									}
								}
							}
							var _179 = ctor.markupFactory || _169.markupFactory;
							var _17a = _179 ? _179(_16a, node, ctor) : new ctor(_16a, node);
							_160.push(_17a);
							if (_172) {
								_149.setObject(_172, _17a);
							}
							for (i = 0; i < _174.length; i++) {
								_14f.after(_17a, _174[i].event, dojo.hitch(_17a, _174[i].func), true);
							}
							for (i = 0; i < _175.length; i++) {
								_175[i].call(_17a);
							}
							for (i = 0; i < _176.length; i++) {
								_17a.watch(_176[i].prop, _176[i].func);
							}
							for (i = 0; i < on.length; i++) {
								don(_17a, on[i].event, on[i].func);
							}
						}, this);
						if (!_15f._started) {
							_14a.forEach(_160, function (_17b) {
								if (!args.noStart && _17b && _149.isFunction(_17b.startup) && !_17b._started) {
									_17b.startup();
								}
							});
						}
						return _160;
					};
					this.parse = function (_17c, args) {
						var root;
						if (!args && _17c && _17c.rootNode) {
							args = _17c;
							root = args.rootNode;
						} else {
							root = _17c;
						}
						root = root ? _14b.byId(root) : _14c.body();
						args = args || {};
						var _17d = (args.scope || dojo._scopeName) + "Type",
							_17e = "data-" + (args.scope || dojo._scopeName) + "-",
							_17f = _17e + "type",
							_180 = _17e + "textdir";
						var list = [];
						var node = root.firstChild;
						var _181 = args && args.inherited;
						if (!_181) {
							function _182(node, attr) {
								return (node.getAttribute && node.getAttribute(attr)) || (node !== _14c.doc && node !== _14c.doc.documentElement && node.parentNode ? _182(node.parentNode, attr) : null);
							};
							_181 = {
								dir: _182(root, "dir"),
								lang: _182(root, "lang"),
								textDir: _182(root, _180)
							};
							for (var key in _181) {
								if (!_181[key]) {
									delete _181[key];
								}
							}
						}
						var _183 = {
							inherited: _181
						};
						var _184;
						var _185;

						function _186(_187) {
							if (!_187.inherited) {
								_187.inherited = {};
								var node = _187.node,
									_188 = _186(_187.parent);
								var _189 = {
									dir: node.getAttribute("dir") || _188.dir,
									lang: node.getAttribute("lang") || _188.lang,
									textDir: node.getAttribute(_180) || _188.textDir
								};
								for (var key in _189) {
									if (_189[key]) {
										_187.inherited[key] = _189[key];
									}
								}
							}
							return _187.inherited;
						};
						while (true) {
							if (!node) {
								if (!_183 || !_183.node) {
									break;
								}
								node = _183.node.nextSibling;
								_184 = _183.scripts;
								_185 = false;
								_183 = _183.parent;
								continue;
							}
							if (node.nodeType != 1) {
								node = node.nextSibling;
								continue;
							}
							if (_184 && node.nodeName.toLowerCase() == "script") {
								type = node.getAttribute("type");
								if (type && /^dojo\/\w/i.test(type)) {
									_184.push(node);
								}
								node = node.nextSibling;
								continue;
							}
							if (_185) {
								node = node.nextSibling;
								continue;
							}
							var type = node.getAttribute(_17f) || node.getAttribute(_17d);
							var _18a = node.firstChild;
							if (!type && (!_18a || (_18a.nodeType == 3 && !_18a.nextSibling))) {
								node = node.nextSibling;
								continue;
							}
							var _18b = {
								node: node,
								scripts: _184,
								parent: _183
							};
							var ctor = type && (_157[type] || (_157[type] = _149.getObject(type))),
								_18c = ctor && !ctor.prototype._noScript ? [] : null;
							if (type) {
								list.push({
									"type": type,
									node: node,
									scripts: _18c,
									inherited: _186(_18b)
								});
							}
							node = _18a;
							_184 = _18c;
							_185 = ctor && ctor.prototype.stopParser && !(args && args.template);
							_183 = _18b;
						}
						var _18d = args && args.template ? {
							template: true
						} : null;
						return this.instantiate(list, _18d, args);
					};
				}();
				if (dojo.config.parseOnLoad) {
					dojo.ready(100, dojo.parser, "parse");
				}
				return dojo.parser;
			});
		},
		"url:oob/usb/templates/USB.html": "<div>\r\n    <img src=\"images/inittool/tbird4_transferDiagram.png\"/>\r\n    <div class=\"ul\">\r\n        <div class=\"li\"><div class=\"indexImage\">1.</div>${nls.step1text}</div>\r\n        <div class=\"li\"><div class=\"indexImage\">2.</div>${nls.step2text}</div>\r\n        <div class=\"li\"><div class=\"indexImage\">3.</div>${nls.step3text}</div>\r\n        <div class=\"li\"><div class=\"indexImage\">4.</div>${nls.step4text}</div>\r\n        <div class=\"li\"><div class=\"indexImage\">5.</div>${nls.step5text}</div>\r\n    </div>\r\n</div>",
		"dojox/validate": function () {
			define("dojox/validate", ["./validate/_base"], function (_18e) {
				return _18e;
			});
		},
		"dijit/form/ToggleButton": function () {
			define("dijit/form/ToggleButton", ["dojo/_base/declare", "dojo/_base/kernel", "./Button", "./_ToggleButtonMixin"], function (_18f, _190, _191, _192) {
				return _18f("dijit.form.ToggleButton", [_191, _192], {
					baseClass: "dijitToggleButton",
					setChecked: function (_193) {
						_190.deprecated("setChecked(" + _193 + ") is deprecated. Use set('checked'," + _193 + ") instead.", "", "2.0");
						this.set("checked", _193);
					}
				});
			});
		},
		"dojo/date/stamp": function () {
			define(["../_base/kernel", "../_base/lang", "../_base/array"], function (dojo, lang, _194) {
				lang.getObject("date.stamp", true, dojo);
				dojo.date.stamp.fromISOString = function (_195, _196) {
					if (!dojo.date.stamp._isoRegExp) {
						dojo.date.stamp._isoRegExp = /^(?:(\d{4})(?:-(\d{2})(?:-(\d{2}))?)?)?(?:T(\d{2}):(\d{2})(?::(\d{2})(.\d+)?)?((?:[+-](\d{2}):(\d{2}))|Z)?)?$/;
					}
					var _197 = dojo.date.stamp._isoRegExp.exec(_195),
						_198 = null;
					if (_197) {
						_197.shift();
						if (_197[1]) {
							_197[1]--;
						}
						if (_197[6]) {
							_197[6] *= 1000;
						}
						if (_196) {
							_196 = new Date(_196);
							_194.forEach(_194.map(["FullYear", "Month", "Date", "Hours", "Minutes", "Seconds", "Milliseconds"], function (prop) {
								return _196["get" + prop]();
							}), function (_199, _19a) {
								_197[_19a] = _197[_19a] || _199;
							});
						}
						_198 = new Date(_197[0] || 1970, _197[1] || 0, _197[2] || 1, _197[3] || 0, _197[4] || 0, _197[5] || 0, _197[6] || 0);
						if (_197[0] < 100) {
							_198.setFullYear(_197[0] || 1970);
						}
						var _19b = 0,
							_19c = _197[7] && _197[7].charAt(0);
						if (_19c != "Z") {
							_19b = ((_197[8] || 0) * 60) + (Number(_197[9]) || 0);
							if (_19c != "-") {
								_19b *= -1;
							}
						}
						if (_19c) {
							_19b -= _198.getTimezoneOffset();
						}
						if (_19b) {
							_198.setTime(_198.getTime() + _19b * 60000);
						}
					}
					return _198;
				};
				dojo.date.stamp.toISOString = function (_19d, _19e) {
					var _19f = function (n) {
						return (n < 10) ? "0" + n : n;
					};
					_19e = _19e || {};
					var _1a0 = [],
						_1a1 = _19e.zulu ? "getUTC" : "get",
						date = "";
					if (_19e.selector != "time") {
						var year = _19d[_1a1 + "FullYear"]();
						date = ["0000".substr((year + "").length) + year, _19f(_19d[_1a1 + "Month"]() + 1), _19f(_19d[_1a1 + "Date"]())].join("-");
					}
					_1a0.push(date);
					if (_19e.selector != "date") {
						var time = [_19f(_19d[_1a1 + "Hours"]()), _19f(_19d[_1a1 + "Minutes"]()), _19f(_19d[_1a1 + "Seconds"]())].join(":");
						var _1a2 = _19d[_1a1 + "Milliseconds"]();
						if (_19e.milliseconds) {
							time += "." + (_1a2 < 100 ? "0" : "") + _19f(_1a2);
						}
						if (_19e.zulu) {
							time += "Z";
						} else {
							if (_19e.selector != "time") {
								var _1a3 = _19d.getTimezoneOffset();
								var _1a4 = Math.abs(_1a3);
								time += (_1a3 > 0 ? "-" : "+") + _19f(Math.floor(_1a4 / 60)) + ":" + _19f(_1a4 % 60);
							}
						}
						_1a0.push(time);
					}
					return _1a0.join("T");
				};
				return dojo.date.stamp;
			});
		},
		"dojo/Stateful": function () {
			define(["./_base/kernel", "./_base/declare", "./_base/lang", "./_base/array"], function (dojo, _1a5, lang, _1a6) {
				return dojo.declare("dojo.Stateful", null, {
					postscript: function (_1a7) {
						if (_1a7) {
							lang.mixin(this, _1a7);
						}
					},
					get: function (name) {
						return this[name];
					},
					set: function (name, _1a8) {
						if (typeof name === "object") {
							for (var x in name) {
								this.set(x, name[x]);
							}
							return this;
						}
						var _1a9 = this[name];
						this[name] = _1a8;
						if (this._watchCallbacks) {
							this._watchCallbacks(name, _1a9, _1a8);
						}
						return this;
					},
					watch: function (name, _1aa) {
						var _1ab = this._watchCallbacks;
						if (!_1ab) {
							var self = this;
							_1ab = this._watchCallbacks = function (name, _1ac, _1ad, _1ae) {
								var _1af = function (_1b0) {
									if (_1b0) {
										_1b0 = _1b0.slice();
										for (var i = 0, l = _1b0.length; i < l; i++) {
											try {
												_1b0[i].call(self, name, _1ac, _1ad);
											} catch (e) {
												console.error(e);
											}
										}
									}
								};
								_1af(_1ab["_" + name]);
								if (!_1ae) {
									_1af(_1ab["*"]);
								}
							};
						}
						if (!_1aa && typeof name === "function") {
							_1aa = name;
							name = "*";
						} else {
							name = "_" + name;
						}
						var _1b1 = _1ab[name];
						if (typeof _1b1 !== "object") {
							_1b1 = _1ab[name] = [];
						}
						_1b1.push(_1aa);
						return {
							unwatch: function () {
								_1b1.splice(_1a6.indexOf(_1b1, _1aa), 1);
							}
						};
					}
				});
			});
		},
		"dijit/form/_AutoCompleterMixin": function () {
			define("dijit/form/_AutoCompleterMixin", ["dojo/_base/connect", "dojo/data/util/filter", "dojo/_base/declare", "dojo/_base/Deferred", "dojo/dom-attr", "dojo/_base/event", "dojo/keys", "dojo/_base/lang", "dojo/query", "dojo/regexp", "dojo/_base/sniff", "dojo/string", "dojo/_base/window", "./DataList", "../registry", "./_TextBoxMixin"], function (_1b2, _1b3, _1b4, _1b5, _1b6, _1b7, keys, lang, _1b8, _1b9, has, _1ba, win, _1bb, _1bc, _1bd) {
				return _1b4("dijit.form._AutoCompleterMixin", null, {
					item: null,
					pageSize: Infinity,
					store: null,
					fetchProperties: {},
					query: {},
					autoComplete: true,
					highlightMatch: "first",
					searchDelay: 100,
					searchAttr: "name",
					labelAttr: "",
					labelType: "text",
					queryExpr: "${0}*",
					ignoreCase: true,
					maxHeight: -1,
					_stopClickEvents: false,
					_getCaretPos: function (_1be) {
						var pos = 0;
						if (typeof (_1be.selectionStart) == "number") {
							pos = _1be.selectionStart;
						} else {
							if (has("ie")) {
								var tr = win.doc.selection.createRange().duplicate();
								var ntr = _1be.createTextRange();
								tr.move("character", 0);
								ntr.move("character", 0);
								try {
									ntr.setEndPoint("EndToEnd", tr);
									pos = String(ntr.text).replace(/\r/g, "").length;
								} catch (e) {}
							}
						}
						return pos;
					},
					_setCaretPos: function (_1bf, _1c0) {
						_1c0 = parseInt(_1c0);
						_1bd.selectInputText(_1bf, _1c0, _1c0);
					},
					_setDisabledAttr: function (_1c1) {
						this.inherited(arguments);
						this.domNode.setAttribute("aria-disabled", _1c1);
					},
					_abortQuery: function () {
						if (this.searchTimer) {
							clearTimeout(this.searchTimer);
							this.searchTimer = null;
						}
						if (this._fetchHandle) {
							if (this._fetchHandle.cancel) {
								this._cancelingQuery = true;
								this._fetchHandle.cancel();
								this._cancelingQuery = false;
							}
							this._fetchHandle = null;
						}
					},
					_onInput: function (evt) {
						this.inherited(arguments);
						if (evt.charOrCode == 229) {
							this._onKey(evt);
						}
					},
					_onKey: function (evt) {
						var key = evt.charOrCode;
						if (evt.altKey || ((evt.ctrlKey || evt.metaKey) && (key != "x" && key != "v")) || key == keys.SHIFT) {
							return;
						}
						var _1c2 = false;
						var pw = this.dropDown;
						var _1c3 = null;
						this._prev_key_backspace = false;
						this._abortQuery();
						this.inherited(arguments);
						if (this._opened) {
							_1c3 = pw.getHighlightedOption();
						}
						switch (key) {
							case keys.PAGE_DOWN:
							case keys.DOWN_ARROW:
							case keys.PAGE_UP:
							case keys.UP_ARROW:
								if (this._opened) {
									this._announceOption(_1c3);
								}
								_1b7.stop(evt);
								break;
							case keys.ENTER:
								if (_1c3) {
									if (_1c3 == pw.nextButton) {
										this._nextSearch(1);
										_1b7.stop(evt);
										break;
									} else {
										if (_1c3 == pw.previousButton) {
											this._nextSearch(-1);
											_1b7.stop(evt);
											break;
										}
									}
								} else {
									this._setBlurValue();
									this._setCaretPos(this.focusNode, this.focusNode.value.length);
								}
								if (this._opened || this._fetchHandle) {
									_1b7.stop(evt);
								}
								case keys.TAB:
									var _1c4 = this.get("displayedValue");
									if (pw && (_1c4 == pw._messages["previousMessage"] || _1c4 == pw._messages["nextMessage"])) {
										break;
									}
									if (_1c3) {
										this._selectOption(_1c3);
									}
									case keys.ESCAPE:
										if (this._opened) {
											this._lastQuery = null;
											this.closeDropDown();
										}
										break;
									case " ":
										if (_1c3) {
											_1b7.stop(evt);
											this._selectOption(_1c3);
											this.closeDropDown();
										} else {
											_1c2 = true;
										}
										break;
									case keys.DELETE:
									case keys.BACKSPACE:
										this._prev_key_backspace = true;
										_1c2 = true;
										break;
									default:
										_1c2 = typeof key == "string" || key == 229;
						}
						if (_1c2) {
							this.item = undefined;
							this.searchTimer = setTimeout(lang.hitch(this, "_startSearchFromInput"), 1);
						}
					},
					_autoCompleteText: function (text) {
						var fn = this.focusNode;
						_1bd.selectInputText(fn, fn.value.length);
						var _1c5 = this.ignoreCase ? "toLowerCase" : "substr";
						if (text[_1c5](0).indexOf(this.focusNode.value[_1c5](0)) == 0) {
							var cpos = this.autoComplete ? this._getCaretPos(fn) : fn.value.length;
							if ((cpos + 1) > fn.value.length) {
								fn.value = text;
								_1bd.selectInputText(fn, cpos);
							}
						} else {
							fn.value = text;
							_1bd.selectInputText(fn);
						}
					},
					_openResultList: function (_1c6, _1c7, _1c8) {
						this._fetchHandle = null;
						if (this.disabled || this.readOnly || (_1c7[this.searchAttr] !== this._lastQuery)) {
							return;
						}
						var _1c9 = this.dropDown.getHighlightedOption();
						this.dropDown.clearResultList();
						if (!_1c6.length && _1c8.start == 0) {
							this.closeDropDown();
							return;
						}
						var _1ca = this.dropDown.createOptions(_1c6, _1c8, lang.hitch(this, "_getMenuLabelFromItem"));
						this._showResultList();
						if (_1c8.direction) {
							if (1 == _1c8.direction) {
								this.dropDown.highlightFirstOption();
							} else {
								if (-1 == _1c8.direction) {
									this.dropDown.highlightLastOption();
								}
							}
							if (_1c9) {
								this._announceOption(this.dropDown.getHighlightedOption());
							}
						} else {
							if (this.autoComplete && !this._prev_key_backspace && !/^[*]+$/.test(_1c7[this.searchAttr].toString())) {
								this._announceOption(_1ca[1]);
							}
						}
					},
					_showResultList: function () {
						this.closeDropDown(true);
						this.openDropDown();
						this.domNode.setAttribute("aria-expanded", "true");
					},
					loadDropDown: function () {
						this._startSearchAll();
					},
					isLoaded: function () {
						return false;
					},
					closeDropDown: function () {
						this._abortQuery();
						if (this._opened) {
							this.inherited(arguments);
							this.domNode.setAttribute("aria-expanded", "false");
							this.focusNode.removeAttribute("aria-activedescendant");
						}
					},
					_setBlurValue: function () {
						var _1cb = this.get("displayedValue");
						var pw = this.dropDown;
						if (pw && (_1cb == pw._messages["previousMessage"] || _1cb == pw._messages["nextMessage"])) {
							this._setValueAttr(this._lastValueReported, true);
						} else {
							if (typeof this.item == "undefined") {
								this.item = null;
								this.set("displayedValue", _1cb);
							} else {
								if (this.value != this._lastValueReported) {
									this._handleOnChange(this.value, true);
								}
								this._refreshState();
							}
						}
					},
					_setItemAttr: function (item, _1cc, _1cd) {
						var _1ce = "";
						if (item) {
							if (!_1cd) {
								_1cd = this.store._oldAPI ? this.store.getValue(item, this.searchAttr) : item[this.searchAttr];
							}
							_1ce = this._getValueField() != this.searchAttr ? this.store.getIdentity(item) : _1cd;
						}
						this.set("value", _1ce, _1cc, _1cd, item);
					},
					_announceOption: function (node) {
						if (!node) {
							return;
						}
						var _1cf;
						if (node == this.dropDown.nextButton || node == this.dropDown.previousButton) {
							_1cf = node.innerHTML;
							this.item = undefined;
							this.value = "";
						} else {
							_1cf = (this.store._oldAPI ? this.store.getValue(node.item, this.searchAttr) : node.item[this.searchAttr]).toString();
							this.set("item", node.item, false, _1cf);
						}
						this.focusNode.value = this.focusNode.value.substring(0, this._lastInput.length);
						this.focusNode.setAttribute("aria-activedescendant", _1b6.get(node, "id"));
						this._autoCompleteText(_1cf);
					},
					_selectOption: function (_1d0) {
						this.closeDropDown();
						if (_1d0) {
							this._announceOption(_1d0);
						}
						this._setCaretPos(this.focusNode, this.focusNode.value.length);
						this._handleOnChange(this.value, true);
					},
					_startSearchAll: function () {
						this._startSearch("");
					},
					_startSearchFromInput: function () {
						this._startSearch(this.focusNode.value.replace(/([\\\*\?])/g, "\\$1"));
					},
					_getQueryString: function (text) {
						return _1ba.substitute(this.queryExpr, [text]);
					},
					_startSearch: function (key) {
						if (!this.dropDown) {
							var _1d1 = this.id + "_popup",
								_1d2 = lang.isString(this.dropDownClass) ? lang.getObject(this.dropDownClass, false) : this.dropDownClass;
							this.dropDown = new _1d2({
								onChange: lang.hitch(this, this._selectOption),
								id: _1d1,
								dir: this.dir,
								textDir: this.textDir
							});
							this.focusNode.removeAttribute("aria-activedescendant");
							this.textbox.setAttribute("aria-owns", _1d1);
						}
						this._lastInput = key;
						var _1d3 = lang.clone(this.query);
						var _1d4 = {
							start: 0,
							count: this.pageSize,
							queryOptions: {
								ignoreCase: this.ignoreCase,
								deep: true
							}
						};
						lang.mixin(_1d4, this.fetchProperties);
						var qs = this._getQueryString(key),
							q;
						if (this.store._oldAPI) {
							q = qs;
						} else {
							q = _1b3.patternToRegExp(qs, this.ignoreCase);
							q.toString = function () {
								return qs;
							};
						}
						this._lastQuery = _1d3[this.searchAttr] = q;
						var _1d5 = this,
							_1d6 = function () {
								var _1d7 = _1d5._fetchHandle = _1d5.store.query(_1d3, _1d4);
								_1b5.when(_1d7, function (res) {
									_1d5._fetchHandle = null;
									res.total = _1d7.total;
									_1d5._openResultList(res, _1d3, _1d4);
								}, function (err) {
									_1d5._fetchHandle = null;
									if (!_1d5._cancelingQuery) {
										console.error(_1d5.declaredClass + " " + err.toString());
										_1d5.closeDropDown();
									}
								});
							};
						this.searchTimer = setTimeout(lang.hitch(this, function (_1d8, _1d9) {
							this.searchTimer = null;
							_1d6();
							this._nextSearch = this.dropDown.onPage = function (_1da) {
								_1d4.start += _1d4.count * _1da;
								_1d4.direction = _1da;
								_1d6();
								_1d9.focus();
							};
						}, _1d3, this), this.searchDelay);
					},
					_getValueField: function () {
						return this.searchAttr;
					},
					constructor: function () {
						this.query = {};
						this.fetchProperties = {};
					},
					postMixInProperties: function () {
						if (!this.store) {
							var _1db = this.srcNodeRef;
							var list = this.list;
							if (list) {
								this.store = _1bc.byId(list);
							} else {
								this.store = new _1bb({}, _1db);
							}
							if (!("value" in this.params)) {
								var item = (this.item = this.store.fetchSelectedItem());
								if (item) {
									var _1dc = this._getValueField();
									this.value = this.store._oldAPI ? this.store.getValue(item, _1dc) : item[_1dc];
								}
							}
						}
						this.inherited(arguments);
					},
					postCreate: function () {
						var _1dd = _1b8("label[for=\"" + this.id + "\"]");
						if (_1dd.length) {
							_1dd[0].id = (this.id + "_label");
							this.domNode.setAttribute("aria-labelledby", _1dd[0].id);
						}
						this.inherited(arguments);
					},
					_getMenuLabelFromItem: function (item) {
						var _1de = this.labelFunc(item, this.store),
							_1df = this.labelType;
						if (this.highlightMatch != "none" && this.labelType == "text" && this._lastInput) {
							_1de = this.doHighlight(_1de, this._escapeHtml(this._lastInput));
							_1df = "html";
						}
						return {
							html: _1df == "html",
							label: _1de
						};
					},
					doHighlight: function (_1e0, find) {
						var _1e1 = (this.ignoreCase ? "i" : "") + (this.highlightMatch == "all" ? "g" : ""),
							i = this.queryExpr.indexOf("${0}");
						find = _1b9.escapeString(find);
						return this._escapeHtml(_1e0).replace(new RegExp((i == 0 ? "^" : "") + "(" + find + ")" + (i == (this.queryExpr.length - 4) ? "$" : ""), _1e1), "<span class=\"dijitComboBoxHighlightMatch\">$1</span>");
					},
					_escapeHtml: function (str) {
						str = String(str).replace(/&/gm, "&amp;").replace(/</gm, "&lt;").replace(/>/gm, "&gt;").replace(/"/gm, "&quot;");
						return str;
					},
					reset: function () {
						this.item = null;
						this.inherited(arguments);
					},
					labelFunc: function (item, _1e2) {
						return (_1e2._oldAPI ? _1e2.getValue(item, this.labelAttr || this.searchAttr) : item[this.labelAttr || this.searchAttr]).toString();
					},
					_setValueAttr: function (_1e3, _1e4, _1e5, item) {
						this._set("item", item || null);
						if (!_1e3) {
							_1e3 = "";
						}
						this.inherited(arguments);
					},
					_setTextDirAttr: function (_1e6) {
						this.inherited(arguments);
						if (this.dropDown) {
							this.dropDown._set("textDir", _1e6);
						}
					}
				});
			});
		},
		"dijit/form/ComboBoxMixin": function () {
			require({
				cache: {
					"url:dijit/form/templates/DropDownBox.html": "<div class=\"dijit dijitReset dijitInline dijitLeft\"\r\n\tid=\"widget_${id}\"\r\n\trole=\"combobox\"\r\n\t><div class='dijitReset dijitRight dijitButtonNode dijitArrowButton dijitDownArrowButton dijitArrowButtonContainer'\r\n\t\tdata-dojo-attach-point=\"_buttonNode, _popupStateNode\" role=\"presentation\"\r\n\t\t><input class=\"dijitReset dijitInputField dijitArrowButtonInner\" value=\"&#9660; \" type=\"text\" tabIndex=\"-1\" readonly=\"readonly\" role=\"presentation\"\r\n\t\t\t${_buttonInputDisabled}\r\n\t/></div\r\n\t><div class='dijitReset dijitValidationContainer'\r\n\t\t><input class=\"dijitReset dijitInputField dijitValidationIcon dijitValidationInner\" value=\"&#935; \" type=\"text\" tabIndex=\"-1\" readonly=\"readonly\" role=\"presentation\"\r\n\t/></div\r\n\t><div class=\"dijitReset dijitInputField dijitInputContainer\"\r\n\t\t><input class='dijitReset dijitInputInner' ${!nameAttrSetting} type=\"text\" autocomplete=\"off\"\r\n\t\t\tdata-dojo-attach-point=\"textbox,focusNode\" role=\"textbox\" aria-haspopup=\"true\"\r\n\t/></div\r\n></div>\r\n"
				}
			});
			define("dijit/form/ComboBoxMixin", ["dojo/_base/declare", "dojo/_base/Deferred", "dojo/_base/kernel", "dojo/_base/lang", "dojo/store/util/QueryResults", "./_AutoCompleterMixin", "./_ComboBoxMenu", "../_HasDropDown", "dojo/text!./templates/DropDownBox.html"], function (_1e7, _1e8, _1e9, lang, _1ea, _1eb, _1ec, _1ed, _1ee) {
				return _1e7("dijit.form.ComboBoxMixin", [_1ed, _1eb], {
					dropDownClass: _1ec,
					hasDownArrow: true,
					templateString: _1ee,
					baseClass: "dijitTextBox dijitComboBox",
					cssStateNodes: {
						"_buttonNode": "dijitDownArrowButton"
					},
					_setHasDownArrowAttr: function (val) {
						this._set("hasDownArrow", val);
						this._buttonNode.style.display = val ? "" : "none";
					},
					_showResultList: function () {
						this.displayMessage("");
						this.inherited(arguments);
					},
					_setStoreAttr: function (_1ef) {
						if (!_1ef.get) {
							lang.mixin(_1ef, {
								_oldAPI: true,
								get: function (id) {
									var _1f0 = new _1e8();
									this.fetchItemByIdentity({
										identity: id,
										onItem: function (_1f1) {
											_1f0.resolve(_1f1);
										},
										onError: function (_1f2) {
											_1f0.reject(_1f2);
										}
									});
									return _1f0.promise;
								},
								query: function (_1f3, _1f4) {
									var _1f5 = new _1e8(function () {
										_1f6.abort && _1f6.abort();
									});
									var _1f6 = this.fetch(lang.mixin({
										query: _1f3,
										onBegin: function (_1f7) {
											_1f5.total = _1f7;
										},
										onComplete: function (_1f8) {
											_1f5.resolve(_1f8);
										},
										onError: function (_1f9) {
											_1f5.reject(_1f9);
										}
									}, _1f4));
									return _1ea(_1f5);
								}
							});
						}
						this._set("store", _1ef);
					},
					postMixInProperties: function () {
						if (this.params.store) {
							this._setStoreAttr(this.params.store);
						}
						this.inherited(arguments);
						if (!this.params.store) {
							var _1fa = this.declaredClass;
							lang.mixin(this.store, {
								getValue: function (item, attr) {
									_1e9.deprecated(_1fa + ".store.getValue(item, attr) is deprecated for builtin store.  Use item.attr directly", "", "2.0");
									return item[attr];
								},
								getLabel: function (item) {
									_1e9.deprecated(_1fa + ".store.getLabel(item) is deprecated for builtin store.  Use item.label directly", "", "2.0");
									return item.name;
								},
								fetch: function (args) {
									_1e9.deprecated(_1fa + ".store.fetch() is deprecated for builtin store.", "Use store.query()", "2.0");
									var shim = ["dojo/data/ObjectStore"];
									require(shim, lang.hitch(this, function (_1fb) {
										new _1fb({
											objectStore: this
										}).fetch(args);
									}));
								}
							});
						}
					}
				});
			});
		},
		"dijit/form/_TextBoxMixin": function () {
			define("dijit/form/_TextBoxMixin", ["dojo/_base/array", "dojo/_base/declare", "dojo/dom", "dojo/_base/event", "dojo/keys", "dojo/_base/lang", ".."], function (_1fc, _1fd, dom, _1fe, keys, lang, _1ff) {
				var _200 = _1fd("dijit.form._TextBoxMixin", null, {
					trim: false,
					uppercase: false,
					lowercase: false,
					propercase: false,
					maxLength: "",
					selectOnClick: false,
					placeHolder: "",
					_getValueAttr: function () {
						return this.parse(this.get("displayedValue"), this.constraints);
					},
					_setValueAttr: function (_201, _202, _203) {
						var _204;
						if (_201 !== undefined) {
							_204 = this.filter(_201);
							if (typeof _203 != "string") {
								if (_204 !== null && ((typeof _204 != "number") || !isNaN(_204))) {
									_203 = this.filter(this.format(_204, this.constraints));
								} else {
									_203 = "";
								}
							}
						}
						if (_203 != null && _203 != undefined && ((typeof _203) != "number" || !isNaN(_203)) && this.textbox.value != _203) {
							this.textbox.value = _203;
							this._set("displayedValue", this.get("displayedValue"));
						}
						if (this.textDir == "auto") {
							this.applyTextDir(this.focusNode, _203);
						}
						this.inherited(arguments, [_204, _202]);
					},
					displayedValue: "",
					_getDisplayedValueAttr: function () {
						return this.filter(this.textbox.value);
					},
					_setDisplayedValueAttr: function (_205) {
						if (_205 === null || _205 === undefined) {
							_205 = "";
						} else {
							if (typeof _205 != "string") {
								_205 = String(_205);
							}
						}
						this.textbox.value = _205;
						this._setValueAttr(this.get("value"), undefined);
						this._set("displayedValue", this.get("displayedValue"));
						if (this.textDir == "auto") {
							this.applyTextDir(this.focusNode, _205);
						}
					},
					format: function (_206) {
						return ((_206 == null || _206 == undefined) ? "" : (_206.toString ? _206.toString() : _206));
					},
					parse: function (_207) {
						return _207;
					},
					_refreshState: function () {},
					onInput: function () {},
					__skipInputEvent: false,
					_onInput: function () {
						if (this.textDir == "auto") {
							this.applyTextDir(this.focusNode, this.focusNode.value);
						}
						this._refreshState();
						this._set("displayedValue", this.get("displayedValue"));
					},
					postCreate: function () {
						this.textbox.setAttribute("value", this.textbox.value);
						this.inherited(arguments);
						var _208 = function (e) {
							var _209 = e.charOrCode || e.keyCode || 229;
							if (e.type == "keydown") {
								switch (_209) {
									case keys.SHIFT:
									case keys.ALT:
									case keys.CTRL:
									case keys.META:
									case keys.CAPS_LOCK:
										return;
									default:
										if (_209 >= 65 && _209 <= 90) {
											return;
										}
								}
							}
							if (e.type == "keypress" && typeof _209 != "string") {
								return;
							}
							if (e.type == "input") {
								if (this.__skipInputEvent) {
									this.__skipInputEvent = false;
									return;
								}
							} else {
								this.__skipInputEvent = true;
							}
							var faux = lang.mixin({}, e, {
								charOrCode: _209,
								wasConsumed: false,
								preventDefault: function () {
									faux.wasConsumed = true;
									e.preventDefault();
								},
								stopPropagation: function () {
									e.stopPropagation();
								}
							});
							if (this.onInput(faux) === false) {
								_1fe.stop(faux);
							}
							if (faux.wasConsumed) {
								return;
							}
							setTimeout(lang.hitch(this, "_onInput", faux), 0);
						};
						_1fc.forEach(["onkeydown", "onkeypress", "onpaste", "oncut", "oninput"], function (_20a) {
							this.connect(this.textbox, _20a, _208);
						}, this);
					},
					_blankValue: "",
					filter: function (val) {
						if (val === null) {
							return this._blankValue;
						}
						if (typeof val != "string") {
							return val;
						}
						if (this.trim) {
							val = lang.trim(val);
						}
						if (this.uppercase) {
							val = val.toUpperCase();
						}
						if (this.lowercase) {
							val = val.toLowerCase();
						}
						if (this.propercase) {
							val = val.replace(/[^\s]+/g, function (word) {
								return word.substring(0, 1).toUpperCase() + word.substring(1);
							});
						}
						return val;
					},
					_setBlurValue: function () {
						this._setValueAttr(this.get("value"), true);
					},
					_onBlur: function (e) {
						if (this.disabled) {
							return;
						}
						this._setBlurValue();
						this.inherited(arguments);
						if (this._selectOnClickHandle) {
							this.disconnect(this._selectOnClickHandle);
						}
					},
					_isTextSelected: function () {
						return this.textbox.selectionStart == this.textbox.selectionEnd;
					},
					_onFocus: function (by) {
						if (this.disabled || this.readOnly) {
							return;
						}
						if (this.selectOnClick && by == "mouse") {
							this._selectOnClickHandle = this.connect(this.domNode, "onmouseup", function () {
								this.disconnect(this._selectOnClickHandle);
								if (this._isTextSelected()) {
									_200.selectInputText(this.textbox);
								}
							});
						}
						this.inherited(arguments);
						this._refreshState();
					},
					reset: function () {
						this.textbox.value = "";
						this.inherited(arguments);
					},
					_setTextDirAttr: function (_20b) {
						if (!this._created || this.textDir != _20b) {
							this._set("textDir", _20b);
							this.applyTextDir(this.focusNode, this.focusNode.value);
						}
					}
				});
				_200._setSelectionRange = _1ff._setSelectionRange = function (_20c, _20d, stop) {
					if (_20c.setSelectionRange) {
						_20c.setSelectionRange(_20d, stop);
					}
				};
				_200.selectInputText = _1ff.selectInputText = function (_20e, _20f, stop) {
					_20e = dom.byId(_20e);
					if (isNaN(_20f)) {
						_20f = 0;
					}
					if (isNaN(stop)) {
						stop = _20e.value ? _20e.value.length : 0;
					}
					try {
						_20e.focus();
						_200._setSelectionRange(_20e, _20f, stop);
					} catch (e) {}
				};
				return _200;
			});
		},
		"dijit/form/RadioButton": function () {
			define("dijit/form/RadioButton", ["dojo/_base/declare", "./CheckBox", "./_RadioButtonMixin"], function (_210, _211, _212) {
				return _210("dijit.form.RadioButton", [_211, _212], {
					baseClass: "dijitRadio"
				});
			});
		},
		"dijit/main": function () {
			define("dijit/main", ["dojo/_base/kernel"], function (dojo) {
				return dojo.dijit;
			});
		},
		"dijit/_OnDijitClickMixin": function () {
			define("dijit/_OnDijitClickMixin", ["dojo/on", "dojo/_base/array", "dojo/keys", "dojo/_base/declare", "dojo/_base/sniff", "dojo/_base/unload", "dojo/_base/window"], function (on, _213, keys, _214, has, _215, win) {
				var _216 = null;
				if (has("ie")) {
					(function () {
						var _217 = function (evt) {
							_216 = evt.srcElement;
						};
						win.doc.attachEvent("onkeydown", _217);
						_215.addOnWindowUnload(function () {
							win.doc.detachEvent("onkeydown", _217);
						});
					})();
				} else {
					win.doc.addEventListener("keydown", function (evt) {
						_216 = evt.target;
					}, true);
				}
				var _218 = function (node, _219) {
					if (/input|button/i.test(node.nodeName)) {
						return on(node, "click", _219);
					} else {
						function _21a(e) {
							return (e.keyCode == keys.ENTER || e.keyCode == keys.SPACE) && !e.ctrlKey && !e.shiftKey && !e.altKey && !e.metaKey;
						};
						var _21b = [on(node, "keypress", function (e) {
							if (_21a(e)) {
								_216 = e.target;
								e.preventDefault();
							}
						}), on(node, "keyup", function (e) {
							if (_21a(e) && e.target == _216) {
								_216 = null;
								_219.call(this, e);
							}
						}), on(node, "click", function (e) {
							_219.call(this, e);
						})];
						return {
							remove: function () {
								_213.forEach(_21b, function (h) {
									h.remove();
								});
							}
						};
					}
				};
				return _214("dijit._OnDijitClickMixin", null, {
					connect: function (obj, _21c, _21d) {
						return this.inherited(arguments, [obj, _21c == "ondijitclick" ? _218 : _21c, _21d]);
					}
				});
			});
		},
		"dojo/dnd/autoscroll": function () {
			define(["../main", "../window"], function (dojo) {
				dojo.getObject("dnd", true, dojo);
				dojo.dnd.getViewport = dojo.window.getBox;
				dojo.dnd.V_TRIGGER_AUTOSCROLL = 32;
				dojo.dnd.H_TRIGGER_AUTOSCROLL = 32;
				dojo.dnd.V_AUTOSCROLL_VALUE = 16;
				dojo.dnd.H_AUTOSCROLL_VALUE = 16;
				dojo.dnd.autoScroll = function (e) {
					var v = dojo.window.getBox(),
						dx = 0,
						dy = 0;
					if (e.clientX < dojo.dnd.H_TRIGGER_AUTOSCROLL) {
						dx = -dojo.dnd.H_AUTOSCROLL_VALUE;
					} else {
						if (e.clientX > v.w - dojo.dnd.H_TRIGGER_AUTOSCROLL) {
							dx = dojo.dnd.H_AUTOSCROLL_VALUE;
						}
					}
					if (e.clientY < dojo.dnd.V_TRIGGER_AUTOSCROLL) {
						dy = -dojo.dnd.V_AUTOSCROLL_VALUE;
					} else {
						if (e.clientY > v.h - dojo.dnd.V_TRIGGER_AUTOSCROLL) {
							dy = dojo.dnd.V_AUTOSCROLL_VALUE;
						}
					}
					window.scrollBy(dx, dy);
				};
				dojo.dnd._validNodes = {
					"div": 1,
					"p": 1,
					"td": 1
				};
				dojo.dnd._validOverflow = {
					"auto": 1,
					"scroll": 1
				};
				dojo.dnd.autoScrollNodes = function (e) {
					var b, t, w, h, rx, ry, dx = 0,
						dy = 0,
						_21e, _21f;
					for (var n = e.target; n;) {
						if (n.nodeType == 1 && (n.tagName.toLowerCase() in dojo.dnd._validNodes)) {
							var s = dojo.getComputedStyle(n),
								_220 = (s.overflow.toLowerCase() in dojo.dnd._validOverflow),
								_221 = (s.overflowX.toLowerCase() in dojo.dnd._validOverflow),
								_222 = (s.overflowY.toLowerCase() in dojo.dnd._validOverflow);
							if (_220 || _221 || _222) {
								b = dojo._getContentBox(n, s);
								t = dojo.position(n, true);
							}
							if (_220 || _221) {
								w = Math.min(dojo.dnd.H_TRIGGER_AUTOSCROLL, b.w / 2);
								rx = e.pageX - t.x;
								if (dojo.isWebKit || dojo.isOpera) {
									rx += dojo.body().scrollLeft;
								}
								dx = 0;
								if (rx > 0 && rx < b.w) {
									if (rx < w) {
										dx = -w;
									} else {
										if (rx > b.w - w) {
											dx = w;
										}
									}
									_21e = n.scrollLeft;
									n.scrollLeft = n.scrollLeft + dx;
								}
							}
							if (_220 || _222) {
								h = Math.min(dojo.dnd.V_TRIGGER_AUTOSCROLL, b.h / 2);
								ry = e.pageY - t.y;
								if (dojo.isWebKit || dojo.isOpera) {
									ry += dojo.body().scrollTop;
								}
								dy = 0;
								if (ry > 0 && ry < b.h) {
									if (ry < h) {
										dy = -h;
									} else {
										if (ry > b.h - h) {
											dy = h;
										}
									}
									_21f = n.scrollTop;
									n.scrollTop = n.scrollTop + dy;
								}
							}
							if (dx || dy) {
								return;
							}
						}
						try {
							n = n.parentNode;
						} catch (x) {
							n = null;
						}
					}
					dojo.dnd.autoScroll(e);
				};
				return dojo.dnd;
			});
		},
		"dijit/form/_RadioButtonMixin": function () {
			define("dijit/form/_RadioButtonMixin", ["dojo/_base/array", "dojo/_base/declare", "dojo/dom-attr", "dojo/_base/event", "dojo/_base/lang", "dojo/query", "dojo/_base/window", "../registry"], function (_223, _224, _225, _226, lang, _227, win, _228) {
				return _224("dijit.form._RadioButtonMixin", null, {
					type: "radio",
					_getRelatedWidgets: function () {
						var ary = [];
						_227("input[type=radio]", this.focusNode.form || win.doc).forEach(lang.hitch(this, function (_229) {
							if (_229.name == this.name && _229.form == this.focusNode.form) {
								var _22a = _228.getEnclosingWidget(_229);
								if (_22a) {
									ary.push(_22a);
								}
							}
						}));
						return ary;
					},
					_setCheckedAttr: function (_22b) {
						this.inherited(arguments);
						if (!this._created) {
							return;
						}
						if (_22b) {
							_223.forEach(this._getRelatedWidgets(), lang.hitch(this, function (_22c) {
								if (_22c != this && _22c.checked) {
									_22c.set("checked", false);
								}
							}));
						}
					},
					_onClick: function (e) {
						if (this.checked || this.disabled) {
							_226.stop(e);
							return false;
						}
						if (this.readOnly) {
							_226.stop(e);
							_223.forEach(this._getRelatedWidgets(), lang.hitch(this, function (_22d) {
								_225.set(this.focusNode || this.domNode, "checked", _22d.checked);
							}));
							return false;
						}
						return this.inherited(arguments);
					}
				});
			});
		},
		"dojo/dnd/TimedMoveable": function () {
			define(["../main", "./Moveable"], function (dojo) {
				var _22e = dojo.dnd.Moveable.prototype.onMove;
				dojo.declare("dojo.dnd.TimedMoveable", dojo.dnd.Moveable, {
					timeout: 40,
					constructor: function (node, _22f) {
						if (!_22f) {
							_22f = {};
						}
						if (_22f.timeout && typeof _22f.timeout == "number" && _22f.timeout >= 0) {
							this.timeout = _22f.timeout;
						}
					},
					onMoveStop: function (_230) {
						if (_230._timer) {
							clearTimeout(_230._timer);
							_22e.call(this, _230, _230._leftTop);
						}
						dojo.dnd.Moveable.prototype.onMoveStop.apply(this, arguments);
					},
					onMove: function (_231, _232) {
						_231._leftTop = _232;
						if (!_231._timer) {
							var _233 = this;
							_231._timer = setTimeout(function () {
								_231._timer = null;
								_22e.call(_233, _231, _231._leftTop);
							}, this.timeout);
						}
					}
				});
				return dojo.dnd.TimedMoveable;
			});
		},
		"dijit/form/_ListMouseMixin": function () {
			define("dijit/form/_ListMouseMixin", ["dojo/_base/declare", "dojo/_base/event", "dojo/touch", "./_ListBase"], function (_234, _235, _236, _237) {
				return _234("dijit.form._ListMouseMixin", _237, {
					postCreate: function () {
						this.inherited(arguments);
						this.connect(this.domNode, _236.press, "_onMouseDown");
						this.connect(this.domNode, _236.release, "_onMouseUp");
						this.connect(this.domNode, "onmouseover", "_onMouseOver");
						this.connect(this.domNode, "onmouseout", "_onMouseOut");
					},
					_onMouseDown: function (evt) {
						_235.stop(evt);
						if (this._hoveredNode) {
							this.onUnhover(this._hoveredNode);
							this._hoveredNode = null;
						}
						this._isDragging = true;
						this._setSelectedAttr(this._getTarget(evt));
					},
					_onMouseUp: function (evt) {
						_235.stop(evt);
						this._isDragging = false;
						var _238 = this._getSelectedAttr();
						var _239 = this._getTarget(evt);
						var _23a = this._hoveredNode;
						if (_238 && _239 == _238) {
							this.onClick(_238);
						} else {
							if (_23a && _239 == _23a) {
								this._setSelectedAttr(_23a);
								this.onClick(_23a);
							}
						}
					},
					_onMouseOut: function () {
						if (this._hoveredNode) {
							this.onUnhover(this._hoveredNode);
							if (this._getSelectedAttr() == this._hoveredNode) {
								this.onSelect(this._hoveredNode);
							}
							this._hoveredNode = null;
						}
						if (this._isDragging) {
							this._cancelDrag = (new Date()).getTime() + 1000;
						}
					},
					_onMouseOver: function (evt) {
						if (this._cancelDrag) {
							var time = (new Date()).getTime();
							if (time > this._cancelDrag) {
								this._isDragging = false;
							}
							this._cancelDrag = null;
						}
						var node = this._getTarget(evt);
						if (!node) {
							return;
						}
						if (this._hoveredNode != node) {
							if (this._hoveredNode) {
								this._onMouseOut({
									target: this._hoveredNode
								});
							}
							if (node && node.parentNode == this.containerNode) {
								if (this._isDragging) {
									this._setSelectedAttr(node);
								} else {
									this._hoveredNode = node;
									this.onHover(node);
								}
							}
						}
					}
				});
			});
		},
		"dojo/cache": function () {
			define(["./_base/kernel", "./text"], function (dojo, text) {
				return dojo.cache;
			});
		},
		"url:dijit/form/templates/DropDownBox.html": "<div class=\"dijit dijitReset dijitInline dijitLeft\"\r\n\tid=\"widget_${id}\"\r\n\trole=\"combobox\"\r\n\t><div class='dijitReset dijitRight dijitButtonNode dijitArrowButton dijitDownArrowButton dijitArrowButtonContainer'\r\n\t\tdata-dojo-attach-point=\"_buttonNode, _popupStateNode\" role=\"presentation\"\r\n\t\t><input class=\"dijitReset dijitInputField dijitArrowButtonInner\" value=\"&#9660; \" type=\"text\" tabIndex=\"-1\" readonly=\"readonly\" role=\"presentation\"\r\n\t\t\t${_buttonInputDisabled}\r\n\t/></div\r\n\t><div class='dijitReset dijitValidationContainer'\r\n\t\t><input class=\"dijitReset dijitInputField dijitValidationIcon dijitValidationInner\" value=\"&#935; \" type=\"text\" tabIndex=\"-1\" readonly=\"readonly\" role=\"presentation\"\r\n\t/></div\r\n\t><div class=\"dijitReset dijitInputField dijitInputContainer\"\r\n\t\t><input class='dijitReset dijitInputInner' ${!nameAttrSetting} type=\"text\" autocomplete=\"off\"\r\n\t\t\tdata-dojo-attach-point=\"textbox,focusNode\" role=\"textbox\" aria-haspopup=\"true\"\r\n\t/></div\r\n></div>\r\n",
		"dijit/ProgressBar": function () {
			require({
				cache: {
					"url:dijit/templates/ProgressBar.html": "<div class=\"dijitProgressBar dijitProgressBarEmpty\" role=\"progressbar\"\r\n\t><div  data-dojo-attach-point=\"internalProgress\" class=\"dijitProgressBarFull\"\r\n\t\t><div class=\"dijitProgressBarTile\" role=\"presentation\"></div\r\n\t\t><span style=\"visibility:hidden\">&#160;</span\r\n\t></div\r\n\t><div data-dojo-attach-point=\"labelNode\" class=\"dijitProgressBarLabel\" id=\"${id}_label\"></div\r\n\t><img data-dojo-attach-point=\"indeterminateHighContrastImage\" class=\"dijitProgressBarIndeterminateHighContrastImage\" alt=\"\"\r\n/></div>\r\n"
				}
			});
			define("dijit/ProgressBar", ["require", "dojo/_base/declare", "dojo/dom-class", "dojo/_base/lang", "dojo/number", "./_Widget", "./_TemplatedMixin", "dojo/text!./templates/ProgressBar.html"], function (_23b, _23c, _23d, lang, _23e, _23f, _240, _241) {
				return _23c("dijit.ProgressBar", [_23f, _240], {
					progress: "0",
					value: "",
					maximum: 100,
					places: 0,
					indeterminate: false,
					label: "",
					name: "",
					templateString: _241,
					_indeterminateHighContrastImagePath: _23b.toUrl("./themes/a11y/indeterminate_progress.gif"),
					postMixInProperties: function () {
						this.inherited(arguments);
						if (!("value" in this.params)) {
							this.value = this.indeterminate ? Infinity : this.progress;
						}
					},
					buildRendering: function () {
						this.inherited(arguments);
						this.indeterminateHighContrastImage.setAttribute("src", this._indeterminateHighContrastImagePath.toString());
						this.update();
					},
					update: function (_242) {
						lang.mixin(this, _242 || {});
						var tip = this.internalProgress,
							ap = this.domNode;
						var _243 = 1;
						if (this.indeterminate) {
							ap.removeAttribute("aria-valuenow");
							ap.removeAttribute("aria-valuemin");
							ap.removeAttribute("aria-valuemax");
						} else {
							if (String(this.progress).indexOf("%") != -1) {
								_243 = Math.min(parseFloat(this.progress) / 100, 1);
								this.progress = _243 * this.maximum;
							} else {
								this.progress = Math.min(this.progress, this.maximum);
								_243 = this.maximum ? this.progress / this.maximum : 0;
							}
							ap.setAttribute("aria-describedby", this.labelNode.id);
							ap.setAttribute("aria-valuenow", this.progress);
							ap.setAttribute("aria-valuemin", 0);
							ap.setAttribute("aria-valuemax", this.maximum);
						}
						this.labelNode.innerHTML = this.report(_243);
						_23d.toggle(this.domNode, "dijitProgressBarIndeterminate", this.indeterminate);
						tip.style.width = (_243 * 100) + "%";
						this.onChange();
					},
					_setValueAttr: function (v) {
						this._set("value", v);
						if (v == Infinity) {
							this.update({
								indeterminate: true
							});
						} else {
							this.update({
								indeterminate: false,
								progress: v
							});
						}
					},
					_setLabelAttr: function (_244) {
						this._set("label", _244);
						this.update();
					},
					_setIndeterminateAttr: function (_245) {
						this.indeterminate = _245;
						this.update();
					},
					report: function (_246) {
						return this.label ? this.label : (this.indeterminate ? "&#160;" : _23e.format(_246, {
							type: "percent",
							places: this.places,
							locale: this.lang
						}));
					},
					onChange: function () {}
				});
			});
		},
		"url:dijit/form/templates/Button.html": "<span class=\"dijit dijitReset dijitInline\" role=\"presentation\"\r\n\t><span class=\"dijitReset dijitInline dijitButtonNode\"\r\n\t\tdata-dojo-attach-event=\"ondijitclick:_onClick\" role=\"presentation\"\r\n\t\t><span class=\"dijitReset dijitStretch dijitButtonContents\"\r\n\t\t\tdata-dojo-attach-point=\"titleNode,focusNode\"\r\n\t\t\trole=\"button\" aria-labelledby=\"${id}_label\"\r\n\t\t\t><span class=\"dijitReset dijitInline dijitIcon\" data-dojo-attach-point=\"iconNode\"></span\r\n\t\t\t><span class=\"dijitReset dijitToggleButtonIconChar\">&#x25CF;</span\r\n\t\t\t><span class=\"dijitReset dijitInline dijitButtonText\"\r\n\t\t\t\tid=\"${id}_label\"\r\n\t\t\t\tdata-dojo-attach-point=\"containerNode\"\r\n\t\t\t></span\r\n\t\t></span\r\n\t></span\r\n\t><input ${!nameAttrSetting} type=\"${type}\" value=\"${value}\" class=\"dijitOffScreen\"\r\n\t\ttabIndex=\"-1\" role=\"presentation\" data-dojo-attach-point=\"valueNode\"\r\n/></span>\r\n",
		"dojo/_base/url": function () {
			define(["./kernel"], function (dojo) {
				var ore = new RegExp("^(([^:/?#]+):)?(//([^/?#]*))?([^?#]*)(\\?([^#]*))?(#(.*))?$"),
					ire = new RegExp("^((([^\\[:]+):)?([^@]+)@)?(\\[([^\\]]+)\\]|([^\\[:]*))(:([0-9]+))?$"),
					_247 = function () {
						var n = null,
							_248 = arguments,
							uri = [_248[0]];
						for (var i = 1; i < _248.length; i++) {
							if (!_248[i]) {
								continue;
							}
							var _249 = new _247(_248[i] + ""),
								_24a = new _247(uri[0] + "");
							if (_249.path == "" && !_249.scheme && !_249.authority && !_249.query) {
								if (_249.fragment != n) {
									_24a.fragment = _249.fragment;
								}
								_249 = _24a;
							} else {
								if (!_249.scheme) {
									_249.scheme = _24a.scheme;
									if (!_249.authority) {
										_249.authority = _24a.authority;
										if (_249.path.charAt(0) != "/") {
											var path = _24a.path.substring(0, _24a.path.lastIndexOf("/") + 1) + _249.path;
											var segs = path.split("/");
											for (var j = 0; j < segs.length; j++) {
												if (segs[j] == ".") {
													if (j == segs.length - 1) {
														segs[j] = "";
													} else {
														segs.splice(j, 1);
														j--;
													}
												} else {
													if (j > 0 && !(j == 1 && segs[0] == "") && segs[j] == ".." && segs[j - 1] != "..") {
														if (j == (segs.length - 1)) {
															segs.splice(j, 1);
															segs[j - 1] = "";
														} else {
															segs.splice(j - 1, 2);
															j -= 2;
														}
													}
												}
											}
											_249.path = segs.join("/");
										}
									}
								}
							}
							uri = [];
							if (_249.scheme) {
								uri.push(_249.scheme, ":");
							}
							if (_249.authority) {
								uri.push("//", _249.authority);
							}
							uri.push(_249.path);
							if (_249.query) {
								uri.push("?", _249.query);
							}
							if (_249.fragment) {
								uri.push("#", _249.fragment);
							}
						}
						this.uri = uri.join("");
						var r = this.uri.match(ore);
						this.scheme = r[2] || (r[1] ? "" : n);
						this.authority = r[4] || (r[3] ? "" : n);
						this.path = r[5];
						this.query = r[7] || (r[6] ? "" : n);
						this.fragment = r[9] || (r[8] ? "" : n);
						if (this.authority != n) {
							r = this.authority.match(ire);
							this.user = r[3] || n;
							this.password = r[4] || n;
							this.host = r[6] || r[7];
							this.port = r[9] || n;
						}
					};
				_247.prototype.toString = function () {
					return this.uri;
				};
				return dojo._Url = _247;
			});
		},
		"dojox/main": function () {
			define("dojox/main", ["dojo/_base/kernel"], function (dojo) {
				return dojo.dojox;
			});
		},
		"dojo/text": function () {
			define(["./_base/kernel", "require", "./has", "./_base/xhr"], function (dojo, _24b, has, xhr) {
				var _24c;
				if (1) {
					_24c = function (url, sync, load) {
						xhr("GET", {
							url: url,
							sync: !!sync,
							load: load
						});
					};
				} else {
					if (_24b.getText) {
						_24c = _24b.getText;
					} else {
						console.error("dojo/text plugin failed to load because loader does not support getText");
					}
				}
				var _24d = {},
					_24e = function (text) {
						if (text) {
							text = text.replace(/^\s*<\?xml(\s)+version=[\'\"](\d)*.(\d)*[\'\"](\s)*\?>/im, "");
							var _24f = text.match(/<body[^>]*>\s*([\s\S]+)\s*<\/body>/im);
							if (_24f) {
								text = _24f[1];
							}
						} else {
							text = "";
						}
						return text;
					},
					_250 = {},
					_251 = {},
					_252 = {
						dynamic: true,
						normalize: function (id, _253) {
							var _254 = id.split("!"),
								url = _254[0];
							return (/^\./.test(url) ? _253(url) : url) + (_254[1] ? "!" + _254[1] : "");
						},
						load: function (id, _255, load) {
							var _256 = id.split("!"),
								_257 = _256.length > 1,
								_258 = _256[0],
								url = _255.toUrl(_256[0]),
								text = _250,
								_259 = function (text) {
									load(_257 ? _24e(text) : text);
								};
							if (_258 in _24d) {
								text = _24d[_258];
							} else {
								if (url in _255.cache) {
									text = _255.cache[url];
								} else {
									if (url in _24d) {
										text = _24d[url];
									}
								}
							}
							if (text === _250) {
								if (_251[url]) {
									_251[url].push(_259);
								} else {
									var _25a = _251[url] = [_259];
									_24c(url, !_255.async, function (text) {
										_24d[_258] = _24d[url] = text;
										for (var i = 0; i < _25a.length;) {
											_25a[i++](text);
										}
										delete _251[url];
									});
								}
							} else {
								_259(text);
							}
						}
					};
				dojo.cache = function (_25b, url, _25c) {
					var key;
					if (typeof _25b == "string") {
						if (/\//.test(_25b)) {
							key = _25b;
							_25c = url;
						} else {
							key = _24b.toUrl(_25b.replace(/\./g, "/") + (url ? ("/" + url) : ""));
						}
					} else {
						key = _25b + "";
						_25c = url;
					}
					var val = (_25c != undefined && typeof _25c != "string") ? _25c.value : _25c,
						_25d = _25c && _25c.sanitize;
					if (typeof val == "string") {
						_24d[key] = val;
						return _25d ? _24e(val) : val;
					} else {
						if (val === null) {
							delete _24d[key];
							return null;
						} else {
							if (!(key in _24d)) {
								_24c(key, true, function (text) {
									_24d[key] = text;
								});
							}
							return _25d ? _24e(_24d[key]) : _24d[key];
						}
					}
				};
				return _252;
			});
		},
		"url:dijit/form/templates/CheckBox.html": "<div class=\"dijit dijitReset dijitInline\" role=\"presentation\"\r\n\t><input\r\n\t \t${!nameAttrSetting} type=\"${type}\" ${checkedAttrSetting}\r\n\t\tclass=\"dijitReset dijitCheckBoxInput\"\r\n\t\tdata-dojo-attach-point=\"focusNode\"\r\n\t \tdata-dojo-attach-event=\"onclick:_onClick\"\r\n/></div>\r\n",
		"oob/encryption/Encryption": function () {
			define(["dojo/_base/lang", "dojo/_base/declare", "dijit/_WidgetBase", "dijit/_TemplatedMixin", "dijit/_WidgetsInTemplateMixin", "../Utils", "dojo/text!./templates/Encryption.html"], function (lang, _25e, _25f, _260, _261, _262, _263) {
				return _25e("oob.encryption.Encryption", [_25f, _260, _261], {
					templateString: _263,
					postCreate: function () {
						this._setEnterFunc();
						this._setNextFunc();
						top.removeAllKeyFiles = this.removeAllKeyFiles;
						this.inherited(arguments);
					},
					_setEnterFunc: function () {
						_262.connectTop("encryptionEnter", this, "onPanelEntered");
					},
					_setNextFunc: function () {
						_262.connectTop("encryptionNext", this, "removeAllKeyFiles");
					},
					licenceOptionSelected: function (_264) {
						var _265 = _264.target || _264.srcElement,
							val = _265.value,
							_266 = (val == "Yes");
						lang.setObject("top.oob.ENCRYPTOPTION", _265.value);
						_262.showMenu("menu_backupdrive", _266);
						_262.showMenu("menu_reinsert2canister", _266);
						this._enableNext(true);
					},
					_enableNext: function (_267) {
						top.enableButton("nextButton", _267);
					},
					setHelpLink: function () {
						top.showHelpLink(true, this.nls.needhelptext);
						top.openHelplink = function () {
							var _268 = top.STARTINGDIR + ["launchpad", "content", top.LOCALE, "helpfiles", _262.getDeviceType(), "tms_encryptionlic.html"].join(top.PATHSEPARATOR);
							top.openURL("file:///" + _268.replace(/\\/g, "/"), "NeedHelp");
						};
					},
					onPanelEntered: function () {
						this.setHelpLink();
						lang.getObject("top.oob.ENCRYPTOPTION") && this._enableNext(true);
					},
					removeAllKeyFiles: function () {
						var _269 = top.STARTINGDIR + ["launchpad", "command", "result", "encryptionkey_*"].join(top.PATHSEPARATOR);
						top.runCommand(command("deleteFile", _269), function () {});
						top.showHelpLink(false);
						_262.navigate2Next();
					}
				});
			});
		},
		"dojo/uacss": function () {
			define(["./dom-geometry", "./_base/lang", "./ready", "./_base/sniff", "./_base/window"], function (_26a, lang, _26b, has, _26c) {
				var html = _26c.doc.documentElement,
					ie = has("ie"),
					_26d = has("opera"),
					maj = Math.floor,
					ff = has("ff"),
					_26e = _26a.boxModel.replace(/-/, ""),
					_26f = {
						"dj_ie": ie,
						"dj_ie6": maj(ie) == 6,
						"dj_ie7": maj(ie) == 7,
						"dj_ie8": maj(ie) == 8,
						"dj_ie9": maj(ie) == 9,
						"dj_quirks": has("quirks"),
						"dj_iequirks": ie && has("quirks"),
						"dj_opera": _26d,
						"dj_khtml": has("khtml"),
						"dj_webkit": has("webkit"),
						"dj_safari": has("safari"),
						"dj_chrome": has("chrome"),
						"dj_gecko": has("mozilla"),
						"dj_ff3": maj(ff) == 3
					};
				_26f["dj_" + _26e] = true;
				var _270 = "";
				for (var clz in _26f) {
					if (_26f[clz]) {
						_270 += clz + " ";
					}
				}
				html.className = lang.trim(html.className + " " + _270);
				_26b(90, function () {
					if (!_26a.isBodyLtr()) {
						var _271 = "dj_rtl dijitRtl " + _270.replace(/ /g, "-rtl ");
						html.className = lang.trim(html.className + " " + _271 + "dj_rtl dijitRtl " + _270.replace(/ /g, "-rtl "));
					}
				});
				return has;
			});
		},
		"oob/WizardWorker": function () {
			define(["dojo/_base/lang", "dojo/_base/declare", "dojo/_base/array", "dojo/dom", "dojo/dom-class", "./Utils", "./tasks/Tasks", "./encryption/Encryption", "./clusterip/IPconfig", "./serviceip/IPconfig", "./usb/USBSteps", "./usb/BackupDrive", "./summary/Summary"], function (lang, _272, _273, dom, _274, _275, _276, _277, _278, _279, _27a, _27b, _27c) {
				var _27d = _272("oob.WizardWorker", null, {
					_CONTENT_WINDOWS: {
						"welcome": {},
						"tasks": {
							widgetClass: _276,
							noStartup: true
						},
						"encryption": {
							widgetClass: _277,
							noStartup: true
						},
						"clusterip": {
							widgetClass: _278,
							noStartup: true
						},
						"serviceip": {
							widgetClass: _279,
							noStartup: true
						},
						"usb": {},
						"poweron": {
							widgetClass: _27a,
							noTitle: true
						},
						"insert2canister": {
							widgetClass: _27a,
							noTitle: true
						},
						"removeusb": {
							widgetClass: _27a,
							noTitle: true
						},
						"backupdrive": {
							widgetClass: _27b,
							noStartup: true
						},
						"reinsert2canister": {},
						"summary": {
							widgetClass: _27c
						}
					},
					_BROWSER_CLASS_MAPPING: {
						"Firefox": "ff",
						"Mozilla": "ff",
						"IExplore": "ie",
						"WebKit": "wk"
					},
					getWindow: function (name) {
						return this._CONTENT_WINDOWS[name];
					},
					loadFrames: function () {
						var name, i = 0,
							_27e = this,
							_27f = _275.objPropsLen(this._CONTENT_WINDOWS);
						for (name in this._CONTENT_WINDOWS) {
							if (name == null) {
								return;
							}
							this.getWindow(name).name = name;
							top.getContentWindow("menu_" + name, function (_280, _281) {
								var _282 = _27e.getWindow(_280.substr(5));
								_282.win = _281.contentWindow;
								_274.add(_282.win.document.body, "prod_" + _275.getDeviceType());
								_274.add(_282.win.document.body, _27e._BROWSER_CLASS_MAPPING[top.BROWSER]);
								_27e.initPanelContent(_282);
								i++;
								if (i == _27f) {
									_27e.wizardPreworks();
								}
							});
						}
					},
					wizardPreworks: function () {
						this.showEncryptionMenus(true);
						var _283 = dom.byId("description", this._CONTENT_WINDOWS["welcome"].win.document);
						_275.Devices.isTb4() && (_283.innerHTML = this._CONTENT_WINDOWS["tasks"].nls.welcomedesctb4);
						_275.Devices.isTMS() && (_283.innerHTML = this._CONTENT_WINDOWS["tasks"].nls.welcomedesctms);
						_275.show(this._CONTENT_WINDOWS["welcome"].win.document.body, true);
					},
					initPanelContent: function (_284) {
						var doc = _284.win.document,
							_285 = dom.byId("nls", doc);
						if (!_285) {
							return;
						}
						_284.nls = _275.getNLSProps(_285);
						if (!_284.noTitle) {
							dom.byId("title", doc).innerHTML = _284.nls.title;
							_284.nls.description && (dom.byId("description", doc).innerHTML = _284.nls.description);
						}
						if (!!_284.widgetClass) {
							_284.widget = new _284.widgetClass({
								nls: _284.nls
							});
							_284.widget.placeAt(dom.byId("panelContent", doc));
							!_284.noStartup && _284.widget.startup();
						}
					},
					showEncryptionMenus: function (_286) {
						var show = false;
						_275.showMenu("menu_encryption", show);
						_275.showMenu("menu_backupdrive", show);
						_275.showMenu("menu_reinsert2canister", show);
					},
					setTitle: function () {
						_275.getDeviceType();
						var _287 = property("PromptTitle");
						top.document.title = _287;
						dom.byId("titleContent", dom.byId("banner", top.root.document).contentWindow.document).innerHTML = _287;
					},
					start: function () {
						this.setTitle();
						this.loadFrames();
					}
				});
				return _27d.instance || (_27d.instance = new _27d());
			});
		},
		"dijit/Tooltip": function () {
			require({
				cache: {
					"url:dijit/templates/Tooltip.html": "<div class=\"dijitTooltip dijitTooltipLeft\" id=\"dojoTooltip\"\r\n\t><div class=\"dijitTooltipContainer dijitTooltipContents\" data-dojo-attach-point=\"containerNode\" role='alert'></div\r\n\t><div class=\"dijitTooltipConnector\" data-dojo-attach-point=\"connectorNode\"></div\r\n></div>\r\n"
				}
			});
			define("dijit/Tooltip", ["dojo/_base/array", "dojo/_base/declare", "dojo/_base/fx", "dojo/dom", "dojo/dom-class", "dojo/dom-geometry", "dojo/dom-style", "dojo/_base/lang", "dojo/_base/sniff", "dojo/_base/window", "./_base/manager", "./place", "./_Widget", "./_TemplatedMixin", "./BackgroundIframe", "dojo/text!./templates/Tooltip.html", "."], function (_288, _289, fx, dom, _28a, _28b, _28c, lang, has, win, _28d, _28e, _28f, _290, _291, _292, _293) {
				var _294 = _289("dijit._MasterTooltip", [_28f, _290], {
					duration: _28d.defaultDuration,
					templateString: _292,
					postCreate: function () {
						win.body().appendChild(this.domNode);
						this.bgIframe = new _291(this.domNode);
						this.fadeIn = fx.fadeIn({
							node: this.domNode,
							duration: this.duration,
							onEnd: lang.hitch(this, "_onShow")
						});
						this.fadeOut = fx.fadeOut({
							node: this.domNode,
							duration: this.duration,
							onEnd: lang.hitch(this, "_onHide")
						});
					},
					show: function (_295, _296, _297, rtl, _298) {
						if (this.aroundNode && this.aroundNode === _296 && this.containerNode.innerHTML == _295) {
							return;
						}
						this.domNode.width = "auto";
						if (this.fadeOut.status() == "playing") {
							this._onDeck = arguments;
							return;
						}
						this.containerNode.innerHTML = _295;
						this.set("textDir", _298);
						this.containerNode.align = rtl ? "right" : "left";
						var pos = _28e.around(this.domNode, _296, _297 && _297.length ? _297 : _299.defaultPosition, !rtl, lang.hitch(this, "orient"));
						var _29a = pos.aroundNodePos;
						if (pos.corner.charAt(0) == "M" && pos.aroundCorner.charAt(0) == "M") {
							this.connectorNode.style.top = _29a.y + ((_29a.h - this.connectorNode.offsetHeight) >> 1) - pos.y + "px";
							this.connectorNode.style.left = "";
						} else {
							if (pos.corner.charAt(1) == "M" && pos.aroundCorner.charAt(1) == "M") {
								this.connectorNode.style.left = _29a.x + ((_29a.w - this.connectorNode.offsetWidth) >> 1) - pos.x + "px";
							} else {
								this.connectorNode.style.left = "";
							}
						}
						_28c.set(this.domNode, "opacity", 0);
						this.fadeIn.play();
						this.isShowingNow = true;
						this.aroundNode = _296;
					},
					orient: function (node, _29b, _29c, _29d, _29e) {
						this.connectorNode.style.top = "";
						var _29f = _29d.w - this.connectorNode.offsetWidth;
						node.className = "dijitTooltip " + {
							"MR-ML": "dijitTooltipRight",
							"ML-MR": "dijitTooltipLeft",
							"TM-BM": "dijitTooltipAbove",
							"BM-TM": "dijitTooltipBelow",
							"BL-TL": "dijitTooltipBelow dijitTooltipABLeft",
							"TL-BL": "dijitTooltipAbove dijitTooltipABLeft",
							"BR-TR": "dijitTooltipBelow dijitTooltipABRight",
							"TR-BR": "dijitTooltipAbove dijitTooltipABRight",
							"BR-BL": "dijitTooltipRight",
							"BL-BR": "dijitTooltipLeft"
						} [_29b + "-" + _29c];
						this.domNode.style.width = "auto";
						var size = _28b.getContentBox(this.domNode);
						var _2a0 = Math.min((Math.max(_29f, 1)), size.w);
						var _2a1 = _2a0 < size.w;
						this.domNode.style.width = _2a0 + "px";
						if (_2a1) {
							this.containerNode.style.overflow = "auto";
							var _2a2 = this.containerNode.scrollWidth;
							this.containerNode.style.overflow = "visible";
							if (_2a2 > _2a0) {
								_2a2 = _2a2 + _28c.get(this.domNode, "paddingLeft") + _28c.get(this.domNode, "paddingRight");
								this.domNode.style.width = _2a2 + "px";
							}
						}
						if (_29c.charAt(0) == "B" && _29b.charAt(0) == "B") {
							var mb = _28b.getMarginBox(node);
							var _2a3 = this.connectorNode.offsetHeight;
							if (mb.h > _29d.h) {
								var _2a4 = _29d.h - ((_29e.h + _2a3) >> 1);
								this.connectorNode.style.top = _2a4 + "px";
								this.connectorNode.style.bottom = "";
							} else {
								this.connectorNode.style.bottom = Math.min(Math.max(_29e.h / 2 - _2a3 / 2, 0), mb.h - _2a3) + "px";
								this.connectorNode.style.top = "";
							}
						} else {
							this.connectorNode.style.top = "";
							this.connectorNode.style.bottom = "";
						}
						return Math.max(0, size.w - _29f);
					},
					_onShow: function () {
						if (has("ie")) {
							this.domNode.style.filter = "";
						}
					},
					hide: function (_2a5) {
						if (this._onDeck && this._onDeck[1] == _2a5) {
							this._onDeck = null;
						} else {
							if (this.aroundNode === _2a5) {
								this.fadeIn.stop();
								this.isShowingNow = false;
								this.aroundNode = null;
								this.fadeOut.play();
							} else {}
						}
					},
					_onHide: function () {
						this.domNode.style.cssText = "";
						this.containerNode.innerHTML = "";
						if (this._onDeck) {
							this.show.apply(this, this._onDeck);
							this._onDeck = null;
						}
					},
					_setAutoTextDir: function (node) {
						this.applyTextDir(node, has("ie") ? node.outerText : node.textContent);
						_288.forEach(node.children, function (_2a6) {
							this._setAutoTextDir(_2a6);
						}, this);
					},
					_setTextDirAttr: function (_2a7) {
						this._set("textDir", typeof _2a7 != "undefined" ? _2a7 : "");
						if (_2a7 == "auto") {
							this._setAutoTextDir(this.containerNode);
						} else {
							this.containerNode.dir = this.textDir;
						}
					}
				});
				_293.showTooltip = function (_2a8, _2a9, _2aa, rtl, _2ab) {
					if (_2aa) {
						_2aa = _288.map(_2aa, function (val) {
							return {
								after: "after-centered",
								before: "before-centered"
							} [val] || val;
						});
					}
					if (!_299._masterTT) {
						_293._masterTT = _299._masterTT = new _294();
					}
					return _299._masterTT.show(_2a8, _2a9, _2aa, rtl, _2ab);
				};
				_293.hideTooltip = function (_2ac) {
					return _299._masterTT && _299._masterTT.hide(_2ac);
				};
				var _299 = _289("dijit.Tooltip", _28f, {
					label: "",
					showDelay: 400,
					connectId: [],
					position: [],
					_setConnectIdAttr: function (_2ad) {
						_288.forEach(this._connections || [], function (_2ae) {
							_288.forEach(_2ae, lang.hitch(this, "disconnect"));
						}, this);
						this._connectIds = _288.filter(lang.isArrayLike(_2ad) ? _2ad : (_2ad ? [_2ad] : []), function (id) {
							return dom.byId(id);
						});
						this._connections = _288.map(this._connectIds, function (id) {
							var node = dom.byId(id);
							return [this.connect(node, "onmouseenter", function (evt) {
								this._onHover(node, evt);
							}), this.connect(node, "onmouseleave", "_onUnHover"), this.connect(node, "onfocus", function (evt) {
								this._onHover(node, evt);
							}), this.connect(node, "onblur", "_onUnHover")];
						}, this);
						this._set("connectId", _2ad);
					},
					addTarget: function (node) {
						var id = node.id || node;
						if (_288.indexOf(this._connectIds, id) == -1) {
							this.set("connectId", this._connectIds.concat(id));
						}
					},
					removeTarget: function (node) {
						var id = node.id || node,
							idx = _288.indexOf(this._connectIds, id);
						if (idx >= 0) {
							this._connectIds.splice(idx, 1);
							this.set("connectId", this._connectIds);
						}
					},
					buildRendering: function () {
						this.inherited(arguments);
						_28a.add(this.domNode, "dijitTooltipData");
					},
					startup: function () {
						this.inherited(arguments);
						var ids = this.connectId;
						_288.forEach(lang.isArrayLike(ids) ? ids : [ids], this.addTarget, this);
					},
					_onHover: function (_2af, e) {
						if (!this._showTimer) {
							this._showTimer = setTimeout(lang.hitch(this, function () {
								this.open(_2af);
							}), this.showDelay);
						}
					},
					_onUnHover: function () {
						if (this._showTimer) {
							clearTimeout(this._showTimer);
							delete this._showTimer;
						}
						this.close();
					},
					open: function (_2b0) {
						if (this._showTimer) {
							clearTimeout(this._showTimer);
							delete this._showTimer;
						}
						_299.show(this.label || this.domNode.innerHTML, _2b0, this.position, !this.isLeftToRight(), this.textDir);
						this._connectNode = _2b0;
						this.onShow(_2b0, this.position);
					},
					close: function () {
						if (this._connectNode) {
							_299.hide(this._connectNode);
							delete this._connectNode;
							this.onHide();
						}
						if (this._showTimer) {
							clearTimeout(this._showTimer);
							delete this._showTimer;
						}
					},
					onShow: function () {},
					onHide: function () {},
					uninitialize: function () {
						this.close();
						this.inherited(arguments);
					}
				});
				_299._MasterTooltip = _294;
				_299.show = _293.showTooltip;
				_299.hide = _293.hideTooltip;
				_299.defaultPosition = ["after-centered", "before-centered"];
				return _299;
			});
		},
		"dojo/string": function () {
			define(["./_base/kernel", "./_base/lang"], function (dojo, lang) {
				lang.getObject("string", true, dojo);
				dojo.string.rep = function (str, num) {
					if (num <= 0 || !str) {
						return "";
					}
					var buf = [];
					for (;;) {
						if (num & 1) {
							buf.push(str);
						}
						if (!(num >>= 1)) {
							break;
						}
						str += str;
					}
					return buf.join("");
				};
				dojo.string.pad = function (text, size, ch, end) {
					if (!ch) {
						ch = "0";
					}
					var out = String(text),
						pad = dojo.string.rep(ch, Math.ceil((size - out.length) / ch.length));
					return end ? out + pad : pad + out;
				};
				dojo.string.substitute = function (_2b1, map, _2b2, _2b3) {
					_2b3 = _2b3 || dojo.global;
					_2b2 = _2b2 ? lang.hitch(_2b3, _2b2) : function (v) {
						return v;
					};
					return _2b1.replace(/\$\{([^\s\:\}]+)(?:\:([^\s\:\}]+))?\}/g, function (_2b4, key, _2b5) {
						var _2b6 = lang.getObject(key, false, map);
						if (_2b5) {
							_2b6 = lang.getObject(_2b5, false, _2b3).call(_2b3, _2b6, key);
						}
						return _2b2(_2b6, key).toString();
					});
				};
				dojo.string.trim = String.prototype.trim ? lang.trim : function (str) {
					str = str.replace(/^\s+/, "");
					for (var i = str.length - 1; i >= 0; i--) {
						if (/\S/.test(str.charAt(i))) {
							str = str.substring(0, i + 1);
							break;
						}
					}
					return str;
				};
				return dojo.string;
			});
		},
		"dijit/form/_FormValueMixin": function () {
			define("dijit/form/_FormValueMixin", ["dojo/_base/declare", "dojo/dom-attr", "dojo/keys", "dojo/_base/sniff", "./_FormWidgetMixin"], function (_2b7, _2b8, keys, has, _2b9) {
				return _2b7("dijit.form._FormValueMixin", _2b9, {
					readOnly: false,
					_setReadOnlyAttr: function (_2ba) {
						_2b8.set(this.focusNode, "readOnly", _2ba);
						this.focusNode.setAttribute("aria-readonly", _2ba);
						this._set("readOnly", _2ba);
					},
					postCreate: function () {
						this.inherited(arguments);
						if (has("ie")) {
							this.connect(this.focusNode || this.domNode, "onkeydown", this._onKeyDown);
						}
						if (this._resetValue === undefined) {
							this._lastValueReported = this._resetValue = this.value;
						}
					},
					_setValueAttr: function (_2bb, _2bc) {
						this._handleOnChange(_2bb, _2bc);
					},
					_handleOnChange: function (_2bd, _2be) {
						this._set("value", _2bd);
						this.inherited(arguments);
					},
					undo: function () {
						this._setValueAttr(this._lastValueReported, false);
					},
					reset: function () {
						this._hasBeenBlurred = false;
						this._setValueAttr(this._resetValue, true);
					},
					_onKeyDown: function (e) {
						if (e.keyCode == keys.ESCAPE && !(e.ctrlKey || e.altKey || e.metaKey)) {
							var te;
							if (has("ie") < 9 || (has("ie") && has("quirks"))) {
								e.preventDefault();
								te = document.createEventObject();
								te.keyCode = keys.ESCAPE;
								te.shiftKey = e.shiftKey;
								e.srcElement.fireEvent("onkeypress", te);
							}
						}
					}
				});
			});
		},
		"dijit/form/_FormWidgetMixin": function () {
			define("dijit/form/_FormWidgetMixin", ["dojo/_base/array", "dojo/_base/declare", "dojo/dom-attr", "dojo/dom-style", "dojo/_base/lang", "dojo/mouse", "dojo/_base/sniff", "dojo/_base/window", "dojo/window", "../a11y"], function (_2bf, _2c0, _2c1, _2c2, lang, _2c3, has, win, _2c4, a11y) {
				return _2c0("dijit.form._FormWidgetMixin", null, {
					name: "",
					alt: "",
					value: "",
					type: "text",
					tabIndex: "0",
					_setTabIndexAttr: "focusNode",
					disabled: false,
					intermediateChanges: false,
					scrollOnFocus: true,
					_setIdAttr: "focusNode",
					postCreate: function () {
						this.inherited(arguments);
						this.connect(this.domNode, "onmousedown", "_onMouseDown");
					},
					_setDisabledAttr: function (_2c5) {
						this._set("disabled", _2c5);
						_2c1.set(this.focusNode, "disabled", _2c5);
						if (this.valueNode) {
							_2c1.set(this.valueNode, "disabled", _2c5);
						}
						this.focusNode.setAttribute("aria-disabled", _2c5);
						if (_2c5) {
							this._set("hovering", false);
							this._set("active", false);
							var _2c6 = "tabIndex" in this.attributeMap ? this.attributeMap.tabIndex : ("_setTabIndexAttr" in this) ? this._setTabIndexAttr : "focusNode";
							_2bf.forEach(lang.isArray(_2c6) ? _2c6 : [_2c6], function (_2c7) {
								var node = this[_2c7];
								if (has("webkit") || a11y.hasDefaultTabStop(node)) {
									node.setAttribute("tabIndex", "-1");
								} else {
									node.removeAttribute("tabIndex");
								}
							}, this);
						} else {
							if (this.tabIndex != "") {
								this.set("tabIndex", this.tabIndex);
							}
						}
					},
					_onFocus: function (e) {
						if (this.scrollOnFocus) {
							_2c4.scrollIntoView(this.domNode);
						}
						this.inherited(arguments);
					},
					isFocusable: function () {
						return !this.disabled && this.focusNode && (_2c2.get(this.domNode, "display") != "none");
					},
					focus: function () {
						if (!this.disabled && this.focusNode.focus) {
							try {
								this.focusNode.focus();
							} catch (e) {}
						}
					},
					compare: function (val1, val2) {
						if (typeof val1 == "number" && typeof val2 == "number") {
							return (isNaN(val1) && isNaN(val2)) ? 0 : val1 - val2;
						} else {
							if (val1 > val2) {
								return 1;
							} else {
								if (val1 < val2) {
									return -1;
								} else {
									return 0;
								}
							}
						}
					},
					onChange: function () {},
					_onChangeActive: false,
					_handleOnChange: function (_2c8, _2c9) {
						if (this._lastValueReported == undefined && (_2c9 === null || !this._onChangeActive)) {
							this._resetValue = this._lastValueReported = _2c8;
						}
						this._pendingOnChange = this._pendingOnChange || (typeof _2c8 != typeof this._lastValueReported) || (this.compare(_2c8, this._lastValueReported) != 0);
						if ((this.intermediateChanges || _2c9 || _2c9 === undefined) && this._pendingOnChange) {
							this._lastValueReported = _2c8;
							this._pendingOnChange = false;
							if (this._onChangeActive) {
								if (this._onChangeHandle) {
									clearTimeout(this._onChangeHandle);
								}
								this._onChangeHandle = setTimeout(lang.hitch(this, function () {
									this._onChangeHandle = null;
									this.onChange(_2c8);
								}), 0);
							}
						}
					},
					create: function () {
						this.inherited(arguments);
						this._onChangeActive = true;
					},
					destroy: function () {
						if (this._onChangeHandle) {
							clearTimeout(this._onChangeHandle);
							this.onChange(this._lastValueReported);
						}
						this.inherited(arguments);
					},
					_onMouseDown: function (e) {
						if ((!this.focused || !has("ie")) && !e.ctrlKey && _2c3.isLeft(e) && this.isFocusable()) {
							var _2ca = this.connect(win.body(), "onmouseup", function () {
								if (this.isFocusable()) {
									this.focus();
								}
								this.disconnect(_2ca);
							});
						}
					}
				});
			});
		},
		"url:dijit/templates/ProgressBar.html": "<div class=\"dijitProgressBar dijitProgressBarEmpty\" role=\"progressbar\"\r\n\t><div  data-dojo-attach-point=\"internalProgress\" class=\"dijitProgressBarFull\"\r\n\t\t><div class=\"dijitProgressBarTile\" role=\"presentation\"></div\r\n\t\t><span style=\"visibility:hidden\">&#160;</span\r\n\t></div\r\n\t><div data-dojo-attach-point=\"labelNode\" class=\"dijitProgressBarLabel\" id=\"${id}_label\"></div\r\n\t><img data-dojo-attach-point=\"indeterminateHighContrastImage\" class=\"dijitProgressBarIndeterminateHighContrastImage\" alt=\"\"\r\n/></div>\r\n",
		"url:oob/usb/templates/USBSteps.html": "<div class=\"rootDiv\">\r\n    <div dojoAttachPoint=\"poweron\">\r\n        <div class=\"bluetext\">${nls.poweron}</div>\r\n        <div>${nls.powerontxt}</div>\r\n        <div class=\"poweronImages zoom\"></div>\r\n    </div>\r\n    <div dojoAttachPoint=\"insert2canister\">\r\n        <div class=\"bluetext\">${nls.insert2canister}</div>\r\n        <div dojoAttachPoint=\"insert2CanDiv\">${nls.insert2canistertxt}</div>\r\n        <div class=\"insert2canisterImages zoom\"></div>\r\n    </div>\r\n    <div dojoAttachPoint=\"removeusb\">\r\n        <div class=\"bluetext\">${nls.removeusb}</div>\r\n        <div>${nls.removeusbtxt}</div>\r\n        <div class=\"removeusbImages zoom\"></div>\r\n    </div>\r\n</div>",
		"dijit/layout/_ContentPaneResizeMixin": function () {
			define("dijit/layout/_ContentPaneResizeMixin", ["dojo/_base/array", "dojo/_base/declare", "dojo/dom-attr", "dojo/dom-class", "dojo/dom-geometry", "dojo/_base/lang", "dojo/query", "dojo/_base/sniff", "dojo/_base/window", "../registry", "./utils", "../_Contained"], function (_2cb, _2cc, _2cd, _2ce, _2cf, lang, _2d0, has, win, _2d1, _2d2, _2d3) {
				return _2cc("dijit.layout._ContentPaneResizeMixin", null, {
					doLayout: true,
					isLayoutContainer: true,
					startup: function () {
						if (this._started) {
							return;
						}
						var _2d4 = this.getParent();
						this._childOfLayoutWidget = _2d4 && _2d4.isLayoutContainer;
						this._needLayout = !this._childOfLayoutWidget;
						this.inherited(arguments);
						if (this._isShown()) {
							this._onShow();
						}
						if (!this._childOfLayoutWidget) {
							this.connect(has("ie") ? this.domNode : win.global, "onresize", function () {
								this._needLayout = !this._childOfLayoutWidget;
								this.resize();
							});
						}
					},
					_checkIfSingleChild: function () {
						var _2d5 = _2d0("> *", this.containerNode).filter(function (node) {
								return node.tagName !== "SCRIPT";
							}),
							_2d6 = _2d5.filter(function (node) {
								return _2cd.has(node, "data-dojo-type") || _2cd.has(node, "dojoType") || _2cd.has(node, "widgetId");
							}),
							_2d7 = _2cb.filter(_2d6.map(_2d1.byNode), function (_2d8) {
								return _2d8 && _2d8.domNode && _2d8.resize;
							});
						if (_2d5.length == _2d6.length && _2d7.length == 1) {
							this._singleChild = _2d7[0];
						} else {
							delete this._singleChild;
						}
						_2ce.toggle(this.containerNode, this.baseClass + "SingleChild", !!this._singleChild);
					},
					resize: function (_2d9, _2da) {
						if (!this._wasShown && this.open !== false) {
							this._onShow();
						}
						this._resizeCalled = true;
						this._scheduleLayout(_2d9, _2da);
					},
					_scheduleLayout: function (_2db, _2dc) {
						if (this._isShown()) {
							this._layout(_2db, _2dc);
						} else {
							this._needLayout = true;
							this._changeSize = _2db;
							this._resultSize = _2dc;
						}
					},
					_layout: function (_2dd, _2de) {
						if (_2dd) {
							_2cf.setMarginBox(this.domNode, _2dd);
						}
						var cn = this.containerNode;
						if (cn === this.domNode) {
							var mb = _2de || {};
							lang.mixin(mb, _2dd || {});
							if (!("h" in mb) || !("w" in mb)) {
								mb = lang.mixin(_2cf.getMarginBox(cn), mb);
							}
							this._contentBox = _2d2.marginBox2contentBox(cn, mb);
						} else {
							this._contentBox = _2cf.getContentBox(cn);
						}
						this._layoutChildren();
						delete this._needLayout;
					},
					_layoutChildren: function () {
						if (this.doLayout) {
							this._checkIfSingleChild();
						}
						if (this._singleChild && this._singleChild.resize) {
							var cb = this._contentBox || _2cf.getContentBox(this.containerNode);
							this._singleChild.resize({
								w: cb.w,
								h: cb.h
							});
						} else {
							_2cb.forEach(this.getChildren(), function (_2df) {
								if (_2df.resize) {
									_2df.resize();
								}
							});
						}
					},
					_isShown: function () {
						if (this._childOfLayoutWidget) {
							if (this._resizeCalled && "open" in this) {
								return this.open;
							}
							return this._resizeCalled;
						} else {
							if ("open" in this) {
								return this.open;
							} else {
								var node = this.domNode,
									_2e0 = this.domNode.parentNode;
								return (node.style.display != "none") && (node.style.visibility != "hidden") && !_2ce.contains(node, "dijitHidden") && _2e0 && _2e0.style && (_2e0.style.display != "none");
							}
						}
					},
					_onShow: function () {
						if (this._needLayout) {
							this._layout(this._changeSize, this._resultSize);
						}
						this.inherited(arguments);
						this._wasShown = true;
					}
				});
			});
		},
		"dijit/nls/loading": function () {
			define("dijit/nls/loading", {
				root: ({
					loadingState: "Loading...",
					errorState: "Sorry, an error occurred"
				}),
				"zh": true,
				"zh-tw": true,
				"tr": true,
				"th": true,
				"sv": true,
				"sl": true,
				"sk": true,
				"ru": true,
				"ro": true,
				"pt": true,
				"pt-pt": true,
				"pl": true,
				"nl": true,
				"nb": true,
				"ko": true,
				"kk": true,
				"ja": true,
				"it": true,
				"hu": true,
				"hr": true,
				"he": true,
				"fr": true,
				"fi": true,
				"es": true,
				"el": true,
				"de": true,
				"da": true,
				"cs": true,
				"ca": true,
				"az": true,
				"ar": true
			});
		},
		"dojo/dnd/Moveable": function () {
			define(["../main", "../Evented", "../touch", "./Mover"], function (dojo, _2e1, _2e2) {
				dojo.declare("dojo.dnd.Moveable", [_2e1], {
					handle: "",
					delay: 0,
					skip: false,
					constructor: function (node, _2e3) {
						this.node = dojo.byId(node);
						if (!_2e3) {
							_2e3 = {};
						}
						this.handle = _2e3.handle ? dojo.byId(_2e3.handle) : null;
						if (!this.handle) {
							this.handle = this.node;
						}
						this.delay = _2e3.delay > 0 ? _2e3.delay : 0;
						this.skip = _2e3.skip;
						this.mover = _2e3.mover ? _2e3.mover : dojo.dnd.Mover;
						this.events = [dojo.connect(this.handle, _2e2.press, this, "onMouseDown"), dojo.connect(this.handle, "ondragstart", this, "onSelectStart"), dojo.connect(this.handle, "onselectstart", this, "onSelectStart")];
					},
					markupFactory: function (_2e4, node, ctor) {
						return new ctor(node, _2e4);
					},
					destroy: function () {
						dojo.forEach(this.events, dojo.disconnect);
						this.events = this.node = this.handle = null;
					},
					onMouseDown: function (e) {
						if (this.skip && dojo.dnd.isFormElement(e)) {
							return;
						}
						if (this.delay) {
							this.events.push(dojo.connect(this.handle, _2e2.move, this, "onMouseMove"), dojo.connect(this.handle, _2e2.release, this, "onMouseUp"));
							this._lastX = e.pageX;
							this._lastY = e.pageY;
						} else {
							this.onDragDetected(e);
						}
						dojo.stopEvent(e);
					},
					onMouseMove: function (e) {
						if (Math.abs(e.pageX - this._lastX) > this.delay || Math.abs(e.pageY - this._lastY) > this.delay) {
							this.onMouseUp(e);
							this.onDragDetected(e);
						}
						dojo.stopEvent(e);
					},
					onMouseUp: function (e) {
						for (var i = 0; i < 2; ++i) {
							dojo.disconnect(this.events.pop());
						}
						dojo.stopEvent(e);
					},
					onSelectStart: function (e) {
						if (!this.skip || !dojo.dnd.isFormElement(e)) {
							dojo.stopEvent(e);
						}
					},
					onDragDetected: function (e) {
						new this.mover(this.node, e, this);
					},
					onMoveStart: function (_2e5) {
						dojo.publish("/dnd/move/start", [_2e5]);
						dojo.addClass(dojo.body(), "dojoMove");
						dojo.addClass(this.node, "dojoMoveItem");
					},
					onMoveStop: function (_2e6) {
						dojo.publish("/dnd/move/stop", [_2e6]);
						dojo.removeClass(dojo.body(), "dojoMove");
						dojo.removeClass(this.node, "dojoMoveItem");
					},
					onFirstMove: function (_2e7, e) {},
					onMove: function (_2e8, _2e9, e) {
						this.onMoving(_2e8, _2e9);
						var s = _2e8.node.style;
						s.left = _2e9.l + "px";
						s.top = _2e9.t + "px";
						this.onMoved(_2e8, _2e9);
					},
					onMoving: function (_2ea, _2eb) {},
					onMoved: function (_2ec, _2ed) {}
				});
				return dojo.dnd.Moveable;
			});
		},
		"dojo/store/util/SimpleQueryEngine": function () {
			define(["../../_base/array"], function (_2ee) {
				return function (_2ef, _2f0) {
					switch (typeof _2ef) {
						default:
							throw new Error("Can not query with a " + typeof _2ef);
						case "object":
						case "undefined":
							var _2f1 = _2ef;
							_2ef = function (_2f2) {
								for (var key in _2f1) {
									var _2f3 = _2f1[key];
									if (_2f3 && _2f3.test) {
										if (!_2f3.test(_2f2[key])) {
											return false;
										}
									} else {
										if (_2f3 != _2f2[key]) {
											return false;
										}
									}
								}
								return true;
							};
							break;
						case "string":
							if (!this[_2ef]) {
								throw new Error("No filter function " + _2ef + " was found in store");
							}
							_2ef = this[_2ef];
						case "function":
					}

					function _2f4(_2f5) {
						var _2f6 = _2ee.filter(_2f5, _2ef);
						if (_2f0 && _2f0.sort) {
							_2f6.sort(function (a, b) {
								for (var sort, i = 0; sort = _2f0.sort[i]; i++) {
									var _2f7 = a[sort.attribute];
									var _2f8 = b[sort.attribute];
									if (_2f7 != _2f8) {
										return !!sort.descending == _2f7 > _2f8 ? -1 : 1;
									}
								}
								return 0;
							});
						}
						if (_2f0 && (_2f0.start || _2f0.count)) {
							var _2f9 = _2f6.length;
							_2f6 = _2f6.slice(_2f0.start || 0, (_2f0.start || 0) + (_2f0.count || Infinity));
							_2f6.total = _2f9;
						}
						return _2f6;
					};
					_2f4.matches = _2ef;
					return _2f4;
				};
			});
		},
		"dojo/cldr/nls/number": function () {
			define({
				root: {
					"scientificFormat": "#E0",
					"currencySpacing-afterCurrency-currencyMatch": "[:letter:]",
					"infinity": "∞",
					"list": ";",
					"percentSign": "%",
					"minusSign": "-",
					"currencySpacing-beforeCurrency-surroundingMatch": "[:digit:]",
					"decimalFormat-short": "000T",
					"currencySpacing-afterCurrency-insertBetween": " ",
					"nan": "NaN",
					"nativeZeroDigit": "0",
					"plusSign": "+",
					"currencySpacing-afterCurrency-surroundingMatch": "[:digit:]",
					"currencySpacing-beforeCurrency-currencyMatch": "[:letter:]",
					"currencyFormat": "¤ #,##0.00",
					"perMille": "‰",
					"group": ",",
					"percentFormat": "#,##0%",
					"decimalFormat": "#,##0.###",
					"decimal": ".",
					"patternDigit": "#",
					"currencySpacing-beforeCurrency-insertBetween": " ",
					"exponential": "E"
				},
				"af": true,
				"af-na": true,
				"ak": true,
				"am": true,
				"ar": true,
				"ar-qa": true,
				"ar-sa": true,
				"ar-sy": true,
				"ar-tn": true,
				"ar-ye": true,
				"as": true,
				"asa": true,
				"az": true,
				"az-cyrl": true,
				"be": true,
				"bem": true,
				"bez": true,
				"bg": true,
				"bm": true,
				"bn": true,
				"bo": true,
				"brx": true,
				"bs": true,
				"ca": true,
				"cgg": true,
				"chr": true,
				"cs": true,
				"da": true,
				"dav": true,
				"de": true,
				"de-at": true,
				"de-ch": true,
				"de-li": true,
				"ebu": true,
				"ee": true,
				"el": true,
				"el-cy": true,
				"en": true,
				"en-au": true,
				"en-be": true,
				"en-bw": true,
				"en-bz": true,
				"en-gb": true,
				"en-ie": true,
				"en-in": true,
				"en-jm": true,
				"en-mt": true,
				"en-na": true,
				"en-nz": true,
				"en-tt": true,
				"en-us-posix": true,
				"en-za": true,
				"en-zw": true,
				"eo": true,
				"es": true,
				"es-419": true,
				"es-cl": true,
				"es-do": true,
				"es-ec": true,
				"es-gt": true,
				"es-hn": true,
				"es-mx": true,
				"es-ni": true,
				"es-pa": true,
				"es-pe": true,
				"es-pr": true,
				"es-py": true,
				"es-sv": true,
				"es-us": true,
				"es-uy": true,
				"es-ve": true,
				"et": true,
				"eu": true,
				"fa": true,
				"fa-af": true,
				"ff": true,
				"fi": true,
				"fil": true,
				"fo": true,
				"fr": true,
				"fr-be": true,
				"fr-ca": true,
				"fr-ch": true,
				"fr-lu": true,
				"ga": true,
				"gl": true,
				"gsw": true,
				"gu": true,
				"guz": true,
				"gv": true,
				"ha": true,
				"haw": true,
				"he": true,
				"hi": true,
				"hr": true,
				"hu": true,
				"hy": true,
				"id": true,
				"ig": true,
				"ii": true,
				"in": true,
				"is": true,
				"it": true,
				"it-ch": true,
				"iw": true,
				"ja": true,
				"jmc": true,
				"ka": true,
				"kab": true,
				"kam": true,
				"kde": true,
				"kea": true,
				"khq": true,
				"ki": true,
				"kk": true,
				"kl": true,
				"kln": true,
				"km": true,
				"kn": true,
				"ko": true,
				"kok": true,
				"ksb": true,
				"kw": true,
				"lg": true,
				"lt": true,
				"luo": true,
				"luy": true,
				"lv": true,
				"mas": true,
				"mer": true,
				"mfe": true,
				"mg": true,
				"mk": true,
				"ml": true,
				"mo": true,
				"mr": true,
				"ms": true,
				"ms-bn": true,
				"mt": true,
				"my": true,
				"naq": true,
				"nb": true,
				"nd": true,
				"ne": true,
				"nl": true,
				"nl-be": true,
				"nn": true,
				"no": true,
				"nr": true,
				"nso": true,
				"nyn": true,
				"om": true,
				"or": true,
				"pa": true,
				"pl": true,
				"ps": true,
				"pt": true,
				"pt-pt": true,
				"rm": true,
				"ro": true,
				"rof": true,
				"ru": true,
				"rw": true,
				"rwk": true,
				"saq": true,
				"seh": true,
				"ses": true,
				"sg": true,
				"sh": true,
				"shi": true,
				"shi-tfng": true,
				"si": true,
				"sk": true,
				"sl": true,
				"sn": true,
				"so": true,
				"sq": true,
				"sr": true,
				"sr-latn-me": true,
				"sr-me": true,
				"ss": true,
				"st": true,
				"sv": true,
				"sw": true,
				"sw-ke": true,
				"ta": true,
				"te": true,
				"teo": true,
				"th": true,
				"ti": true,
				"tl": true,
				"tn": true,
				"tr": true,
				"ts": true,
				"tzm": true,
				"uk": true,
				"ur": true,
				"ur-in": true,
				"uz-af": true,
				"uz-arab": true,
				"ve": true,
				"vi": true,
				"vun": true,
				"xh": true,
				"xog": true,
				"yo": true,
				"zh": true,
				"zh-hant": true,
				"zh-hant-hk": true,
				"zh-hk": true,
				"zu": true
			});
		},
		"url:oob/summary/templates/Summary.html": "<div>\r\n    <div dojoAttachPoint=\"createClusterdiv\">\r\n        <div dojoAttachPoint=\"ipdiv\" class=\"hidden\">\r\n            <div dojoAttachPoint=\"iptitlediv\" class=\"iptitle\">${nls.systemip}</div>\r\n            <div dojoAttachPoint=\"ipv4div\">\r\n                <table>\r\n                    <tr><td>${nls.address}:</td><td name=\"address4\"></td></tr>\r\n                    <tr><td>${nls.mask}:</td>   <td name=\"mask4\"></td></tr>\r\n                    <tr><td>${nls.gateway}:</td><td name=\"gateway4\"></td></tr>\r\n                </table>\r\n            </div>\r\n            <div dojoAttachPoint=\"ipv6div\">\r\n                <table>\r\n                    <tr><td>${nls.address}:</td><td name=\"address6\"></td></tr>\r\n                    <tr><td>${nls.prefix}:</td> <td name=\"mask6\"></td></tr>\r\n                    <tr><td>${nls.gateway}:</td><td name=\"gateway6\"></td></tr>\r\n                </table>\r\n            </div>\r\n        </div>\r\n        <div class=\"hidden errordiv\" dojoAttachPoint=\"errordiv\">\r\n            <div class=\"errorinfodiv\" dojoAttachPoint=\"errorinfodiv\">${nls.errorinfo}</div>\r\n            <div class=\"backendError\" dojoAttachPoint=\"backendError\"></div>\r\n\r\n            <div class=\"hidden serviceipCheckDiv\" dojoAttachPoint=\"checkingServiceIPDiv\">\r\n                <div><div class=\"image16 chargingImage\"></div>\r\n                    <span dojoAttachPoint=\"serviceIPUnreachableDiv\" class=\"iconTextSpan\">${nls.serviceipverification}</span>\r\n                </div>\r\n            </div>\r\n\r\n            <div class=\"hidden serviceipCheckDiv\" dojoAttachPoint=\"ipUnreachedDiv\">\r\n                ${nls.serviceipunreached}\r\n            </div>\r\n\r\n            <div class=\"hidden serviceipCheckDiv\" dojoAttachPoint=\"getIBMSupportDiv\">\r\n                ${nls.contactsupport}\r\n            </div>\r\n        </div>\r\n\r\n        <div dojoType=\"dijit.Dialog\" dojoAttachPoint=\"dialog\" title=\"${nls.dialogtitle}\" draggable=\"false\">\r\n            <div class=\"dialogContent\">\r\n                <div class=\"charingDiv\"><div class=\"image16 chargingImage\" dojoAttachPoint=\"chargingIcon\"></div><span dojoAttachPoint=\"chargingSpan\" class=\"iconTextSpan\"></span></div>\r\n                <div class=\"countDownTimer\" dojoAttachPoint=\"countDownTimerText\"></div>\r\n                <div class=\"batteryError hidden\" dojoAttachPoint=\"dialogError\"></div>\r\n            </div>\r\n            <div class=\"summaryDialog dijitDialogPaneActionBar\" dojoAttachPoint=\"dialogActionbar\">\r\n                <button dojoType=\"dijit.form.Button\" type=\"button\" dojoAttachPoint=\"dialogBtn\" dojoAttachEvent=\"onClick:dialogBtnClicked\">${nls.dialogbtn}</button>\r\n            </div>\r\n        </div>\r\n    </div>\r\n\r\n    <div dojoAttachPoint=\"resetPwddiv\" class=\"hidden\">\r\n        <div>${nls.resetfailedreason}</div>\r\n        <div class=\"mart20\">${nls.resetfailedsolution}</div>\r\n        <div>\r\n            <ol>\r\n                <li>${nls.resetfailedstep1}</li>\r\n                <li>${nls.resetfailedstep2}</li>\r\n                <li>${nls.resetfailedstep3}</li>\r\n            </ol>\r\n        </div>\r\n    </div>\r\n\r\n    <div dojoAttachPoint=\"extendSysDiv\" class=\"hidden extendSysDiv\">\r\n        <div>${nls.extendenclosurestep1}</div>\r\n        <div>${nls.extendenclosurestep2}</div>\r\n    </div>\r\n</div>",
		"dijit/popup": function () {
			define("dijit/popup", ["dojo/_base/array", "dojo/aspect", "dojo/_base/connect", "dojo/_base/declare", "dojo/dom", "dojo/dom-attr", "dojo/dom-construct", "dojo/dom-geometry", "dojo/dom-style", "dojo/_base/event", "dojo/keys", "dojo/_base/lang", "dojo/on", "dojo/_base/sniff", "dojo/_base/window", "./place", "./BackgroundIframe", "."], function (_2fa, _2fb, _2fc, _2fd, dom, _2fe, _2ff, _300, _301, _302, keys, lang, on, has, win, _303, _304, _305) {
				var _306 = _2fd(null, {
					_stack: [],
					_beginZIndex: 1000,
					_idGen: 1,
					_createWrapper: function (_307) {
						var _308 = _307._popupWrapper,
							node = _307.domNode;
						if (!_308) {
							_308 = _2ff.create("div", {
								"class": "dijitPopup",
								style: {
									display: "none"
								},
								role: "presentation"
							}, win.body());
							_308.appendChild(node);
							var s = node.style;
							s.display = "";
							s.visibility = "";
							s.position = "";
							s.top = "0px";
							_307._popupWrapper = _308;
							_2fb.after(_307, "destroy", function () {
								_2ff.destroy(_308);
								delete _307._popupWrapper;
							});
						}
						return _308;
					},
					moveOffScreen: function (_309) {
						var _30a = this._createWrapper(_309);
						_301.set(_30a, {
							visibility: "hidden",
							top: "-9999px",
							display: ""
						});
					},
					hide: function (_30b) {
						var _30c = this._createWrapper(_30b);
						_301.set(_30c, "display", "none");
					},
					getTopPopup: function () {
						var _30d = this._stack;
						for (var pi = _30d.length - 1; pi > 0 && _30d[pi].parent === _30d[pi - 1].widget; pi--) {}
						return _30d[pi];
					},
					open: function (args) {
						var _30e = this._stack,
							_30f = args.popup,
							_310 = args.orient || ["below", "below-alt", "above", "above-alt"],
							ltr = args.parent ? args.parent.isLeftToRight() : _300.isBodyLtr(),
							_311 = args.around,
							id = (args.around && args.around.id) ? (args.around.id + "_dropdown") : ("popup_" + this._idGen++);
						while (_30e.length && (!args.parent || !dom.isDescendant(args.parent.domNode, _30e[_30e.length - 1].widget.domNode))) {
							this.close(_30e[_30e.length - 1].widget);
						}
						var _312 = this._createWrapper(_30f);
						_2fe.set(_312, {
							id: id,
							style: {
								zIndex: this._beginZIndex + _30e.length
							},
							"class": "dijitPopup " + (_30f.baseClass || _30f["class"] || "").split(" ")[0] + "Popup",
							dijitPopupParent: args.parent ? args.parent.id : ""
						});
						if (has("ie") || has("mozilla")) {
							if (!_30f.bgIframe) {
								_30f.bgIframe = new _304(_312);
							}
						}
						var best = _311 ? _303.around(_312, _311, _310, ltr, _30f.orient ? lang.hitch(_30f, "orient") : null) : _303.at(_312, args, _310 == "R" ? ["TR", "BR", "TL", "BL"] : ["TL", "BL", "TR", "BR"], args.padding);
						_312.style.display = "";
						_312.style.visibility = "visible";
						_30f.domNode.style.visibility = "visible";
						var _313 = [];
						_313.push(on(_312, _2fc._keypress, lang.hitch(this, function (evt) {
							if (evt.charOrCode == keys.ESCAPE && args.onCancel) {
								_302.stop(evt);
								args.onCancel();
							} else {
								if (evt.charOrCode === keys.TAB) {
									_302.stop(evt);
									var _314 = this.getTopPopup();
									if (_314 && _314.onCancel) {
										_314.onCancel();
									}
								}
							}
						})));
						if (_30f.onCancel && args.onCancel) {
							_313.push(_30f.on("cancel", args.onCancel));
						}
						_313.push(_30f.on(_30f.onExecute ? "execute" : "change", lang.hitch(this, function () {
							var _315 = this.getTopPopup();
							if (_315 && _315.onExecute) {
								_315.onExecute();
							}
						})));
						_30e.push({
							widget: _30f,
							parent: args.parent,
							onExecute: args.onExecute,
							onCancel: args.onCancel,
							onClose: args.onClose,
							handlers: _313
						});
						if (_30f.onOpen) {
							_30f.onOpen(best);
						}
						return best;
					},
					close: function (_316) {
						var _317 = this._stack;
						while ((_316 && _2fa.some(_317, function (elem) {
								return elem.widget == _316;
							})) || (!_316 && _317.length)) {
							var top = _317.pop(),
								_318 = top.widget,
								_319 = top.onClose;
							if (_318.onClose) {
								_318.onClose();
							}
							var h;
							while (h = top.handlers.pop()) {
								h.remove();
							}
							if (_318 && _318.domNode) {
								this.hide(_318);
							}
							if (_319) {
								_319();
							}
						}
					}
				});
				return (_305.popup = new _306());
			});
		},
		"dijit/_base/manager": function () {
			define("dijit/_base/manager", ["dojo/_base/array", "dojo/_base/config", "../registry", ".."], function (_31a, _31b, _31c, _31d) {
				_31a.forEach(["byId", "getUniqueId", "findWidgets", "_destroyAll", "byNode", "getEnclosingWidget"], function (name) {
					_31d[name] = _31c[name];
				});
				_31d.defaultDuration = _31b["defaultDuration"] || 200;
				return _31d;
			});
		},
		"dojox/validate/regexp": function () {
			define("dojox/validate/regexp", ["dojo/_base/lang", "dojo/regexp", "dojox/main"], function (lang, _31e, _31f) {
				var _320 = lang.getObject("validate.regexp", true, _31f);
				_320 = _31f.validate.regexp = {
					ipAddress: function (_321) {
						_321 = (typeof _321 == "object") ? _321 : {};
						if (typeof _321.allowDottedDecimal != "boolean") {
							_321.allowDottedDecimal = true;
						}
						if (typeof _321.allowDottedHex != "boolean") {
							_321.allowDottedHex = true;
						}
						if (typeof _321.allowDottedOctal != "boolean") {
							_321.allowDottedOctal = true;
						}
						if (typeof _321.allowDecimal != "boolean") {
							_321.allowDecimal = true;
						}
						if (typeof _321.allowHex != "boolean") {
							_321.allowHex = true;
						}
						if (typeof _321.allowIPv6 != "boolean") {
							_321.allowIPv6 = true;
						}
						if (typeof _321.allowHybrid != "boolean") {
							_321.allowHybrid = true;
						}
						var _322 = "((\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])\\.){3}(\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])";
						var _323 = "(0[xX]0*[\\da-fA-F]?[\\da-fA-F]\\.){3}0[xX]0*[\\da-fA-F]?[\\da-fA-F]";
						var _324 = "(0+[0-3][0-7][0-7]\\.){3}0+[0-3][0-7][0-7]";
						var _325 = "(0|[1-9]\\d{0,8}|[1-3]\\d{9}|4[01]\\d{8}|42[0-8]\\d{7}|429[0-3]\\d{6}|" + "4294[0-8]\\d{5}|42949[0-5]\\d{4}|429496[0-6]\\d{3}|4294967[01]\\d{2}|42949672[0-8]\\d|429496729[0-5])";
						var _326 = "0[xX]0*[\\da-fA-F]{1,8}";
						var _327 = "([\\da-fA-F]{1,4}\\:){7}[\\da-fA-F]{1,4}";
						var _328 = "([\\da-fA-F]{1,4}\\:){6}" + "((\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])\\.){3}(\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])";
						var a = [];
						if (_321.allowDottedDecimal) {
							a.push(_322);
						}
						if (_321.allowDottedHex) {
							a.push(_323);
						}
						if (_321.allowDottedOctal) {
							a.push(_324);
						}
						if (_321.allowDecimal) {
							a.push(_325);
						}
						if (_321.allowHex) {
							a.push(_326);
						}
						if (_321.allowIPv6) {
							a.push(_327);
						}
						if (_321.allowHybrid) {
							a.push(_328);
						}
						var _329 = "";
						if (a.length > 0) {
							_329 = "(" + a.join("|") + ")";
						}
						return _329;
					},
					host: function (_32a) {
						_32a = (typeof _32a == "object") ? _32a : {};
						if (typeof _32a.allowIP != "boolean") {
							_32a.allowIP = true;
						}
						if (typeof _32a.allowLocal != "boolean") {
							_32a.allowLocal = false;
						}
						if (typeof _32a.allowPort != "boolean") {
							_32a.allowPort = true;
						}
						if (typeof _32a.allowNamed != "boolean") {
							_32a.allowNamed = false;
						}
						var _32b = "(?:[\\da-zA-Z](?:[-\\da-zA-Z]{0,61}[\\da-zA-Z])?)";
						var _32c = "(?:[a-zA-Z](?:[-\\da-zA-Z]{0,6}[\\da-zA-Z])?)";
						var _32d = _32a.allowPort ? "(\\:\\d+)?" : "";
						var _32e = "((?:" + _32b + "\\.)+" + _32c + "\\.?)";
						if (_32a.allowIP) {
							_32e += "|" + _320.ipAddress(_32a);
						}
						if (_32a.allowLocal) {
							_32e += "|localhost";
						}
						if (_32a.allowNamed) {
							_32e += "|^[^-][a-zA-Z0-9_-]*";
						}
						return "(" + _32e + ")" + _32d;
					},
					url: function (_32f) {
						_32f = (typeof _32f == "object") ? _32f : {};
						if (!("scheme" in _32f)) {
							_32f.scheme = [true, false];
						}
						var _330 = _31e.buildGroupRE(_32f.scheme, function (q) {
							if (q) {
								return "(https?|ftps?)\\://";
							}
							return "";
						});
						var _331 = "(/(?:[^?#\\s/]+/)*(?:[^?#\\s/]+(?:\\?[^?#\\s/]*)?(?:#[A-Za-z][\\w.:-]*)?)?)?";
						return _330 + _320.host(_32f) + _331;
					},
					emailAddress: function (_332) {
						_332 = (typeof _332 == "object") ? _332 : {};
						if (typeof _332.allowCruft != "boolean") {
							_332.allowCruft = false;
						}
						_332.allowPort = false;
						var _333 = "([!#-'*+\\-\\/-9=?A-Z^-~]+[.])*[!#-'*+\\-\\/-9=?A-Z^-~]+";
						var _334 = _333 + "@" + _320.host(_332);
						if (_332.allowCruft) {
							_334 = "<?(mailto\\:)?" + _334 + ">?";
						}
						return _334;
					},
					emailAddressList: function (_335) {
						_335 = (typeof _335 == "object") ? _335 : {};
						if (typeof _335.listSeparator != "string") {
							_335.listSeparator = "\\s;,";
						}
						var _336 = _320.emailAddress(_335);
						var _337 = "(" + _336 + "\\s*[" + _335.listSeparator + "]\\s*)*" + _336 + "\\s*[" + _335.listSeparator + "]?\\s*";
						return _337;
					},
					numberFormat: function (_338) {
						_338 = (typeof _338 == "object") ? _338 : {};
						if (typeof _338.format == "undefined") {
							_338.format = "###-###-####";
						}
						var _339 = function (_33a) {
							return _31e.escapeString(_33a, "?").replace(/\?/g, "\\d?").replace(/#/g, "\\d");
						};
						return _31e.buildGroupRE(_338.format, _339);
					},
					ca: {
						postalCode: function () {
							return "([A-Z][0-9][A-Z] [0-9][A-Z][0-9])";
						},
						province: function () {
							return "(AB|BC|MB|NB|NL|NS|NT|NU|ON|PE|QC|SK|YT)";
						}
					},
					us: {
						state: function (_33b) {
							_33b = (typeof _33b == "object") ? _33b : {};
							if (typeof _33b.allowTerritories != "boolean") {
								_33b.allowTerritories = true;
							}
							if (typeof _33b.allowMilitary != "boolean") {
								_33b.allowMilitary = true;
							}
							var _33c = "AL|AK|AZ|AR|CA|CO|CT|DE|DC|FL|GA|HI|ID|IL|IN|IA|KS|KY|LA|ME|MD|MA|MI|MN|MS|MO|MT|" + "NE|NV|NH|NJ|NM|NY|NC|ND|OH|OK|OR|PA|RI|SC|SD|TN|TX|UT|VT|VA|WA|WV|WI|WY";
							var _33d = "AS|FM|GU|MH|MP|PW|PR|VI";
							var _33e = "AA|AE|AP";
							if (_33b.allowTerritories) {
								_33c += "|" + _33d;
							}
							if (_33b.allowMilitary) {
								_33c += "|" + _33e;
							}
							return "(" + _33c + ")";
						}
					}
				};
				return _320;
			});
		},
		"dojo/dnd/Mover": function () {
			define(["../main", "../Evented", "../touch", "./common", "./autoscroll"], function (dojo, _33f, _340) {
				dojo.declare("dojo.dnd.Mover", [_33f], {
					constructor: function (node, e, host) {
						this.node = dojo.byId(node);
						this.marginBox = {
							l: e.pageX,
							t: e.pageY
						};
						this.mouseButton = e.button;
						var h = (this.host = host),
							d = node.ownerDocument;
						this.events = [dojo.connect(d, _340.move, this, "onFirstMove"), dojo.connect(d, _340.move, this, "onMouseMove"), dojo.connect(d, _340.release, this, "onMouseUp"), dojo.connect(d, "ondragstart", dojo.stopEvent), dojo.connect(d.body, "onselectstart", dojo.stopEvent)];
						if (h && h.onMoveStart) {
							h.onMoveStart(this);
						}
					},
					onMouseMove: function (e) {
						dojo.dnd.autoScroll(e);
						var m = this.marginBox;
						this.host.onMove(this, {
							l: m.l + e.pageX,
							t: m.t + e.pageY
						}, e);
						dojo.stopEvent(e);
					},
					onMouseUp: function (e) {
						if (dojo.isWebKit && dojo.isMac && this.mouseButton == 2 ? e.button == 0 : this.mouseButton == e.button) {
							this.destroy();
						}
						dojo.stopEvent(e);
					},
					onFirstMove: function (e) {
						var s = this.node.style,
							l, t, h = this.host;
						switch (s.position) {
							case "relative":
							case "absolute":
								l = Math.round(parseFloat(s.left)) || 0;
								t = Math.round(parseFloat(s.top)) || 0;
								break;
							default:
								s.position = "absolute";
								var m = dojo.marginBox(this.node);
								var b = dojo.doc.body;
								var bs = dojo.getComputedStyle(b);
								var bm = dojo._getMarginBox(b, bs);
								var bc = dojo._getContentBox(b, bs);
								l = m.l - (bc.l - bm.l);
								t = m.t - (bc.t - bm.t);
								break;
						}
						this.marginBox.l = l - this.marginBox.l;
						this.marginBox.t = t - this.marginBox.t;
						if (h && h.onFirstMove) {
							h.onFirstMove(this, e);
						}
						dojo.disconnect(this.events.shift());
					},
					destroy: function () {
						dojo.forEach(this.events, dojo.disconnect);
						var h = this.host;
						if (h && h.onMoveStop) {
							h.onMoveStop(this);
						}
						this.events = this.node = this.host = null;
					}
				});
				return dojo.dnd.Mover;
			});
		},
		"dijit/BackgroundIframe": function () {
			define("dijit/BackgroundIframe", ["require", ".", "dojo/_base/config", "dojo/dom-construct", "dojo/dom-style", "dojo/_base/lang", "dojo/on", "dojo/_base/sniff", "dojo/_base/window"], function (_341, _342, _343, _344, _345, lang, on, has, win) {
				var _346 = new function () {
					var _347 = [];
					this.pop = function () {
						var _348;
						if (_347.length) {
							_348 = _347.pop();
							_348.style.display = "";
						} else {
							if (has("ie") < 9) {
								var burl = _343["dojoBlankHtmlUrl"] || _341.toUrl("dojo/resources/blank.html") || "javascript:\"\"";
								var html = "<iframe src='" + burl + "' role='presentation'" + " style='position: absolute; left: 0px; top: 0px;" + "z-index: -1; filter:Alpha(Opacity=\"0\");'>";
								_348 = win.doc.createElement(html);
							} else {
								_348 = _344.create("iframe");
								_348.src = "javascript:\"\"";
								_348.className = "dijitBackgroundIframe";
								_348.setAttribute("role", "presentation");
								_345.set(_348, "opacity", 0.1);
							}
							_348.tabIndex = -1;
						}
						return _348;
					};
					this.push = function (_349) {
						_349.style.display = "none";
						_347.push(_349);
					};
				}();
				_342.BackgroundIframe = function (node) {
					if (!node.id) {
						throw new Error("no id");
					}
					if (has("ie") || has("mozilla")) {
						var _34a = (this.iframe = _346.pop());
						node.appendChild(_34a);
						if (has("ie") < 7 || has("quirks")) {
							this.resize(node);
							this._conn = on(node, "resize", lang.hitch(this, function () {
								this.resize(node);
							}));
						} else {
							_345.set(_34a, {
								width: "100%",
								height: "100%"
							});
						}
					}
				};
				lang.extend(_342.BackgroundIframe, {
					resize: function (node) {
						if (this.iframe) {
							_345.set(this.iframe, {
								width: node.offsetWidth + "px",
								height: node.offsetHeight + "px"
							});
						}
					},
					destroy: function () {
						if (this._conn) {
							this._conn.remove();
							this._conn = null;
						}
						if (this.iframe) {
							_346.push(this.iframe);
							delete this.iframe;
						}
					}
				});
				return _342.BackgroundIframe;
			});
		},
		"dijit/form/Button": function () {
			require({
				cache: {
					"url:dijit/form/templates/Button.html": "<span class=\"dijit dijitReset dijitInline\" role=\"presentation\"\r\n\t><span class=\"dijitReset dijitInline dijitButtonNode\"\r\n\t\tdata-dojo-attach-event=\"ondijitclick:_onClick\" role=\"presentation\"\r\n\t\t><span class=\"dijitReset dijitStretch dijitButtonContents\"\r\n\t\t\tdata-dojo-attach-point=\"titleNode,focusNode\"\r\n\t\t\trole=\"button\" aria-labelledby=\"${id}_label\"\r\n\t\t\t><span class=\"dijitReset dijitInline dijitIcon\" data-dojo-attach-point=\"iconNode\"></span\r\n\t\t\t><span class=\"dijitReset dijitToggleButtonIconChar\">&#x25CF;</span\r\n\t\t\t><span class=\"dijitReset dijitInline dijitButtonText\"\r\n\t\t\t\tid=\"${id}_label\"\r\n\t\t\t\tdata-dojo-attach-point=\"containerNode\"\r\n\t\t\t></span\r\n\t\t></span\r\n\t></span\r\n\t><input ${!nameAttrSetting} type=\"${type}\" value=\"${value}\" class=\"dijitOffScreen\"\r\n\t\ttabIndex=\"-1\" role=\"presentation\" data-dojo-attach-point=\"valueNode\"\r\n/></span>\r\n"
				}
			});
			define("dijit/form/Button", ["require", "dojo/_base/declare", "dojo/dom-class", "dojo/_base/kernel", "dojo/_base/lang", "dojo/ready", "./_FormWidget", "./_ButtonMixin", "dojo/text!./templates/Button.html"], function (_34b, _34c, _34d, _34e, lang, _34f, _350, _351, _352) {
				if (!_34e.isAsync) {
					_34f(0, function () {
						var _353 = ["dijit/form/DropDownButton", "dijit/form/ComboButton", "dijit/form/ToggleButton"];
						_34b(_353);
					});
				}
				return _34c("dijit.form.Button", [_350, _351], {
					showLabel: true,
					iconClass: "dijitNoIcon",
					_setIconClassAttr: {
						node: "iconNode",
						type: "class"
					},
					baseClass: "dijitButton",
					templateString: _352,
					_setValueAttr: "valueNode",
					_onClick: function (e) {
						var ok = this.inherited(arguments);
						if (ok) {
							if (this.valueNode) {
								this.valueNode.click();
								e.preventDefault();
							}
						}
						return ok;
					},
					_fillContent: function (_354) {
						if (_354 && (!this.params || !("label" in this.params))) {
							var _355 = lang.trim(_354.innerHTML);
							if (_355) {
								this.label = _355;
							}
						}
					},
					_setShowLabelAttr: function (val) {
						if (this.containerNode) {
							_34d.toggle(this.containerNode, "dijitDisplayNone", !val);
						}
						this._set("showLabel", val);
					},
					setLabel: function (_356) {
						_34e.deprecated("dijit.form.Button.setLabel() is deprecated.  Use set('label', ...) instead.", "", "2.0");
						this.set("label", _356);
					},
					_setLabelAttr: function (_357) {
						this.inherited(arguments);
						if (!this.showLabel && !("title" in this.params)) {
							this.titleNode.title = lang.trim(this.containerNode.innerText || this.containerNode.textContent || "");
						}
					}
				});
			});
		},
		"dijit/_WidgetBase": function () {
			define("dijit/_WidgetBase", ["require", "dojo/_base/array", "dojo/aspect", "dojo/_base/config", "dojo/_base/connect", "dojo/_base/declare", "dojo/dom", "dojo/dom-attr", "dojo/dom-class", "dojo/dom-construct", "dojo/dom-geometry", "dojo/dom-style", "dojo/_base/kernel", "dojo/_base/lang", "dojo/on", "dojo/ready", "dojo/Stateful", "dojo/topic", "dojo/_base/window", "./registry"], function (_358, _359, _35a, _35b, _35c, _35d, dom, _35e, _35f, _360, _361, _362, _363, lang, on, _364, _365, _366, win, _367) {
				if (!_363.isAsync) {
					_364(0, function () {
						var _368 = ["dijit/_base/manager"];
						_358(_368);
					});
				}
				var _369 = {};

				function _36a(obj) {
					var ret = {};
					for (var attr in obj) {
						ret[attr.toLowerCase()] = true;
					}
					return ret;
				};

				function _36b(attr) {
					return function (val) {
						_35e[val ? "set" : "remove"](this.domNode, attr, val);
						this._set(attr, val);
					};
				};
				return _35d("dijit._WidgetBase", _365, {
					id: "",
					_setIdAttr: "domNode",
					lang: "",
					_setLangAttr: _36b("lang"),
					dir: "",
					_setDirAttr: _36b("dir"),
					textDir: "",
					"class": "",
					_setClassAttr: {
						node: "domNode",
						type: "class"
					},
					style: "",
					title: "",
					tooltip: "",
					baseClass: "",
					srcNodeRef: null,
					domNode: null,
					containerNode: null,
					attributeMap: {},
					_blankGif: _35b.blankGif || _358.toUrl("dojo/resources/blank.gif"),
					postscript: function (_36c, _36d) {
						this.create(_36c, _36d);
					},
					create: function (_36e, _36f) {
						this.srcNodeRef = dom.byId(_36f);
						this._connects = [];
						this._supportingWidgets = [];
						if (this.srcNodeRef && (typeof this.srcNodeRef.id == "string")) {
							this.id = this.srcNodeRef.id;
						}
						if (_36e) {
							this.params = _36e;
							lang.mixin(this, _36e);
						}
						this.postMixInProperties();
						if (!this.id) {
							this.id = _367.getUniqueId(this.declaredClass.replace(/\./g, "_"));
						}
						_367.add(this);
						this.buildRendering();
						if (this.domNode) {
							this._applyAttributes();
							var _370 = this.srcNodeRef;
							if (_370 && _370.parentNode && this.domNode !== _370) {
								_370.parentNode.replaceChild(this.domNode, _370);
							}
						}
						if (this.domNode) {
							this.domNode.setAttribute("widgetId", this.id);
						}
						this.postCreate();
						if (this.srcNodeRef && !this.srcNodeRef.parentNode) {
							delete this.srcNodeRef;
						}
						this._created = true;
					},
					_applyAttributes: function () {
						var ctor = this.constructor,
							list = ctor._setterAttrs;
						if (!list) {
							list = (ctor._setterAttrs = []);
							for (var attr in this.attributeMap) {
								list.push(attr);
							}
							var _371 = ctor.prototype;
							for (var _372 in _371) {
								if (_372 in this.attributeMap) {
									continue;
								}
								var _373 = "_set" + _372.replace(/^[a-z]|-[a-zA-Z]/g, function (c) {
									return c.charAt(c.length - 1).toUpperCase();
								}) + "Attr";
								if (_373 in _371) {
									list.push(_372);
								}
							}
						}
						_359.forEach(list, function (attr) {
							if (this.params && attr in this.params) {} else {
								if (this[attr]) {
									this.set(attr, this[attr]);
								}
							}
						}, this);
						for (var _374 in this.params) {
							this.set(_374, this[_374]);
						}
					},
					postMixInProperties: function () {},
					buildRendering: function () {
						if (!this.domNode) {
							this.domNode = this.srcNodeRef || _360.create("div");
						}
						if (this.baseClass) {
							var _375 = this.baseClass.split(" ");
							if (!this.isLeftToRight()) {
								_375 = _375.concat(_359.map(_375, function (name) {
									return name + "Rtl";
								}));
							}
							_35f.add(this.domNode, _375);
						}
					},
					postCreate: function () {},
					startup: function () {
						if (this._started) {
							return;
						}
						this._started = true;
						_359.forEach(this.getChildren(), function (obj) {
							if (!obj._started && !obj._destroyed && lang.isFunction(obj.startup)) {
								obj.startup();
								obj._started = true;
							}
						});
					},
					destroyRecursive: function (_376) {
						this._beingDestroyed = true;
						this.destroyDescendants(_376);
						this.destroy(_376);
					},
					destroy: function (_377) {
						this._beingDestroyed = true;
						this.uninitialize();
						var c;
						while (c = this._connects.pop()) {
							c.remove();
						}
						var w;
						while (w = this._supportingWidgets.pop()) {
							if (w.destroyRecursive) {
								w.destroyRecursive();
							} else {
								if (w.destroy) {
									w.destroy();
								}
							}
						}
						this.destroyRendering(_377);
						_367.remove(this.id);
						this._destroyed = true;
					},
					destroyRendering: function (_378) {
						if (this.bgIframe) {
							this.bgIframe.destroy(_378);
							delete this.bgIframe;
						}
						if (this.domNode) {
							if (_378) {
								_35e.remove(this.domNode, "widgetId");
							} else {
								_360.destroy(this.domNode);
							}
							delete this.domNode;
						}
						if (this.srcNodeRef) {
							if (!_378) {
								_360.destroy(this.srcNodeRef);
							}
							delete this.srcNodeRef;
						}
					},
					destroyDescendants: function (_379) {
						_359.forEach(this.getChildren(), function (_37a) {
							if (_37a.destroyRecursive) {
								_37a.destroyRecursive(_379);
							}
						});
					},
					uninitialize: function () {
						return false;
					},
					_setStyleAttr: function (_37b) {
						var _37c = this.domNode;
						if (lang.isObject(_37b)) {
							_362.set(_37c, _37b);
						} else {
							if (_37c.style.cssText) {
								_37c.style.cssText += "; " + _37b;
							} else {
								_37c.style.cssText = _37b;
							}
						}
						this._set("style", _37b);
					},
					_attrToDom: function (attr, _37d, _37e) {
						_37e = arguments.length >= 3 ? _37e : this.attributeMap[attr];
						_359.forEach(lang.isArray(_37e) ? _37e : [_37e], function (_37f) {
							var _380 = this[_37f.node || _37f || "domNode"];
							var type = _37f.type || "attribute";
							switch (type) {
								case "attribute":
									if (lang.isFunction(_37d)) {
										_37d = lang.hitch(this, _37d);
									}
									var _381 = _37f.attribute ? _37f.attribute : (/^on[A-Z][a-zA-Z]*$/.test(attr) ? attr.toLowerCase() : attr);
									_35e.set(_380, _381, _37d);
									break;
								case "innerText":
									_380.innerHTML = "";
									_380.appendChild(win.doc.createTextNode(_37d));
									break;
								case "innerHTML":
									_380.innerHTML = _37d;
									break;
								case "class":
									_35f.replace(_380, _37d, this[attr]);
									break;
							}
						}, this);
					},
					get: function (name) {
						var _382 = this._getAttrNames(name);
						return this[_382.g] ? this[_382.g]() : this[name];
					},
					set: function (name, _383) {
						if (typeof name === "object") {
							for (var x in name) {
								this.set(x, name[x]);
							}
							return this;
						}
						var _384 = this._getAttrNames(name),
							_385 = this[_384.s];
						if (lang.isFunction(_385)) {
							var _386 = _385.apply(this, Array.prototype.slice.call(arguments, 1));
						} else {
							var _387 = this.focusNode && !lang.isFunction(this.focusNode) ? "focusNode" : "domNode",
								tag = this[_387].tagName,
								_388 = _369[tag] || (_369[tag] = _36a(this[_387])),
								map = name in this.attributeMap ? this.attributeMap[name] : _384.s in this ? this[_384.s] : ((_384.l in _388 && typeof _383 != "function") || /^aria-|^data-|^role$/.test(name)) ? _387 : null;
							if (map != null) {
								this._attrToDom(name, _383, map);
							}
							this._set(name, _383);
						}
						return _386 || this;
					},
					_attrPairNames: {},
					_getAttrNames: function (name) {
						var apn = this._attrPairNames;
						if (apn[name]) {
							return apn[name];
						}
						var uc = name.replace(/^[a-z]|-[a-zA-Z]/g, function (c) {
							return c.charAt(c.length - 1).toUpperCase();
						});
						return (apn[name] = {
							n: name + "Node",
							s: "_set" + uc + "Attr",
							g: "_get" + uc + "Attr",
							l: uc.toLowerCase()
						});
					},
					_set: function (name, _389) {
						var _38a = this[name];
						this[name] = _389;
						if (this._watchCallbacks && this._created && _389 !== _38a) {
							this._watchCallbacks(name, _38a, _389);
						}
					},
					on: function (type, func) {
						return _35a.after(this, this._onMap(type), func, true);
					},
					_onMap: function (type) {
						var ctor = this.constructor,
							map = ctor._onMap;
						if (!map) {
							map = (ctor._onMap = {});
							for (var attr in ctor.prototype) {
								if (/^on/.test(attr)) {
									map[attr.replace(/^on/, "").toLowerCase()] = attr;
								}
							}
						}
						return map[type.toLowerCase()];
					},
					toString: function () {
						return "[Widget " + this.declaredClass + ", " + (this.id || "NO ID") + "]";
					},
					getChildren: function () {
						return this.containerNode ? _367.findWidgets(this.containerNode) : [];
					},
					getParent: function () {
						return _367.getEnclosingWidget(this.domNode.parentNode);
					},
					connect: function (obj, _38b, _38c) {
						var _38d = _35c.connect(obj, _38b, this, _38c);
						this._connects.push(_38d);
						return _38d;
					},
					disconnect: function (_38e) {
						var i = _359.indexOf(this._connects, _38e);
						if (i != -1) {
							_38e.remove();
							this._connects.splice(i, 1);
						}
					},
					subscribe: function (t, _38f) {
						var _390 = _366.subscribe(t, lang.hitch(this, _38f));
						this._connects.push(_390);
						return _390;
					},
					unsubscribe: function (_391) {
						this.disconnect(_391);
					},
					isLeftToRight: function () {
						return this.dir ? (this.dir == "ltr") : _361.isBodyLtr();
					},
					isFocusable: function () {
						return this.focus && (_362.get(this.domNode, "display") != "none");
					},
					placeAt: function (_392, _393) {
						if (_392.declaredClass && _392.addChild) {
							_392.addChild(this, _393);
						} else {
							_360.place(this.domNode, _392, _393);
						}
						return this;
					},
					getTextDir: function (text, _394) {
						return _394;
					},
					applyTextDir: function () {}
				});
			});
		},
		"dijit/form/Form": function () {
			define("dijit/form/Form", ["dojo/_base/declare", "dojo/dom-attr", "dojo/_base/event", "dojo/_base/kernel", "dojo/_base/sniff", "../_Widget", "../_TemplatedMixin", "./_FormMixin", "../layout/_ContentPaneResizeMixin"], function (_395, _396, _397, _398, has, _399, _39a, _39b, _39c) {
				return _395("dijit.form.Form", [_399, _39a, _39b, _39c], {
					name: "",
					action: "",
					method: "",
					encType: "",
					"accept-charset": "",
					accept: "",
					target: "",
					templateString: "<form data-dojo-attach-point='containerNode' data-dojo-attach-event='onreset:_onReset,onsubmit:_onSubmit' ${!nameAttrSetting}></form>",
					postMixInProperties: function () {
						this.nameAttrSetting = this.name ? ("name='" + this.name + "'") : "";
						this.inherited(arguments);
					},
					execute: function () {},
					onExecute: function () {},
					_setEncTypeAttr: function (_39d) {
						this.encType = _39d;
						_396.set(this.domNode, "encType", _39d);
						if (has("ie")) {
							this.domNode.encoding = _39d;
						}
					},
					reset: function (e) {
						var faux = {
							returnValue: true,
							preventDefault: function () {
								this.returnValue = false;
							},
							stopPropagation: function () {},
							currentTarget: e ? e.target : this.domNode,
							target: e ? e.target : this.domNode
						};
						if (!(this.onReset(faux) === false) && faux.returnValue) {
							this.inherited(arguments, []);
						}
					},
					onReset: function () {
						return true;
					},
					_onReset: function (e) {
						this.reset(e);
						_397.stop(e);
						return false;
					},
					_onSubmit: function (e) {
						var fp = this.constructor.prototype;
						if (this.execute != fp.execute || this.onExecute != fp.onExecute) {
							_398.deprecated("dijit.form.Form:execute()/onExecute() are deprecated. Use onSubmit() instead.", "", "2.0");
							this.onExecute();
							this.execute(this.getValues());
						}
						if (this.onSubmit(e) === false) {
							_397.stop(e);
						}
					},
					onSubmit: function () {
						return this.isValid();
					},
					submit: function () {
						if (!(this.onSubmit() === false)) {
							this.containerNode.submit();
						}
					}
				});
			});
		},
		"dojo/store/Memory": function () {
			define(["../_base/declare", "./util/QueryResults", "./util/SimpleQueryEngine"], function (_39e, _39f, _3a0) {
				return _39e("dojo.store.Memory", null, {
					constructor: function (_3a1) {
						for (var i in _3a1) {
							this[i] = _3a1[i];
						}
						this.setData(this.data || []);
					},
					data: null,
					idProperty: "id",
					index: null,
					queryEngine: _3a0,
					get: function (id) {
						return this.data[this.index[id]];
					},
					getIdentity: function (_3a2) {
						return _3a2[this.idProperty];
					},
					put: function (_3a3, _3a4) {
						var data = this.data,
							_3a5 = this.index,
							_3a6 = this.idProperty;
						var id = (_3a4 && "id" in _3a4) ? _3a4.id : _3a6 in _3a3 ? _3a3[_3a6] : Math.random();
						if (id in _3a5) {
							if (_3a4 && _3a4.overwrite === false) {
								throw new Error("Object already exists");
							}
							data[_3a5[id]] = _3a3;
						} else {
							_3a5[id] = data.push(_3a3) - 1;
						}
						return id;
					},
					add: function (_3a7, _3a8) {
						(_3a8 = _3a8 || {}).overwrite = false;
						return this.put(_3a7, _3a8);
					},
					remove: function (id) {
						var _3a9 = this.index;
						var data = this.data;
						if (id in _3a9) {
							data.splice(_3a9[id], 1);
							this.setData(data);
							return true;
						}
					},
					query: function (_3aa, _3ab) {
						return _39f(this.queryEngine(_3aa, _3ab)(this.data));
					},
					setData: function (data) {
						if (data.items) {
							this.idProperty = data.identifier;
							data = this.data = data.items;
						} else {
							this.data = data;
						}
						this.index = {};
						for (var i = 0, l = data.length; i < l; i++) {
							this.index[data[i][this.idProperty]] = i;
						}
					}
				});
			});
		},
		"url:dijit/templates/Tooltip.html": "<div class=\"dijitTooltip dijitTooltipLeft\" id=\"dojoTooltip\"\r\n\t><div class=\"dijitTooltipContainer dijitTooltipContents\" data-dojo-attach-point=\"containerNode\" role='alert'></div\r\n\t><div class=\"dijitTooltipConnector\" data-dojo-attach-point=\"connectorNode\"></div\r\n></div>\r\n",
		"dojox/validate/web": function () {
			define("dojox/validate/web", ["./_base", "./regexp"], function (_3ac, _3ad) {
				_3ac.isIpAddress = function (_3ae, _3af) {
					var re = new RegExp("^" + _3ad.ipAddress(_3af) + "$", "i");
					return re.test(_3ae);
				};
				_3ac.isUrl = function (_3b0, _3b1) {
					var re = new RegExp("^" + _3ad.url(_3b1) + "$", "i");
					return re.test(_3b0);
				};
				_3ac.isEmailAddress = function (_3b2, _3b3) {
					var re = new RegExp("^" + _3ad.emailAddress(_3b3) + "$", "i");
					return re.test(_3b2);
				};
				_3ac.isEmailAddressList = function (_3b4, _3b5) {
					var re = new RegExp("^" + _3ad.emailAddressList(_3b5) + "$", "i");
					return re.test(_3b4);
				};
				_3ac.getEmailAddressList = function (_3b6, _3b7) {
					if (!_3b7) {
						_3b7 = {};
					}
					if (!_3b7.listSeparator) {
						_3b7.listSeparator = "\\s;,";
					}
					if (_3ac.isEmailAddressList(_3b6, _3b7)) {
						return _3b6.split(new RegExp("\\s*[" + _3b7.listSeparator + "]\\s*"));
					}
					return [];
				};
				return _3ac;
			});
		},
		"dojo/regexp": function () {
			define(["./_base/kernel", "./_base/lang"], function (dojo, lang) {
				lang.getObject("regexp", true, dojo);
				dojo.regexp.escapeString = function (str, _3b8) {
					return str.replace(/([\.$?*|{}\(\)\[\]\\\/\+^])/g, function (ch) {
						if (_3b8 && _3b8.indexOf(ch) != -1) {
							return ch;
						}
						return "\\" + ch;
					});
				};
				dojo.regexp.buildGroupRE = function (arr, re, _3b9) {
					if (!(arr instanceof Array)) {
						return re(arr);
					}
					var b = [];
					for (var i = 0; i < arr.length; i++) {
						b.push(re(arr[i]));
					}
					return dojo.regexp.group(b.join("|"), _3b9);
				};
				dojo.regexp.group = function (_3ba, _3bb) {
					return "(" + (_3bb ? "?:" : "") + _3ba + ")";
				};
				return dojo.regexp;
			});
		},
		"dijit/form/ComboBox": function () {
			define("dijit/form/ComboBox", ["dojo/_base/declare", "./ValidationTextBox", "./ComboBoxMixin"], function (_3bc, _3bd, _3be) {
				return _3bc("dijit.form.ComboBox", [_3bd, _3be], {});
			});
		},
		"dijit/form/_FormMixin": function () {
			define("dijit/form/_FormMixin", ["dojo/_base/array", "dojo/_base/declare", "dojo/_base/kernel", "dojo/_base/lang", "dojo/window"], function (_3bf, _3c0, _3c1, lang, _3c2) {
				return _3c0("dijit.form._FormMixin", null, {
					state: "",
					_getDescendantFormWidgets: function (_3c3) {
						var res = [];
						_3bf.forEach(_3c3 || this.getChildren(), function (_3c4) {
							if ("value" in _3c4) {
								res.push(_3c4);
							} else {
								res = res.concat(this._getDescendantFormWidgets(_3c4.getChildren()));
							}
						}, this);
						return res;
					},
					reset: function () {
						_3bf.forEach(this._getDescendantFormWidgets(), function (_3c5) {
							if (_3c5.reset) {
								_3c5.reset();
							}
						});
					},
					validate: function () {
						var _3c6 = false;
						return _3bf.every(_3bf.map(this._getDescendantFormWidgets(), function (_3c7) {
							_3c7._hasBeenBlurred = true;
							var _3c8 = _3c7.disabled || !_3c7.validate || _3c7.validate();
							if (!_3c8 && !_3c6) {
								_3c2.scrollIntoView(_3c7.containerNode || _3c7.domNode);
								_3c7.focus();
								_3c6 = true;
							}
							return _3c8;
						}), function (item) {
							return item;
						});
					},
					setValues: function (val) {
						_3c1.deprecated(this.declaredClass + "::setValues() is deprecated. Use set('value', val) instead.", "", "2.0");
						return this.set("value", val);
					},
					_setValueAttr: function (obj) {
						var map = {};
						_3bf.forEach(this._getDescendantFormWidgets(), function (_3c9) {
							if (!_3c9.name) {
								return;
							}
							var _3ca = map[_3c9.name] || (map[_3c9.name] = []);
							_3ca.push(_3c9);
						});
						for (var name in map) {
							if (!map.hasOwnProperty(name)) {
								continue;
							}
							var _3cb = map[name],
								_3cc = lang.getObject(name, false, obj);
							if (_3cc === undefined) {
								continue;
							}
							if (!lang.isArray(_3cc)) {
								_3cc = [_3cc];
							}
							if (typeof _3cb[0].checked == "boolean") {
								_3bf.forEach(_3cb, function (w) {
									w.set("value", _3bf.indexOf(_3cc, w.value) != -1);
								});
							} else {
								if (_3cb[0].multiple) {
									_3cb[0].set("value", _3cc);
								} else {
									_3bf.forEach(_3cb, function (w, i) {
										w.set("value", _3cc[i]);
									});
								}
							}
						}
					},
					getValues: function () {
						_3c1.deprecated(this.declaredClass + "::getValues() is deprecated. Use get('value') instead.", "", "2.0");
						return this.get("value");
					},
					_getValueAttr: function () {
						var obj = {};
						_3bf.forEach(this._getDescendantFormWidgets(), function (_3cd) {
							var name = _3cd.name;
							if (!name || _3cd.disabled) {
								return;
							}
							var _3ce = _3cd.get("value");
							if (typeof _3cd.checked == "boolean") {
								if (/Radio/.test(_3cd.declaredClass)) {
									if (_3ce !== false) {
										lang.setObject(name, _3ce, obj);
									} else {
										_3ce = lang.getObject(name, false, obj);
										if (_3ce === undefined) {
											lang.setObject(name, null, obj);
										}
									}
								} else {
									var ary = lang.getObject(name, false, obj);
									if (!ary) {
										ary = [];
										lang.setObject(name, ary, obj);
									}
									if (_3ce !== false) {
										ary.push(_3ce);
									}
								}
							} else {
								var prev = lang.getObject(name, false, obj);
								if (typeof prev != "undefined") {
									if (lang.isArray(prev)) {
										prev.push(_3ce);
									} else {
										lang.setObject(name, [prev, _3ce], obj);
									}
								} else {
									lang.setObject(name, _3ce, obj);
								}
							}
						});
						return obj;
					},
					isValid: function () {
						return this.state == "";
					},
					onValidStateChange: function () {},
					_getState: function () {
						var _3cf = _3bf.map(this._descendants, function (w) {
							return w.get("state") || "";
						});
						return _3bf.indexOf(_3cf, "Error") >= 0 ? "Error" : _3bf.indexOf(_3cf, "Incomplete") >= 0 ? "Incomplete" : "";
					},
					disconnectChildren: function () {
						_3bf.forEach(this._childConnections || [], lang.hitch(this, "disconnect"));
						_3bf.forEach(this._childWatches || [], function (w) {
							w.unwatch();
						});
					},
					connectChildren: function (_3d0) {
						var _3d1 = this;
						this.disconnectChildren();
						this._descendants = this._getDescendantFormWidgets();
						var set = _3d0 ? function (name, val) {
							_3d1[name] = val;
						} : lang.hitch(this, "_set");
						set("value", this.get("value"));
						set("state", this._getState());
						var _3d2 = (this._childConnections = []),
							_3d3 = (this._childWatches = []);
						_3bf.forEach(_3bf.filter(this._descendants, function (item) {
							return item.validate;
						}), function (_3d4) {
							_3bf.forEach(["state", "disabled"], function (attr) {
								_3d3.push(_3d4.watch(attr, function () {
									_3d1.set("state", _3d1._getState());
								}));
							});
						});
						var _3d5 = function () {
							if (_3d1._onChangeDelayTimer) {
								clearTimeout(_3d1._onChangeDelayTimer);
							}
							_3d1._onChangeDelayTimer = setTimeout(function () {
								delete _3d1._onChangeDelayTimer;
								_3d1._set("value", _3d1.get("value"));
							}, 10);
						};
						_3bf.forEach(_3bf.filter(this._descendants, function (item) {
							return item.onChange;
						}), function (_3d6) {
							_3d2.push(_3d1.connect(_3d6, "onChange", _3d5));
							_3d3.push(_3d6.watch("disabled", _3d5));
						});
					},
					startup: function () {
						this.inherited(arguments);
						this.connectChildren(true);
						this.watch("state", function (attr, _3d7, _3d8) {
							this.onValidStateChange(_3d8 == "");
						});
					},
					destroy: function () {
						this.disconnectChildren();
						this.inherited(arguments);
					}
				});
			});
		},
		"dijit/form/_CheckBoxMixin": function () {
			define("dijit/form/_CheckBoxMixin", ["dojo/_base/declare", "dojo/dom-attr", "dojo/_base/event"], function (_3d9, _3da, _3db) {
				return _3d9("dijit.form._CheckBoxMixin", null, {
					type: "checkbox",
					value: "on",
					readOnly: false,
					_aria_attr: "aria-checked",
					_setReadOnlyAttr: function (_3dc) {
						this._set("readOnly", _3dc);
						_3da.set(this.focusNode, "readOnly", _3dc);
						this.focusNode.setAttribute("aria-readonly", _3dc);
					},
					_setLabelAttr: undefined,
					postMixInProperties: function () {
						if (this.value == "") {
							this.value = "on";
						}
						this.inherited(arguments);
					},
					reset: function () {
						this.inherited(arguments);
						this._set("value", this.params.value || "on");
						_3da.set(this.focusNode, "value", this.value);
					},
					_onClick: function (e) {
						if (this.readOnly) {
							_3db.stop(e);
							return false;
						}
						return this.inherited(arguments);
					}
				});
			});
		},
		"dijit/layout/ContentPane": function () {
			define("dijit/layout/ContentPane", ["dojo/_base/kernel", "dojo/_base/lang", "../_Widget", "./_ContentPaneResizeMixin", "dojo/string", "dojo/html", "dojo/i18n!../nls/loading", "dojo/_base/array", "dojo/_base/declare", "dojo/_base/Deferred", "dojo/dom", "dojo/dom-attr", "dojo/_base/window", "dojo/_base/xhr", "dojo/i18n"], function (_3dd, lang, _3de, _3df, _3e0, html, _3e1, _3e2, _3e3, _3e4, dom, _3e5, win, xhr, i18n) {
				return _3e3("dijit.layout.ContentPane", [_3de, _3df], {
					href: "",
					content: "",
					extractContent: false,
					parseOnLoad: true,
					parserScope: _3dd._scopeName,
					preventCache: false,
					preload: false,
					refreshOnShow: false,
					loadingMessage: "<span class='dijitContentPaneLoading'><span class='dijitInline dijitIconLoading'></span>${loadingState}</span>",
					errorMessage: "<span class='dijitContentPaneError'><span class='dijitInline dijitIconError'></span>${errorState}</span>",
					isLoaded: false,
					baseClass: "dijitContentPane",
					ioArgs: {},
					onLoadDeferred: null,
					_setTitleAttr: null,
					stopParser: true,
					template: false,
					create: function (_3e6, _3e7) {
						if ((!_3e6 || !_3e6.template) && _3e7 && !("href" in _3e6) && !("content" in _3e6)) {
							var df = win.doc.createDocumentFragment();
							_3e7 = dom.byId(_3e7);
							while (_3e7.firstChild) {
								df.appendChild(_3e7.firstChild);
							}
							_3e6 = lang.delegate(_3e6, {
								content: df
							});
						}
						this.inherited(arguments, [_3e6, _3e7]);
					},
					postMixInProperties: function () {
						this.inherited(arguments);
						var _3e8 = i18n.getLocalization("dijit", "loading", this.lang);
						this.loadingMessage = _3e0.substitute(this.loadingMessage, _3e8);
						this.errorMessage = _3e0.substitute(this.errorMessage, _3e8);
					},
					buildRendering: function () {
						this.inherited(arguments);
						if (!this.containerNode) {
							this.containerNode = this.domNode;
						}
						this.domNode.title = "";
						if (!_3e5.get(this.domNode, "role")) {
							this.domNode.setAttribute("role", "group");
						}
					},
					startup: function () {
						this.inherited(arguments);
						if (this._contentSetter) {
							_3e2.forEach(this._contentSetter.parseResults, function (obj) {
								if (!obj._started && !obj._destroyed && lang.isFunction(obj.startup)) {
									obj.startup();
									obj._started = true;
								}
							}, this);
						}
					},
					setHref: function (href) {
						_3dd.deprecated("dijit.layout.ContentPane.setHref() is deprecated. Use set('href', ...) instead.", "", "2.0");
						return this.set("href", href);
					},
					_setHrefAttr: function (href) {
						this.cancel();
						this.onLoadDeferred = new _3e4(lang.hitch(this, "cancel"));
						this.onLoadDeferred.addCallback(lang.hitch(this, "onLoad"));
						this._set("href", href);
						if (this.preload || (this._created && this._isShown())) {
							this._load();
						} else {
							this._hrefChanged = true;
						}
						return this.onLoadDeferred;
					},
					setContent: function (data) {
						_3dd.deprecated("dijit.layout.ContentPane.setContent() is deprecated.  Use set('content', ...) instead.", "", "2.0");
						this.set("content", data);
					},
					_setContentAttr: function (data) {
						this._set("href", "");
						this.cancel();
						this.onLoadDeferred = new _3e4(lang.hitch(this, "cancel"));
						if (this._created) {
							this.onLoadDeferred.addCallback(lang.hitch(this, "onLoad"));
						}
						this._setContent(data || "");
						this._isDownloaded = false;
						return this.onLoadDeferred;
					},
					_getContentAttr: function () {
						return this.containerNode.innerHTML;
					},
					cancel: function () {
						if (this._xhrDfd && (this._xhrDfd.fired == -1)) {
							this._xhrDfd.cancel();
						}
						delete this._xhrDfd;
						this.onLoadDeferred = null;
					},
					uninitialize: function () {
						if (this._beingDestroyed) {
							this.cancel();
						}
						this.inherited(arguments);
					},
					destroyRecursive: function (_3e9) {
						if (this._beingDestroyed) {
							return;
						}
						this.inherited(arguments);
					},
					_onShow: function () {
						this.inherited(arguments);
						if (this.href) {
							if (!this._xhrDfd && (!this.isLoaded || this._hrefChanged || this.refreshOnShow)) {
								return this.refresh();
							}
						}
					},
					refresh: function () {
						this.cancel();
						this.onLoadDeferred = new _3e4(lang.hitch(this, "cancel"));
						this.onLoadDeferred.addCallback(lang.hitch(this, "onLoad"));
						this._load();
						return this.onLoadDeferred;
					},
					_load: function () {
						this._setContent(this.onDownloadStart(), true);
						var self = this;
						var _3ea = {
							preventCache: (this.preventCache || this.refreshOnShow),
							url: this.href,
							handleAs: "text"
						};
						if (lang.isObject(this.ioArgs)) {
							lang.mixin(_3ea, this.ioArgs);
						}
						var hand = (this._xhrDfd = (this.ioMethod || xhr.get)(_3ea));
						hand.addCallback(function (html) {
							try {
								self._isDownloaded = true;
								self._setContent(html, false);
								self.onDownloadEnd();
							} catch (err) {
								self._onError("Content", err);
							}
							delete self._xhrDfd;
							return html;
						});
						hand.addErrback(function (err) {
							if (!hand.canceled) {
								self._onError("Download", err);
							}
							delete self._xhrDfd;
							return err;
						});
						delete this._hrefChanged;
					},
					_onLoadHandler: function (data) {
						this._set("isLoaded", true);
						try {
							this.onLoadDeferred.callback(data);
						} catch (e) {
							console.error("Error " + this.widgetId + " running custom onLoad code: " + e.message);
						}
					},
					_onUnloadHandler: function () {
						this._set("isLoaded", false);
						try {
							this.onUnload();
						} catch (e) {
							console.error("Error " + this.widgetId + " running custom onUnload code: " + e.message);
						}
					},
					destroyDescendants: function (_3eb) {
						if (this.isLoaded) {
							this._onUnloadHandler();
						}
						var _3ec = this._contentSetter;
						_3e2.forEach(this.getChildren(), function (_3ed) {
							if (_3ed.destroyRecursive) {
								_3ed.destroyRecursive(_3eb);
							}
						});
						if (_3ec) {
							_3e2.forEach(_3ec.parseResults, function (_3ee) {
								if (_3ee.destroyRecursive && _3ee.domNode && _3ee.domNode.parentNode == win.body()) {
									_3ee.destroyRecursive(_3eb);
								}
							});
							delete _3ec.parseResults;
						}
						if (!_3eb) {
							html._emptyNode(this.containerNode);
						}
						delete this._singleChild;
					},
					_setContent: function (cont, _3ef) {
						this.destroyDescendants();
						var _3f0 = this._contentSetter;
						if (!(_3f0 && _3f0 instanceof html._ContentSetter)) {
							_3f0 = this._contentSetter = new html._ContentSetter({
								node: this.containerNode,
								_onError: lang.hitch(this, this._onError),
								onContentError: lang.hitch(this, function (e) {
									var _3f1 = this.onContentError(e);
									try {
										this.containerNode.innerHTML = _3f1;
									} catch (e) {
										console.error("Fatal " + this.id + " could not change content due to " + e.message, e);
									}
								})
							});
						}
						var _3f2 = lang.mixin({
							cleanContent: this.cleanContent,
							extractContent: this.extractContent,
							parseContent: !cont.domNode && this.parseOnLoad,
							parserScope: this.parserScope,
							startup: false,
							dir: this.dir,
							lang: this.lang,
							textDir: this.textDir
						}, this._contentSetterParams || {});
						_3f0.set((lang.isObject(cont) && cont.domNode) ? cont.domNode : cont, _3f2);
						delete this._contentSetterParams;
						if (this.doLayout) {
							this._checkIfSingleChild();
						}
						if (!_3ef) {
							if (this._started) {
								delete this._started;
								this.startup();
								this._scheduleLayout();
							}
							this._onLoadHandler(cont);
						}
					},
					_onError: function (type, err, _3f3) {
						this.onLoadDeferred.errback(err);
						var _3f4 = this["on" + type + "Error"].call(this, err);
						if (_3f3) {
							console.error(_3f3, err);
						} else {
							if (_3f4) {
								this._setContent(_3f4, true);
							}
						}
					},
					onLoad: function () {},
					onUnload: function () {},
					onDownloadStart: function () {
						return this.loadingMessage;
					},
					onContentError: function () {},
					onDownloadError: function () {
						return this.errorMessage;
					},
					onDownloadEnd: function () {}
				});
			});
		},
		"oob/serviceip/IPconfig": function () {
			require({
				cache: {
					"url:oob/serviceip/templates/IPconfig.html": "<div>\r\n    <div class=\"radioDiv\">\r\n        <div class=\"radioItem\">\r\n            <input type=\"radio\" name=\"iptype\" id=\"type4_s\" value=\"ipv4\" dojoAttachPoint=\"radio4\" dojoType=\"dijit.form.RadioButton\" dojoAttachEvent=\"onClick:ipV4Selected\"></input>\r\n            <label for=\"type4_s\" class=\"radioLabel\">${nls.ipv4}</label>\r\n        </div>\r\n        <div class=\"radioItem\">\r\n            <input type=\"radio\" name=\"iptype\" id=\"type6_s\" value=\"ipv6\" dojoAttachPoint=\"radio6\" dojoType=\"dijit.form.RadioButton\" dojoAttachEvent=\"onClick:ipV6Selected\"></input>\r\n            <label for=\"type6_s\" class=\"radioLabel\">${nls.ipv6}</label>\r\n        </div>\r\n    </div>\r\n    <div dojoAttachPoint=\"ipv4div\" class=\"ipDiv\">\r\n        <form dojoType=\"dijit.form.Form\" dojoAttachPoint=\"ipv4Form\">\r\n            <table>\r\n                <tr><td>${nls.address}</td><td><input type=\"text\" name=\"address4\" dojoAttachPoint=\"address_4\" dojoType=\"dijit.form.ValidationTextBox\"></input></td></tr>\r\n                <tr><td>${nls.mask}</td>   <td><input type=\"text\" name=\"mask4\" dojoAttachPoint=\"mask_4\" dojoType=\"dijit.form.ValidationTextBox\"></input></td></tr>\r\n                <tr><td>${nls.gateway}</td><td><input type=\"text\" name=\"gateway4\" dojoAttachPoint=\"gateway_4\" dojoType=\"dijit.form.ValidationTextBox\"></input></td></tr>\r\n            </table>\r\n        </form>\r\n        <div dojoAttachPoint=\"difSubnet\" class=\"difSubnet hidden\">${nls.notsamenetwork}</div>\r\n    </div>\r\n    <div dojoAttachPoint=\"ipv6div\" class=\"ipDiv\">\r\n        <form dojoType=\"dijit.form.Form\" dojoAttachPoint=\"ipv6Form\">\r\n            <table>\r\n                <tr><td>${nls.address}</td><td><input type=\"text\" name=\"address6\" dojoAttachPoint=\"address_6\" dojoType=\"dijit.form.ValidationTextBox\"></input></td></tr>\r\n                <tr><td>${nls.prefix}</td> <td><input type=\"text\" name=\"mask6\" dojoAttachPoint=\"mask_6\" dojoType=\"dijit.form.ValidationTextBox\"></input></td></tr>\r\n                <tr><td>${nls.gateway}</td><td><input type=\"text\" name=\"gateway6\" dojoAttachPoint=\"gateway_6\" dojoType=\"dijit.form.ValidationTextBox\"></input></td></tr>\r\n            </table>\r\n        </form>\r\n    </div>\r\n</div>"
				}
			});
			define("oob/serviceip/IPconfig", ["dojo/_base/declare", "oob/clusterip/IPconfig", "oob/Utils", "dojo/text!./templates/IPconfig.html"], function (_3f5, _3f6, _3f7, _3f8) {
				return _3f5("oob.serviceip.IPconfig", [_3f6], {
					templateString: _3f8,
					panelName: "menu_serviceip",
					CMD_TEMP: {
						"ipv4": "satask chserviceip -serviceip ${address4} -gw ${gateway4} -mask ${mask4}",
						"ipv6": "satask chserviceip -serviceip_6 ${address6} -gw_6 ${gateway6} -prefix_6 ${mask6}"
					},
					_setEnterFunc: function () {
						_3f7.connectTop("serviceipEnter", this, "enterFunc");
					},
					_setNextFunc: function () {
						_3f7.connectTop("serviceipNext", this, "writeCommandIntoFile");
					}
				});
			});
		},
		"url:dijit/form/templates/ValidationTextBox.html": "<div class=\"dijit dijitReset dijitInline dijitLeft\"\r\n\tid=\"widget_${id}\" role=\"presentation\"\r\n\t><div class='dijitReset dijitValidationContainer'\r\n\t\t><input class=\"dijitReset dijitInputField dijitValidationIcon dijitValidationInner\" value=\"&#935; \" type=\"text\" tabIndex=\"-1\" readonly=\"readonly\" role=\"presentation\"\r\n\t/></div\r\n\t><div class=\"dijitReset dijitInputField dijitInputContainer\"\r\n\t\t><input class=\"dijitReset dijitInputInner\" data-dojo-attach-point='textbox,focusNode' autocomplete=\"off\"\r\n\t\t\t${!nameAttrSetting} type='${type}'\r\n\t/></div\r\n></div>\r\n",
		"dojox/validate/_base": function () {
			define("dojox/validate/_base", ["dojo/_base/lang", "dojo/regexp", "dojo/number", "./regexp"], function (lang, _3f9, _3fa, _3fb) {
				var _3fc = lang.getObject("dojox.validate", true);
				_3fc.isText = function (_3fd, _3fe) {
					_3fe = (typeof _3fe == "object") ? _3fe : {};
					if (/^\s*$/.test(_3fd)) {
						return false;
					}
					if (typeof _3fe.length == "number" && _3fe.length != _3fd.length) {
						return false;
					}
					if (typeof _3fe.minlength == "number" && _3fe.minlength > _3fd.length) {
						return false;
					}
					if (typeof _3fe.maxlength == "number" && _3fe.maxlength < _3fd.length) {
						return false;
					}
					return true;
				};
				_3fc._isInRangeCache = {};
				_3fc.isInRange = function (_3ff, _400) {
					_3ff = _3fa.parse(_3ff, _400);
					if (isNaN(_3ff)) {
						return false;
					}
					_400 = (typeof _400 == "object") ? _400 : {};
					var max = (typeof _400.max == "number") ? _400.max : Infinity,
						min = (typeof _400.min == "number") ? _400.min : -Infinity,
						dec = (typeof _400.decimal == "string") ? _400.decimal : ".",
						_401 = _3fc._isInRangeCache,
						_402 = _3ff + "max" + max + "min" + min + "dec" + dec;
					if (typeof _401[_402] != "undefined") {
						return _401[_402];
					}
					_401[_402] = !(_3ff < min || _3ff > max);
					return _401[_402];
				};
				_3fc.isNumberFormat = function (_403, _404) {
					var re = new RegExp("^" + _3fb.numberFormat(_404) + "$", "i");
					return re.test(_403);
				};
				_3fc.isValidLuhn = function (_405) {
					var sum = 0,
						_406, _407;
					if (!lang.isString(_405)) {
						_405 = String(_405);
					}
					_405 = _405.replace(/[- ]/g, "");
					_406 = _405.length % 2;
					for (var i = 0; i < _405.length; i++) {
						_407 = parseInt(_405.charAt(i));
						if (i % 2 == _406) {
							_407 *= 2;
						}
						if (_407 > 9) {
							_407 -= 9;
						}
						sum += _407;
					}
					return !(sum % 10);
				};
				return _3fc;
			});
		},
		"url:dijit/form/templates/TextBox.html": "<div class=\"dijit dijitReset dijitInline dijitLeft\" id=\"widget_${id}\" role=\"presentation\"\r\n\t><div class=\"dijitReset dijitInputField dijitInputContainer\"\r\n\t\t><input class=\"dijitReset dijitInputInner\" data-dojo-attach-point='textbox,focusNode' autocomplete=\"off\"\r\n\t\t\t${!nameAttrSetting} type='${type}'\r\n\t/></div\r\n></div>\r\n",
		"dijit/layout/utils": function () {
			define("dijit/layout/utils", ["dojo/_base/array", "dojo/dom-class", "dojo/dom-geometry", "dojo/dom-style", "dojo/_base/lang", ".."], function (_408, _409, _40a, _40b, lang, _40c) {
				var _40d = lang.getObject("layout", true, _40c);
				_40d.marginBox2contentBox = function (node, mb) {
					var cs = _40b.getComputedStyle(node);
					var me = _40a.getMarginExtents(node, cs);
					var pb = _40a.getPadBorderExtents(node, cs);
					return {
						l: _40b.toPixelValue(node, cs.paddingLeft),
						t: _40b.toPixelValue(node, cs.paddingTop),
						w: mb.w - (me.w + pb.w),
						h: mb.h - (me.h + pb.h)
					};
				};

				function _40e(word) {
					return word.substring(0, 1).toUpperCase() + word.substring(1);
				};

				function size(_40f, dim) {
					var _410 = _40f.resize ? _40f.resize(dim) : _40a.setMarginBox(_40f.domNode, dim);
					if (_410) {
						lang.mixin(_40f, _410);
					} else {
						lang.mixin(_40f, _40a.getMarginBox(_40f.domNode));
						lang.mixin(_40f, dim);
					}
				};
				_40d.layoutChildren = function (_411, dim, _412, _413, _414) {
					dim = lang.mixin({}, dim);
					_409.add(_411, "dijitLayoutContainer");
					_412 = _408.filter(_412, function (item) {
						return item.region != "center" && item.layoutAlign != "client";
					}).concat(_408.filter(_412, function (item) {
						return item.region == "center" || item.layoutAlign == "client";
					}));
					_408.forEach(_412, function (_415) {
						var elm = _415.domNode,
							pos = (_415.region || _415.layoutAlign);
						if (!pos) {
							throw new Error("No region setting for " + _415.id);
						}
						var _416 = elm.style;
						_416.left = dim.l + "px";
						_416.top = dim.t + "px";
						_416.position = "absolute";
						_409.add(elm, "dijitAlign" + _40e(pos));
						var _417 = {};
						if (_413 && _413 == _415.id) {
							_417[_415.region == "top" || _415.region == "bottom" ? "h" : "w"] = _414;
						}
						if (pos == "top" || pos == "bottom") {
							_417.w = dim.w;
							size(_415, _417);
							dim.h -= _415.h;
							if (pos == "top") {
								dim.t += _415.h;
							} else {
								_416.top = dim.t + dim.h + "px";
							}
						} else {
							if (pos == "left" || pos == "right") {
								_417.h = dim.h;
								size(_415, _417);
								dim.w -= _415.w;
								if (pos == "left") {
									dim.l += _415.w;
								} else {
									_416.left = dim.l + dim.w + "px";
								}
							} else {
								if (pos == "client" || pos == "center") {
									size(_415, dim);
								}
							}
						}
					});
				};
				return {
					marginBox2contentBox: _40d.marginBox2contentBox,
					layoutChildren: _40d.layoutChildren
				};
			});
		},
		"dijit/_Contained": function () {
			define("dijit/_Contained", ["dojo/_base/declare", "./registry"], function (_418, _419) {
				return _418("dijit._Contained", null, {
					_getSibling: function (_41a) {
						var node = this.domNode;
						do {
							node = node[_41a + "Sibling"];
						} while (node && node.nodeType != 1);
						return node && _419.byNode(node);
					},
					getPreviousSibling: function () {
						return this._getSibling("previous");
					},
					getNextSibling: function () {
						return this._getSibling("next");
					},
					getIndexInParent: function () {
						var p = this.getParent();
						if (!p || !p.getIndexOfChild) {
							return -1;
						}
						return p.getIndexOfChild(this);
					}
				});
			});
		},
		"oob/summary/Summary": function () {
			define(["dojo/_base/lang", "dojo/_base/array", "dojo/_base/Deferred", "dojo/_base/declare", "dojo/query", "dojo/dom", "dojo/dom-class", "dojo/string", "dijit/_WidgetBase", "dijit/_TemplatedMixin", "dijit/_WidgetsInTemplateMixin", "dojo/text!./templates/Summary.html", "oob/Utils", "oob/summary/CountDownTimerMixin", "dijit/form/Button", "dijit/Dialog"], function (lang, _41b, _41c, _41d, _41e, dom, _41f, _420, _421, _422, _423, _424, _425, _426) {
				return _41d("oob.summary.Summary", [_421, _422, _423, _426], {
					nls: null,
					templateString: _424,
					refreshContinue: true,
					saCommand: null,
					cmdResult: null,
					targetServiceIP: null,
					TIME_CLUSTER_VERIFICATION: 3,
					IP_REACHED_REG: /ttl=\d+/mi,
					batteryCharged: false,
					postMixInProperties: function () {
						var nls = this.nls;
						nls.resetfailedstep2 = _425.escapeHTML(nls.resetfailedstep2);
						nls.errorinfo = nls.errorinfo + " " + nls.usesat2fix;
						this.inherited(arguments);
					},
					postCreate: function () {
						this._setEnterFunc();
						this._setNextFunc();
						top.go2IBMsuppoert = lang.hitch(this, this.go2IBMSupport);
						this.inherited(arguments);
					},
					_setEnterFunc: function () {
						_425.connectTop("summaryEnter", this, "checkSACommandResult");
					},
					checkSACommandResult: function () {
						if (!top.commandResult) {
							_425.show(this.extendSysDiv, true);
							var _427 = this;
							_425.getCurrentPanelDoc(function (doc) {
								dom.byId("title", doc).innerHTML = _427.nls.extendenclosuretitle;
								dom.byId("description", doc).innerHTML = _427.nls.extendenclosuredesc;
							});
							return;
						}
						this.saCommand = top.commandResult.getCommand(0);
						this.cmdResult = this.saCommand.getAllProps();
						var _428 = (top.oob.task == top.oob.TASKS[1]);
						_425.show(this.createClusterdiv, !_428);
						_425.show(this.resetPwddiv, _428);
						switch (top.oob.task) {
							case top.oob.TASKS[0]:
								this.checkCreateClusterCMDResult();
								break;
							case top.oob.TASKS[1]:
								this.checkResetPwdCMDResult();
								break;
							case top.oob.TASKS[2]:
								this.checkSetServiceIPCMDResult();
								break;
						}
					},
					confirmServiceIP: function () {
						this.disableFinishButton(true, this.finishBtnHolder[1]);
						this._toggleSetServiceIPDiv(true);
						var _429 = this,
							_42a = this.saCommand.getServiceStatusCMD(),
							_42b = _42a.getProps(["service_IP_address", "service_IP_address_6"]),
							_42c = _41b.filter(_42b.service_IP_address.concat(_42b.service_IP_address_6), function (ip) {
								if (ip != null && dojo.string.trim(ip) != "") {
									return true;
								} else {
									return false;
								}
							});
						var _42d = 0,
							len = _42c.length,
							_42e = top.STARTINGDIR + ["launchpad", "command", "result", "servicepingresult.txt"].join(top.PATHSEPARATOR);
						var _42f = function () {
							var def = new _41c();
							def.then(function () {
								_42f();
							});
							top.runCommand(command("deleteFile", _42e), function () {
								top.runCommand(command("ping", _42c[_42d], _42e), function () {
									_425.callWithVerification(_42e, lang.hitch(this, function (_430) {
										if (this.IP_REACHED_REG.exec(_430) != null) {
											this.targetServiceIP = {
												"ip": _42c[_42d]
											};
											this._hideSetServiceIPDiv();
											this.disableFinishButton(false, this.finishBtnHolder[1]);
										} else {
											_42d++;
											if (_42d < len) {
												def.callback(true);
											} else {
												this.targetServiceIP = {
													"ip": null
												};
												this._toggleSetServiceIPDiv(false);
												top.moveToSetServieIP = this.moveToSetServieIP;
												this.disableFinishButton(false, this.finishBtnHolder[1]);
											}
										}
									}));
								}, _429, (top.BROWSER == "IExplore" ? 1000 * 10 : null));
							});
						};
						_42f();
					},
					_toggleSetServiceIPDiv: function (_431) {
						_425.show(this.checkingServiceIPDiv, _431);
						_425.show(this.ipUnreachedDiv, !_431);
					},
					_hideSetServiceIPDiv: function () {
						_425.show(this.checkingServiceIPDiv, false);
						_425.show(this.ipUnreachedDiv, false);
					},
					checkCreateClusterCMDResult: function (_432) {
						var _433 = this.saCommand.getServiceStatusCMD().getProps("time_to_charge")[0] * 1,
							_434 = _433 > 0 ? {
								prompt: this.nls.dialogbatterycontent,
								error: this.nls.dialogchargingerror
							} : {
								prompt: this.nls.dialogclustercontent,
								error: this.nls.dialogunableconnectcluster
							};
						this.confirmServiceIP();
						if (this.cmdResult.exit != 0) {
							this._toggleIpDiv(false);
							this._showBackendError();
						} else {
							this._setVerificationDialogText(_434.prompt);
							this.dialog.show();
							this.dialogBtn.set("disabled", true);
							this.refreshClusterStatus(_433 + this.TIME_CLUSTER_VERIFICATION, _434.error);
							this.disableFinishButton(true, this.finishBtnHolder[0]);
						}
					},
					checkResetPwdCMDResult: function (_435) {
						var _436 = (this.cmdResult.exit == 0);
						_425.show(this.resetPwddiv, !_436);
						if (_436) {
							this.setDesc(this.nls.resetpwdsuccessdesc);
						} else {
							this.setDesc(this.nls.resetpwdfailuredesc);
						}
					},
					checkSetServiceIPCMDResult: function (_437) {
						var _438 = (this.cmdResult.exit == 0);
						this._toggleIpDiv(_438);
						this._hideSetServiceIPDiv();
						_425.getCurrentPanelDoc(function (doc) {
							_425.show(dom.byId("description", doc), true);
						});
						if (_438) {
							this.iptitlediv.innerHTML = this.nls.serviceip;
							this._showIPvalues();
						} else {
							this.setDesc(this.nls.serviceipfailuredesc);
							_425.show(this.errorinfodiv, false);
							this.backendError.innerHTML = this._createCMMVCLink(this._filterMessage(this.cmdResult.output));
						}
					},
					setDesc: function (str) {
						_425.getCurrentPanelDoc(function (doc) {
							dom.byId("description", doc).innerHTML = str;
						});
					},
					_setNextFunc: function () {
						_425.connectTop("finishAction", this, "showFinishPrompt");
					},
					showFinishPrompt: function () {
						switch (top.oob.task) {
							case top.oob.TASKS[0]:
								if (this.batteryCharged) {
									this.showFinishDialog();
								} else {
									this.direct2GUIFromCMDResult("service");
								}
								break;
							case top.oob.TASKS[1]:
								this.direct2GUIFromCMDResult("cluster");
								break;
							case top.oob.TASKS[2]:
								if (this.cmdResult.exit == 0) {
									this.direct2GUIbySetIP("service");
								}
								_425.exitProgram();
								break;
							default:
								_425.exitProgram();
						}
					},
					showFinishDialog: function () {
						var _439 = this;
						top.showFinishDlg(function () {
							_439.direct2GUIbySetIP();
							_425.exitProgram();
						});
					},
					direct2GUIFromCMDResult: function (type) {
						if (this.saCommand == null) {
							_425.exitProgram();
							return;
						}
						var _43a = this.saCommand.getServiceStatusCMD(),
							_43b = _43a.getProps("cluster_ip"),
							_43c = _43a.getProps("cluster_ip_6");
						switch (type) {
							case "service":
								if (this.targetServiceIP != null && this.targetServiceIP.ip != null) {
									_425.openURL(_425.getURLbyIP(this.targetServiceIP.ip) + "/service");
								}
								break;
							case "cluster":
								_425.openURL(_425.getFirstIpURL(_43b, _43c));
								break;
						}
						_425.exitProgram();
					},
					direct2GUIbySetIP: function (type) {
						var URL = _425.getURLbyIP(top.clusterIP.ipv4Checked ? top.clusterIP.ipv4.address4 : top.clusterIP.ipv6.address6);
						_425.openURL(type == "service" ? URL + "/service" : URL);
					},
					_showIPvalues: function () {
						var ipv4 = top.clusterIP.ipv4Checked,
							type = (ipv4 ? 4 : 6),
							_43d = (ipv4 ? top.clusterIP.ipv4 : top.clusterIP.ipv6);
						this._toggleIpDiv(true);
						_425.show(this.ipv4div, ipv4);
						_425.show(this.ipv6div, !ipv4);
						_41b.forEach(["address", "mask", "gateway"], function (_43e) {
							var _43f = _43e + type;
							_41e("[name=" + _43f + "]", this.ipdiv)[0].innerHTML = _43d[_43f];
						}, this);
					},
					_filterMessage: function (msg) {
						if (msg.indexOf("CMMVC8000E") == -1) {
							return msg;
						}
						return this.nls.errorclustercreated;
					},
					_showBackendError: function () {
						_425.getCurrentPanelDoc(function (doc) {
							_425.show(dom.byId("description", doc), false);
						});
						this._toggleIpDiv(false);
						if (this.cmdResult.exit == 1) {
							this.backendError.innerHTML = this._createCMMVCLink(this._filterMessage(this.cmdResult.output));
						}
					},
					_createCMMVCLink: function (_440) {
						if (_440.indexOf("CMMVC") == -1) {
							return _440;
						}
						var _441 = "file:///",
							_442 = top.STARTINGDIR + ["launchpad", "content", top.LOCALE, "helpfiles", _425.getDeviceType(), "tbrd_gui_" + _420.trim(_440.match(/CMMVC\S*\s/m)[0]).toLowerCase() + ".html"].join(top.PATHSEPARATOR);
						return top.fileExists(_442) ? ("<a href=\"#\" onclick=\"top.openURL('" + _441 + _442.replace(/\\/g, "/") + "', 'ErrorLink');\">" + _440 + "</a>") : _440;
					},
					_toggleIpDiv: function (show) {
						_425.show(this.ipdiv, show);
						_425.show(this.errordiv, !show);
					},
					_setVerificationDialogText: function (msg) {
						this.chargingSpan.innerHTML = msg;
					},
					_waitForTomcatStartup: function () {
						this._setVerificationDialogText(this.nls.waitingfortomcat);
						this.countdownTimer.setTime(2 * 60 * 1000);
						this.countdownTimer.startCount(lang.hitch(this, function (text) {
							this.countDownTimerText.innerHTML = text;
							this.dialogBtn.set("disabled", false);
						}), lang.hitch(this, function () {
							this.dialogBtnClicked();
						}));
					},
					refreshClusterStatus: function (_443, _444) {
						var _445 = this,
							_446 = false;
						this.pingCluster(function () {
							_446 = true;
							setTimeout(function () {
								_445.countdownTimer.stopCount();
								_445.setDialogComplete();
								_445.dialogBtnClicked();
							}, _445.countdownTimer.time);
						});
						this.countdownTimer.setTime(_443 * 60 * 1000);
						this.countdownTimer.startCount(lang.hitch(this, function (text) {
							this.countDownTimerText.innerHTML = text;
						}), lang.hitch(this, function () {
							if (_446) {
								return;
							}
							this.setDialogError(_444);
						}));
					},
					pingCluster: function (_447) {
						var _448 = this,
							_449 = top.clusterIP.ipv4Checked ? top.clusterIP.ipv4.address4 : top.clusterIP.ipv6.address6,
							_44a = top.STARTINGDIR + ["launchpad", "command", "result", "pingresult.txt"].join(top.PATHSEPARATOR);
						var _44b = function () {
							if (!_448.refreshContinue) {
								return;
							}
							var def = new _41c();
							def.then(function () {
								_44b();
							});
							top.runCommand(command("deleteFile", _44a), function () {
								top.runCommand(command("ping", _449, _44a), function () {
									_425.callWithVerification(_44a, lang.hitch(this, function (_44c) {
										if (!this.refreshContinue) {
											return;
										}
										if (this.IP_REACHED_REG.exec(_44c) != null) {
											_447();
										} else {
											setTimeout(function () {
												def.callback(true);
											}, 1000 * 10);
										}
									}));
								}, _448, (top.BROWSER == "IExplore" ? 1000 * 5 : null));
							});
						};
						_44b();
					},
					setDialogComplete: function () {
						this.finishBtnHolderStatus = {};
						this._stopTimers();
						this._toggleChargingIcon(true);
						this.batteryCharged = true;
					},
					_toggleChargingIcon: function (_44d) {
						_41f.toggle(this.chargingIcon, "chargingImage", !_44d);
						_41f.toggle(this.chargingIcon, "chargedImage", _44d);
					},
					setDialogError: function (_44e) {
						this._stopTimers();
						_425.show(this.chargingIcon, false);
						this.dialogError.innerHTML = _44e;
						_425.show(this.dialogError, true);
					},
					_stopTimers: function () {
						this.countdownTimer.stopCount();
						this.refreshContinue = false;
						this.dialogBtn.set("disabled", false);
						_425.show(this.countDownTimerText, false);
					},
					dialogBtnClicked: function () {
						this.countdownTimer.inter && this.setDialogComplete();
						this.dialog.hide();
						this.disableFinishButton(false, this.finishBtnHolder[0]);
						if (this.batteryCharged) {
							this._showIPvalues();
						} else {
							this._showBackendError();
						}
					},
					finishBtnHolder: ["batteryCharging", "prepareService"],
					finishBtnHolderStatus: {},
					disableFinishButton: function (_44f, id) {
						this.finishBtnHolderStatus[id] = _44f;
						if (!_44f) {
							var _450 = true;
							for (var id in this.finishBtnHolderStatus) {
								if (this.finishBtnHolderStatus[id]) {
									_450 = false;
									break;
								}
							}
							top.enableButton("nextButton", _450);
						} else {
							top.enableButton("nextButton", !_44f);
						}
					},
					moveToSetServieIP: function () {
						top.navigateTo("menu_tasks");
						top.TasksWidget.chooseSetServiceIP();
						setTimeout(function () {
							top.TasksWidget.saveTasksType();
						}, 500);
					},
					go2IBMSupport: function () {
						_425.openURL(this.nls.ibmsupportaddress);
					}
				});
			});
		},
		"oob/usb/USBSteps": function () {
			define(["dojo/_base/lang", "dojo/_base/declare", "dojo/_base/array", "dojo/query", "dijit/_WidgetBase", "dijit/_TemplatedMixin", "dijit/_WidgetsInTemplateMixin", "dijit/registry", "../Utils", "./USB", "dojo/text!./templates/USBSteps.html", "dojo/NodeList-dom"], function (lang, _451, _452, _453, _454, _455, _456, _457, _458, USB, _459) {
				return _451("oob.usb.USBSteps", [_454, _455, _456, USB], {
					nls: null,
					templateString: _459,
					postMixInProperties: function () {
						this.inherited(arguments);
						if (_458.Devices.isV7k()) {
							this.nls.powerontxt = this.nls.powerontxtv7k;
							this.nls.insert2canistertxt = this.nls.insert2canistertxtv7k;
						}
						if (_458.Devices.isTMS()) {
							this.nls.insert2canistertxt = this.nls.insert2canistertxttms;
							this.nls.insert2canistertxtsip = this.nls.insert2canistertxtsiptms;
							this.nls.powerontxt = this.nls.powerontxttms;
						}
					},
					postCreate: function () {
						if (!top.showUSBSteps) {
							var _45a = this,
								_45b = top.setUSBStepHelpLink = function (type) {
									top.showHelpLink(true, _45a.nls.needhelptext);
									top.openHelplink = function () {
										var _45c = top.STARTINGDIR + ["launchpad", "content", top.LOCALE, "helpfiles", _458.getDeviceType(), {
											"poweron": "tbrd_gui_poweron_statusled.html",
											"insert2canister": "tbrd_gui_faultled_parent.html",
											"removeusb": "tbrd_gui_nextdisabled.html",
											"backupdrive": "tms_encryptioncopyPC.html",
											"reinsert2canister": "tms_encryptioncopycanister.html"
										} [type]].join(top.PATHSEPARATOR);
										top.openURL("file:///" + _45c.replace(/\\/g, "/"), "NeedHelp");
									};
								};
							top.showUSBSteps = function (type) {
								switch (type) {
									case "poweron":
										top.enableButton("previousButton", false);
										break;
									case "insert2canister":
										_458.isMenuShown("menu_poweron") || top.enableButton("previousButton", false);
										top.navigationHistory = [];
										var _45d = oob.tasks.Tasks.prototype.TASKS[2],
											_45e = (top.oob.task === _45d ? _45a.nls.insert2canistertxtsip : _45a.nls.insert2canistertxt);
										break;
									case "removeusb":
										break;
								}
								_45b(type);
								top.getContentWindow(null, function (_45f, _460) {
									_452.forEach(["poweron", "insert2canister", "removeusb"], function (area) {
										var _461 = _460.contentWindow.document.body;
										_453("div[dojoattachpoint=" + area + "]", _461).toggleClass("hidden", area != type);
										if (area == type && type == "insert2canister") {
											_453("div[dojoattachpoint=insert2CanDiv]", _461)[0].innerHTML = _45e;
										}
									});
								});
							};
							this._setEnterFunc();
							this._setNextFunc();
							this._setPreviousFunc();
						}
						this.inherited(arguments);
					},
					go2Next: function () {
						top.showHelpLink(false);
						this.inherited(arguments);
					}
				});
			});
		},
		"dijit/form/DataList": function () {
			define("dijit/form/DataList", ["dojo/_base/declare", "dojo/dom", "dojo/_base/lang", "dojo/query", "dojo/store/Memory", "../registry"], function (_462, dom, lang, _463, _464, _465) {
				function _466(_467) {
					return {
						id: _467.value,
						value: _467.value,
						name: lang.trim(_467.innerText || _467.textContent || "")
					};
				};
				return _462("dijit.form.DataList", _464, {
					constructor: function (_468, _469) {
						this.domNode = dom.byId(_469);
						lang.mixin(this, _468);
						if (this.id) {
							_465.add(this);
						}
						this.domNode.style.display = "none";
						this.inherited(arguments, [{
							data: _463("option", this.domNode).map(_466)
						}]);
					},
					destroy: function () {
						_465.remove(this.id);
					},
					fetchSelectedItem: function () {
						var _46a = _463("> option[selected]", this.domNode)[0] || _463("> option", this.domNode)[0];
						return _46a && _466(_46a);
					}
				});
			});
		},
		"dijit/form/CheckBox": function () {
			require({
				cache: {
					"url:dijit/form/templates/CheckBox.html": "<div class=\"dijit dijitReset dijitInline\" role=\"presentation\"\r\n\t><input\r\n\t \t${!nameAttrSetting} type=\"${type}\" ${checkedAttrSetting}\r\n\t\tclass=\"dijitReset dijitCheckBoxInput\"\r\n\t\tdata-dojo-attach-point=\"focusNode\"\r\n\t \tdata-dojo-attach-event=\"onclick:_onClick\"\r\n/></div>\r\n"
				}
			});
			define("dijit/form/CheckBox", ["require", "dojo/_base/declare", "dojo/dom-attr", "dojo/_base/kernel", "dojo/query", "dojo/ready", "./ToggleButton", "./_CheckBoxMixin", "dojo/text!./templates/CheckBox.html", "dojo/NodeList-dom"], function (_46b, _46c, _46d, _46e, _46f, _470, _471, _472, _473) {
				if (!_46e.isAsync) {
					_470(0, function () {
						var _474 = ["dijit/form/RadioButton"];
						_46b(_474);
					});
				}
				return _46c("dijit.form.CheckBox", [_471, _472], {
					templateString: _473,
					baseClass: "dijitCheckBox",
					_setValueAttr: function (_475, _476) {
						if (typeof _475 == "string") {
							this._set("value", _475);
							_46d.set(this.focusNode, "value", _475);
							_475 = true;
						}
						if (this._created) {
							this.set("checked", _475, _476);
						}
					},
					_getValueAttr: function () {
						return (this.checked ? this.value : false);
					},
					_setIconClassAttr: null,
					postMixInProperties: function () {
						this.inherited(arguments);
						this.checkedAttrSetting = this.checked ? "checked" : "";
					},
					_fillContent: function () {},
					_onFocus: function () {
						if (this.id) {
							_46f("label[for='" + this.id + "']").addClass("dijitFocusedLabel");
						}
						this.inherited(arguments);
					},
					_onBlur: function () {
						if (this.id) {
							_46f("label[for='" + this.id + "']").removeClass("dijitFocusedLabel");
						}
						this.inherited(arguments);
					}
				});
			});
		},
		"url:dijit/templates/Dialog.html": "<div class=\"dijitDialog\" role=\"dialog\" aria-labelledby=\"${id}_title\">\r\n\t<div data-dojo-attach-point=\"titleBar\" class=\"dijitDialogTitleBar\">\r\n\t<span data-dojo-attach-point=\"titleNode\" class=\"dijitDialogTitle\" id=\"${id}_title\"></span>\r\n\t<span data-dojo-attach-point=\"closeButtonNode\" class=\"dijitDialogCloseIcon\" data-dojo-attach-event=\"ondijitclick: onCancel\" title=\"${buttonCancel}\" role=\"button\" tabIndex=\"-1\">\r\n\t\t<span data-dojo-attach-point=\"closeText\" class=\"closeText\" title=\"${buttonCancel}\">x</span>\r\n\t</span>\r\n\t</div>\r\n\t\t<div data-dojo-attach-point=\"containerNode\" class=\"dijitDialogPaneContent\"></div>\r\n</div>\r\n",
		"dojo/html": function () {
			define(["./_base/kernel", "./_base/lang", "./_base/array", "./_base/declare", "./dom", "./dom-construct", "./parser"], function (dojo, lang, _477, _478, dom, _479, _47a) {
				lang.getObject("html", true, dojo);
				var _47b = 0;
				dojo.html._secureForInnerHtml = function (cont) {
					return cont.replace(/(?:\s*<!DOCTYPE\s[^>]+>|<title[^>]*>[\s\S]*?<\/title>)/ig, "");
				};
				dojo.html._emptyNode = _479.empty;
				dojo.html._setNodeContent = function (node, cont) {
					_479.empty(node);
					if (cont) {
						if (typeof cont == "string") {
							cont = _479.toDom(cont, node.ownerDocument);
						}
						if (!cont.nodeType && lang.isArrayLike(cont)) {
							for (var _47c = cont.length, i = 0; i < cont.length; i = _47c == cont.length ? i + 1 : 0) {
								_479.place(cont[i], node, "last");
							}
						} else {
							_479.place(cont, node, "last");
						}
					}
					return node;
				};
				_478("dojo.html._ContentSetter", null, {
					node: "",
					content: "",
					id: "",
					cleanContent: false,
					extractContent: false,
					parseContent: false,
					parserScope: dojo._scopeName,
					startup: true,
					constructor: function (_47d, node) {
						lang.mixin(this, _47d || {});
						node = this.node = dom.byId(this.node || node);
						if (!this.id) {
							this.id = ["Setter", (node) ? node.id || node.tagName : "", _47b++].join("_");
						}
					},
					set: function (cont, _47e) {
						if (undefined !== cont) {
							this.content = cont;
						}
						if (_47e) {
							this._mixin(_47e);
						}
						this.onBegin();
						this.setContent();
						this.onEnd();
						return this.node;
					},
					setContent: function () {
						var node = this.node;
						if (!node) {
							throw new Error(this.declaredClass + ": setContent given no node");
						}
						try {
							node = dojo.html._setNodeContent(node, this.content);
						} catch (e) {
							var _47f = this.onContentError(e);
							try {
								node.innerHTML = _47f;
							} catch (e) {
								console.error("Fatal " + this.declaredClass + ".setContent could not change content due to " + e.message, e);
							}
						}
						this.node = node;
					},
					empty: function () {
						if (this.parseResults && this.parseResults.length) {
							_477.forEach(this.parseResults, function (w) {
								if (w.destroy) {
									w.destroy();
								}
							});
							delete this.parseResults;
						}
						dojo.html._emptyNode(this.node);
					},
					onBegin: function () {
						var cont = this.content;
						if (lang.isString(cont)) {
							if (this.cleanContent) {
								cont = dojo.html._secureForInnerHtml(cont);
							}
							if (this.extractContent) {
								var _480 = cont.match(/<body[^>]*>\s*([\s\S]+)\s*<\/body>/im);
								if (_480) {
									cont = _480[1];
								}
							}
						}
						this.empty();
						this.content = cont;
						return this.node;
					},
					onEnd: function () {
						if (this.parseContent) {
							this._parse();
						}
						return this.node;
					},
					tearDown: function () {
						delete this.parseResults;
						delete this.node;
						delete this.content;
					},
					onContentError: function (err) {
						return "Error occured setting content: " + err;
					},
					_mixin: function (_481) {
						var _482 = {},
							key;
						for (key in _481) {
							if (key in _482) {
								continue;
							}
							this[key] = _481[key];
						}
					},
					_parse: function () {
						var _483 = this.node;
						try {
							var _484 = {};
							_477.forEach(["dir", "lang", "textDir"], function (name) {
								if (this[name]) {
									_484[name] = this[name];
								}
							}, this);
							this.parseResults = _47a.parse({
								rootNode: _483,
								noStart: !this.startup,
								inherited: _484,
								scope: this.parserScope
							});
						} catch (e) {
							this._onError("Content", e, "Error parsing in _ContentSetter#" + this.id);
						}
					},
					_onError: function (type, err, _485) {
						var _486 = this["on" + type + "Error"].call(this, err);
						if (_485) {
							console.error(_485, err);
						} else {
							if (_486) {
								dojo.html._setNodeContent(this.node, _486, true);
							}
						}
					}
				});
				dojo.html.set = function (node, cont, _487) {
					if (undefined == cont) {
						console.warn("dojo.html.set: no cont argument provided, using empty string");
						cont = "";
					}
					if (!_487) {
						return dojo.html._setNodeContent(node, cont, true);
					} else {
						var op = new dojo.html._ContentSetter(lang.mixin(_487, {
							content: cont,
							node: node
						}));
						return op.set();
					}
				};
				return dojo.html;
			});
		},
		"dijit/form/ValidationTextBox": function () {
			require({
				cache: {
					"url:dijit/form/templates/ValidationTextBox.html": "<div class=\"dijit dijitReset dijitInline dijitLeft\"\r\n\tid=\"widget_${id}\" role=\"presentation\"\r\n\t><div class='dijitReset dijitValidationContainer'\r\n\t\t><input class=\"dijitReset dijitInputField dijitValidationIcon dijitValidationInner\" value=\"&#935; \" type=\"text\" tabIndex=\"-1\" readonly=\"readonly\" role=\"presentation\"\r\n\t/></div\r\n\t><div class=\"dijitReset dijitInputField dijitInputContainer\"\r\n\t\t><input class=\"dijitReset dijitInputInner\" data-dojo-attach-point='textbox,focusNode' autocomplete=\"off\"\r\n\t\t\t${!nameAttrSetting} type='${type}'\r\n\t/></div\r\n></div>\r\n"
				}
			});
			define("dijit/form/ValidationTextBox", ["dojo/_base/declare", "dojo/i18n", "./TextBox", "../Tooltip", "dojo/text!./templates/ValidationTextBox.html", "dojo/i18n!./nls/validate"], function (_488, i18n, _489, _48a, _48b) {
				return _488("dijit.form.ValidationTextBox", _489, {
					templateString: _48b,
					baseClass: "dijitTextBox dijitValidationTextBox",
					required: false,
					promptMessage: "",
					invalidMessage: "$_unset_$",
					missingMessage: "$_unset_$",
					message: "",
					constraints: {},
					regExp: ".*",
					regExpGen: function () {
						return this.regExp;
					},
					state: "",
					tooltipPosition: [],
					_setValueAttr: function () {
						this.inherited(arguments);
						this.validate(this.focused);
					},
					validator: function (_48c, _48d) {
						return (new RegExp("^(?:" + this.regExpGen(_48d) + ")" + (this.required ? "" : "?") + "$")).test(_48c) && (!this.required || !this._isEmpty(_48c)) && (this._isEmpty(_48c) || this.parse(_48c, _48d) !== undefined);
					},
					_isValidSubset: function () {
						return this.textbox.value.search(this._partialre) == 0;
					},
					isValid: function () {
						return this.validator(this.textbox.value, this.constraints);
					},
					_isEmpty: function (_48e) {
						return (this.trim ? /^\s*$/ : /^$/).test(_48e);
					},
					getErrorMessage: function () {
						return (this.required && this._isEmpty(this.textbox.value)) ? this.missingMessage : this.invalidMessage;
					},
					getPromptMessage: function () {
						return this.promptMessage;
					},
					_maskValidSubsetError: true,
					validate: function (_48f) {
						var _490 = "";
						var _491 = this.disabled || this.isValid(_48f);
						if (_491) {
							this._maskValidSubsetError = true;
						}
						var _492 = this._isEmpty(this.textbox.value);
						var _493 = !_491 && _48f && this._isValidSubset();
						this._set("state", _491 ? "" : (((((!this._hasBeenBlurred || _48f) && _492) || _493) && this._maskValidSubsetError) ? "Incomplete" : "Error"));
						this.focusNode.setAttribute("aria-invalid", _491 ? "false" : "true");
						if (this.state == "Error") {
							this._maskValidSubsetError = _48f && _493;
							_490 = this.getErrorMessage(_48f);
						} else {
							if (this.state == "Incomplete") {
								_490 = this.getPromptMessage(_48f);
								this._maskValidSubsetError = !this._hasBeenBlurred || _48f;
							} else {
								if (_492) {
									_490 = this.getPromptMessage(_48f);
								}
							}
						}
						this.set("message", _490);
						return _491;
					},
					displayMessage: function (_494) {
						if (_494 && this.focused) {
							_48a.show(_494, this.domNode, this.tooltipPosition, !this.isLeftToRight());
						} else {
							_48a.hide(this.domNode);
						}
					},
					_refreshState: function () {
						this.validate(this.focused);
						this.inherited(arguments);
					},
					constructor: function () {
						this.constraints = {};
					},
					_setConstraintsAttr: function (_495) {
						if (!_495.locale && this.lang) {
							_495.locale = this.lang;
						}
						this._set("constraints", _495);
						this._computePartialRE();
					},
					_computePartialRE: function () {
						var p = this.regExpGen(this.constraints);
						this.regExp = p;
						var _496 = "";
						if (p != ".*") {
							this.regExp.replace(/\\.|\[\]|\[.*?[^\\]{1}\]|\{.*?\}|\(\?[=:!]|./g, function (re) {
								switch (re.charAt(0)) {
									case "{":
									case "+":
									case "?":
									case "*":
									case "^":
									case "$":
									case "|":
									case "(":
										_496 += re;
										break;
									case ")":
										_496 += "|$)";
										break;
									default:
										_496 += "(?:" + re + "|$)";
										break;
								}
							});
						}
						try {
							"".search(_496);
						} catch (e) {
							_496 = this.regExp;
							console.warn("RegExp error in " + this.declaredClass + ": " + this.regExp);
						}
						this._partialre = "^(?:" + _496 + ")$";
					},
					postMixInProperties: function () {
						this.inherited(arguments);
						this.messages = i18n.getLocalization("dijit.form", "validate", this.lang);
						if (this.invalidMessage == "$_unset_$") {
							this.invalidMessage = this.messages.invalidMessage;
						}
						if (!this.invalidMessage) {
							this.invalidMessage = this.promptMessage;
						}
						if (this.missingMessage == "$_unset_$") {
							this.missingMessage = this.messages.missingMessage;
						}
						if (!this.missingMessage) {
							this.missingMessage = this.invalidMessage;
						}
						this._setConstraintsAttr(this.constraints);
					},
					_setDisabledAttr: function (_497) {
						this.inherited(arguments);
						this._refreshState();
					},
					_setRequiredAttr: function (_498) {
						this._set("required", _498);
						this.focusNode.setAttribute("aria-required", _498);
						this._refreshState();
					},
					_setMessageAttr: function (_499) {
						this._set("message", _499);
						this.displayMessage(_499);
					},
					reset: function () {
						this._maskValidSubsetError = true;
						this.inherited(arguments);
					},
					_onBlur: function () {
						this.displayMessage("");
						this.inherited(arguments);
					}
				});
			});
		},
		"dojo/window": function () {
			define(["./_base/lang", "./_base/sniff", "./_base/window", "./dom", "./dom-geometry", "./dom-style"], function (lang, has, _49a, dom, geom, _49b) {
				var _49c = lang.getObject("dojo.window", true);
				_49c.getBox = function () {
					var _49d = (_49a.doc.compatMode == "BackCompat") ? _49a.body() : _49a.doc.documentElement,
						_49e = geom.docScroll(),
						w, h;
					if (has("touch")) {
						var _49f = _49a.doc.parentWindow || _49a.doc.defaultView;
						w = _49f.innerWidth || _49d.clientWidth;
						h = _49f.innerHeight || _49d.clientHeight;
					} else {
						w = _49d.clientWidth;
						h = _49d.clientHeight;
					}
					return {
						l: _49e.x,
						t: _49e.y,
						w: w,
						h: h
					};
				};
				_49c.get = function (doc) {
					if (has("ie") && _49c !== document.parentWindow) {
						doc.parentWindow.execScript("document._parentWindow = window;", "Javascript");
						var win = doc._parentWindow;
						doc._parentWindow = null;
						return win;
					}
					return doc.parentWindow || doc.defaultView;
				};
				_49c.scrollIntoView = function (node, pos) {
					try {
						node = dom.byId(node);
						var doc = node.ownerDocument || _49a.doc,
							body = doc.body || _49a.body(),
							html = doc.documentElement || body.parentNode,
							isIE = has("ie"),
							isWK = has("webkit");
						if ((!(has("mozilla") || isIE || isWK || has("opera")) || node == body || node == html) && (typeof node.scrollIntoView != "undefined")) {
							node.scrollIntoView(false);
							return;
						}
						var _4a0 = doc.compatMode == "BackCompat",
							_4a1 = (isIE >= 9 && node.ownerDocument.parentWindow.frameElement) ? ((html.clientHeight > 0 && html.clientWidth > 0 && (body.clientHeight == 0 || body.clientWidth == 0 || body.clientHeight > html.clientHeight || body.clientWidth > html.clientWidth)) ? html : body) : (_4a0 ? body : html),
							_4a2 = isWK ? body : _4a1,
							_4a3 = _4a1.clientWidth,
							_4a4 = _4a1.clientHeight,
							rtl = !geom.isBodyLtr(),
							_4a5 = pos || geom.position(node),
							el = node.parentNode,
							_4a6 = function (el) {
								return ((isIE <= 6 || (isIE && _4a0)) ? false : (_49b.get(el, "position").toLowerCase() == "fixed"));
							};
						if (_4a6(node)) {
							return;
						}
						while (el) {
							if (el == body) {
								el = _4a2;
							}
							var _4a7 = geom.position(el),
								_4a8 = _4a6(el);
							if (el == _4a2) {
								_4a7.w = _4a3;
								_4a7.h = _4a4;
								if (_4a2 == html && isIE && rtl) {
									_4a7.x += _4a2.offsetWidth - _4a7.w;
								}
								if (_4a7.x < 0 || !isIE) {
									_4a7.x = 0;
								}
								if (_4a7.y < 0 || !isIE) {
									_4a7.y = 0;
								}
							} else {
								var pb = geom.getPadBorderExtents(el);
								_4a7.w -= pb.w;
								_4a7.h -= pb.h;
								_4a7.x += pb.l;
								_4a7.y += pb.t;
								var _4a9 = el.clientWidth,
									_4aa = _4a7.w - _4a9;
								if (_4a9 > 0 && _4aa > 0) {
									_4a7.w = _4a9;
									_4a7.x += (rtl && (isIE || el.clientLeft > pb.l)) ? _4aa : 0;
								}
								_4a9 = el.clientHeight;
								_4aa = _4a7.h - _4a9;
								if (_4a9 > 0 && _4aa > 0) {
									_4a7.h = _4a9;
								}
							}
							if (_4a8) {
								if (_4a7.y < 0) {
									_4a7.h += _4a7.y;
									_4a7.y = 0;
								}
								if (_4a7.x < 0) {
									_4a7.w += _4a7.x;
									_4a7.x = 0;
								}
								if (_4a7.y + _4a7.h > _4a4) {
									_4a7.h = _4a4 - _4a7.y;
								}
								if (_4a7.x + _4a7.w > _4a3) {
									_4a7.w = _4a3 - _4a7.x;
								}
							}
							var l = _4a5.x - _4a7.x,
								t = _4a5.y - Math.max(_4a7.y, 0),
								r = l + _4a5.w - _4a7.w,
								bot = t + _4a5.h - _4a7.h;
							if (r * l > 0) {
								var s = Math[l < 0 ? "max" : "min"](l, r);
								if (rtl && ((isIE == 8 && !_4a0) || isIE >= 9)) {
									s = -s;
								}
								_4a5.x += el.scrollLeft;
								el.scrollLeft += s;
								_4a5.x -= el.scrollLeft;
							}
							if (bot * t > 0) {
								_4a5.y += el.scrollTop;
								el.scrollTop += Math[t < 0 ? "max" : "min"](t, bot);
								_4a5.y -= el.scrollTop;
							}
							el = (el != _4a2) && !_4a8 && el.parentNode;
						}
					} catch (error) {
						console.error("scrollIntoView: " + error);
						node.scrollIntoView(false);
					}
				};
				return _49c;
			});
		},
		"dojo/number": function () {
			define(["./_base/kernel", "./_base/lang", "./i18n", "./i18n!./cldr/nls/number", "./string", "./regexp"], function (dojo, lang, i18n, _4ab, _4ac, _4ad) {
				lang.getObject("number", true, dojo);
				dojo.number.format = function (_4ae, _4af) {
					_4af = lang.mixin({}, _4af || {});
					var _4b0 = i18n.normalizeLocale(_4af.locale),
						_4b1 = i18n.getLocalization("dojo.cldr", "number", _4b0);
					_4af.customs = _4b1;
					var _4b2 = _4af.pattern || _4b1[(_4af.type || "decimal") + "Format"];
					if (isNaN(_4ae) || Math.abs(_4ae) == Infinity) {
						return null;
					}
					return dojo.number._applyPattern(_4ae, _4b2, _4af);
				};
				dojo.number._numberPatternRE = /[#0,]*[#0](?:\.0*#*)?/;
				dojo.number._applyPattern = function (_4b3, _4b4, _4b5) {
					_4b5 = _4b5 || {};
					var _4b6 = _4b5.customs.group,
						_4b7 = _4b5.customs.decimal,
						_4b8 = _4b4.split(";"),
						_4b9 = _4b8[0];
					_4b4 = _4b8[(_4b3 < 0) ? 1 : 0] || ("-" + _4b9);
					if (_4b4.indexOf("%") != -1) {
						_4b3 *= 100;
					} else {
						if (_4b4.indexOf("‰") != -1) {
							_4b3 *= 1000;
						} else {
							if (_4b4.indexOf("¤") != -1) {
								_4b6 = _4b5.customs.currencyGroup || _4b6;
								_4b7 = _4b5.customs.currencyDecimal || _4b7;
								_4b4 = _4b4.replace(/\u00a4{1,3}/, function (_4ba) {
									var prop = ["symbol", "currency", "displayName"][_4ba.length - 1];
									return _4b5[prop] || _4b5.currency || "";
								});
							} else {
								if (_4b4.indexOf("E") != -1) {
									throw new Error("exponential notation not supported");
								}
							}
						}
					}
					var _4bb = dojo.number._numberPatternRE;
					var _4bc = _4b9.match(_4bb);
					if (!_4bc) {
						throw new Error("unable to find a number expression in pattern: " + _4b4);
					}
					if (_4b5.fractional === false) {
						_4b5.places = 0;
					}
					return _4b4.replace(_4bb, dojo.number._formatAbsolute(_4b3, _4bc[0], {
						decimal: _4b7,
						group: _4b6,
						places: _4b5.places,
						round: _4b5.round
					}));
				};
				dojo.number.round = function (_4bd, _4be, _4bf) {
					var _4c0 = 10 / (_4bf || 10);
					return (_4c0 * +_4bd).toFixed(_4be) / _4c0;
				};
				if ((0.9).toFixed() == 0) {
					var _4c1 = dojo.number.round;
					dojo.number.round = function (v, p, m) {
						var d = Math.pow(10, -p || 0),
							a = Math.abs(v);
						if (!v || a >= d || a * Math.pow(10, p + 1) < 5) {
							d = 0;
						}
						return _4c1(v, p, m) + (v > 0 ? d : -d);
					};
				}
				dojo.number._formatAbsolute = function (_4c2, _4c3, _4c4) {
					_4c4 = _4c4 || {};
					if (_4c4.places === true) {
						_4c4.places = 0;
					}
					if (_4c4.places === Infinity) {
						_4c4.places = 6;
					}
					var _4c5 = _4c3.split("."),
						_4c6 = typeof _4c4.places == "string" && _4c4.places.indexOf(","),
						_4c7 = _4c4.places;
					if (_4c6) {
						_4c7 = _4c4.places.substring(_4c6 + 1);
					} else {
						if (!(_4c7 >= 0)) {
							_4c7 = (_4c5[1] || []).length;
						}
					}
					if (!(_4c4.round < 0)) {
						_4c2 = dojo.number.round(_4c2, _4c7, _4c4.round);
					}
					var _4c8 = String(Math.abs(_4c2)).split("."),
						_4c9 = _4c8[1] || "";
					if (_4c5[1] || _4c4.places) {
						if (_4c6) {
							_4c4.places = _4c4.places.substring(0, _4c6);
						}
						var pad = _4c4.places !== undefined ? _4c4.places : (_4c5[1] && _4c5[1].lastIndexOf("0") + 1);
						if (pad > _4c9.length) {
							_4c8[1] = _4ac.pad(_4c9, pad, "0", true);
						}
						if (_4c7 < _4c9.length) {
							_4c8[1] = _4c9.substr(0, _4c7);
						}
					} else {
						if (_4c8[1]) {
							_4c8.pop();
						}
					}
					var _4ca = _4c5[0].replace(",", "");
					pad = _4ca.indexOf("0");
					if (pad != -1) {
						pad = _4ca.length - pad;
						if (pad > _4c8[0].length) {
							_4c8[0] = _4ac.pad(_4c8[0], pad);
						}
						if (_4ca.indexOf("#") == -1) {
							_4c8[0] = _4c8[0].substr(_4c8[0].length - pad);
						}
					}
					var _4cb = _4c5[0].lastIndexOf(","),
						_4cc, _4cd;
					if (_4cb != -1) {
						_4cc = _4c5[0].length - _4cb - 1;
						var _4ce = _4c5[0].substr(0, _4cb);
						_4cb = _4ce.lastIndexOf(",");
						if (_4cb != -1) {
							_4cd = _4ce.length - _4cb - 1;
						}
					}
					var _4cf = [];
					for (var _4d0 = _4c8[0]; _4d0;) {
						var off = _4d0.length - _4cc;
						_4cf.push((off > 0) ? _4d0.substr(off) : _4d0);
						_4d0 = (off > 0) ? _4d0.slice(0, off) : "";
						if (_4cd) {
							_4cc = _4cd;
							delete _4cd;
						}
					}
					_4c8[0] = _4cf.reverse().join(_4c4.group || ",");
					return _4c8.join(_4c4.decimal || ".");
				};
				dojo.number.regexp = function (_4d1) {
					return dojo.number._parseInfo(_4d1).regexp;
				};
				dojo.number._parseInfo = function (_4d2) {
					_4d2 = _4d2 || {};
					var _4d3 = i18n.normalizeLocale(_4d2.locale),
						_4d4 = i18n.getLocalization("dojo.cldr", "number", _4d3),
						_4d5 = _4d2.pattern || _4d4[(_4d2.type || "decimal") + "Format"],
						_4d6 = _4d4.group,
						_4d7 = _4d4.decimal,
						_4d8 = 1;
					if (_4d5.indexOf("%") != -1) {
						_4d8 /= 100;
					} else {
						if (_4d5.indexOf("‰") != -1) {
							_4d8 /= 1000;
						} else {
							var _4d9 = _4d5.indexOf("¤") != -1;
							if (_4d9) {
								_4d6 = _4d4.currencyGroup || _4d6;
								_4d7 = _4d4.currencyDecimal || _4d7;
							}
						}
					}
					var _4da = _4d5.split(";");
					if (_4da.length == 1) {
						_4da.push("-" + _4da[0]);
					}
					var re = _4ad.buildGroupRE(_4da, function (_4db) {
						_4db = "(?:" + _4ad.escapeString(_4db, ".") + ")";
						return _4db.replace(dojo.number._numberPatternRE, function (_4dc) {
							var _4dd = {
									signed: false,
									separator: _4d2.strict ? _4d6 : [_4d6, ""],
									fractional: _4d2.fractional,
									decimal: _4d7,
									exponent: false
								},
								_4de = _4dc.split("."),
								_4df = _4d2.places;
							if (_4de.length == 1 && _4d8 != 1) {
								_4de[1] = "###";
							}
							if (_4de.length == 1 || _4df === 0) {
								_4dd.fractional = false;
							} else {
								if (_4df === undefined) {
									_4df = _4d2.pattern ? _4de[1].lastIndexOf("0") + 1 : Infinity;
								}
								if (_4df && _4d2.fractional == undefined) {
									_4dd.fractional = true;
								}
								if (!_4d2.places && (_4df < _4de[1].length)) {
									_4df += "," + _4de[1].length;
								}
								_4dd.places = _4df;
							}
							var _4e0 = _4de[0].split(",");
							if (_4e0.length > 1) {
								_4dd.groupSize = _4e0.pop().length;
								if (_4e0.length > 1) {
									_4dd.groupSize2 = _4e0.pop().length;
								}
							}
							return "(" + dojo.number._realNumberRegexp(_4dd) + ")";
						});
					}, true);
					if (_4d9) {
						re = re.replace(/([\s\xa0]*)(\u00a4{1,3})([\s\xa0]*)/g, function (_4e1, _4e2, _4e3, _4e4) {
							var prop = ["symbol", "currency", "displayName"][_4e3.length - 1],
								_4e5 = _4ad.escapeString(_4d2[prop] || _4d2.currency || "");
							_4e2 = _4e2 ? "[\\s\\xa0]" : "";
							_4e4 = _4e4 ? "[\\s\\xa0]" : "";
							if (!_4d2.strict) {
								if (_4e2) {
									_4e2 += "*";
								}
								if (_4e4) {
									_4e4 += "*";
								}
								return "(?:" + _4e2 + _4e5 + _4e4 + ")?";
							}
							return _4e2 + _4e5 + _4e4;
						});
					}
					return {
						regexp: re.replace(/[\xa0 ]/g, "[\\s\\xa0]"),
						group: _4d6,
						decimal: _4d7,
						factor: _4d8
					};
				};
				dojo.number.parse = function (_4e6, _4e7) {
					var info = dojo.number._parseInfo(_4e7),
						_4e8 = (new RegExp("^" + info.regexp + "$")).exec(_4e6);
					if (!_4e8) {
						return NaN;
					}
					var _4e9 = _4e8[1];
					if (!_4e8[1]) {
						if (!_4e8[2]) {
							return NaN;
						}
						_4e9 = _4e8[2];
						info.factor *= -1;
					}
					_4e9 = _4e9.replace(new RegExp("[" + info.group + "\\s\\xa0" + "]", "g"), "").replace(info.decimal, ".");
					return _4e9 * info.factor;
				};
				dojo.number._realNumberRegexp = function (_4ea) {
					_4ea = _4ea || {};
					if (!("places" in _4ea)) {
						_4ea.places = Infinity;
					}
					if (typeof _4ea.decimal != "string") {
						_4ea.decimal = ".";
					}
					if (!("fractional" in _4ea) || /^0/.test(_4ea.places)) {
						_4ea.fractional = [true, false];
					}
					if (!("exponent" in _4ea)) {
						_4ea.exponent = [true, false];
					}
					if (!("eSigned" in _4ea)) {
						_4ea.eSigned = [true, false];
					}
					var _4eb = dojo.number._integerRegexp(_4ea),
						_4ec = _4ad.buildGroupRE(_4ea.fractional, function (q) {
							var re = "";
							if (q && (_4ea.places !== 0)) {
								re = "\\" + _4ea.decimal;
								if (_4ea.places == Infinity) {
									re = "(?:" + re + "\\d+)?";
								} else {
									re += "\\d{" + _4ea.places + "}";
								}
							}
							return re;
						}, true);
					var _4ed = _4ad.buildGroupRE(_4ea.exponent, function (q) {
						if (q) {
							return "([eE]" + dojo.number._integerRegexp({
								signed: _4ea.eSigned
							}) + ")";
						}
						return "";
					});
					var _4ee = _4eb + _4ec;
					if (_4ec) {
						_4ee = "(?:(?:" + _4ee + ")|(?:" + _4ec + "))";
					}
					return _4ee + _4ed;
				};
				dojo.number._integerRegexp = function (_4ef) {
					_4ef = _4ef || {};
					if (!("signed" in _4ef)) {
						_4ef.signed = [true, false];
					}
					if (!("separator" in _4ef)) {
						_4ef.separator = "";
					} else {
						if (!("groupSize" in _4ef)) {
							_4ef.groupSize = 3;
						}
					}
					var _4f0 = _4ad.buildGroupRE(_4ef.signed, function (q) {
						return q ? "[-+]" : "";
					}, true);
					var _4f1 = _4ad.buildGroupRE(_4ef.separator, function (sep) {
						if (!sep) {
							return "(?:\\d+)";
						}
						sep = _4ad.escapeString(sep);
						if (sep == " ") {
							sep = "\\s";
						} else {
							if (sep == " ") {
								sep = "\\s\\xa0";
							}
						}
						var grp = _4ef.groupSize,
							grp2 = _4ef.groupSize2;
						if (grp2) {
							var _4f2 = "(?:0|[1-9]\\d{0," + (grp2 - 1) + "}(?:[" + sep + "]\\d{" + grp2 + "})*[" + sep + "]\\d{" + grp + "})";
							return ((grp - grp2) > 0) ? "(?:" + _4f2 + "|(?:0|[1-9]\\d{0," + (grp - 1) + "}))" : _4f2;
						}
						return "(?:0|[1-9]\\d{0," + (grp - 1) + "}(?:[" + sep + "]\\d{" + grp + "})*)";
					}, true);
					return _4f0 + _4f1;
				};
				return dojo.number;
			});
		},
		"dijit/_FocusMixin": function () {
			define("dijit/_FocusMixin", ["./focus", "./_WidgetBase", "dojo/_base/declare", "dojo/_base/lang"], function (_4f3, _4f4, _4f5, lang) {
				lang.extend(_4f4, {
					focused: false,
					onFocus: function () {},
					onBlur: function () {},
					_onFocus: function () {
						this.onFocus();
					},
					_onBlur: function () {
						this.onBlur();
					}
				});
				return _4f5("dijit._FocusMixin", null, {
					_focusManager: _4f3
				});
			});
		},
		"dojo/data/util/filter": function () {
			define(["dojo/_base/lang"], function (lang) {
				var _4f6 = lang.getObject("dojo.data.util.filter", true);
				_4f6.patternToRegExp = function (_4f7, _4f8) {
					var rxp = "^";
					var c = null;
					for (var i = 0; i < _4f7.length; i++) {
						c = _4f7.charAt(i);
						switch (c) {
							case "\\":
								rxp += c;
								i++;
								rxp += _4f7.charAt(i);
								break;
							case "*":
								rxp += ".*";
								break;
							case "?":
								rxp += ".";
								break;
							case "$":
							case "^":
							case "/":
							case "+":
							case ".":
							case "|":
							case "(":
							case ")":
							case "{":
							case "}":
							case "[":
							case "]":
								rxp += "\\";
							default:
								rxp += c;
						}
					}
					rxp += "$";
					if (_4f8) {
						return new RegExp(rxp, "mi");
					} else {
						return new RegExp(rxp, "m");
					}
				};
				return _4f6;
			});
		},
		"dijit/_WidgetsInTemplateMixin": function () {
			define("dijit/_WidgetsInTemplateMixin", ["dojo/_base/array", "dojo/_base/declare", "dojo/parser", "dijit/registry"], function (_4f9, _4fa, _4fb, _4fc) {
				return _4fa("dijit._WidgetsInTemplateMixin", null, {
					_earlyTemplatedStartup: false,
					widgetsInTemplate: true,
					_beforeFillContent: function () {
						if (this.widgetsInTemplate) {
							var node = this.domNode;
							var cw = (this._startupWidgets = _4fb.parse(node, {
								noStart: !this._earlyTemplatedStartup,
								template: true,
								inherited: {
									dir: this.dir,
									lang: this.lang,
									textDir: this.textDir
								},
								propsThis: this,
								scope: "dojo"
							}));
							this._supportingWidgets = _4fc.findWidgets(node);
							this._attachTemplateNodes(cw, function (n, p) {
								return n[p];
							});
						}
					},
					startup: function () {
						_4f9.forEach(this._startupWidgets, function (w) {
							if (w && !w._started && w.startup) {
								w.startup();
							}
						});
						this.inherited(arguments);
					}
				});
			});
		},
		"dijit/form/_ButtonMixin": function () {
			define("dijit/form/_ButtonMixin", ["dojo/_base/declare", "dojo/dom", "dojo/_base/event", "../registry"], function (_4fd, dom, _4fe, _4ff) {
				return _4fd("dijit.form._ButtonMixin", null, {
					label: "",
					type: "button",
					_onClick: function (e) {
						if (this.disabled) {
							_4fe.stop(e);
							return false;
						}
						var _500 = this.onClick(e) === false;
						if (!_500 && this.type == "submit" && !(this.valueNode || this.focusNode).form) {
							for (var node = this.domNode; node.parentNode; node = node.parentNode) {
								var _501 = _4ff.byNode(node);
								if (_501 && typeof _501._onSubmit == "function") {
									_501._onSubmit(e);
									_500 = true;
									break;
								}
							}
						}
						if (_500) {
							e.preventDefault();
						}
						return !_500;
					},
					postCreate: function () {
						this.inherited(arguments);
						dom.setSelectable(this.focusNode, false);
					},
					onClick: function () {
						return true;
					},
					_setLabelAttr: function (_502) {
						this._set("label", _502);
						(this.containerNode || this.focusNode).innerHTML = _502;
					}
				});
			});
		},
		"dijit/registry": function () {
			define("dijit/registry", ["dojo/_base/array", "dojo/_base/sniff", "dojo/_base/unload", "dojo/_base/window", "."], function (_503, has, _504, win, _505) {
				var _506 = {},
					hash = {};
				var _507 = {
					length: 0,
					add: function (_508) {
						if (hash[_508.id]) {
							throw new Error("Tried to register widget with id==" + _508.id + " but that id is already registered");
						}
						hash[_508.id] = _508;
						this.length++;
					},
					remove: function (id) {
						if (hash[id]) {
							delete hash[id];
							this.length--;
						}
					},
					byId: function (id) {
						return typeof id == "string" ? hash[id] : id;
					},
					byNode: function (node) {
						return hash[node.getAttribute("widgetId")];
					},
					toArray: function () {
						var ar = [];
						for (var id in hash) {
							ar.push(hash[id]);
						}
						return ar;
					},
					getUniqueId: function (_509) {
						var id;
						do {
							id = _509 + "_" + (_509 in _506 ? ++_506[_509] : _506[_509] = 0);
						} while (hash[id]);
						return _505._scopeName == "dijit" ? id : _505._scopeName + "_" + id;
					},
					findWidgets: function (root) {
						var _50a = [];

						function _50b(root) {
							for (var node = root.firstChild; node; node = node.nextSibling) {
								if (node.nodeType == 1) {
									var _50c = node.getAttribute("widgetId");
									if (_50c) {
										var _50d = hash[_50c];
										if (_50d) {
											_50a.push(_50d);
										}
									} else {
										_50b(node);
									}
								}
							}
						};
						_50b(root);
						return _50a;
					},
					_destroyAll: function () {
						_505._curFocus = null;
						_505._prevFocus = null;
						_505._activeStack = [];
						_503.forEach(_507.findWidgets(win.body()), function (_50e) {
							if (!_50e._destroyed) {
								if (_50e.destroyRecursive) {
									_50e.destroyRecursive();
								} else {
									if (_50e.destroy) {
										_50e.destroy();
									}
								}
							}
						});
					},
					getEnclosingWidget: function (node) {
						while (node) {
							var id = node.getAttribute && node.getAttribute("widgetId");
							if (id) {
								return hash[id];
							}
							node = node.parentNode;
						}
						return null;
					},
					_hash: hash
				};
				if (has("ie")) {
					_504.addOnWindowUnload(function () {
						_507._destroyAll();
					});
				}
				_505.registry = _507;
				return _507;
			});
		},
		"url:oob/serviceip/templates/IPconfig.html": "<div>\r\n    <div class=\"radioDiv\">\r\n        <div class=\"radioItem\">\r\n            <input type=\"radio\" name=\"iptype\" id=\"type4_s\" value=\"ipv4\" dojoAttachPoint=\"radio4\" dojoType=\"dijit.form.RadioButton\" dojoAttachEvent=\"onClick:ipV4Selected\"></input>\r\n            <label for=\"type4_s\" class=\"radioLabel\">${nls.ipv4}</label>\r\n        </div>\r\n        <div class=\"radioItem\">\r\n            <input type=\"radio\" name=\"iptype\" id=\"type6_s\" value=\"ipv6\" dojoAttachPoint=\"radio6\" dojoType=\"dijit.form.RadioButton\" dojoAttachEvent=\"onClick:ipV6Selected\"></input>\r\n            <label for=\"type6_s\" class=\"radioLabel\">${nls.ipv6}</label>\r\n        </div>\r\n    </div>\r\n    <div dojoAttachPoint=\"ipv4div\" class=\"ipDiv\">\r\n        <form dojoType=\"dijit.form.Form\" dojoAttachPoint=\"ipv4Form\">\r\n            <table>\r\n                <tr><td>${nls.address}</td><td><input type=\"text\" name=\"address4\" dojoAttachPoint=\"address_4\" dojoType=\"dijit.form.ValidationTextBox\"></input></td></tr>\r\n                <tr><td>${nls.mask}</td>   <td><input type=\"text\" name=\"mask4\" dojoAttachPoint=\"mask_4\" dojoType=\"dijit.form.ValidationTextBox\"></input></td></tr>\r\n                <tr><td>${nls.gateway}</td><td><input type=\"text\" name=\"gateway4\" dojoAttachPoint=\"gateway_4\" dojoType=\"dijit.form.ValidationTextBox\"></input></td></tr>\r\n            </table>\r\n        </form>\r\n        <div dojoAttachPoint=\"difSubnet\" class=\"difSubnet hidden\">${nls.notsamenetwork}</div>\r\n    </div>\r\n    <div dojoAttachPoint=\"ipv6div\" class=\"ipDiv\">\r\n        <form dojoType=\"dijit.form.Form\" dojoAttachPoint=\"ipv6Form\">\r\n            <table>\r\n                <tr><td>${nls.address}</td><td><input type=\"text\" name=\"address6\" dojoAttachPoint=\"address_6\" dojoType=\"dijit.form.ValidationTextBox\"></input></td></tr>\r\n                <tr><td>${nls.prefix}</td> <td><input type=\"text\" name=\"mask6\" dojoAttachPoint=\"mask_6\" dojoType=\"dijit.form.ValidationTextBox\"></input></td></tr>\r\n                <tr><td>${nls.gateway}</td><td><input type=\"text\" name=\"gateway6\" dojoAttachPoint=\"gateway_6\" dojoType=\"dijit.form.ValidationTextBox\"></input></td></tr>\r\n            </table>\r\n        </form>\r\n    </div>\r\n</div>",
		"oob/Utils": function () {
			define(["dojo/_base/lang", "dojo/_base/declare", "dojo/_base/array", "dojo/_base/Deferred", "dojo/dom", "dojo/dom-geometry", "dojo/dom-style", "dojo/dom-attr", "dojo/fx", "dojo/aspect", "dojo/query"], function (lang, _50f, _510, _511, dom, _512, _513, attr, fx, _514, _515) {
				var _516 = _50f(null, {
					getNLSProps: function (el) {
						var re = {};
						_510.forEach(el.attributes, function (item) {
							var k = item.nodeName,
								v = item.nodeValue;
							if (k != "id" && v != null && v != "") {
								re[item.nodeName] = item.nodeValue;
							}
						}, this);
						return re;
					},
					showMenu: function (_517, show) {
						top.showNavigation(_517, show);
						top.activateNavigation(_517, show);
					},
					isMenuShown: function (_518) {
						var cfg = top.navigationDocument.properties[_518];
						return !(cfg.show == "false" || cfg.activate == "false");
					},
					show: function _show(o, _519) {
						var f = !!_519 ? "removeClass" : "addClass";
						if (dojo.isFunction(o[f])) {
							o[f]("hidden");
						} else {
							if (o.domNode) {
								dojo[f](o.domNode, "hidden");
							} else {
								dojo[f](o, "hidden");
							}
						}
					},
					escapeHTML: function (str) {
						return str.replace(/</g, "&lt;").replace(/>/g, "&gt;");
					},
					connectTop: function (_51a, _51b, func) {
						_514.after(top.navFuncs, _51a, lang.hitch(_51b, func));
					},
					navigate2Next: function () {
						var _51c = top.getContentWindow(),
							_51d = top.getNextItem(top.navigationCurrent);
						navOrder = top.getNavOrder();
						if (_51d) {
							(_51d == "menu_usb") && (_51d = top.getNextItem(_51d));
							top.navigateTo(top.evalJSCP(_51d, _51c));
						} else {
							if (top.navigationCurrent == navOrder[navOrder.length - 1]) {
								top.Exit(false);
							}
						}
					},
					saveCMDStr: function (str) {
						top.runCommand(command("deleteFile", top.flashDrive + top.sataskFiles.result));
						this.writeFile(str, top.flashDrive + top.sataskFiles.command);
					},
					saveUSBFingerMark: function () {
						top.appFingerMark = (Math.random() + "").substr(2);
						this.writeFile(top.appFingerMark, top.InitToolPathOnUSB + top.appmarkPath);
					},
					writeFile: function (str, _51e) {
						if (top.BROWSER != "IExplore") {
							top.writeTextFile(_51e, str, false);
						} else {
							top.runCommand(command("writeFile", str, _51e));
						}
					},
					alignElementCenter: function (_51f, dom) {
						var _520 = _513.getComputedStyle(_51f),
							_521 = _512.getContentBox(_51f, _520),
							_522 = _513.getComputedStyle(dom),
							_523 = _512.getContentBox(dom, _522);
						_513.set(dom, {
							"marginLeft": (_521.w - _523.w) / 2 + "px"
						});
					},
					getURLbyIP: function (ip) {
						if (ip.indexOf(":") != -1) {
							return "https://[" + ip + "]";
						} else {
							return "https://" + ip;
						}
					},
					getFirstIpURL: function (ips1, ips2) {
						var re = "";
						dojo.some(ips1.concat(ips2), function (ip) {
							if (ip != null && dojo.string.trim(ip) != "") {
								re = ip;
								return true;
							}
						});
						return this.getURLbyIP(re);
					},
					callWithVerification: function (path, _524) {
						var _525 = setInterval(function () {
							var txt = top.readTextFile(path);
							if (txt.indexOf("COMMANDEND") != -1) {
								clearInterval(_525);
								_524(txt);
							}
						}, 1000);
					},
					openURL: function (URL, _526) {
						if (_526 == null || top.OS == "Mac") {
							top.viewPage(NO_DISKID, URL);
							return;
						}
						var posX = screen.width > 800 ? (screen.width - 800) / 2 : 0,
							posY = screen.height > 600 ? (screen.height - 600) / 2 : 0,
							win = window.open(URL, _526, "width=800,height=600,left=" + posX + ",top=" + posY + ",location=no,menubar=no,titlebar=no,scrollbars=yes,resizable=yes,status=no,toolbar=no", true);
						win && win.focus();
					},
					exitProgram: function (_527) {
						setTimeout(function () {
							engineTop.secureExit(securityCheck);
						}, _527 == null ? 2 * 1000 : _527 * 1000);
					},
					getCurrentPanelDoc: function (_528, ctx) {
						this.getPanelDoc(top.navigationCurrent.substr(5), _528, ctx);
					},
					getPanelDoc: function (id, _529, ctx) {
						require(["oob/WizardWorker"], function (_52a) {
							var doc = _52a.getWindow(id).win.document;
							ctx ? _529.apply(ctx, [doc]) : _529(doc);
						});
					},
					setMenuItemName: function (id, name) {
						var _52b = dom.byId("menu_" + id, frames[0].frames[1].document),
							_52c = _515("span", _52b)[0];
						attr.set(_52b, "alt", name);
						attr.set(_52b, "title", name);
						_52c.innerHTML = name;
					},
					prepare4Wipein: function (el) {
						this.show(el, true);
						_513.set(el, "overflow", "hidden");
						_513.set(el, "height", 0);
					},
					_getBuildTxts: function () {
						return top.buildTxts || (top.buildTxts = function () {
							var path = top.STARTINGDIR + ["launchpad", "content", "build.txt"].join(top.PATHSEPARATOR);
							return top.readTextFile(path).match(/:.*/g);
						}());
					},
					getDeviceType: function () {
						var type = top.SVCDeviceType || (top.SVCDeviceType = dojo.string.trim(this._getBuildTxts()[1].substr(1)));
						return type == "9846" ? "9840" : type;
					},
					ASCIIToUnicode: function (text) {
						var i = 0,
							len = text.length,
							p1, p2, ret, _52d = function (code) {
								return code.length == 1 ? "0" + code : code;
							},
							ret = [];
						for (; i < len;) {
							p1 = _52d(text.charCodeAt(i).toString(16));
							p2 = _52d(text.charCodeAt(i + 1).toString(16));
							var _52e = unescape("%u" + p2 + p1);
							_52e != null && ret.push(_52e);
							i = i + 2;
						}
						return ret.join("");
					},
					objPropsLen: function (obj) {
						var p, i = 0;
						for (p in obj) {
							i++;
						}
						return i;
					}
				});
				var _52f = new _516();
				_52f.Devices = {
					isV7k: function () {
						return _52f.getDeviceType() == "2076";
					},
					isAtlantis: function () {
						return _52f.getDeviceType() == "2077";
					},
					isTb4: function () {
						return _52f.getDeviceType() == "2071_2072";
					},
					isTMS: function () {
						return _52f.getDeviceType() == "9840";
					},
					isFortWorth: function () {
						_52f.getDeviceType();
						return top.SVCDeviceType == "9846";
					},
					is1CtrlEncDevice: function () {
						return this.isTMS() || this.isTb4();
					}
				};
				top.openURL = _52f.openURL;
				top.navigate2Next = _52f.navigate2Next;
				return _52f;
			});
		},
		"oob/tasks/Tasks": function () {
			define(["dojo/_base/lang", "dojo/_base/declare", "dojo/query", "dojo/mouse", "dojo/dom", "dojo/dom-style", "dojo/fx", "dijit/_WidgetBase", "dijit/_TemplatedMixin", "dijit/_WidgetsInTemplateMixin", "dijit/registry", "dojo/text!./templates/Tasks.html", "oob/Utils", "dojo/NodeList-dom", "dijit/form/Form", "dijit/form/RadioButton"], function (lang, _530, _531, _532, dom, _533, fx, _534, _535, _536, _537, _538, _539) {
				return _530("oob.tasks.Tasks", [_534, _535, _536], {
					nls: null,
					optionSelected: false,
					TASKS: ["createCluster", "resetPwd", "setServiceIp"],
					SAVED_VAL: {
						first: null,
						second: null,
						task: null
					},
					YES_NO: {
						yes: "Yes",
						no: "No"
					},
					templateString: _538,
					postMixInProperties: function () {
						this.inherited(arguments);
						if (_539.Devices.is1CtrlEncDevice()) {
							this.nls.newsystemprompt = this.nls.newsystemprompt1ctrl;
						}
					},
					postCreate: function () {
						this._setEnterFunc();
						this._setNextFunc();
						var _53a = _539.Devices.isTb4();
						if (!_53a) {
							_539.getPanelDoc("tasks", function (doc) {
								_539.show(dom.byId("description", doc), false);
							});
							_539.show(this.simpleCreateSysArea, false);
							_539.prepare4Wipein(this.extendPrompt);
							_539.prepare4Wipein(this.sysCantAccessArea);
						} else {
							_539.show(this.createPrompt, false);
							_539.show(this.sysCantAccessArea, true);
						}
						lang.setObject("top.oob.TASKS", this.TASKS);
						top.TasksWidget = this;
						this.inherited(arguments);
						this.setDefaultOption();
					},
					firstOptionSelected: function () {
						var _53b = this._getFormValue("firstSelection");
						if (_53b === this.SAVED_VAL.first) {
							return;
						}
						this.SAVED_VAL.first = _53b;
						if (_53b === this.YES_NO.yes) {
							this.hideCantAccessSys();
							this.hideExtendPrompt();
							this.onNewClusterClicked();
							this._enableNext(true);
						} else {
							if (!_539.Devices.is1CtrlEncDevice()) {
								_539.show(this.extendPrompt, true);
								fx.wipeIn({
									node: this.extendPrompt
								}).play();
							} else {
								fx.wipeIn({
									node: this.sysCantAccessArea
								}).play();
							}
							this.unselectCreateCluster();
							this._showMenuItems();
							this._enableNext(false);
						}
					},
					secondOptionSelected: function (val) {
						var _53c = this._getFormValue("secondSelection");
						if (_53c === this.SAVED_VAL.second) {
							return;
						}
						this.SAVED_VAL.second = _53c;
						this.SAVED_VAL.task = null;
						if (_53c === this.YES_NO.yes) {
							this.hideCantAccessSys();
							this.onExtendClusterClicked(true);
							this._enableNext(true);
						} else {
							fx.wipeIn({
								node: this.sysCantAccessArea
							}).play();
							this.onExtendClusterClicked(false);
							this._showMenuItems();
							this._enableNext(false);
						}
					},
					onOptionClicked: function (val) {
						var task = this._getFormValue("task");
						if (task == null) {
							return;
						}
						this.SAVED_VAL.task = task;
						this._showMenuItems();
						if (task === this.TASKS[0] && !_539.Devices.isTb4()) {
							return;
						}
						var pwdInput = this.resetpwdval;
						if (task === this.TASKS[1] && (!pwdInput.isValid() || pwdInput.get('value') == 'passw0rd')) {
							pwdInput.set('state', 'Error');
							this._enableNext(false);
							return;
						}
						this._enableNext(true);
					},
					hideExtendPrompt: function () {
						fx.wipeOut({
							node: this.extendPrompt
						}).play();
						var _53d = this._getFormValue("secondSelection");
						if (!_53d) {
							return;
						}
						this.SAVED_VAL.second = null;
						_537.byId("secondSelection" + _53d).set("checked", false);
					},
					hideCantAccessSys: function () {
						fx.wipeOut({
							node: this.sysCantAccessArea
						}).play();
						this.task2.set("checked", false);
						this.task3.set("checked", false);
					},
					setDefaultOption: function () {
						_539.Devices.isTb4() ? this.chooseCreateCluster() : this.onNewClusterClicked();
					},
					_getFormValue: function (_53e) {
						return this.taskForm.get("value")[_53e];
					},
					_showMenuItems: function () {
						var task = this._getFormValue("task"),
							_53f = (this._getFormValue("secondSelection") === this.YES_NO.yes);
						this._showEncryptionMenu(task == this.TASKS[0]);
						_539.showMenu("menu_expandsys", _53f);
						_539.showMenu("menu_clusterip", task == this.TASKS[0]);
						_539.showMenu("menu_serviceip", task == this.TASKS[2]);
						_539.showMenu("menu_usb", !_53f);
						_539.showMenu("menu_poweron", task == this.TASKS[0]);
						_539.showMenu("menu_summary", !_53f);
					},
					onNewClusterClicked: function () {
						this.chooseCreateCluster();
						this._showMenuItems();
					},
					onExtendClusterClicked: function (_540) {
						var _541 = this;
						require(["oob/WizardWorker"], function (_542) {
							var nls = _542.getWindow("summary").nls;
							_541._showMenuItems();
						});
					},
					chooseCreateCluster: function () {
						!_539.Devices.isTb4() && _537.byId("firstSelectionYes").set("checked", true);
						this.task1.set("checked", true);
					},
					chooseSetServiceIP: function () {
						_537.byId("firstSelectionNo").set("checked", true);
						_537.byId("secondSelectionNo").set("checked", true);
						this.task3.set("checked", true);
					},
					unselectCreateCluster: function () {
						this.task1.set("checked", false);
					},
					_enableNext: function (_543) {
						this.optionSelected = _543;
						top.enableButton("nextButton", _543);
					},
					_setEnterFunc: function () {
						_539.connectTop("tasksEnter", this, "onPanelEntered");
					},
					_setNextFunc: function () {
						_539.connectTop("tasksNext", this, "saveTasksType");
					},
					saveTasksType: function () {
						var task = this._getFormValue("task");
						lang.setObject("top.oob.task", task);
						if (task == this.TASKS[1]) {
							_539.saveCMDStr(this._getSATCommandStr());
						}
						this._showEncryptionMenu(task == this.TASKS[0]);
						_539.navigate2Next();
					},
					_showEncryptionMenu: function (show) {
						require(["oob/WizardWorker"], function (w) {
							w.showEncryptionMenus(show);
						});
					},
					onPanelEntered: function () {
						top.navigationHistory[0].page !== "menu_expandsys" && _539.show(this.extendPrompt, false);
						_539.saveUSBFingerMark();
						top.navigationHistory = [];
						this.removeCommandFile();
						top.enableButton("nextButton", this.optionSelected);
					},
					removeCommandFile: function () {
						top.runCommand(command("deleteFile", top.flashDrive + top.sataskFiles.command));
					},
					_getSATCommandStr: function () {
						return "satask resetpassword -password " + this.resetpwdval.get("value").trim();
					}
				});
			});
		},
		"dojo/store/util/QueryResults": function () {
			define(["../../_base/array", "../../_base/lang", "../../_base/Deferred"], function (_544, lang, _545) {
				var util = lang.getObject("dojo.store.util", true);
				util.QueryResults = function (_546) {
					if (!_546) {
						return _546;
					}
					if (_546.then) {
						_546 = lang.delegate(_546);
					}

					function _547(_548) {
						if (!_546[_548]) {
							_546[_548] = function () {
								var args = arguments;
								return _545.when(_546, function (_549) {
									Array.prototype.unshift.call(args, _549);
									return util.QueryResults(_544[_548].apply(_544, args));
								});
							};
						}
					};
					_547("forEach");
					_547("filter");
					_547("map");
					if (!_546.total) {
						_546.total = _545.when(_546, function (_54a) {
							return _54a.length;
						});
					}
					return _546;
				};
				return util.QueryResults;
			});
		},
		"oob/usb/SACommand": function () {
			define(["dojo/_base/declare", "dojo/_base/array"], function (_54b, _54c) {
				var _54d = _54b("oob.usb.SACommand", null, {
					commandText: null,
					allPropNames: ["date", "command", "output", "exit", "satasktxt"],
					regExTemp: {
						prop: "<!-- ${0}=\"(.*?)\" -->",
						statusCMD: "<!-- ${0}_start -->(.*\r?\n)*?.*<!-- ${0}_end -->"
					},
					constructor: function (_54e) {
						this.commandText = _54e;
					},
					getAllProps: function () {
						return this.getProps(this.allPropNames);
					},
					getServiceStatusCMD: function () {
						return this._getStatusCMD("lsservicestatus");
					},
					getProps: function (_54f) {
						if (typeof _54f != "string") {
							var re = {};
							_54c.forEach(_54f, function (name) {
								re[name] = this._getProperty(name);
							}, this);
							return re;
						} else {
							return this._getProperty(_54f);
						}
					},
					_getRegExp: function (type, name) {
						return new RegExp(dojo.string.substitute(this.regExTemp[type], [name]), "g");
					},
					_getProperty: function (name) {
						return dojo.string.trim(this._getRegExp("prop", name).exec(this.commandText)[1]);
					},
					_getStatusCMD: function (name) {
						return new _550(this.commandText.match(this._getRegExp("statusCMD", name))[0]);
					}
				});
				var _550 = _54b("StatusCMD", [_54d], {
					allPropNames: ["cluster_status", "battery_charging", "Battery_id", "Battery_status", "time_to_charge", "product_serial"],
					regExTemp: {
						prop: "${0}\\s(.*?)\r?\n"
					},
					_getProperty: function (name) {
						var res = this.commandText.match(this._getRegExp("prop", name));
						_54c.forEach(res, function (item, i) {
							res[i] = dojo.string.trim(item.replace(name, ""));
						});
						return res;
					}
				});
				return _54d;
			});
		},
		"dijit/form/_ListBase": function () {
			define("dijit/form/_ListBase", ["dojo/_base/declare", "dojo/window"], function (_551, _552) {
				return _551("dijit.form._ListBase", null, {
					selected: null,
					_getTarget: function (evt) {
						var tgt = evt.target;
						var _553 = this.containerNode;
						if (tgt == _553 || tgt == this.domNode) {
							return null;
						}
						while (tgt && tgt.parentNode != _553) {
							tgt = tgt.parentNode;
						}
						return tgt;
					},
					selectFirstNode: function () {
						var _554 = this.containerNode.firstChild;
						while (_554 && _554.style.display == "none") {
							_554 = _554.nextSibling;
						}
						this._setSelectedAttr(_554);
					},
					selectLastNode: function () {
						var last = this.containerNode.lastChild;
						while (last && last.style.display == "none") {
							last = last.previousSibling;
						}
						this._setSelectedAttr(last);
					},
					selectNextNode: function () {
						var _555 = this._getSelectedAttr();
						if (!_555) {
							this.selectFirstNode();
						} else {
							var next = _555.nextSibling;
							while (next && next.style.display == "none") {
								next = next.nextSibling;
							}
							if (!next) {
								this.selectFirstNode();
							} else {
								this._setSelectedAttr(next);
							}
						}
					},
					selectPreviousNode: function () {
						var _556 = this._getSelectedAttr();
						if (!_556) {
							this.selectLastNode();
						} else {
							var prev = _556.previousSibling;
							while (prev && prev.style.display == "none") {
								prev = prev.previousSibling;
							}
							if (!prev) {
								this.selectLastNode();
							} else {
								this._setSelectedAttr(prev);
							}
						}
					},
					_setSelectedAttr: function (node) {
						if (this.selected != node) {
							var _557 = this._getSelectedAttr();
							if (_557) {
								this.onDeselect(_557);
								this.selected = null;
							}
							if (node && node.parentNode == this.containerNode) {
								this.selected = node;
								_552.scrollIntoView(node);
								this.onSelect(node);
							}
						} else {
							if (node) {
								this.onSelect(node);
							}
						}
					},
					_getSelectedAttr: function () {
						var v = this.selected;
						return (v && v.parentNode == this.containerNode) ? v : (this.selected = null);
					}
				});
			});
		},
		"oob/usb/BackupDrive": function () {
			define(["dojo/_base/lang", "dojo/_base/declare", "dojo/_base/array", "dojo/dom", "dojo/dom-style", "dojo/dom-class", "dojo/dom-geometry", "dojo/aspect", "dojo/store/Memory", "dijit/_WidgetBase", "dijit/_TemplatedMixin", "dijit/_WidgetsInTemplateMixin", "dijit/Tooltip", "../Utils", "dojo/text!./templates/BackDrive.html", "dijit/form/Button", "dijit/form/ComboBox", "dijit/ProgressBar"], function (lang, _558, _559, dom, _55a, _55b, _55c, _55d, _55e, _55f, _560, _561, _562, _563, _564) {
				var _565 = _558("oob.usb.Drive", null, {
					type: 0,
					volName: "",
					caption: "",
					desc: "",
					access: false,
					constructor: function (_566, type, _567, _568) {
						this.caption = _566;
						this.type = type;
						this.volName = _567;
						this.desc = this.getDesc();
						this.access = _568;
					},
					getDesc: function () {
						if (this.volName && this.volName != "") {
							return this.volName + " (" + this.caption + ")";
						} else {
							return this.caption;
						}
					}
				});
				_565.loadFromText = function (text, _569) {
					if (_569) {
						var _56a = top.OS == "Mac" ? /on (.*) \(/ : /on (.*) type/;
						return new _565(text.match(_56a)[1], 2, "", true);
					}
					var _56b = text.match(/\S+/g);
					if (top.OS == "Windows_XP") {
						return new _565(_56b[0], _56b[1], _56b[2] ? dojo.string.trim(text.substring(text.indexOf(_56b[2]))) : "", true);
					}
					return new _565(_56b[1], _56b[2], _56b[3] ? dojo.string.trim(text.substring(text.indexOf(_56b[3]))) : "", _56b[0] == "0");
				};
				return _558("oob.usb.BackupDrive", [_55f, _560, _561], {
					KEY_FILE_PREFIX: "encryptionkey_",
					keyFileName: null,
					keyFileContent: null,
					keyCopied: 0,
					keyFileTemp: top.STARTINGDIR + ["launchpad", "command", "result"].join(top.PATHSEPARATOR),
					copying: false,
					copyEnd: false,
					emptyUSBs: null,
					targetDisk: null,
					DRIVE_REFRESH_INTER: (top.OS == "Mac" ? 1000 * 20 : 1000 * 10),
					templateString: _564,
					postCreate: function () {
						this._setEnterFunc();
						this.inherited(arguments);
						this.connectPostPosPopWrapper();
						this.keyCopied = 0;
						this.emptyUSBs = [];
					},
					connectPostPosPopWrapper: function () {
						var _56c = this.removeableDrives;
						_55d.after(_56c, "openDropDown", function () {
							var _56d = _56c.dropDown,
								_56e = _56d._popupWrapper,
								mBox = _55c.getMarginBox(_56e);
							var _56f = property("navigationWidth", "250"),
								_570 = property("bannerHeight", "48");
							mBox.l = mBox.l + parseInt(_56f);
							mBox.t = mBox.t + parseInt(_570);
							_55c.setMarginBox(_56e, mBox);
						});
					},
					_setEnterFunc: function () {
						_563.connectTop("backupDriveEnter", this, "panelEnterFunc");
					},
					panelEnterFunc: function () {
						this.saveKeyFile();
						this.copybutton.set("disabled", true);
						top.enableNextBtnTooltip(this.nls.nexttip2key);
						top.setUSBStepHelpLink("backupdrive");
					},
					saveKeyFile: function () {
						this.hideAreasExceptLoading();
						this.readEncryptionKey();
					},
					clearSelection: function () {
						this.removeableDrives.set("value", "");
						this.copybutton.set("disabled", true);
						this.targetDisk = null;
					},
					_showProgressBar: function (show) {
						_55b.toggle(this.copyingProgress.domNode, "hidden", !show);
						this.copyingProgress.set("value", 0);
						show && this.copyingProgress.set("label", this.removeableDrives.get("value"));
						show && this.copyingProgress.domNode.focus();
					},
					readEncryptionKey: function () {
						var _571 = this,
							_572 = this.keyFileName = lang.getObject("top.oob.encryptKeyFile"),
							_573 = top.flashDrive + _572;
						this.keyFileContent = top.readTextFile(_573);
						top.runCommand(command("copyFile", _573, this.keyFileTemp), function () {});
						setTimeout(function () {
							_571.startLoadDrives();
						}, 2000);
					},
					loadUSBSticks: function () {
						if (this.copying || this.copyEnd || this.removeableDrives._opened) {
							return;
						}
						var _574 = this,
							_575 = top.STARTINGDIR + ["launchpad", "command", "result", "listdrives.txt"].join(top.PATHSEPARATOR);
						top.runCommand(command("listDrives", _575), function () {
							if (this.copying || this.copyEnd || this.removeableDrives._opened) {
								return;
							}
							var _576 = top.readTextFile(_575, "ASCII"),
								_577 = top.OS.indexOf("Windows") != -1,
								_578 = _577 ? "\r\n" : "\n",
								_579 = [];
							if (_577 && top.BROWSER == "Firefox") {
								_576 = _563.ASCIIToUnicode(_576);
							}
							_559.forEach(_576.split(_578), function (line, idx) {
								if ((_577 && idx == 0) || line == "") {
									return;
								}
								_579.push(_565.loadFromText(line, !_577));
							});
							var _57a = this.emptyUSBs = (top.OS == "Mac" ? _579 : _559.filter(_579, function (_57b) {
								var _57c = _57b.caption + top.PATHSEPARATOR + this.keyFileName,
									_57d = top.fileExists(_57c) ? top.readTextFile(_57c) : null;
								return _57b.type == 2 && _57b.access && this.keyFileContent != _57d;
							}, this));
							var _57e = new _55e({
								data: _57a
							});
							this.removeableDrives.set("store", _57e);
							this.isSelectionGone(_57a) && this.clearSelection();
							_57a.length == 1 && this.removeableDrives.set("value", _57a[0].desc);
							this.showDiskSelections(_57a.length > 0);
						}, this);
					},
					isSelectionGone: function (usbs) {
						return !_559.some(usbs, function (usb) {
							return usb.caption == this.targetDisk;
						}, this);
					},
					loadingDrive: null,
					startLoadDrives: function () {
						this.loadUSBSticks();
						this.loadingDrive = setInterval(lang.hitch(this, this.loadUSBSticks), this.DRIVE_REFRESH_INTER);
					},
					hideAreasExceptLoading: function () {
						_559.forEach(["keysavedArea", "targetArea", "copybuttondiv"], function (area) {
							_55b.add(this[area], "hidden");
						}, this);
					},
					hideLoadingShowTarget: function () {
						_559.forEach(["backupArea"], function (area) {
							_55b.add(this[area], "hidden");
						}, this);
						_559.forEach(["keysavedArea", "targetArea", "copybuttondiv"], function (area) {
							_55b.remove(this[area], "hidden");
						}, this);
					},
					showDiskSelections: function (show) {
						_55b.toggle(this.promptaNewUSB, "hidden", show);
						this._showProgressBar(false);
						_55b.contains(this.copybuttondiv, "hidden") && this.hideLoadingShowTarget();
					},
					_enableNext: function (_57f) {
						this.copyEnd = true;
						top.enableButton("nextButton", _57f);
					},
					_onDriveChange: function (val) {
						!!val && _559.some(this.emptyUSBs, function (usb) {
							if (usb.desc == val) {
								this.targetDisk = usb.caption;
								return true;
							}
						}, this) && this.copybutton.set("disabled", false);
					},
					startCopy: function () {
						this.copying = true;
						this.copybutton.set("disabled", true);
						top.runCommand(command("copyFilesInPath", this.keyFileTemp, this.targetDisk, this.KEY_FILE_PREFIX), function () {}, this);
						this.keyCopied++;
						this._showProgressBar(true);
						var i = 0,
							_580 = this,
							_581 = setInterval(function () {
								if (i > 100) {
									clearInterval(_581);
									clearInterval(_580.loadingDrive);
									_580.copying = false;
									_580.clearSelection();
									if (_580.keyCopied == 2) {
										_580._enableNext(true);
										top.disableNextBtnTooltip();
									} else {
										top.enableNextBtnTooltip(_580.nls.nexttip1key);
										_580.startLoadDrives();
									}
									return;
								}
								_580.copyingProgress.set("value", i++);
							}, 50);
					}
				});
			});
		},
		"oob/clusterip/IPconfig": function () {
			define(["dojo/_base/array", "dojo/_base/declare", "dijit/_WidgetBase", "dijit/_TemplatedMixin", "dijit/_WidgetsInTemplateMixin", "dojo/text!./templates/IPconfig.html", "oob/Utils", "dijit/form/Form", "dijit/form/RadioButton", "dijit/form/ValidationTextBox", "dojox/validate", "dojox/validate/web"], function (_582, _583, _584, _585, _586, _587, _588, form, _589, _58a, _58b, _58c) {
				return _583("oob.clusterip.IPconfig", [_584, _585, _586], {
					nls: null,
					templateString: _587,
					ipv4Checked: true,
					panelName: "menu_clusterip",
					IPFIELDS: ["address", "mask", "gateway"],
					CMD_TEMP: {
						"ipv4": "satask mkcluster -clusterip ${address4} -gw ${gateway4} -mask ${mask4}",
						"ipv6": "satask mkcluster -clusterip_6 ${address6} -gw_6 ${gateway6} -prefix_6 ${mask6}",
						"encrypt": "-encrypt yes"
					},
					postMixInProperties: function () {
						this.inherited(arguments);
					},
					postCreate: function () {
						this._setValidatorEvent();
						this.ipV4Selected();
						this._setEnterFunc();
						this._setNextFunc();
						this.inherited(arguments);
					},
					ipTypeChanged: function () {
						this.ipv4Checked = this.radio4.get("checked");
						_588.show(this.ipv4div, this.ipv4Checked);
						_588.show(this.ipv6div, !this.ipv4Checked);
						if (top.navigationCurrent == this.panelName) {
							this.updateChanges();
						}
					},
					ipV4Selected: function () {
						this.radio4.set("checked", true);
						this.radio6.set("checked", false);
						this.ipTypeChanged();
					},
					ipV6Selected: function () {
						this.radio4.set("checked", false);
						this.radio6.set("checked", true);
						this.ipTypeChanged();
					},
					_setValidatorEvent: function () {
						var _58d = {
								allowIPv6: false,
								allowHybrid: false,
								allowDecimal: false,
								allowHex: false,
								allowDottedOctal: false,
								allowDottedHex: false
							},
							_58e = {
								allowDottedDecimal: false,
								allowHybrid: false,
								allowDecimal: false,
								allowHex: false,
								allowDottedOctal: false,
								allowDottedHex: false
							};
						_582.forEach(this.IPFIELDS, function (f) {
							var _58f = this[f + "_4"];
							this._setFieldValidator(_58f);
							this._setFieldEvent(_58f);
							_58f.constraints = _58d;
							_58f.invalidMessage = this.nls.invalidmsg;
						}, this);
						_582.forEach(this.IPFIELDS, function (f, i) {
							var _590 = this[f + "_6"];
							if (i != 1) {
								this._setFieldValidator(_590);
								_590.constraints = _58e;
							} else {
								this._setPrefixValidator(_590);
							}
							this._setFieldEvent(_590);
							_590.invalidMessage = this.nls.invalidmsg;
						}, this);
					},
					_setFieldValidator: function (w) {
						w.trim = true;
						w.validator = function (_591, _592) {
							return !_591 || dojox.validate.isIpAddress(_591, _592);
						};
					},
					_setPrefixValidator: function (w) {
						w.trim = true;
						w.validator = function (_593, _594) {
							return !_593 || dojox.validate.isInRange(_593, {
								min: 0,
								max: 128
							});
						};
					},
					_setFieldEvent: function (w) {
						var _595 = this;
						w.onChange = function () {
							_595.updateChanges();
							_595._autoFill(this);
						};
						w.intermediateChanges = true;
					},
					_autoFill: function (w) {
						var _596 = this.IPFIELDS[0] + "_4",
							_597 = this[_596].get("value");
						if (w.dojoAttachPoint == _596 && _597 && this[_596].isValid()) {
							if (this.mask_4.get("value") == "") {
								this.mask_4.set("value", "255.255.255.0");
							}
							if (this.gateway_4.get("value") == "") {
								this.gateway_4.set("value", _597.split(".").slice(0, 3).join(".") + ".1");
							}
						}
					},
					isValid: function (type) {
						return _582.every(this.IPFIELDS, function (f) {
							return this[f + "_" + type].isValid();
						}, this);
					},
					isComplete: function (type) {
						return !_582.some(this.IPFIELDS, function (f) {
							return this[f + "_" + type].get("value") == "";
						}, this);
					},
					isIPv4SameNetWork: function () {
						var ip = this.address_4.get("value").split("."),
							mask = this.mask_4.get("value").split("."),
							_598 = this.gateway_4.get("value").split(".");
						var _599 = !_582.some(mask, function (_59a, idx) {
							if (_59a == 255) {
								return ip[idx] != _598[idx];
							} else {
								return (ip[idx] & mask[idx]) != (_598[idx] & mask[idx]);
							}
						});
						_588.show(this.difSubnet, !_599);
						return _599;
					},
					updateChanges: function () {
						_588.show(this.difSubnet, false);
						var _59b = (this.ipv4Checked && this.isValid(4) && this.isComplete(4) && this.isIPv4SameNetWork()) || (!this.ipv4Checked && this.isValid(6) && this.isComplete(6));
						top.enableButton("nextButton", _59b);
					},
					enterFunc: function () {
						this.startup();
						this.updateChanges();
					},
					_setEnterFunc: function () {
						_588.connectTop("clusteripEnter", this, "enterFunc");
					},
					_setNextFunc: function () {
						_588.connectTop("clusteripNext", this, "writeCommandIntoFile");
					},
					_getSATCommandStr: function () {
						var cmd, _59c;
						if (this.ipv4Checked) {
							cmd = this.CMD_TEMP.ipv4;
							_59c = this.ipv4Form.get("value");
						} else {
							cmd = this.CMD_TEMP.ipv6;
							_59c = this.ipv6Form.get("value");
						}
						var _59d = dojo.string.substitute(cmd, _59c);
						return top.oob.ENCRYPTOPTION == "Yes" && this.panelName == "menu_clusterip" ? _59d + " " + this.CMD_TEMP.encrypt : _59d;
					},
					writeCommandIntoFile: function () {
						_588.saveCMDStr(this._getSATCommandStr());
						top.clusterIP = {
							"ipv4Checked": this.ipv4Checked,
							"ipv4": this.ipv4Form.get("value"),
							"ipv6": this.ipv6Form.get("value")
						};
						_588.navigate2Next();
					}
				});
			});
		},
		"dijit/form/_FormWidget": function () {
			define("dijit/form/_FormWidget", ["dojo/_base/declare", "dojo/_base/kernel", "dojo/ready", "../_Widget", "../_CssStateMixin", "../_TemplatedMixin", "./_FormWidgetMixin"], function (_59e, _59f, _5a0, _5a1, _5a2, _5a3, _5a4) {
				if (!_59f.isAsync) {
					_5a0(0, function () {
						var _5a5 = ["dijit/form/_FormValueWidget"];
						require(_5a5);
					});
				}
				return _59e("dijit.form._FormWidget", [_5a1, _5a3, _5a2, _5a4], {
					setDisabled: function (_5a6) {
						_59f.deprecated("setDisabled(" + _5a6 + ") is deprecated. Use set('disabled'," + _5a6 + ") instead.", "", "2.0");
						this.set("disabled", _5a6);
					},
					setValue: function (_5a7) {
						_59f.deprecated("dijit.form._FormWidget:setValue(" + _5a7 + ") is deprecated.  Use set('value'," + _5a7 + ") instead.", "", "2.0");
						this.set("value", _5a7);
					},
					getValue: function () {
						_59f.deprecated(this.declaredClass + "::getValue() is deprecated. Use get('value') instead.", "", "2.0");
						return this.get("value");
					},
					postMixInProperties: function () {
						this.nameAttrSetting = this.name ? ("name=\"" + this.name.replace(/'/g, "&quot;") + "\"") : "";
						this.inherited(arguments);
					},
					_setTypeAttr: null
				});
			});
		},
		"dojo/dnd/common": function () {
			define(["../main"], function (dojo) {
				dojo.getObject("dnd", true, dojo);
				dojo.dnd.getCopyKeyState = dojo.isCopyKey;
				dojo.dnd._uniqueId = 0;
				dojo.dnd.getUniqueId = function () {
					var id;
					do {
						id = dojo._scopeName + "Unique" + (++dojo.dnd._uniqueId);
					} while (dojo.byId(id));
					return id;
				};
				dojo.dnd._empty = {};
				dojo.dnd.isFormElement = function (e) {
					var t = e.target;
					if (t.nodeType == 3) {
						t = t.parentNode;
					}
					return " button textarea input select option ".indexOf(" " + t.tagName.toLowerCase() + " ") >= 0;
				};
				return dojo.dnd;
			});
		},
		"oob/usb/SAResult": function () {
			define(["dojo/_base/declare", "oob/usb/SACommand"], function (_5a8, _5a9) {
				return _5a8("oob.usb.SAResult", null, {
					reText: null,
					_commands: null,
					constructor: function (_5aa) {
						this.reText = _5aa;
						this._getCommands();
					},
					_getCommands: function () {
						if (this._commands == null) {
							var _5ab = /<!-- command_start -->(.*\r?\n)*?.*<!-- command_end -->/g;
							this._commands = this.reText.match(_5ab);
						}
					},
					getCommand: function (idx) {
						if (idx >= this._commands.length) {
							return null;
						}
						return new _5a9(this._commands[idx]);
					}
				});
			});
		},
		"dijit/form/_ComboBoxMenu": function () {
			define("dijit/form/_ComboBoxMenu", ["dojo/_base/declare", "dojo/dom-class", "dojo/dom-construct", "dojo/dom-style", "dojo/keys", "../_WidgetBase", "../_TemplatedMixin", "./_ComboBoxMenuMixin", "./_ListMouseMixin"], function (_5ac, _5ad, _5ae, _5af, keys, _5b0, _5b1, _5b2, _5b3) {
				return _5ac("dijit.form._ComboBoxMenu", [_5b0, _5b1, _5b3, _5b2], {
					templateString: "<div class='dijitReset dijitMenu' data-dojo-attach-point='containerNode' style='overflow: auto; overflow-x: hidden;'>" + "<div class='dijitMenuItem dijitMenuPreviousButton' data-dojo-attach-point='previousButton' role='option'></div>" + "<div class='dijitMenuItem dijitMenuNextButton' data-dojo-attach-point='nextButton' role='option'></div>" + "</div>",
					baseClass: "dijitComboBoxMenu",
					_createMenuItem: function () {
						return _5ae.create("div", {
							"class": "dijitReset dijitMenuItem" + (this.isLeftToRight() ? "" : " dijitMenuItemRtl"),
							role: "option"
						});
					},
					onHover: function (node) {
						_5ad.add(node, "dijitMenuItemHover");
					},
					onUnhover: function (node) {
						_5ad.remove(node, "dijitMenuItemHover");
					},
					onSelect: function (node) {
						_5ad.add(node, "dijitMenuItemSelected");
					},
					onDeselect: function (node) {
						_5ad.remove(node, "dijitMenuItemSelected");
					},
					_page: function (up) {
						var _5b4 = 0;
						var _5b5 = this.domNode.scrollTop;
						var _5b6 = _5af.get(this.domNode, "height");
						if (!this.getHighlightedOption()) {
							this.selectNextNode();
						}
						while (_5b4 < _5b6) {
							if (up) {
								if (!this.getHighlightedOption().previousSibling || this._highlighted_option.previousSibling.style.display == "none") {
									break;
								}
								this.selectPreviousNode();
							} else {
								if (!this.getHighlightedOption().nextSibling || this._highlighted_option.nextSibling.style.display == "none") {
									break;
								}
								this.selectNextNode();
							}
							var _5b7 = this.domNode.scrollTop;
							_5b4 += (_5b7 - _5b5) * (up ? -1 : 1);
							_5b5 = _5b7;
						}
					},
					handleKey: function (evt) {
						switch (evt.charOrCode) {
							case keys.DOWN_ARROW:
								this.selectNextNode();
								return false;
							case keys.PAGE_DOWN:
								this._page(false);
								return false;
							case keys.UP_ARROW:
								this.selectPreviousNode();
								return false;
							case keys.PAGE_UP:
								this._page(true);
								return false;
							default:
								return true;
						}
					}
				});
			});
		},
		"dijit/Dialog": function () {
			require({
				cache: {
					"url:dijit/templates/Dialog.html": "<div class=\"dijitDialog\" role=\"dialog\" aria-labelledby=\"${id}_title\">\r\n\t<div data-dojo-attach-point=\"titleBar\" class=\"dijitDialogTitleBar\">\r\n\t<span data-dojo-attach-point=\"titleNode\" class=\"dijitDialogTitle\" id=\"${id}_title\"></span>\r\n\t<span data-dojo-attach-point=\"closeButtonNode\" class=\"dijitDialogCloseIcon\" data-dojo-attach-event=\"ondijitclick: onCancel\" title=\"${buttonCancel}\" role=\"button\" tabIndex=\"-1\">\r\n\t\t<span data-dojo-attach-point=\"closeText\" class=\"closeText\" title=\"${buttonCancel}\">x</span>\r\n\t</span>\r\n\t</div>\r\n\t\t<div data-dojo-attach-point=\"containerNode\" class=\"dijitDialogPaneContent\"></div>\r\n</div>\r\n"
				}
			});
			define("dijit/Dialog", ["require", "dojo/_base/array", "dojo/_base/connect", "dojo/_base/declare", "dojo/_base/Deferred", "dojo/dom", "dojo/dom-class", "dojo/dom-geometry", "dojo/dom-style", "dojo/_base/event", "dojo/_base/fx", "dojo/i18n", "dojo/_base/kernel", "dojo/keys", "dojo/_base/lang", "dojo/on", "dojo/ready", "dojo/_base/sniff", "dojo/_base/window", "dojo/window", "dojo/dnd/Moveable", "dojo/dnd/TimedMoveable", "./focus", "./_base/manager", "./_Widget", "./_TemplatedMixin", "./_CssStateMixin", "./form/_FormMixin", "./_DialogMixin", "./DialogUnderlay", "./layout/ContentPane", "dojo/text!./templates/Dialog.html", ".", "dojo/i18n!./nls/common"], function (_5b8, _5b9, _5ba, _5bb, _5bc, dom, _5bd, _5be, _5bf, _5c0, fx, i18n, _5c1, keys, lang, on, _5c2, has, win, _5c3, _5c4, _5c5, _5c6, _5c7, _5c8, _5c9, _5ca, _5cb, _5cc, _5cd, _5ce, _5cf, _5d0) {
				var _5d1 = _5bb("dijit._DialogBase", [_5c9, _5cb, _5cc, _5ca], {
					templateString: _5cf,
					baseClass: "dijitDialog",
					cssStateNodes: {
						closeButtonNode: "dijitDialogCloseIcon"
					},
					_setTitleAttr: [{
						node: "titleNode",
						type: "innerHTML"
					}, {
						node: "titleBar",
						type: "attribute"
					}],
					open: false,
					duration: _5c7.defaultDuration,
					refocus: true,
					autofocus: true,
					_firstFocusItem: null,
					_lastFocusItem: null,
					doLayout: false,
					draggable: true,
					"aria-describedby": "",
					postMixInProperties: function () {
						var _5d2 = i18n.getLocalization("dijit", "common");
						lang.mixin(this, _5d2);
						this.inherited(arguments);
					},
					postCreate: function () {
						_5bf.set(this.domNode, {
							display: "none",
							position: "absolute"
						});
						win.body().appendChild(this.domNode);
						this.inherited(arguments);
						this.connect(this, "onExecute", "hide");
						this.connect(this, "onCancel", "hide");
						this._modalconnects = [];
					},
					onLoad: function () {
						this._position();
						if (this.autofocus && _5d3.isTop(this)) {
							this._getFocusItems(this.domNode);
							_5c6.focus(this._firstFocusItem);
						}
						this.inherited(arguments);
					},
					_endDrag: function () {
						var _5d4 = _5be.position(this.domNode),
							_5d5 = _5c3.getBox();
						_5d4.y = Math.min(Math.max(_5d4.y, 0), (_5d5.h - _5d4.h));
						_5d4.x = Math.min(Math.max(_5d4.x, 0), (_5d5.w - _5d4.w));
						this._relativePosition = _5d4;
						this._position();
					},
					_setup: function () {
						var node = this.domNode;
						if (this.titleBar && this.draggable) {
							this._moveable = new((has("ie") == 6) ? _5c5 : _5c4)(node, {
								handle: this.titleBar
							});
							this.connect(this._moveable, "onMoveStop", "_endDrag");
						} else {
							_5bd.add(node, "dijitDialogFixed");
						}
						this.underlayAttrs = {
							dialogId: this.id,
							"class": _5b9.map(this["class"].split(/\s/), function (s) {
								return s + "_underlay";
							}).join(" ")
						};
					},
					_size: function () {
						this._checkIfSingleChild();
						if (this._singleChild) {
							if (this._singleChildOriginalStyle) {
								this._singleChild.domNode.style.cssText = this._singleChildOriginalStyle;
							}
							delete this._singleChildOriginalStyle;
						} else {
							_5bf.set(this.containerNode, {
								width: "auto",
								height: "auto"
							});
						}
						var bb = _5be.position(this.domNode);
						var _5d6 = _5c3.getBox();
						if (bb.w >= _5d6.w || bb.h >= _5d6.h) {
							var w = Math.min(bb.w, Math.floor(_5d6.w * 0.75)),
								h = Math.min(bb.h, Math.floor(_5d6.h * 0.75));
							if (this._singleChild && this._singleChild.resize) {
								this._singleChildOriginalStyle = this._singleChild.domNode.style.cssText;
								this._singleChild.resize({
									w: w,
									h: h
								});
							} else {
								_5bf.set(this.containerNode, {
									width: w + "px",
									height: h + "px",
									overflow: "auto",
									position: "relative"
								});
							}
						} else {
							if (this._singleChild && this._singleChild.resize) {
								this._singleChild.resize();
							}
						}
					},
					_position: function () {
						if (!_5bd.contains(win.body(), "dojoMove")) {
							var node = this.domNode,
								_5d7 = _5c3.getBox(),
								p = this._relativePosition,
								bb = p ? null : _5be.position(node),
								l = Math.floor(_5d7.l + (p ? p.x : (_5d7.w - bb.w) / 2)),
								t = Math.floor(_5d7.t + (p ? p.y : (_5d7.h - bb.h) / 2));
							_5bf.set(node, {
								left: l + "px",
								top: t + "px"
							});
						}
					},
					_onKey: function (evt) {
						if (evt.charOrCode) {
							var node = evt.target;
							if (evt.charOrCode === keys.TAB) {
								this._getFocusItems(this.domNode);
							}
							var _5d8 = (this._firstFocusItem == this._lastFocusItem);
							if (node == this._firstFocusItem && evt.shiftKey && evt.charOrCode === keys.TAB) {
								if (!_5d8) {
									_5c6.focus(this._lastFocusItem);
								}
								_5c0.stop(evt);
							} else {
								if (node == this._lastFocusItem && evt.charOrCode === keys.TAB && !evt.shiftKey) {
									if (!_5d8) {
										_5c6.focus(this._firstFocusItem);
									}
									_5c0.stop(evt);
								} else {
									while (node) {
										if (node == this.domNode || _5bd.contains(node, "dijitPopup")) {
											if (evt.charOrCode == keys.ESCAPE) {
												this.onCancel();
											} else {
												return;
											}
										}
										node = node.parentNode;
									}
									if (evt.charOrCode !== keys.TAB) {
										_5c0.stop(evt);
									} else {
										if (!has("opera")) {
											try {
												this._firstFocusItem.focus();
											} catch (e) {}
										}
									}
								}
							}
						}
					},
					show: function () {
						if (this.open) {
							return;
						}
						if (!this._started) {
							this.startup();
						}
						if (!this._alreadyInitialized) {
							this._setup();
							this._alreadyInitialized = true;
						}
						if (this._fadeOutDeferred) {
							this._fadeOutDeferred.cancel();
						}
						this._modalconnects.push(on(window, "scroll", lang.hitch(this, "layout")));
						this._modalconnects.push(on(window, "resize", lang.hitch(this, function () {
							var _5d9 = _5c3.getBox();
							if (!this._oldViewport || _5d9.h != this._oldViewport.h || _5d9.w != this._oldViewport.w) {
								this.layout();
								this._oldViewport = _5d9;
							}
						})));
						this._modalconnects.push(on(this.domNode, _5ba._keypress, lang.hitch(this, "_onKey")));
						_5bf.set(this.domNode, {
							opacity: 0,
							display: ""
						});
						this._set("open", true);
						this._onShow();
						this._size();
						this._position();
						var _5da;
						this._fadeInDeferred = new _5bc(lang.hitch(this, function () {
							_5da.stop();
							delete this._fadeInDeferred;
						}));
						_5da = fx.fadeIn({
							node: this.domNode,
							duration: this.duration,
							beforeBegin: lang.hitch(this, function () {
								_5d3.show(this, this.underlayAttrs);
							}),
							onEnd: lang.hitch(this, function () {
								if (this.autofocus && _5d3.isTop(this)) {
									this._getFocusItems(this.domNode);
									_5c6.focus(this._firstFocusItem);
								}
								this._fadeInDeferred.callback(true);
								delete this._fadeInDeferred;
							})
						}).play();
						return this._fadeInDeferred;
					},
					hide: function () {
						if (!this._alreadyInitialized) {
							return;
						}
						if (this._fadeInDeferred) {
							this._fadeInDeferred.cancel();
						}
						var _5db;
						this._fadeOutDeferred = new _5bc(lang.hitch(this, function () {
							_5db.stop();
							delete this._fadeOutDeferred;
						}));
						this._fadeOutDeferred.then(lang.hitch(this, "onHide"));
						_5db = fx.fadeOut({
							node: this.domNode,
							duration: this.duration,
							onEnd: lang.hitch(this, function () {
								this.domNode.style.display = "none";
								_5d3.hide(this);
								this._fadeOutDeferred.callback(true);
								delete this._fadeOutDeferred;
							})
						}).play();
						if (this._scrollConnected) {
							this._scrollConnected = false;
						}
						var h;
						while (h = this._modalconnects.pop()) {
							h.remove();
						}
						if (this._relativePosition) {
							delete this._relativePosition;
						}
						this._set("open", false);
						return this._fadeOutDeferred;
					},
					layout: function () {
						if (this.domNode.style.display != "none") {
							if (_5d0._underlay) {
								_5d0._underlay.layout();
							}
							this._position();
						}
					},
					destroy: function () {
						if (this._fadeInDeferred) {
							this._fadeInDeferred.cancel();
						}
						if (this._fadeOutDeferred) {
							this._fadeOutDeferred.cancel();
						}
						if (this._moveable) {
							this._moveable.destroy();
						}
						var h;
						while (h = this._modalconnects.pop()) {
							h.remove();
						}
						_5d3.hide(this);
						this.inherited(arguments);
					}
				});
				var _5dc = _5bb("dijit.Dialog", [_5ce, _5d1], {});
				_5dc._DialogBase = _5d1;
				var _5d3 = _5dc._DialogLevelManager = {
					_beginZIndex: 950,
					show: function (_5dd, _5de) {
						ds[ds.length - 1].focus = _5c6.curNode;
						var _5df = _5d0._underlay;
						if (!_5df || _5df._destroyed) {
							_5df = _5d0._underlay = new _5cd(_5de);
						} else {
							_5df.set(_5dd.underlayAttrs);
						}
						var _5e0 = ds[ds.length - 1].dialog ? ds[ds.length - 1].zIndex + 2 : _5dc._DialogLevelManager._beginZIndex;
						if (ds.length == 1) {
							_5df.show();
						}
						_5bf.set(_5d0._underlay.domNode, "zIndex", _5e0 - 1);
						_5bf.set(_5dd.domNode, "zIndex", _5e0);
						ds.push({
							dialog: _5dd,
							underlayAttrs: _5de,
							zIndex: _5e0
						});
					},
					hide: function (_5e1) {
						if (ds[ds.length - 1].dialog == _5e1) {
							ds.pop();
							var pd = ds[ds.length - 1];
							if (ds.length == 1) {
								if (!_5d0._underlay._destroyed) {
									_5d0._underlay.hide();
								}
							} else {
								_5bf.set(_5d0._underlay.domNode, "zIndex", pd.zIndex - 1);
								_5d0._underlay.set(pd.underlayAttrs);
							}
							if (_5e1.refocus) {
								var _5e2 = pd.focus;
								if (pd.dialog && (!_5e2 || !dom.isDescendant(_5e2, pd.dialog.domNode))) {
									pd.dialog._getFocusItems(pd.dialog.domNode);
									_5e2 = pd.dialog._firstFocusItem;
								}
								if (_5e2) {
									try {
										_5e2.focus();
									} catch (e) {}
								}
							}
						} else {
							var idx = _5b9.indexOf(_5b9.map(ds, function (elem) {
								return elem.dialog;
							}), _5e1);
							if (idx != -1) {
								ds.splice(idx, 1);
							}
						}
					},
					isTop: function (_5e3) {
						return ds[ds.length - 1].dialog == _5e3;
					}
				};
				var ds = _5dc._dialogStack = [{
					dialog: null,
					focus: null,
					underlayAttrs: null
				}];
				if (!_5c1.isAsync) {
					_5c2(0, function () {
						var _5e4 = ["dijit/TooltipDialog"];
						_5b8(_5e4);
					});
				}
				return _5dc;
			});
		},
		"dijit/a11y": function () {
			define("dijit/a11y", ["dojo/_base/array", "dojo/_base/config", "dojo/_base/declare", "dojo/dom", "dojo/dom-attr", "dojo/dom-style", "dojo/_base/sniff", "./_base/manager", "."], function (_5e5, _5e6, _5e7, dom, _5e8, _5e9, has, _5ea, _5eb) {
				var _5ec = (_5eb._isElementShown = function (elem) {
					var s = _5e9.get(elem);
					return (s.visibility != "hidden") && (s.visibility != "collapsed") && (s.display != "none") && (_5e8.get(elem, "type") != "hidden");
				});
				_5eb.hasDefaultTabStop = function (elem) {
					switch (elem.nodeName.toLowerCase()) {
						case "a":
							return _5e8.has(elem, "href");
						case "area":
						case "button":
						case "input":
						case "object":
						case "select":
						case "textarea":
							return true;
						case "iframe":
							var body;
							try {
								var _5ed = elem.contentDocument;
								if ("designMode" in _5ed && _5ed.designMode == "on") {
									return true;
								}
								body = _5ed.body;
							} catch (e1) {
								try {
									body = elem.contentWindow.document.body;
								} catch (e2) {
									return false;
								}
							}
							return body && (body.contentEditable == "true" || (body.firstChild && body.firstChild.contentEditable == "true"));
						default:
							return elem.contentEditable == "true";
					}
				};
				var _5ee = (_5eb.isTabNavigable = function (elem) {
					if (_5e8.get(elem, "disabled")) {
						return false;
					} else {
						if (_5e8.has(elem, "tabIndex")) {
							return _5e8.get(elem, "tabIndex") >= 0;
						} else {
							return _5eb.hasDefaultTabStop(elem);
						}
					}
				});
				_5eb._getTabNavigable = function (root) {
					var _5ef, last, _5f0, _5f1, _5f2, _5f3, _5f4 = {};

					function _5f5(node) {
						return node && node.tagName.toLowerCase() == "input" && node.type && node.type.toLowerCase() == "radio" && node.name && node.name.toLowerCase();
					};
					var _5f6 = function (_5f7) {
						for (var _5f8 = _5f7.firstChild; _5f8; _5f8 = _5f8.nextSibling) {
							if (_5f8.nodeType != 1 || (has("ie") && _5f8.scopeName !== "HTML") || !_5ec(_5f8)) {
								continue;
							}
							if (_5ee(_5f8)) {
								var _5f9 = _5e8.get(_5f8, "tabIndex");
								if (!_5e8.has(_5f8, "tabIndex") || _5f9 == 0) {
									if (!_5ef) {
										_5ef = _5f8;
									}
									last = _5f8;
								} else {
									if (_5f9 > 0) {
										if (!_5f0 || _5f9 < _5f1) {
											_5f1 = _5f9;
											_5f0 = _5f8;
										}
										if (!_5f2 || _5f9 >= _5f3) {
											_5f3 = _5f9;
											_5f2 = _5f8;
										}
									}
								}
								var rn = _5f5(_5f8);
								if (_5e8.get(_5f8, "checked") && rn) {
									_5f4[rn] = _5f8;
								}
							}
							if (_5f8.nodeName.toUpperCase() != "SELECT") {
								_5f6(_5f8);
							}
						}
					};
					if (_5ec(root)) {
						_5f6(root);
					}

					function rs(node) {
						return _5f4[_5f5(node)] || node;
					};
					return {
						first: rs(_5ef),
						last: rs(last),
						lowest: rs(_5f0),
						highest: rs(_5f2)
					};
				};
				_5eb.getFirstInTabbingOrder = function (root) {
					var _5fa = _5eb._getTabNavigable(dom.byId(root));
					return _5fa.lowest ? _5fa.lowest : _5fa.first;
				};
				_5eb.getLastInTabbingOrder = function (root) {
					var _5fb = _5eb._getTabNavigable(dom.byId(root));
					return _5fb.last ? _5fb.last : _5fb.highest;
				};
				return {
					hasDefaultTabStop: _5eb.hasDefaultTabStop,
					isTabNavigable: _5eb.isTabNavigable,
					_getTabNavigable: _5eb._getTabNavigable,
					getFirstInTabbingOrder: _5eb.getFirstInTabbingOrder,
					getLastInTabbingOrder: _5eb.getLastInTabbingOrder
				};
			});
		},
		"dijit/form/_ToggleButtonMixin": function () {
			define("dijit/form/_ToggleButtonMixin", ["dojo/_base/declare", "dojo/dom-attr"], function (_5fc, _5fd) {
				return _5fc("dijit.form._ToggleButtonMixin", null, {
					checked: false,
					_aria_attr: "aria-pressed",
					_onClick: function (evt) {
						var _5fe = this.checked;
						this._set("checked", !_5fe);
						var ret = this.inherited(arguments);
						this.set("checked", ret ? this.checked : _5fe);
						return ret;
					},
					_setCheckedAttr: function (_5ff, _600) {
						this._set("checked", _5ff);
						_5fd.set(this.focusNode || this.domNode, "checked", _5ff);
						(this.focusNode || this.domNode).setAttribute(this._aria_attr, _5ff ? "true" : "false");
						this._handleOnChange(_5ff, _600);
					},
					reset: function () {
						this._hasBeenBlurred = false;
						this.set("checked", this.params.checked || false);
					}
				});
			});
		},
		"url:oob/usb/templates/BackDrive.html": "<div>\r\n    <div class=\"trdiv sourceDiv\"><div class=\"tdfirst\">${nls.source}</div>\r\n        <div data-dojo-attach-point=\"backupArea\">\r\n            <div class=\"image16 copyingImage\"></div>\r\n            <div class=\"readingtxt spirit\">${nls.readingkey}</div>\r\n        </div>\r\n        <div data-dojo-attach-point=\"keysavedArea\" class=\"grayText\">${nls.encryptionkey}</div>\r\n    </div>\r\n    <div class=\"trdiv targetDiv\" data-dojo-attach-point=\"targetArea\">\r\n        <div class=\"tdfirst\"><span>${nls.target}</span></div>\r\n\r\n        <div data-dojo-attach-point=\"copySelection\" class=\"copySelection\">\r\n            <div>\r\n                <select data-dojo-type=\"dijit.form.ComboBox\" style=\"width:200px\" \r\n                        data-dojo-props='searchAttr:\"desc\", labelAttr: \"desc\"'\r\n                        data-dojo-attach-event=\"onChange:_onDriveChange\"\r\n                        data-dojo-attach-point=\"removeableDrives\"></select>\r\n                <div class=\"grayText inputPlaceholder\" data-dojo-attach-point=\"promptaNewUSB\">${nls.insertusbprompt}</div>\r\n                <div class=\"folderIcon\"></div>\r\n            </div>\r\n            <div data-dojo-type=\"dijit.ProgressBar\" class=\"hidden backupProgressbar\" data-dojo-attach-point=\"copyingProgress\"></div>\r\n        </div>\r\n    </div>\r\n\r\n    <div data-dojo-attach-point=\"copybuttondiv\" class=\"copybutton\">\r\n        <button data-dojo-attach-point=\"copybutton\" data-dojo-type=\"dijit.form.Button\" data-dojo-attach-event=\"onClick:startCopy\">${nls.copy}</button>\r\n    </div>\r\n</div>",
		"dijit/_Widget": function () {
			define("dijit/_Widget", ["dojo/aspect", "dojo/_base/config", "dojo/_base/connect", "dojo/_base/declare", "dojo/_base/kernel", "dojo/_base/lang", "dojo/query", "dojo/ready", "./registry", "./_WidgetBase", "./_OnDijitClickMixin", "./_FocusMixin", "dojo/uacss", "./hccss"], function (_601, _602, _603, _604, _605, lang, _606, _607, _608, _609, _60a, _60b) {
				function _60c() {};

				function _60d(_60e) {
					return function (obj, _60f, _610, _611) {
						if (obj && typeof _60f == "string" && obj[_60f] == _60c) {
							return obj.on(_60f.substring(2).toLowerCase(), lang.hitch(_610, _611));
						}
						return _60e.apply(_603, arguments);
					};
				};
				_601.around(_603, "connect", _60d);
				if (_605.connect) {
					_601.around(_605, "connect", _60d);
				}
				var _612 = _604("dijit._Widget", [_609, _60a, _60b], {
					onClick: _60c,
					onDblClick: _60c,
					onKeyDown: _60c,
					onKeyPress: _60c,
					onKeyUp: _60c,
					onMouseDown: _60c,
					onMouseMove: _60c,
					onMouseOut: _60c,
					onMouseOver: _60c,
					onMouseLeave: _60c,
					onMouseEnter: _60c,
					onMouseUp: _60c,
					constructor: function (_613) {
						this._toConnect = {};
						for (var name in _613) {
							if (this[name] === _60c) {
								this._toConnect[name.replace(/^on/, "").toLowerCase()] = _613[name];
								delete _613[name];
							}
						}
					},
					postCreate: function () {
						this.inherited(arguments);
						for (var name in this._toConnect) {
							this.on(name, this._toConnect[name]);
						}
						delete this._toConnect;
					},
					on: function (type, func) {
						if (this[this._onMap(type)] === _60c) {
							return _603.connect(this.domNode, type.toLowerCase(), this, func);
						}
						return this.inherited(arguments);
					},
					_setFocusedAttr: function (val) {
						this._focused = val;
						this._set("focused", val);
					},
					setAttribute: function (attr, _614) {
						_605.deprecated(this.declaredClass + "::setAttribute(attr, value) is deprecated. Use set() instead.", "", "2.0");
						this.set(attr, _614);
					},
					attr: function (name, _615) {
						if (_602.isDebug) {
							var _616 = arguments.callee._ach || (arguments.callee._ach = {}),
								_617 = (arguments.callee.caller || "unknown caller").toString();
							if (!_616[_617]) {
								_605.deprecated(this.declaredClass + "::attr() is deprecated. Use get() or set() instead, called from " + _617, "", "2.0");
								_616[_617] = true;
							}
						}
						var args = arguments.length;
						if (args >= 2 || typeof name === "object") {
							return this.set.apply(this, arguments);
						} else {
							return this.get(name);
						}
					},
					getDescendants: function () {
						_605.deprecated(this.declaredClass + "::getDescendants() is deprecated. Use getChildren() instead.", "", "2.0");
						return this.containerNode ? _606("[widgetId]", this.containerNode).map(_608.byNode) : [];
					},
					_onShow: function () {
						this.onShow();
					},
					onShow: function () {},
					onHide: function () {},
					onClose: function () {
						return true;
					}
				});
				if (!_605.isAsync) {
					_607(0, function () {
						var _618 = ["dijit/_base"];
						require(_618);
					});
				}
				return _612;
			});
		},
		"dojo/touch": function () {
			define(["./_base/kernel", "./on", "./has", "./mouse"], function (dojo, on, has, _619) {
				function _61a(type) {
					return function (node, _61b) {
						return on(node, type, _61b);
					};
				};
				var _61c = has("touch");
				dojo.touch = {
					press: _61a(_61c ? "touchstart" : "mousedown"),
					move: _61a(_61c ? "touchmove" : "mousemove"),
					release: _61a(_61c ? "touchend" : "mouseup"),
					cancel: _61c ? _61a("touchcancel") : _619.leave
				};
				return dojo.touch;
			});
		},
		"oob/usb/USB": function () {
			define(["dojo/_base/lang", "dojo/_base/declare", "dojo/_base/array", "dojo/_base/Deferred", "dojo/string", "dijit/_WidgetBase", "dijit/_TemplatedMixin", "dijit/_WidgetsInTemplateMixin", "dojo/text!./templates/USB.html", "oob/Utils", "oob/usb/SAResult"], function (lang, _61d, _61e, _61f, _620, _621, _622, _623, _624, _625, _626) {
				function when(_627, _628) {
					var _629 = typeof _627.then === "function";
					if (_629) {
						_627.then(_628);
					} else {
						var def = new _61f();
						def.then(_628);
						def.resolve(_627);
					}
				};
				return _61d("oob.usb.USB", [_621, _622, _623], {
					nls: null,
					resultText: "",
					templateString: _624,
					USB_VERIFIED_FILE: "InitTool.ex1",
					usbVrfTimer: null,
					USBAttached: true,
					postCreate: function () {
						this.inherited(arguments);
					},
					checkUSBStatus: function () {
						var _62a = this;
						when(this.setResult2Top(), function (s) {
							if (s) {
								this.verifyResultFile();
								return;
							}
							this.usbVrfTimer = setInterval(function () {
								var _62b = top.fileExists(top.InitToolPathOnUSB + _62a.USB_VERIFIED_FILE);
								if (_62b ^ _62a.USBAttached) {
									_62a.USBAttached = _62b;
									if (_62b) {
										_62a.verifyResultFile();
									} else {}
								}
							}, 1000 * 3);
						});
					},
					_setEnterFunc: function () {
						_625.connectTop("usbEnter", this, "checkUSBStatus");
					},
					_setNextFunc: function () {
						_625.connectTop("usbNext", this, "go2Next");
					},
					_setPreviousFunc: function () {
						_625.connectTop("usbPrevious", this, "go2Previous");
					},
					verifyResultFile: function () {
						var _62c = false;
						if (top.fileExists(top.InitToolPathOnUSB + top.appmarkPath)) {
							var _62d = top.readTextFile(top.InitToolPathOnUSB + top.appmarkPath);
							if (_62d != null && (dojo.string.trim(_62d) == top.appFingerMark)) {
								_62c = true;
							}
						}
						when(this.setResult2Top(), function (s) {
							if (_62c && s) {
								top.enableButton("nextButton", true);
							} else {
								require(["oob/WizardWorker"], function (_62e) {
									var nls = _62e.getWindow("usb").nls;
									if (_625.Devices.isTMS()) {
										nls.improperusbstickaction2 = nls.improperusbstickaction2tms;
										nls.improperusbstickaction3 = nls.improperusbstickaction3tms;
									}
									var _62f = "<div>" + nls.improperusbstick + "</div>" + "<div style=\"margin-top: 15px;\">" + nls.improperusbstickaction1 + "</div>" + "<div style=\"margin-top: 10px;\">" + nls.improperusbstickaction2 + "</div>" + "<div style=\"margin-top: 10px;\">" + nls.improperusbstickaction3 + "</div>" + "<div style=\"margin-top: 10px;\">" + nls.improperusbstickaction4 + "</div>";
									top.showWarningDlg(_62f, function () {
										_625.exitProgram(0);
									}, function () {
										top.topDialog.hide();
									}, [{
										elem: "#itdojodialog",
										classes: ["errorDialog"]
									}]);
								});
							}
						});
					},
					setResult2Top: function () {
						if (!top.fileExists(top.flashDrive + top.sataskFiles.result)) {
							return false;
						}
						var res = new _626(top.readTextFile(top.flashDrive + top.sataskFiles.result));
						if (res._commands != null && res._commands.length > 0) {
							top.commandResult = res;
							if (top.oob.ENCRYPTOPTION == "Yes") {
								var _630 = (res.getCommand(0).getAllProps().exit == 0),
									def = new _61f();
								if (_630) {
									var _631 = res.getCommand(0).getServiceStatusCMD().getProps("cluster_id")[0],
										_632 = res.getCommand(0).getServiceStatusCMD().getProps("cluster_name")[0],
										_633 = "encryptionkey_" + _631.toUpperCase() + "_*_" + _632,
										_634 = top.STARTINGDIR + ["launchpad", "command", "result", "listFilesResult.txt"].join(top.PATHSEPARATOR);
									top.runCommand(command("listFiles", top.flashDrive + _633, _634), function () {
										var _635 = top.readTextFile(_634, "ASCII"),
											_636 = top.OS.indexOf("Windows") != -1,
											_637 = _635.split(_636 ? "\r\n" : ","),
											_638 = null;
										_61e.some(_637, function (f) {
											if (f.indexOf("encryptionkey_") != -1) {
												_638 = _620.trim(f);
												lang.setObject("top.oob.encryptKeyFile", _638);
												return true;
											}
										});
										def.resolve(_638 != null);
									}, this);
								} else {
									def.resolve(false);
								}
								_625.showMenu("menu_backupdrive", _630);
								_625.showMenu("menu_reinsert2canister", _630);
								return def.promise;
							}
							return true;
						} else {
							return false;
						}
					},
					clearUSBStatusTimer: function () {
						if (!this.usbVrfTimer) {
							return;
						}
						clearInterval(this.usbVrfTimer);
						this.usbVrfTimer = null;
					},
					go2Previous: function () {
						this.clearUSBStatusTimer();
						top.navigateTo("menu_insert2canister");
					},
					go2Next: function () {
						this.clearUSBStatusTimer();
						_625.navigate2Next();
					}
				});
			});
		},
		"dijit/form/nls/ComboBox": function () {
			define("dijit/form/nls/ComboBox", {
				root: ({
					previousMessage: "Previous choices",
					nextMessage: "More choices"
				}),
				"zh": true,
				"zh-tw": true,
				"tr": true,
				"th": true,
				"sv": true,
				"sl": true,
				"sk": true,
				"ru": true,
				"ro": true,
				"pt": true,
				"pt-pt": true,
				"pl": true,
				"nl": true,
				"nb": true,
				"ko": true,
				"kk": true,
				"ja": true,
				"it": true,
				"hu": true,
				"hr": true,
				"he": true,
				"fr": true,
				"fi": true,
				"es": true,
				"el": true,
				"de": true,
				"da": true,
				"cs": true,
				"ca": true,
				"az": true,
				"ar": true
			});
		},
		"dojo/fx": function () {
			define(["./_base/lang", "./Evented", "./_base/kernel", "./_base/array", "./_base/connect", "./_base/fx", "./dom", "./dom-style", "./dom-geometry", "./ready", "require"], function (lang, _639, dojo, _63a, _63b, _63c, dom, _63d, geom, _63e, _63f) {
				if (!dojo.isAsync) {
					_63e(0, function () {
						var _640 = ["./fx/Toggler"];
						_63f(_640);
					});
				}
				var _641 = dojo.fx = {};
				var _642 = {
					_fire: function (evt, args) {
						if (this[evt]) {
							this[evt].apply(this, args || []);
						}
						return this;
					}
				};
				var _643 = function (_644) {
					this._index = -1;
					this._animations = _644 || [];
					this._current = this._onAnimateCtx = this._onEndCtx = null;
					this.duration = 0;
					_63a.forEach(this._animations, function (a) {
						this.duration += a.duration;
						if (a.delay) {
							this.duration += a.delay;
						}
					}, this);
				};
				_643.prototype = new _639();
				lang.extend(_643, {
					_onAnimate: function () {
						this._fire("onAnimate", arguments);
					},
					_onEnd: function () {
						_63b.disconnect(this._onAnimateCtx);
						_63b.disconnect(this._onEndCtx);
						this._onAnimateCtx = this._onEndCtx = null;
						if (this._index + 1 == this._animations.length) {
							this._fire("onEnd");
						} else {
							this._current = this._animations[++this._index];
							this._onAnimateCtx = _63b.connect(this._current, "onAnimate", this, "_onAnimate");
							this._onEndCtx = _63b.connect(this._current, "onEnd", this, "_onEnd");
							this._current.play(0, true);
						}
					},
					play: function (_645, _646) {
						if (!this._current) {
							this._current = this._animations[this._index = 0];
						}
						if (!_646 && this._current.status() == "playing") {
							return this;
						}
						var _647 = _63b.connect(this._current, "beforeBegin", this, function () {
								this._fire("beforeBegin");
							}),
							_648 = _63b.connect(this._current, "onBegin", this, function (arg) {
								this._fire("onBegin", arguments);
							}),
							_649 = _63b.connect(this._current, "onPlay", this, function (arg) {
								this._fire("onPlay", arguments);
								_63b.disconnect(_647);
								_63b.disconnect(_648);
								_63b.disconnect(_649);
							});
						if (this._onAnimateCtx) {
							_63b.disconnect(this._onAnimateCtx);
						}
						this._onAnimateCtx = _63b.connect(this._current, "onAnimate", this, "_onAnimate");
						if (this._onEndCtx) {
							_63b.disconnect(this._onEndCtx);
						}
						this._onEndCtx = _63b.connect(this._current, "onEnd", this, "_onEnd");
						this._current.play.apply(this._current, arguments);
						return this;
					},
					pause: function () {
						if (this._current) {
							var e = _63b.connect(this._current, "onPause", this, function (arg) {
								this._fire("onPause", arguments);
								_63b.disconnect(e);
							});
							this._current.pause();
						}
						return this;
					},
					gotoPercent: function (_64a, _64b) {
						this.pause();
						var _64c = this.duration * _64a;
						this._current = null;
						_63a.some(this._animations, function (a) {
							if (a.duration <= _64c) {
								this._current = a;
								return true;
							}
							_64c -= a.duration;
							return false;
						});
						if (this._current) {
							this._current.gotoPercent(_64c / this._current.duration, _64b);
						}
						return this;
					},
					stop: function (_64d) {
						if (this._current) {
							if (_64d) {
								for (; this._index + 1 < this._animations.length; ++this._index) {
									this._animations[this._index].stop(true);
								}
								this._current = this._animations[this._index];
							}
							var e = _63b.connect(this._current, "onStop", this, function (arg) {
								this._fire("onStop", arguments);
								_63b.disconnect(e);
							});
							this._current.stop();
						}
						return this;
					},
					status: function () {
						return this._current ? this._current.status() : "stopped";
					},
					destroy: function () {
						if (this._onAnimateCtx) {
							_63b.disconnect(this._onAnimateCtx);
						}
						if (this._onEndCtx) {
							_63b.disconnect(this._onEndCtx);
						}
					}
				});
				lang.extend(_643, _642);
				_641.chain = function (_64e) {
					return new _643(_64e);
				};
				var _64f = function (_650) {
					this._animations = _650 || [];
					this._connects = [];
					this._finished = 0;
					this.duration = 0;
					_63a.forEach(_650, function (a) {
						var _651 = a.duration;
						if (a.delay) {
							_651 += a.delay;
						}
						if (this.duration < _651) {
							this.duration = _651;
						}
						this._connects.push(_63b.connect(a, "onEnd", this, "_onEnd"));
					}, this);
					this._pseudoAnimation = new _63c.Animation({
						curve: [0, 1],
						duration: this.duration
					});
					var self = this;
					_63a.forEach(["beforeBegin", "onBegin", "onPlay", "onAnimate", "onPause", "onStop", "onEnd"], function (evt) {
						self._connects.push(_63b.connect(self._pseudoAnimation, evt, function () {
							self._fire(evt, arguments);
						}));
					});
				};
				lang.extend(_64f, {
					_doAction: function (_652, args) {
						_63a.forEach(this._animations, function (a) {
							a[_652].apply(a, args);
						});
						return this;
					},
					_onEnd: function () {
						if (++this._finished > this._animations.length) {
							this._fire("onEnd");
						}
					},
					_call: function (_653, args) {
						var t = this._pseudoAnimation;
						t[_653].apply(t, args);
					},
					play: function (_654, _655) {
						this._finished = 0;
						this._doAction("play", arguments);
						this._call("play", arguments);
						return this;
					},
					pause: function () {
						this._doAction("pause", arguments);
						this._call("pause", arguments);
						return this;
					},
					gotoPercent: function (_656, _657) {
						var ms = this.duration * _656;
						_63a.forEach(this._animations, function (a) {
							a.gotoPercent(a.duration < ms ? 1 : (ms / a.duration), _657);
						});
						this._call("gotoPercent", arguments);
						return this;
					},
					stop: function (_658) {
						this._doAction("stop", arguments);
						this._call("stop", arguments);
						return this;
					},
					status: function () {
						return this._pseudoAnimation.status();
					},
					destroy: function () {
						_63a.forEach(this._connects, _63b.disconnect);
					}
				});
				lang.extend(_64f, _642);
				_641.combine = function (_659) {
					return new _64f(_659);
				};
				_641.wipeIn = function (args) {
					var node = args.node = dom.byId(args.node),
						s = node.style,
						o;
					var anim = _63c.animateProperty(lang.mixin({
						properties: {
							height: {
								start: function () {
									o = s.overflow;
									s.overflow = "hidden";
									if (s.visibility == "hidden" || s.display == "none") {
										s.height = "1px";
										s.display = "";
										s.visibility = "";
										return 1;
									} else {
										var _65a = _63d.get(node, "height");
										return Math.max(_65a, 1);
									}
								},
								end: function () {
									return node.scrollHeight;
								}
							}
						}
					}, args));
					var fini = function () {
						s.height = "auto";
						s.overflow = o;
					};
					_63b.connect(anim, "onStop", fini);
					_63b.connect(anim, "onEnd", fini);
					return anim;
				};
				_641.wipeOut = function (args) {
					var node = args.node = dom.byId(args.node),
						s = node.style,
						o;
					var anim = _63c.animateProperty(lang.mixin({
						properties: {
							height: {
								end: 1
							}
						}
					}, args));
					_63b.connect(anim, "beforeBegin", function () {
						o = s.overflow;
						s.overflow = "hidden";
						s.display = "";
					});
					var fini = function () {
						s.overflow = o;
						s.height = "auto";
						s.display = "none";
					};
					_63b.connect(anim, "onStop", fini);
					_63b.connect(anim, "onEnd", fini);
					return anim;
				};
				_641.slideTo = function (args) {
					var node = args.node = dom.byId(args.node),
						top = null,
						left = null;
					var init = (function (n) {
						return function () {
							var cs = _63d.getComputedStyle(n);
							var pos = cs.position;
							top = (pos == "absolute" ? n.offsetTop : parseInt(cs.top) || 0);
							left = (pos == "absolute" ? n.offsetLeft : parseInt(cs.left) || 0);
							if (pos != "absolute" && pos != "relative") {
								var ret = geom.position(n, true);
								top = ret.y;
								left = ret.x;
								n.style.position = "absolute";
								n.style.top = top + "px";
								n.style.left = left + "px";
							}
						};
					})(node);
					init();
					var anim = _63c.animateProperty(lang.mixin({
						properties: {
							top: args.top || 0,
							left: args.left || 0
						}
					}, args));
					_63b.connect(anim, "beforeBegin", anim, init);
					return anim;
				};
				return _641;
			});
		},
		"url:oob/encryption/templates/Encryption.html": "<div>\r\n    <form id=\"encform\" dojoType=\"dijit.form.Form\" dojoAttachPoint=\"encForm\">\r\n        <div class=\"promptArea\">\r\n            <div>${nls.desc}</div>\r\n            <div class=\"alignCenter optionsDiv\">\r\n                <span class=\"spirit\">\r\n                    <input type=\"radio\" dojoType=\"dijit.form.RadioButton\" name=\"licenceSelection\" id=\"licenceSelectionYes\" dojoAttachEvent=\"onClick:licenceOptionSelected\" value=\"Yes\"/>\r\n                    <label for=\"licenceSelectionYes\" class=\"radioLabel\">${nls.yes}</label>\r\n                </span>\r\n                <span class=\"spirit\">\r\n                    <input type=\"radio\" dojoType=\"dijit.form.RadioButton\" name=\"licenceSelection\" id=\"licenceSelectionNo\" dojoAttachEvent=\"onClick:licenceOptionSelected\" value=\"No\"/>\r\n                    <label for=\"licenceSelectionNo\" class=\"radioLabel\">${nls.no}</label>\r\n                </span>\r\n            </div>\r\n        </div>\r\n        <div class=\"note\"><div class=\"infoIcon spirit\"></div><span class=\"infoText\">${nls.note}</span></div>\r\n    </form>\r\n</div>",
		"dijit/_DialogMixin": function () {
			define("dijit/_DialogMixin", ["dojo/_base/declare", "./a11y"], function (_65b, a11y) {
				return _65b("dijit._DialogMixin", null, {
					execute: function () {},
					onCancel: function () {},
					onExecute: function () {},
					_onSubmit: function () {
						this.onExecute();
						this.execute(this.get("value"));
					},
					_getFocusItems: function () {
						var _65c = a11y._getTabNavigable(this.containerNode);
						this._firstFocusItem = _65c.lowest || _65c.first || this.closeButtonNode || this.domNode;
						this._lastFocusItem = _65c.last || _65c.highest || this._firstFocusItem;
					}
				});
			});
		},
		"dijit/nls/common": function () {
			define("dijit/nls/common", {
				root: ({
					buttonOk: "OK",
					buttonCancel: "Cancel",
					buttonSave: "Save",
					itemClose: "Close"
				}),
				"zh": true,
				"zh-tw": true,
				"tr": true,
				"th": true,
				"sv": true,
				"sl": true,
				"sk": true,
				"ru": true,
				"ro": true,
				"pt": true,
				"pt-pt": true,
				"pl": true,
				"nl": true,
				"nb": true,
				"ko": true,
				"kk": true,
				"ja": true,
				"it": true,
				"hu": true,
				"hr": true,
				"he": true,
				"fr": true,
				"fi": true,
				"es": true,
				"el": true,
				"de": true,
				"da": true,
				"cs": true,
				"ca": true,
				"az": true,
				"ar": true
			});
		},
		"dijit/form/_FormValueWidget": function () {
			define("dijit/form/_FormValueWidget", ["dojo/_base/declare", "dojo/_base/sniff", "./_FormWidget", "./_FormValueMixin"], function (_65d, has, _65e, _65f) {
				return _65d("dijit.form._FormValueWidget", [_65e, _65f], {
					_layoutHackIE7: function () {
						if (has("ie") == 7) {
							var _660 = this.domNode;
							var _661 = _660.parentNode;
							var _662 = _660.firstChild || _660;
							var _663 = _662.style.filter;
							var _664 = this;
							while (_661 && _661.clientHeight == 0) {
								(function ping() {
									var _665 = _664.connect(_661, "onscroll", function () {
										_664.disconnect(_665);
										_662.style.filter = (new Date()).getMilliseconds();
										setTimeout(function () {
											_662.style.filter = _663;
										}, 0);
									});
								})();
								_661 = _661.parentNode;
							}
						}
					}
				});
			});
		}
	}
});
require(["dojo/i18n"], function (i18n) {
	i18n._preloadLocalizations("oob/nls/oob", ["nl-nl", "en-us", "da", "fi-fi", "pt-pt", "hu", "sk", "sl", "pl", "ca", "sv", "zh-tw", "ar", "en-gb", "he-il", "de-de", "ko-kr", "ja-jp", "nb", "ru", "es-es", "th", "cs", "it-it", "pt-br", "fr-fr", "el", "tr", "zh-cn"]);
});
define("oob/oob", {});