// hottopics.js
// NLS_CHARSET=UTF-8
//
// (C) Copyright IBM Corporation, 2003, 2006                        //
// All rights reserved. Licensed Materials Property of IBM          //
// US Government Users Restricted Rights                            //
// Use, duplication or disclosure restricted by                     //
// GSA ADP Schedule Contract with IBM Corp.                         //

//START NON-TRANSLATABLE
//////////////////////////////////////////////////////////////////////
// define simple object.
function hotTopic() {
	args=hotTopic.arguments;
	this.text = args[0];
	this.stext = args[1] || "intentionally blank";
	this.url = args[2] || "";

   this.getText = getText;
   this.getBlurb = getBlurb;
   this.getURL = getURL;
}

function getText() {
	return this.text;
}
function getBlurb(){
	return this.stext;
}
function getURL(){
	return this.url;
}
//
//////////////////////////////////////////////////////////////////////


//////////////////////////////////////////////////////////////////////
// redefine the 'push' function for all browsers.
//if (Array.prototype.push && ([0].push(true)==true))
//        Array.prototype.push = null;

if(!Array.prototype.push) {
    function array_push() {
        for(i=0;i<arguments.length;i++){
            this[this.length] = arguments[i];
        }
        return this.length;
    }

    Array.prototype.push = array_push;

}
//
//////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////
// function for generating random number.

var masterHTid=null;
function getHTvalue(aQuotes){
  if (!masterHTid) {
	// select random quote (integer).
	var numRand = Math.random();
	var numQuote = aQuotes.length - 1;
	masterHTid = Math.round((numQuote - 1) * numRand) + 1;
  }
  return masterHTid;
}
//
//////////////////////////////////////////////////////////////////////




//END NON-TRANSLATABLE

//////////////////////////////////////////////////////////////////////
// initialize an array of objects.
var quotes = new Array;
//START QUOTE TRANSLATABLE 1 2
quotes.push(new hotTopic("特定のページにブックマークを付けることができます。", "ブックマーク付け", "./icfaq.htm#bookmark"));
quotes.push(new hotTopic("ガイド付きセットアップ・ウィザードを使用してハードウェア管理コンソールを構成することができます。", "ガイド付きセットアップ・ウィザードを使用した HMC の構成", "../iphai/confighmcgs.htm"));
quotes.push(new hotTopic("お客様の要件にあわせてカスタマイズされた、サーバーのセットアップ・チェックリストを作成することができます。", "カスタマイズされたサーバー初期セットアップ用チェックリストの作成", "../iphaf/issintwelcome.htm"));
quotes.push(new hotTopic("CD インストール・バージョンの Information Center の更新をダウンロードおよびインストールできます。", "CD インストール・バージョンの Information Center に対する更新のダウンロード", "./icupdates.htm#downloadupdates"));
quotes.push(new hotTopic("新しい Information Center インターフェースの製品紹介をアニメーションで見ることができます。", "Information Center インターフェース", "./icfaq.htm#flashdemo"));
quotes.push(new hotTopic("ご使用のサーバーまたは拡張装置に各種のハードウェア・フィーチャーを取り付けたり、多くの部品を取り替えることができます。", "フィーチャーの取り付け", "../iphaj/installcifcio.htm"));
quotes.push(new hotTopic("いくつかある対話式コースとチュートリアルの中から選択して、サーバーの仮想化についてさらに詳しく学習できます。", "学習とチュートリアル", "../iphcy/learningandtutorials.html"));
quotes.push(new hotTopic("モデルのリストでは、マシン・タイプ・モデル (MTM) 名、フルネーム、ショート・ネームのほか、ブランドまたはファミリーを見ることができます。", "モデル番号とモデル名", "./modelnumbersandnames.htm"));
quotes.push(new hotTopic("読みやすい図表を使用して、IBM Systems ハードウェア Information Center で現在提供されている pSeries 資料を検索することができます。", "Information Center への pSeries ブックのマップ", "./icpserieslist.htm"));
quotes.push(new hotTopic("各主要トピックとそのサブトピックを印刷することができます。", "印刷", "./icfaq.htm#print"));
quotes.push(new hotTopic("インターネット更新にサブスクライブすると、IBM Systems ハードウェア Information Center が更新されたときに、通知を受け取ることができます。", "インターネット更新のサブスクリプション", "./icupdates.htm#subscribe"));

//END QUOTE TRANSLATABLE
// end array of objects
//////////////////////////////////////////////////////////////////////

//START QUOTE TRANSLATABLE
var strDidYouKnowHeader = "<H2>ご存じでしたか?<\/H2>";
var sDidYouKnow = "&nbsp;&nbsp;ご存じでしたか?";
var sSeeAllTips = "すべてのヒントを参照する";
//END QUOTE TRANSLATABLE

//START NON-TRANSLATABLE
//////////////////////////////////////////////////////////////////////
// begin execution path
var HTid=getHTvalue(quotes);
// end execution path
//////////////////////////////////////////////////////////////////////


//////////////////////////////////////////////////////////////////////
// suport functions
//////////////////////////////////////////////////////////////////////
// functions to create formatted strings and write to document.
function getHotTopic(){
	result = '<A href="'+quotes[HTid].getURL()+'">'+quotes[HTid].getText()+'<\/A>';
	return result;
}
function getHotTopic2(){
	result = '<A href="'+quotes[HTid].getURL()+'"><IMG src=".\/images\/fw.gif" width="16" height="17" vspace="0" hspace="0" border="0" alt=""\/><\/A> ';
	return result;

}
function getHotTopic3(){
	result = '<A href="'+quotes[HTid].getURL()+'">'+quotes[HTid].getBlurb()+'<\/A>';
	return result;

}
function dumpHotTopics(){
	document.writeln(strDidYouKnowHeader);
	document.writeln('<BLOCKQUOTE>');
	for ( ht in quotes ) {
		result = '<P class="frontendbarlink" style="width: 100%;"><A href="'+quotes[ht].url+'">'+quotes[ht].stext+'<\/A><\/P>';
		result += '<P>'+quotes[ht].text+'<\/P>';
		document.writeln(result);
	}
	document.writeln('<\/BLOCKQUOTE>');
}
//////////////////////////////////////////////////////////////////////
// This hideous function is a work around for Netscape 4.x.  The function 
// creates the WHOLE callout box. Since, we cannot call a function from within
// a TD in Netscape 4.x, we cannot do the getHotTopic() calls in a callout box
// within the HTML.  That would result in an empty callout box. So we have a
// 'parent' function call in the HTML that creates the whole callout box.
// This function is not executed in Netscape 4.x, so there is no empty calloutbox.  QED.
function doDidYouKnow(){
	var result=getHotTopic();
	result+='<br>';
	result+=getHotTopic2();
	result+=getHotTopic3();
	result+='<br>';
	result+='       <A href=".\/hottopics.htm"><IMG src=".\/images\/fw.gif" width="16" height="17" vspace="0" hspace="0" border="0" alt=""><\/A> ';
//result+='       <A href=".\/hottopics.htm" class="fbox">'+sSeeAllTips+'</A>';
	result+='       <A href=".\/hottopics.htm">'+sSeeAllTips+'<\/A>';
	document.open();
	document.write(result);
	document.close();
}

//END NON-TRANSLATABLE

