// hottopics.js
// NLS_CHARSET=UTF-8
//
// (C) Copyright IBM Corporation, 2003, 2006                        //
// All rights reserved. Licensed Materials Property of IBM          //
// US Government Users Restricted Rights                            //
// Use, duplication or disclosure restricted by                     //
// GSA ADP Schedule Contract with IBM Corp.                         //

//START NON-TRANSLATABLE
//////////////////////////////////////////////////////////////////////
// define simple object.
function hotTopic() {
	args=hotTopic.arguments;
	this.text = args[0];
	this.stext = args[1] || "intentionally blank";
	this.url = args[2] || "";

   this.getText = getText;
   this.getBlurb = getBlurb;
   this.getURL = getURL;
}

function getText() {
	return this.text;
}
function getBlurb(){
	return this.stext;
}
function getURL(){
	return this.url;
}
//
//////////////////////////////////////////////////////////////////////


//////////////////////////////////////////////////////////////////////
// redefine the 'push' function for all browsers.
//if (Array.prototype.push && ([0].push(true)==true))
//        Array.prototype.push = null;

if(!Array.prototype.push) {
    function array_push() {
        for(i=0;i<arguments.length;i++){
            this[this.length] = arguments[i];
        }
        return this.length;
    }

    Array.prototype.push = array_push;

}
//
//////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////
// function for generating random number.

var masterHTid=null;
function getHTvalue(aQuotes){
  if (!masterHTid) {
	// select random quote (integer).
	var numRand = Math.random();
	var numQuote = aQuotes.length - 1;
	masterHTid = Math.round((numQuote - 1) * numRand) + 1;
  }
  return masterHTid;
}
//
//////////////////////////////////////////////////////////////////////




//END NON-TRANSLATABLE

//////////////////////////////////////////////////////////////////////
// initialize an array of objects.
var quotes = new Array;
//START QUOTE TRANSLATABLE 1 2
quotes.push(new hotTopic("Puede marcar una página concreta como favorita.", "Añadir a favoritos", "./icfaq.htm#bookmark"));
quotes.push(new hotTopic("Puede configurar la consola de gestión de hardware (HMC) utilizando el asistente de instalación guiada.", "Configurar la HMC utilizando el asistente de instalación guiada", "../iphai/confighmcgs.htm"));
quotes.push(new hotTopic("Puede crear una lista de comprobación de instalación de servidor personalizada según sus necesidades.", "Crear una lista de comprobación personalizada para la instalación inicial del servidor", "../iphaf/issintwelcome.htm"));
quotes.push(new hotTopic("Puede descargar e instalar actualizaciones de la versión de Information Center instalada desde CD.", "Descargar actualizaciones de la versión de Information Center instalada desde CD", "./icupdates.htm#downloadupdates"));
quotes.push(new hotTopic("Puede ver un tour por el producto animado en la nueva interfaz de Information Center.", "Interfaz de Information Center", "./icfaq.htm#flashdemo"));
quotes.push(new hotTopic("Puede instalar una gran variedad de dispositivos de hardware y sustituir numerosas piezas en los servidores o las unidades de expansión.", "Instalar dispositivos", "../iphaj/installcifcio.htm"));
quotes.push(new hotTopic("Puede seleccionar en una lista de varios cursos interactivos y guías de aprendizaje, para conocer más detalles sobre la virtualización del servidor.", "Aprendizaje y guías de aprendizaje", "../iphcy/learningandtutorials.html"));
quotes.push(new hotTopic("Puede ver una lista de modelos que incluya el nombre de tipo de máquina y modelo (MTM), el nombre completo, el nombre corto y la marca o familia.", "Lista de los números de modelo y sus nombres", "./modelnumbersandnames.htm"));
quotes.push(new hotTopic("Puede utilizar un diagrama fácil de leer para localizar la documentación de pSeries que ahora está en IBM Hardware Information Center.", "Mapa de libros de pSeries en Information Center", "./icpserieslist.htm"));
quotes.push(new hotTopic("Puede imprimir cada tema importante junto con sus subtemas.", "Imprimir", "./icfaq.htm#print"));
quotes.push(new hotTopic("Puede suscribirse a actualizaciones por Internet para recibir notificaciones siempre que se produzcan actualizaciones en IBM Systems Hardware Information Center.", "Suscribirse a actualizaciones por Internet", "./icupdates.htm#subscribe"));

//END QUOTE TRANSLATABLE
// end array of objects
//////////////////////////////////////////////////////////////////////

//START QUOTE TRANSLATABLE
var strDidYouKnowHeader = "<H2>¿Sabía que...?<\/H2>";
var sDidYouKnow = "&nbsp;&nbsp;¿Sabía que...?";
var sSeeAllTips = "Ver todas las sugerencias";
//END QUOTE TRANSLATABLE

//START NON-TRANSLATABLE
//////////////////////////////////////////////////////////////////////
// begin execution path
var HTid=getHTvalue(quotes);
// end execution path
//////////////////////////////////////////////////////////////////////


//////////////////////////////////////////////////////////////////////
// suport functions
//////////////////////////////////////////////////////////////////////
// functions to create formatted strings and write to document.
function getHotTopic(){
	result = '<A href="'+quotes[HTid].getURL()+'">'+quotes[HTid].getText()+'<\/A>';
	return result;
}
function getHotTopic2(){
	result = '<A href="'+quotes[HTid].getURL()+'"><IMG src=".\/images\/fw.gif" width="16" height="17" vspace="0" hspace="0" border="0" alt=""\/><\/A> ';
	return result;

}
function getHotTopic3(){
	result = '<A href="'+quotes[HTid].getURL()+'">'+quotes[HTid].getBlurb()+'<\/A>';
	return result;

}
function dumpHotTopics(){
	document.writeln(strDidYouKnowHeader);
	document.writeln('<BLOCKQUOTE>');
	for ( ht in quotes ) {
		result = '<P class="frontendbarlink" style="width: 100%;"><A href="'+quotes[ht].url+'">'+quotes[ht].stext+'<\/A><\/P>';
		result += '<P>'+quotes[ht].text+'<\/P>';
		document.writeln(result);
	}
	document.writeln('<\/BLOCKQUOTE>');
}
//////////////////////////////////////////////////////////////////////
// This hideous function is a work around for Netscape 4.x.  The function 
// creates the WHOLE callout box. Since, we cannot call a function from within
// a TD in Netscape 4.x, we cannot do the getHotTopic() calls in a callout box
// within the HTML.  That would result in an empty callout box. So we have a
// 'parent' function call in the HTML that creates the whole callout box.
// This function is not executed in Netscape 4.x, so there is no empty calloutbox.  QED.
function doDidYouKnow(){
	var result=getHotTopic();
	result+='<br>';
	result+=getHotTopic2();
	result+=getHotTopic3();
	result+='<br>';
	result+='       <A href=".\/hottopics.htm"><IMG src=".\/images\/fw.gif" width="16" height="17" vspace="0" hspace="0" border="0" alt=""><\/A> ';
//result+='       <A href=".\/hottopics.htm" class="fbox">'+sSeeAllTips+'</A>';
	result+='       <A href=".\/hottopics.htm">'+sSeeAllTips+'<\/A>';
	document.open();
	document.write(result);
	document.close();
}

//END NON-TRANSLATABLE

