// hottopics.js
// NLS_CHARSET=UTF-8
//
// (C) Copyright IBM Corporation, 2003, 2006                        //
// All rights reserved. Licensed Materials Property of IBM          //
// US Government Users Restricted Rights                            //
// Use, duplication or disclosure restricted by                     //
// GSA ADP Schedule Contract with IBM Corp.                         //

//START NON-TRANSLATABLE
//////////////////////////////////////////////////////////////////////
// define simple object.
function hotTopic() {
	args=hotTopic.arguments;
	this.text = args[0];
	this.stext = args[1] || "intentionally blank";
	this.url = args[2] || "";

   this.getText = getText;
   this.getBlurb = getBlurb;
   this.getURL = getURL;
}

function getText() {
	return this.text;
}
function getBlurb(){
	return this.stext;
}
function getURL(){
	return this.url;
}
//
//////////////////////////////////////////////////////////////////////


//////////////////////////////////////////////////////////////////////
// redefine the 'push' function for all browsers.
//if (Array.prototype.push && ([0].push(true)==true))
//        Array.prototype.push = null;

if(!Array.prototype.push) {
    function array_push() {
        for(i=0;i<arguments.length;i++){
            this[this.length] = arguments[i];
        }
        return this.length;
    }

    Array.prototype.push = array_push;

}
//
//////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////
// function for generating random number.

var masterHTid=null;
function getHTvalue(aQuotes){
  if (!masterHTid) {
	// select random quote (integer).
	var numRand = Math.random();
	var numQuote = aQuotes.length - 1;
	masterHTid = Math.round((numQuote - 1) * numRand) + 1;
  }
  return masterHTid;
}
//
//////////////////////////////////////////////////////////////////////




//END NON-TRANSLATABLE

//////////////////////////////////////////////////////////////////////
// initialize an array of objects.
var quotes = new Array;
//START QUOTE TRANSLATABLE 1 2
quotes.push(new hotTopic("Konkrétní stránku můžete označit záložkou.", "Označení záložkou", "./icfaq.htm#bookmark"));
quotes.push(new hotTopic("Konzoli HMC (Hardware Management Console) můžete nakonfigurovat pomocí průvodce Guided Setup. ", "Konfigurování konzole HMC pomocí Úvodní příručky", "../iphai/confighmcgs.htm"));
quotes.push(new hotTopic("Můžete vytvořit kontrolní seznam pro nastavení serveru, který bude odpovídat vašim potřebám.", "Vytvoření přizpůsobeného kontrolního seznamu pro nastavení serveru", "../iphaf/issintwelcome.htm"));
quotes.push(new hotTopic("Můžete si stáhnout a nainstalovat aktualizace pro vaši verzi aplikaci Information Center nainstalovanou z CD-ROM. ", "Stažení aktualizací pro verzi aplikace Information Center instalovanou z CD-ROM ", "./icupdates.htm#downloadupdates"));
quotes.push(new hotTopic("Můžete shlédnout animovanou prohlídku nového rozhraní Information Center. ", "Rozhraní Information Center ", "./icfaq.htm#flashdemo"));
quotes.push(new hotTopic("Můžete nainstalovat širokou škálu hardwarových komponent a vyměnit mnoho dílů ve vašich serverech nebo rozšiřujících jednotkách.", "Instalace komponent", "../iphaj/installcifcio.htm"));
quotes.push(new hotTopic("Můžete si vybrat z mnoha interaktivních kurzů a výukových programů, které vám poskytnou velké množství informací o virtualizaci serveru. ", "Výukový materiál a výukové programy", "../iphcy/learningandtutorials.html"));
quotes.push(new hotTopic("Můžete si prohlédnout seznam modelů zahrnující jméno typu-modelu (MTM), celé jméno, zkrácené jméno a značku nebo produktovou řadu pro každý model. ", "Seznam čísel a jmen modelů", "./modelnumbersandnames.htm"));
quotes.push(new hotTopic("K vyhledání dokumentace, která je nyní k dispozici v rámci aplikace IBM Hardware Information Center, můžete použít jednoduché schéma.", "Mapa publikací o serveru pSeries v aplikaci Information Center", "./icpserieslist.htm"));
quotes.push(new hotTopic("Můžete si vytisknout každé hlavní téma spolu s dílčími tématy.", "Tisk", "./icfaq.htm#print"));
quotes.push(new hotTopic("Můžete si objednat zasílání internetových aktualizací. Pokud to učiníte, budete informováni vždy, když se vyskytne nějaká aktualizace aplikace IBM Systems Hardware Information Center.", "Objednání internetových aktualizací", "./icupdates.htm#subscribe"));

//END QUOTE TRANSLATABLE
// end array of objects
//////////////////////////////////////////////////////////////////////

//START QUOTE TRANSLATABLE
var strDidYouKnowHeader = "<H2>Víte, že?<\/H2>";
var sDidYouKnow = "&nbsp;&nbsp;Víte, že?";
var sSeeAllTips = "Viz všechny rady";
//END QUOTE TRANSLATABLE

//START NON-TRANSLATABLE
//////////////////////////////////////////////////////////////////////
// begin execution path
var HTid=getHTvalue(quotes);
// end execution path
//////////////////////////////////////////////////////////////////////


//////////////////////////////////////////////////////////////////////
// suport functions
//////////////////////////////////////////////////////////////////////
// functions to create formatted strings and write to document.
function getHotTopic(){
	result = '<A href="'+quotes[HTid].getURL()+'">'+quotes[HTid].getText()+'<\/A>';
	return result;
}
function getHotTopic2(){
	result = '<A href="'+quotes[HTid].getURL()+'"><IMG src=".\/images\/fw.gif" width="16" height="17" vspace="0" hspace="0" border="0" alt=""\/><\/A> ';
	return result;

}
function getHotTopic3(){
	result = '<A href="'+quotes[HTid].getURL()+'">'+quotes[HTid].getBlurb()+'<\/A>';
	return result;

}
function dumpHotTopics(){
	document.writeln(strDidYouKnowHeader);
	document.writeln('<BLOCKQUOTE>');
	for ( ht in quotes ) {
		result = '<P class="frontendbarlink" style="width: 100%;"><A href="'+quotes[ht].url+'">'+quotes[ht].stext+'<\/A><\/P>';
		result += '<P>'+quotes[ht].text+'<\/P>';
		document.writeln(result);
	}
	document.writeln('<\/BLOCKQUOTE>');
}
//////////////////////////////////////////////////////////////////////
// This hideous function is a work around for Netscape 4.x.  The function 
// creates the WHOLE callout box. Since, we cannot call a function from within
// a TD in Netscape 4.x, we cannot do the getHotTopic() calls in a callout box
// within the HTML.  That would result in an empty callout box. So we have a
// 'parent' function call in the HTML that creates the whole callout box.
// This function is not executed in Netscape 4.x, so there is no empty calloutbox.  QED.
function doDidYouKnow(){
	var result=getHotTopic();
	result+='<br>';
	result+=getHotTopic2();
	result+=getHotTopic3();
	result+='<br>';
	result+='       <A href=".\/hottopics.htm"><IMG src=".\/images\/fw.gif" width="16" height="17" vspace="0" hspace="0" border="0" alt=""><\/A> ';
//result+='       <A href=".\/hottopics.htm" class="fbox">'+sSeeAllTips+'</A>';
	result+='       <A href=".\/hottopics.htm">'+sSeeAllTips+'<\/A>';
	document.open();
	document.write(result);
	document.close();
}

//END NON-TRANSLATABLE

