// hottopics.js
// NLS_CHARSET=UTF-8
//
// (C) Copyright IBM Corporation, 2003, 2006                        //
// All rights reserved. Licensed Materials Property of IBM          //
// US Government Users Restricted Rights                            //
// Use, duplication or disclosure restricted by                     //
// GSA ADP Schedule Contract with IBM Corp.                         //

//START NON-TRANSLATABLE
//////////////////////////////////////////////////////////////////////
// define simple object.
function hotTopic() {
	args=hotTopic.arguments;
	this.text = args[0];
	this.stext = args[1] || "intentionally blank";
	this.url = args[2] || "";

   this.getText = getText;
   this.getBlurb = getBlurb;
   this.getURL = getURL;
}

function getText() {
	return this.text;
}
function getBlurb(){
	return this.stext;
}
function getURL(){
	return this.url;
}
//
//////////////////////////////////////////////////////////////////////


//////////////////////////////////////////////////////////////////////
// redefine the 'push' function for all browsers.
//if (Array.prototype.push && ([0].push(true)==true))
//        Array.prototype.push = null;

if(!Array.prototype.push) {
    function array_push() {
        for(i=0;i<arguments.length;i++){
            this[this.length] = arguments[i];
        }
        return this.length;
    }

    Array.prototype.push = array_push;

}
//
//////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////
// function for generating random number.

var masterHTid=null;
function getHTvalue(aQuotes){
  if (!masterHTid) {
	// select random quote (integer).
	var numRand = Math.random();
	var numQuote = aQuotes.length - 1;
	masterHTid = Math.round((numQuote - 1) * numRand) + 1;
  }
  return masterHTid;
}
//
//////////////////////////////////////////////////////////////////////




//END NON-TRANSLATABLE

//////////////////////////////////////////////////////////////////////
// initialize an array of objects.
var quotes = new Array;
//START QUOTE TRANSLATABLE 1 2
quotes.push(new hotTopic("Vous pouvez ajouter une page Web à vos signets.", "Mise en signet", "./icfaq.htm#bookmark"));
quotes.push(new hotTopic("Vous pouvez configurer la console HMC via l\'Assistant de configuration guidée.", "Configuration de la console HMC à l\'aide de l\'Assistant de configuration guidée", "../iphai/confighmcgs.htm"));
quotes.push(new hotTopic("Vous pouvez créer une liste de contrôle adaptée à vos besoins pour la configuration du serveur.", "Création d\'une liste de contrôle personnalisée pour la configuration initiale du serveur", "../iphaf/issintwelcome.htm"));
quotes.push(new hotTopic("Vous pouvez télécharger et installer des mises à jour de la version de l\'Information Center installée à partir du CD.", "Téléchargement des mises à jour pour la version de l\'Information Center installée à partir du CD", "./icupdates.htm#downloadupdates"));
quotes.push(new hotTopic("Vous pouvez effectuer une visite en ligne de la nouvelle interface de l\'Information Center.", "Interface de l\'Information Center", "./icfaq.htm#flashdemo"));
quotes.push(new hotTopic("Vous pouvez installer un grand choix de dispositifs matériels et remplacer plusieurs composants dans vos serveurs ou unités d\'extension.", "Installation des dispositifs et remplacement des composants", "../iphaj/installcifcio.htm"));
quotes.push(new hotTopic("Vous pouvez choisir parmi plusieurs cours et tutoriels en ligne qui vous informeront sur la virtualisation des serveurs.", "Learning and tutorials", "../iphcy/learningandtutorials.html"));
quotes.push(new hotTopic("Vous pouvez visualiser la liste des différents modèles, avec le type machine, le nom complet, le nom abrégé et la marque ou famille du modèle.", "Liste des références et des noms de modèles", "./modelnumbersandnames.htm"));
quotes.push(new hotTopic("Vous pouvez utiliser un tableau pratique pour trouver la documentation pSeries qui figure désormais dans l\'IBM Systems Hardware Information Center.", "Localisation des manuels pSeries sur l\'Information Center", "./icpserieslist.htm"));
quotes.push(new hotTopic("Vous pouvez imprimer les rubriques principales et leurs sous-rubriques.", "Impression", "./icfaq.htm#print"));
quotes.push(new hotTopic("Vous pouvez vous abonner aux mises à jour Internet afin de recevoir des alertes de mise à jour de l\'IBM Systems Hardware Information Center.", "Abonnement aux mises à jour Internet", "./icupdates.htm#subscribe"));

//END QUOTE TRANSLATABLE
// end array of objects
//////////////////////////////////////////////////////////////////////

//START QUOTE TRANSLATABLE
var strDidYouKnowHeader = "<H2>Le saviez-vous ?<\/H2>";
var sDidYouKnow = "&nbsp;&nbsp;Le saviez-vous ?";
var sSeeAllTips = "Afficher tous les conseils";
//END QUOTE TRANSLATABLE

//START NON-TRANSLATABLE
//////////////////////////////////////////////////////////////////////
// begin execution path
var HTid=getHTvalue(quotes);
// end execution path
//////////////////////////////////////////////////////////////////////


//////////////////////////////////////////////////////////////////////
// suport functions
//////////////////////////////////////////////////////////////////////
// functions to create formatted strings and write to document.
function getHotTopic(){
	result = '<A href="'+quotes[HTid].getURL()+'">'+quotes[HTid].getText()+'<\/A>';
	return result;
}
function getHotTopic2(){
	result = '<A href="'+quotes[HTid].getURL()+'"><IMG src=".\/images\/fw.gif" width="16" height="17" vspace="0" hspace="0" border="0" alt=""\/><\/A> ';
	return result;

}
function getHotTopic3(){
	result = '<A href="'+quotes[HTid].getURL()+'">'+quotes[HTid].getBlurb()+'<\/A>';
	return result;

}
function dumpHotTopics(){
	document.writeln(strDidYouKnowHeader);
	document.writeln('<BLOCKQUOTE>');
	for ( ht in quotes ) {
		result = '<P class="frontendbarlink" style="width: 100%;"><A href="'+quotes[ht].url+'">'+quotes[ht].stext+'<\/A><\/P>';
		result += '<P>'+quotes[ht].text+'<\/P>';
		document.writeln(result);
	}
	document.writeln('<\/BLOCKQUOTE>');
}
//////////////////////////////////////////////////////////////////////
// This hideous function is a work around for Netscape 4.x.  The function 
// creates the WHOLE callout box. Since, we cannot call a function from within
// a TD in Netscape 4.x, we cannot do the getHotTopic() calls in a callout box
// within the HTML.  That would result in an empty callout box. So we have a
// 'parent' function call in the HTML that creates the whole callout box.
// This function is not executed in Netscape 4.x, so there is no empty calloutbox.  QED.
function doDidYouKnow(){
	var result=getHotTopic();
	result+='<br>';
	result+=getHotTopic2();
	result+=getHotTopic3();
	result+='<br>';
	result+='       <A href=".\/hottopics.htm"><IMG src=".\/images\/fw.gif" width="16" height="17" vspace="0" hspace="0" border="0" alt=""><\/A> ';
//result+='       <A href=".\/hottopics.htm" class="fbox">'+sSeeAllTips+'</A>';
	result+='       <A href=".\/hottopics.htm">'+sSeeAllTips+'<\/A>';
	document.open();
	document.write(result);
	document.close();
}

//END NON-TRANSLATABLE

