// hottopics.js
// NLS_CHARSET=UTF-8
//
// (C) Copyright IBM Corporation, 2003, 2006                        //
// All rights reserved. Licensed Materials Property of IBM          //
// US Government Users Restricted Rights                            //
// Use, duplication or disclosure restricted by                     //
// GSA ADP Schedule Contract with IBM Corp.                         //

//START NON-TRANSLATABLE
//////////////////////////////////////////////////////////////////////
// define simple object.
function hotTopic() {
	args=hotTopic.arguments;
	this.text = args[0];
	this.stext = args[1] || "intentionally blank";
	this.url = args[2] || "";

   this.getText = getText;
   this.getBlurb = getBlurb;
   this.getURL = getURL;
}

function getText() {
	return this.text;
}
function getBlurb(){
	return this.stext;
}
function getURL(){
	return this.url;
}
//
//////////////////////////////////////////////////////////////////////


//////////////////////////////////////////////////////////////////////
// redefine the 'push' function for all browsers.
//if (Array.prototype.push && ([0].push(true)==true))
//        Array.prototype.push = null;

if(!Array.prototype.push) {
    function array_push() {
        for(i=0;i<arguments.length;i++){
            this[this.length] = arguments[i];
        }
        return this.length;
    }

    Array.prototype.push = array_push;

}
//
//////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////
// function for generating random number.

var masterHTid=null;
function getHTvalue(aQuotes){
  if (!masterHTid) {
	// select random quote (integer).
	var numRand = Math.random();
	var numQuote = aQuotes.length - 1;
	masterHTid = Math.round((numQuote - 1) * numRand) + 1;
  }
  return masterHTid;
}
//
//////////////////////////////////////////////////////////////////////




//END NON-TRANSLATABLE

//////////////////////////////////////////////////////////////////////
// initialize an array of objects.
var quotes = new Array;
//START QUOTE TRANSLATABLE 1 2
quotes.push(new hotTopic("Você pode marcar uma página específcia. ", "Marcando", "./icfaq.htm#bookmark"));
quotes.push(new hotTopic("Você pode configurar o Hardware Management Console utilizando o assistente Configuração Dirigida. ", "Configurando o HMC utilizando o assistente Configuração Dirigida", "../iphai/confighmcgs.htm"));
quotes.push(new hotTopic("É possível criar uma lista de verificação de configuração do servidor customizada para suas necessidades. ", "Criando uma Lista de Verificação da Configuração Inicial do Servidor", "../iphaf/issintwelcome.htm"));
quotes.push(new hotTopic("Você pode fazer download e instalar atualizações da versão do Information Center instalada a partir do CD.", "Fazendo Download de Atualizações da Versão do Information Center Instalada a Partir do CD", "./icupdates.htm#downloadupdates"));
quotes.push(new hotTopic("Você pode visualizar um tour animado do produto pela nova interface do Information Center.", "Interface do Information Center", "./icfaq.htm#flashdemo"));
quotes.push(new hotTopic("Você pode instalar uma variedade de recursos de hardware e substituir muitas peças nos servidores e unidades de expansão. ", "Instalando Recursos", "../iphaj/installcifcio.htm"));
quotes.push(new hotTopic("Você pode selecionar dentre diversos cursos e tutoriais interativos para ajudá-lo a obter informações adicionais sobre a virtualização de servidores.", "Informações e Tutoriais", "../iphcy/learningandtutorials.html"));
quotes.push(new hotTopic("Você pode visualizar uma lista de modelos que incluem o nome MTM (Machine Type-Model), o nome completo e a marca ou família.", "Lista de Números e Nomes de Modelos", "./modelnumbersandnames.htm"));
quotes.push(new hotTopic("Você pode utilizar um gráfico de fácil leitura para localizar a documentação do pSeries que agora se encontra no IBM Systems Hardware Information Center.", "Mapa de manuais pSeries para o Information Center", "./icpserieslist.htm"));
quotes.push(new hotTopic("Você pode imprimir cada tópico principal junto com seus subtópicos.", "Imprimindo", "./icfaq.htm#print"));
quotes.push(new hotTopic("Você pode assinar as atualizações da Internet para receber notificações quando ocorrerem updates do IBM Systems Hardware Information Center.", "Assinando Atualizações da Internet", "./icupdates.htm#subscribe"));

//END QUOTE TRANSLATABLE
// end array of objects
//////////////////////////////////////////////////////////////////////

//START QUOTE TRANSLATABLE
var strDidYouKnowHeader = "<H2>Você Sabia?<\/H2>";
var sDidYouKnow = "&nbsp;&nbsp;Você Sabia?";
var sSeeAllTips = "Consulte todas as dicas";
//END QUOTE TRANSLATABLE

//START NON-TRANSLATABLE
//////////////////////////////////////////////////////////////////////
// begin execution path
var HTid=getHTvalue(quotes);
// end execution path
//////////////////////////////////////////////////////////////////////


//////////////////////////////////////////////////////////////////////
// suport functions
//////////////////////////////////////////////////////////////////////
// functions to create formatted strings and write to document.
function getHotTopic(){
	result = '<A href="'+quotes[HTid].getURL()+'">'+quotes[HTid].getText()+'<\/A>';
	return result;
}
function getHotTopic2(){
	result = '<A href="'+quotes[HTid].getURL()+'"><IMG src=".\/images\/fw.gif" width="16" height="17" vspace="0" hspace="0" border="0" alt=""\/><\/A> ';
	return result;

}
function getHotTopic3(){
	result = '<A href="'+quotes[HTid].getURL()+'">'+quotes[HTid].getBlurb()+'<\/A>';
	return result;

}
function dumpHotTopics(){
	document.writeln(strDidYouKnowHeader);
	document.writeln('<BLOCKQUOTE>');
	for ( ht in quotes ) {
		result = '<P class="frontendbarlink" style="width: 100%;"><A href="'+quotes[ht].url+'">'+quotes[ht].stext+'<\/A><\/P>';
		result += '<P>'+quotes[ht].text+'<\/P>';
		document.writeln(result);
	}
	document.writeln('<\/BLOCKQUOTE>');
}
//////////////////////////////////////////////////////////////////////
// This hideous function is a work around for Netscape 4.x.  The function 
// creates the WHOLE callout box. Since, we cannot call a function from within
// a TD in Netscape 4.x, we cannot do the getHotTopic() calls in a callout box
// within the HTML.  That would result in an empty callout box. So we have a
// 'parent' function call in the HTML that creates the whole callout box.
// This function is not executed in Netscape 4.x, so there is no empty calloutbox.  QED.
function doDidYouKnow(){
	var result=getHotTopic();
	result+='<br>';
	result+=getHotTopic2();
	result+=getHotTopic3();
	result+='<br>';
	result+='       <A href=".\/hottopics.htm"><IMG src=".\/images\/fw.gif" width="16" height="17" vspace="0" hspace="0" border="0" alt=""><\/A> ';
//result+='       <A href=".\/hottopics.htm" class="fbox">'+sSeeAllTips+'</A>';
	result+='       <A href=".\/hottopics.htm">'+sSeeAllTips+'<\/A>';
	document.open();
	document.write(result);
	document.close();
}

//END NON-TRANSLATABLE

